/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.sdk.calls.call.video;

import android.content.Context;
import android.content.res.Resources;
import android.os.Build;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewGroup;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.webrtc.Camera1Enumerator;
import org.webrtc.Camera2Enumerator;
import org.webrtc.CameraEnumerator;
import org.webrtc.DefaultVideoDecoderFactory;
import org.webrtc.DefaultVideoEncoderFactory;
import org.webrtc.EglBase;
import org.webrtc.MediaStream;
import org.webrtc.PeerConnectionFactory;
import org.webrtc.SurfaceTextureHelper;
import org.webrtc.SurfaceViewRenderer;
import org.webrtc.VideoCapturer;
import org.webrtc.VideoDecoderFactory;
import org.webrtc.VideoEncoderFactory;
import org.webrtc.VideoSink;
import org.webrtc.VideoSource;
import org.webrtc.VideoTrack;
import org.webrtc.audio.AudioDeviceModule;
import org.webrtc.audio.JavaAudioDeviceModule;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b\u0000\u0018\u00002\u00020\u0001:\u0001%B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0011\u001a\u00020\fH\u0002J\u001a\u0010\u0012\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\b\u0010\u0019\u001a\u00020\fH\u0002J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u000e\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u001eJ\u0006\u0010\u001f\u001a\u00020\u001bJ\u0018\u0010 \u001a\u00020\u001b2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0018\u0010!\u001a\u00020\u001b2\u0006\u0010\"\u001a\u00020\u001e2\u0006\u0010#\u001a\u00020\u0016H\u0002J\b\u0010$\u001a\u00020\u001bH\u0002R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lio/streamlayer/sdk/calls/call/video/SRLCallSource;", "", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "capturer", "Lorg/webrtc/VideoCapturer;", "localMediaStream", "Lorg/webrtc/MediaStream;", "localVideoTrack", "Lorg/webrtc/VideoTrack;", "peerConnectionFactory", "Lorg/webrtc/PeerConnectionFactory;", "rootEglBase", "Lorg/webrtc/EglBase;", "videoSource", "Lorg/webrtc/VideoSource;", "buildPeerConnectionFactory", "createCameraCapturer", "enumerator", "Lorg/webrtc/CameraEnumerator;", "isFrontCamera", "", "createJavaAudioDevice", "Lorg/webrtc/audio/AudioDeviceModule;", "getPeerFactory", "initPeerConnectionFactory", "", "prepareVideoSurfaceView", "videoCallSurface", "Lorg/webrtc/SurfaceViewRenderer;", "release", "setCamera", "setSurfaceView", "surfaceViewRenderer", "isMirror", "setVideoSource", "DisplayUtil", "sdk_originalVoximplantRelease"})
public final class SRLCallSource {
    private MediaStream localMediaStream;
    private VideoSource videoSource;
    private VideoTrack localVideoTrack;
    private final EglBase rootEglBase;
    private PeerConnectionFactory peerConnectionFactory;
    private VideoCapturer capturer;
    private final Context context;

    private final void initPeerConnectionFactory(Context context) {
        PeerConnectionFactory.initialize((PeerConnectionFactory.InitializationOptions)PeerConnectionFactory.InitializationOptions.builder((Context)context).setEnableInternalTracer(true).createInitializationOptions());
    }

    private final PeerConnectionFactory getPeerFactory() {
        PeerConnectionFactory peerConnectionFactory = this.peerConnectionFactory;
        if (peerConnectionFactory == null) {
            peerConnectionFactory = this.buildPeerConnectionFactory();
        }
        return peerConnectionFactory;
    }

    private final void setVideoSource() {
        if (this.videoSource == null && this.localVideoTrack == null) {
            SRLCallSource sRLCallSource = this;
            sRLCallSource.videoSource = sRLCallSource.getPeerFactory().createVideoSource(false);
            String string2 = UUID.randomUUID().toString();
            string2 = sRLCallSource.getPeerFactory().createVideoTrack(string2, this.videoSource);
            MediaStream mediaStream = sRLCallSource.localMediaStream;
            if (mediaStream != null) {
                mediaStream.addTrack((VideoTrack)string2);
            }
            this.localVideoTrack = string2;
        }
    }

    private final PeerConnectionFactory buildPeerConnectionFactory() {
        new PeerConnectionFactory.Options().disableNetworkMonitor = true;
        SRLCallSource sRLCallSource = this;
        this.peerConnectionFactory = PeerConnectionFactory.builder().setVideoDecoderFactory((VideoDecoderFactory)new DefaultVideoDecoderFactory(this.rootEglBase.getEglBaseContext())).setVideoEncoderFactory((VideoEncoderFactory)new DefaultVideoEncoderFactory(this.rootEglBase.getEglBaseContext(), false, false)).setOptions(new PeerConnectionFactory.Options()).setAudioDeviceModule(sRLCallSource.createJavaAudioDevice(sRLCallSource.context)).createPeerConnectionFactory();
        Intrinsics.checkExpressionValueIsNotNull((Object)this.peerConnectionFactory, (String)"factory");
        return this.peerConnectionFactory;
    }

    private final void setSurfaceView(SurfaceViewRenderer surfaceViewRenderer, boolean bl) {
        try {
            surfaceViewRenderer.init(this.rootEglBase.getEglBaseContext(), null);
        }
        catch (Exception exception) {}
        SurfaceViewRenderer surfaceViewRenderer2 = surfaceViewRenderer;
        surfaceViewRenderer2.setZOrderMediaOverlay(true);
        surfaceViewRenderer2.setMirror(bl);
    }

    private final VideoCapturer createCameraCapturer(CameraEnumerator cameraEnumerator, boolean bl) {
        for (String string2 : cameraEnumerator.getDeviceNames()) {
            if (!(bl ? cameraEnumerator.isFrontFacing(string2) : cameraEnumerator.isBackFacing(string2)) || (string2 = cameraEnumerator.createCapturer(string2, null)) == null) continue;
            return string2;
        }
        for (String string2 : this) {
            if ((bl ? cameraEnumerator.isFrontFacing(string2) : cameraEnumerator.isBackFacing(string2)) || (string2 = cameraEnumerator.createCapturer(string2, null)) == null) continue;
            return string2;
        }
        return null;
    }

    private final void setCamera(Context context, boolean bl) {
        VideoCapturer videoCapturer;
        SurfaceTextureHelper surfaceTextureHelper = SurfaceTextureHelper.create((String)"CaptureThread", (EglBase.Context)sRLCallSource.rootEglBase.getEglBaseContext());
        if (Camera2Enumerator.isSupported((Context)context)) {
            Camera2Enumerator camera2Enumerator;
            Camera2Enumerator camera2Enumerator2 = camera2Enumerator;
            camera2Enumerator = new Camera2Enumerator(context);
            videoCapturer = sRLCallSource.createCameraCapturer((CameraEnumerator)camera2Enumerator2, bl);
        } else {
            Camera1Enumerator camera1Enumerator;
            Camera1Enumerator camera1Enumerator2 = camera1Enumerator;
            camera1Enumerator = new Camera1Enumerator(false);
            videoCapturer = sRLCallSource.createCameraCapturer((CameraEnumerator)camera1Enumerator2, bl);
        }
        sRLCallSource.capturer = videoCapturer;
        if (videoCapturer != null) {
            SRLCallSource sRLCallSource = sRLCallSource.videoSource;
            if (sRLCallSource == null) {
                Intrinsics.throwNpe();
            }
            VideoCapturer videoCapturer2 = videoCapturer;
            videoCapturer2.initialize(surfaceTextureHelper, context, sRLCallSource.getCapturerObserver());
            videoCapturer2.startCapture(DisplayUtil.INSTANCE.screenWidth() / 2, DisplayUtil.INSTANCE.screenHeight() / 2, 30);
        }
    }

    private final AudioDeviceModule createJavaAudioDevice(Context context) {
        JavaAudioDeviceModule.AudioTrackErrorCallback audioTrackErrorCallback2;
        JavaAudioDeviceModule.AudioTrackErrorCallback audioTrackErrorCallback3 = audioTrackErrorCallback2;
        audioTrackErrorCallback2 = new JavaAudioDeviceModule.AudioTrackErrorCallback(){

            public void onWebRtcAudioTrackInitError(@NotNull String string2) {
                Intrinsics.checkParameterIsNotNull((Object)string2, (String)"errorMessage");
            }

            public void onWebRtcAudioTrackStartError(@NotNull JavaAudioDeviceModule.AudioTrackStartErrorCode audioTrackStartErrorCode, @NotNull String string2) {
                Intrinsics.checkParameterIsNotNull((Object)audioTrackStartErrorCode, (String)"errorCode");
                Intrinsics.checkParameterIsNotNull((Object)string2, (String)"errorMessage");
            }

            public void onWebRtcAudioTrackError(@NotNull String string2) {
                Intrinsics.checkParameterIsNotNull((Object)string2, (String)"errorMessage");
            }
        };
        AudioDeviceModule audioDeviceModule = JavaAudioDeviceModule.builder((Context)context).setAudioTrackErrorCallback(audioTrackErrorCallback3).setUseHardwareAcousticEchoCanceler(false).setUseHardwareNoiseSuppressor(false).setAudioSource(1).createAudioDeviceModule();
        Intrinsics.checkExpressionValueIsNotNull((Object)audioDeviceModule, (String)"JavaAudioDeviceModule.bu\u2026createAudioDeviceModule()");
        return audioDeviceModule;
    }

    public SRLCallSource(@NotNull Context context) {
        SRLCallSource sRLCallSource = this;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        sRLCallSource.context = context;
        EglBase eglBase = EglBase.create();
        Intrinsics.checkExpressionValueIsNotNull((Object)eglBase, (String)"EglBase.create()");
        sRLCallSource.rootEglBase = eglBase;
        sRLCallSource.initPeerConnectionFactory(sRLCallSource.context);
        sRLCallSource.peerConnectionFactory = sRLCallSource.buildPeerConnectionFactory();
    }

    public final void release() {
        VideoTrack videoTrack = this.localVideoTrack;
        if (videoTrack != null) {
            videoTrack.setEnabled(false);
        }
        this.localMediaStream = null;
        this.videoSource = null;
        this.localVideoTrack = null;
        this.peerConnectionFactory = null;
        videoTrack = this.capturer;
        if (videoTrack != null) {
            videoTrack.stopCapture();
        }
        this.capturer = null;
    }

    public final void prepareVideoSurfaceView(@NotNull SurfaceViewRenderer surfaceViewRenderer) {
        SRLCallSource sRLCallSource = sRLCallSource3;
        Intrinsics.checkParameterIsNotNull((Object)surfaceViewRenderer, (String)"videoCallSurface");
        sRLCallSource.setVideoSource();
        VideoTrack videoTrack = sRLCallSource.localVideoTrack;
        if (videoTrack != null) {
            videoTrack.setEnabled(true);
        }
        if ((videoTrack = sRLCallSource3.localVideoTrack) != null) {
            videoTrack.addSink((VideoSink)surfaceViewRenderer);
        }
        SRLCallSource sRLCallSource2 = sRLCallSource3;
        sRLCallSource3.setSurfaceView(surfaceViewRenderer, false);
        SRLCallSource sRLCallSource3 = surfaceViewRenderer.getContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)sRLCallSource3, (String)"context");
        sRLCallSource2.setCamera((Context)sRLCallSource3, true);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004J\u0006\u0010\u0006\u001a\u00020\u0007J\u0006\u0010\b\u001a\u00020\u0007J\u0006\u0010\t\u001a\u00020\u0007J6\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\u00072\b\b\u0002\u0010\u000f\u001a\u00020\u00072\b\b\u0002\u0010\u0010\u001a\u00020\u00072\b\b\u0002\u0010\u0011\u001a\u00020\u0007J\u000e\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004J\u0006\u0010\u0013\u001a\u00020\u0007\u00a8\u0006\u0014"}, d2={"Lio/streamlayer/sdk/calls/call/video/SRLCallSource$DisplayUtil;", "", "()V", "dpToPx", "", "dp", "screenHeight", "", "screenHeightStatusBarExluded", "screenWidth", "setMargins", "", "v", "Landroid/view/View;", "left", "top", "right", "bottom", "spToPx", "statusBarHeight", "sdk_originalVoximplantRelease"})
    public static final class DisplayUtil {
        public static final DisplayUtil INSTANCE = new DisplayUtil();

        public static /* synthetic */ void setMargins$default(DisplayUtil displayUtil, View view, int n, int n2, int n3, int n4, int n5, Object object) {
            if ((n5 & 2) != 0) {
                n = 0;
            }
            if ((n5 & 4) != 0) {
                n2 = 0;
            }
            if ((n5 & 8) != 0) {
                n3 = 0;
            }
            if ((n5 & 0x10) != 0) {
                n4 = 0;
            }
            displayUtil.setMargins(view, n, n2, n3, n4);
        }

        private DisplayUtil() {
        }

        public final int screenWidth() {
            Resources resources = Resources.getSystem();
            Intrinsics.checkExpressionValueIsNotNull((Object)resources, (String)"Resources.getSystem()");
            return resources.getDisplayMetrics().widthPixels;
        }

        public final int screenHeight() {
            Resources resources = Resources.getSystem();
            Intrinsics.checkExpressionValueIsNotNull((Object)resources, (String)"Resources.getSystem()");
            return resources.getDisplayMetrics().heightPixels;
        }

        public final int screenHeightStatusBarExluded() {
            return this.screenHeight() - this.statusBarHeight();
        }

        public final int statusBarHeight() {
            int n;
            int n2 = Resources.getSystem().getIdentifier("status_bar_height", "dimen", "android");
            if (n2 > 0) {
                n = Resources.getSystem().getDimensionPixelSize(n2);
            } else {
                double d = Build.VERSION.SDK_INT >= 23 ? 24 : 25;
                Resources resources = Resources.getSystem();
                Intrinsics.checkExpressionValueIsNotNull((Object)resources, (String)"Resources.getSystem()");
                n = (int)Math.ceil(d * (double)resources.getDisplayMetrics().density);
            }
            return n;
        }

        public final float dpToPx(float f) {
            Resources resources = Resources.getSystem();
            Intrinsics.checkExpressionValueIsNotNull((Object)resources, (String)"Resources.getSystem()");
            DisplayUtil displayUtil = resources.getDisplayMetrics();
            return TypedValue.applyDimension((int)1, (float)f, (DisplayMetrics)displayUtil);
        }

        public final float spToPx(float f) {
            Resources resources = Resources.getSystem();
            Intrinsics.checkExpressionValueIsNotNull((Object)resources, (String)"Resources.getSystem()");
            DisplayUtil displayUtil = resources.getDisplayMetrics();
            return TypedValue.applyDimension((int)2, (float)f, (DisplayMetrics)displayUtil);
        }

        public final void setMargins(@NotNull View view, int n, int n2, int n3, int n4) {
            View view2 = view;
            Intrinsics.checkParameterIsNotNull((Object)view2, (String)"v");
            if (view2.getLayoutParams() instanceof ViewGroup.MarginLayoutParams) {
                DisplayUtil displayUtil = view.getLayoutParams();
                if (displayUtil != null) {
                    ((ViewGroup.MarginLayoutParams)displayUtil).setMargins(n, n2, n3, n4);
                    view.requestLayout();
                } else {
                    throw new TypeCastException("null cannot be cast to non-null type android.view.ViewGroup.MarginLayoutParams");
                }
            }
        }
    }
}

