/*
 * Decompiled with CFR 0.152.
 */
package io.sundr.builder.internal.processor;

import io.sundr.builder.annotations.ExternalBuildables;
import io.sundr.builder.annotations.Inline;
import io.sundr.builder.internal.BuilderContext;
import io.sundr.builder.internal.BuilderContextManager;
import io.sundr.builder.internal.functions.ClazzAs;
import io.sundr.builder.internal.processor.AbstractBuilderProcessor;
import io.sundr.builder.internal.utils.BuilderUtils;
import io.sundr.codegen.model.JavaClazz;
import io.sundr.codegen.utils.ModelUtils;
import java.io.IOException;
import java.util.Set;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import javax.tools.Diagnostic;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@SupportedAnnotationTypes(value={"io.sundr.builder.annotations.ExternalBuildables"})
public class ExternalBuildableProcessor
extends AbstractBuilderProcessor {
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment env) {
        ExternalBuildables generated;
        Elements elements = this.processingEnv.getElementUtils();
        for (TypeElement typeElement : annotations) {
            for (Element element : env.getElementsAnnotatedWith(typeElement)) {
                generated = element.getAnnotation(ExternalBuildables.class);
                BuilderContext ctx = BuilderContextManager.create(elements, generated.generateBuilderPackage(), generated.builderPackage(), new Inline[0]);
                for (String name : generated.value()) {
                    TypeElement typeElement2 = elements.getTypeElement(name);
                    ctx.getRepository().register(typeElement2);
                }
                for (TypeElement ref : BuilderUtils.getBuildableReferences(ctx, generated)) {
                    ctx.getRepository().register(ModelUtils.getClassElement((Element)ref));
                }
            }
        }
        for (TypeElement typeElement : annotations) {
            for (Element element : env.getElementsAnnotatedWith(typeElement)) {
                generated = element.getAnnotation(ExternalBuildables.class);
                for (String name : generated.value()) {
                    TypeElement typeElement3 = elements.getTypeElement(name);
                    if (typeElement3 == null) {
                        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, "Type:" + name + " doesn't exists. Ignoring...");
                        continue;
                    }
                    BuilderContext ctx = BuilderContextManager.getContext();
                    JavaClazz clazz = (JavaClazz)ctx.getTypeElementToJavaClazz().apply((Object)ModelUtils.getClassElement((Element)typeElement3));
                    this.generateLocalDependenciesIfNeeded();
                    try {
                        this.generateFromClazz((JavaClazz)ClazzAs.FLUENT_INTERFACE.apply(clazz), "templates/builder/fluentimpl.vm");
                        if (generated.editableEnabled()) {
                            this.generateFromClazz((JavaClazz)ClazzAs.EDITABLE_BUILDER.apply(clazz), this.selectBuilderTemplate(generated.validationEnabled()));
                            this.generateFromClazz((JavaClazz)ClazzAs.EDITABLE.apply(clazz), "templates/builder/editable.vm");
                        } else {
                            this.generateFromClazz((JavaClazz)ClazzAs.BUILDER.apply(clazz), this.selectBuilderTemplate(generated.validationEnabled()));
                        }
                        for (Inline inline : generated.inline()) {
                            this.generateFromClazz(this.inlineableOf(ctx, clazz, inline), "templates/builder/class.vm");
                        }
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        }
        return true;
    }
}

