/*
 * Decompiled with CFR 0.152.
 */
package io.sundr.builder.internal;

import io.sundr.builder.Builder;
import io.sundr.builder.annotations.Inline;
import io.sundr.builder.internal.BuilderContext;
import java.util.concurrent.atomic.AtomicReference;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;

public class BuilderContextManager {
    private static final AtomicReference<BuilderContext> context = new AtomicReference();

    private BuilderContextManager() {
    }

    public static BuilderContext create(Elements elements, Types types) {
        BuilderContext ctx = new BuilderContext(elements, types, false, Builder.class.getPackage().getName(), new Inline[0]);
        context.set(ctx);
        return ctx;
    }

    public static BuilderContext create(Elements elements, Types types, Boolean generateBuilderPackage, String packageName, Inline ... inlineables) {
        BuilderContext ctx = new BuilderContext(elements, types, generateBuilderPackage, packageName, inlineables);
        if (context.compareAndSet(null, ctx)) {
            return ctx;
        }
        BuilderContext existing = context.get();
        if (!packageName.equals(existing.getBuilderPackage())) {
            throw new IllegalStateException("Cannot use different builder package names in a single project. Used:" + packageName + " but package:" + existing.getGenerateBuilderPackage() + " already exists.");
        }
        if (!generateBuilderPackage.equals(existing.getGenerateBuilderPackage())) {
            throw new IllegalStateException("Cannot use different values for generate builder package in a single project.");
        }
        return existing;
    }

    public static synchronized BuilderContext getContext() {
        if (context.get() == null) {
            throw new IllegalStateException("Builder context not available.");
        }
        return context.get();
    }
}

