/*
 * Decompiled with CFR 0.152.
 */
package io.sundr.builder.internal.functions;

import io.sundr.Function;
import io.sundr.FunctionFactory;
import io.sundr.builder.internal.BuildableRepository;
import io.sundr.builder.internal.BuilderContext;
import io.sundr.builder.internal.BuilderContextManager;
import io.sundr.builder.internal.functions.CollectionTypes;
import io.sundr.builder.internal.functions.TypeAs;
import io.sundr.codegen.model.ClassRef;
import io.sundr.codegen.model.ClassRefBuilder;
import io.sundr.codegen.model.EditableClassRef;
import io.sundr.codegen.model.Kind;
import io.sundr.codegen.model.Property;
import io.sundr.codegen.model.PropertyBuilder;
import io.sundr.codegen.model.TypeDef;
import io.sundr.codegen.model.TypeRef;
import io.sundr.codegen.utils.StringUtils;
import io.sundr.codegen.utils.TypeUtils;
import java.util.LinkedHashSet;
import java.util.Set;

public class Decendants {
    public static final Function<TypeDef, Set<TypeDef>> BUILDABLE_DECENDANTS = FunctionFactory.cache((Function)new Function<TypeDef, Set<TypeDef>>(){

        public Set<TypeDef> apply(TypeDef item) {
            if (item.equals((Object)TypeDef.OBJECT)) {
                return new LinkedHashSet<TypeDef>();
            }
            LinkedHashSet<TypeDef> result = new LinkedHashSet<TypeDef>();
            BuilderContext ctx = BuilderContextManager.getContext();
            BuildableRepository repository = ctx.getBuildableRepository();
            for (TypeDef type : repository.getBuildables()) {
                if (type.getKind() != Kind.CLASS || type.isAbstract() || !Decendants.isDescendant(type, item) || type.equals((Object)item) || type.getAttributes().containsKey("GENERATED")) continue;
                result.add(type);
            }
            return result;
        }
    });
    public static Function<Property, Set<Property>> PROPERTY_BUILDABLE_DESCENDANTS = FunctionFactory.cache((Function)new Function<Property, Set<Property>>(){

        public Set<Property> apply(Property property) {
            LinkedHashSet<Property> result;
            block4: {
                TypeRef baseType;
                block3: {
                    result = new LinkedHashSet<Property>();
                    baseType = property.getTypeRef();
                    if (!((Boolean)CollectionTypes.IS_COLLECTION.apply((Object)baseType)).booleanValue()) break block3;
                    TypeRef unwrapped = (TypeRef)TypeAs.UNWRAP_COLLECTION_OF.apply((Object)baseType);
                    if (!(unwrapped instanceof ClassRef)) break block4;
                    ClassRef candidate = (ClassRef)unwrapped;
                    for (TypeDef descendant : (Set)BUILDABLE_DECENDANTS.apply((Object)candidate.getDefinition())) {
                        EditableClassRef collectionType = ((ClassRefBuilder)new ClassRefBuilder((ClassRef)baseType).withArguments(new TypeRef[]{descendant.toInternalReference()})).build();
                        String propertyName = StringUtils.deCaptializeFirst((String)descendant.getName()) + property.getNameCapitalized();
                        result.add((Property)((PropertyBuilder)((PropertyBuilder)((PropertyBuilder)((PropertyBuilder)new PropertyBuilder(property).withName(propertyName)).withTypeRef((TypeRef)collectionType)).addToAttributes("DESCENDANT_OF", (Object)property)).addToAttributes("BUILDABLE", (Object)true)).build());
                    }
                    break block4;
                }
                if (baseType instanceof ClassRef) {
                    ClassRef candidate = (ClassRef)baseType;
                    for (TypeDef descendant : (Set)BUILDABLE_DECENDANTS.apply((Object)candidate.getDefinition())) {
                        String propertyName = StringUtils.deCaptializeFirst((String)(descendant.getName() + property.getNameCapitalized()));
                        result.add((Property)((PropertyBuilder)((PropertyBuilder)((PropertyBuilder)((PropertyBuilder)new PropertyBuilder(property).withName(propertyName)).withTypeRef((TypeRef)TypeUtils.classRefOf((TypeDef)descendant, (Object[])new Object[0]))).addToAttributes("DESCENDANT_OF", (Object)property)).addToAttributes("BUILDABLE", (Object)true)).build());
                    }
                }
            }
            return result;
        }
    });

    public static boolean isDescendant(TypeDef item, TypeDef candidate) {
        if (item == null || candidate == null) {
            return false;
        }
        return candidate.isAssignableFrom(item);
    }
}

