/*
 * Decompiled with CFR 0.152.
 */
package io.sundr.builder.internal.functions;

import io.sundr.Function;
import io.sundr.FunctionFactory;
import io.sundr.builder.Constants;
import io.sundr.builder.internal.BuilderContextManager;
import io.sundr.builder.internal.functions.CollectionTypes;
import io.sundr.builder.internal.functions.Decendants;
import io.sundr.builder.internal.functions.PropertyAs;
import io.sundr.builder.internal.functions.TypeAs;
import io.sundr.builder.internal.utils.BuilderUtils;
import io.sundr.codegen.functions.Singularize;
import io.sundr.codegen.model.ClassRef;
import io.sundr.codegen.model.EditableProperty;
import io.sundr.codegen.model.Method;
import io.sundr.codegen.model.MethodBuilder;
import io.sundr.codegen.model.MethodFluent;
import io.sundr.codegen.model.Property;
import io.sundr.codegen.model.PropertyBuilder;
import io.sundr.codegen.model.Statement;
import io.sundr.codegen.model.StringStatement;
import io.sundr.codegen.model.TypeDef;
import io.sundr.codegen.model.TypeParamRef;
import io.sundr.codegen.model.TypeRef;
import io.sundr.codegen.utils.StringUtils;
import io.sundr.codegen.utils.TypeUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.lang.model.element.Modifier;

public class ToMethod {
    private static final String BUILDABLE_ARRAY_GETTER_TEXT = StringUtils.loadResourceQuietly((String)"snippets/buildable-array-getter.txt");
    private static final String SIMPLE_ARRAY_GETTER_TEXT = StringUtils.loadResourceQuietly((String)"snippets/simple-array-getter.txt");
    public static final Function<Property, Method> WITH = FunctionFactory.cache((Function)new Function<Property, Method>(){

        public Method apply(Property property) {
            TypeParamRef returnType = property.getAttributes().containsKey("GENERIC_TYPE_REF") ? (TypeRef)property.getAttributes().get("GENERIC_TYPE_REF") : Constants.T_REF;
            String methodName = "with" + property.getNameCapitalized();
            return ((MethodBuilder)((MethodFluent.BlockNested)((MethodBuilder)((MethodBuilder)((MethodBuilder)((MethodBuilder)((MethodBuilder)new MethodBuilder().withModifiers(TypeUtils.modifiersToInt((Modifier[])new Modifier[]{Modifier.PUBLIC}))).withName(methodName)).withReturnType((TypeRef)returnType)).withArguments(new Property[]{property})).withVarArgPreferred(true)).withNewBlock().withStatements(this.getStementes(property))).endBlock()).build();
        }

        private List<Statement> getStementes(Property property) {
            TypeParamRef returnType = property.getAttributes().containsKey("GENERIC_TYPE_REF") ? (TypeRef)property.getAttributes().get("GENERIC_TYPE_REF") : Constants.T_REF;
            String name = property.getName();
            TypeRef type = property.getTypeRef();
            TypeRef unwraped = (TypeRef)TypeAs.combine(TypeAs.UNWRAP_COLLECTION_OF, TypeAs.UNWRAP_ARRAY_OF).apply((Object)property.getTypeRef());
            ArrayList<Statement> statements = new ArrayList<Statement>();
            if (((Boolean)CollectionTypes.IS_COLLECTION.apply((Object)type)).booleanValue() || ((Boolean)CollectionTypes.IS_MAP.apply((Object)type)).booleanValue()) {
                String className = ((ClassRef)type).getDefinition().getName();
                statements.add((Statement)new StringStatement("this." + name + ".clear();"));
                if (((Boolean)CollectionTypes.IS_MAP.apply((Object)type)).booleanValue()) {
                    statements.add((Statement)new StringStatement("if (" + name + " != null) {this." + name + ".putAll(" + name + ");} return (" + returnType + ") this;"));
                } else if (((Boolean)CollectionTypes.IS_LIST.apply((Object)type)).booleanValue() || ((Boolean)CollectionTypes.IS_SET.apply((Object)type)).booleanValue()) {
                    String addToMethodName = "addTo" + property.getNameCapitalized();
                    statements.add((Statement)new StringStatement("if (" + name + " != null) {for (" + unwraped.toString() + " item : " + name + "){this." + addToMethodName + "(item);}} return (" + returnType + ") this;"));
                }
                return statements;
            }
            if (BuilderUtils.isBuildable(unwraped)) {
                TypeDef builder = (TypeDef)TypeAs.BUILDER.apply((Object)((ClassRef)unwraped).getDefinition());
                String propertyName = property.getName();
                String builderClass = builder.getName();
                statements.add((Statement)new StringStatement("if (" + propertyName + "!=null){ this." + propertyName + "= new " + builderClass + "(" + propertyName + "); _visitables.add(this." + propertyName + ");} return (" + returnType + ") this;"));
                return statements;
            }
            statements.add((Statement)new StringStatement("this." + property.getName() + "=" + property.getName() + "; return (" + returnType + ") this;"));
            return statements;
        }
    });
    public static final Function<Property, Method> WITH_ARRAY = FunctionFactory.cache((Function)new Function<Property, Method>(){

        public Method apply(Property property) {
            TypeParamRef returnType = property.getAttributes().containsKey("GENERIC_TYPE_REF") ? (TypeRef)property.getAttributes().get("GENERIC_TYPE_REF") : Constants.T_REF;
            String methodName = "with" + property.getNameCapitalized();
            TypeRef unwraped = (TypeRef)TypeAs.combine(TypeAs.UNWRAP_COLLECTION_OF, TypeAs.UNWRAP_ARRAY_OF).apply((Object)property.getTypeRef());
            String addToMethodName = "addTo" + property.getNameCapitalized();
            TypeRef arrayType = (TypeRef)TypeAs.ARRAY_OF.apply((Object)unwraped);
            EditableProperty arrayProperty = ((PropertyBuilder)new PropertyBuilder(property).withTypeRef(arrayType)).build();
            return ((MethodBuilder)((MethodFluent.BlockNested)((MethodBuilder)((MethodBuilder)((MethodBuilder)((MethodBuilder)((MethodBuilder)new MethodBuilder().withModifiers(TypeUtils.modifiersToInt((Modifier[])new Modifier[]{Modifier.PUBLIC}))).withName(methodName)).withReturnType((TypeRef)returnType)).withArguments(new Property[]{arrayProperty})).withVarArgPreferred(true)).withNewBlock().addNewStringStatementStatement("this." + property.getName() + ".clear(); if (" + property.getName() + " != null) {for (" + unwraped.toString() + " item :" + property.getName() + "){ this." + addToMethodName + "(item);}} return (" + returnType + ") this;")).endBlock()).build();
        }
    });
    public static final Function<Property, Method> GETTER = FunctionFactory.cache((Function)new Function<Property, Method>(){

        public Method apply(Property property) {
            TypeRef unwrapped = (TypeRef)TypeAs.combine(TypeAs.UNWRAP_COLLECTION_OF, TypeAs.UNWRAP_ARRAY_OF).apply((Object)property.getTypeRef());
            String prefix = BuilderUtils.isBoolean(property.getTypeRef()) ? "is" : "get";
            String methodName = prefix + property.getNameCapitalized();
            ArrayList<StringStatement> statements = new ArrayList<StringStatement>();
            TreeSet<Property> descendants = new TreeSet<Property>(new Comparator<Property>(){

                @Override
                public int compare(Property left, Property right) {
                    return left.getName().compareTo(right.getName());
                }
            });
            descendants.addAll((Collection)Decendants.PROPERTY_BUILDABLE_DESCENDANTS.apply((Object)property));
            if (BuilderUtils.isMap(property.getTypeRef())) {
                statements.add(new StringStatement("return this." + property.getName() + ";"));
            } else if (BuilderUtils.isBuildable(unwrapped)) {
                if (BuilderUtils.isList(property.getTypeRef()) || BuilderUtils.isSet(property.getTypeRef())) {
                    statements.add(new StringStatement("return build(" + property.getName() + ");"));
                } else {
                    statements.add(new StringStatement("return this." + property.getName() + "!=null?this." + property.getName() + ".build():null;"));
                }
            } else if (!descendants.isEmpty()) {
                if (BuilderUtils.isList(property.getTypeRef()) || BuilderUtils.isSet(property.getTypeRef())) {
                    statements.add(new StringStatement("return build(" + property.getName() + ");"));
                } else {
                    statements.add(new StringStatement("return this." + property.getName() + ";"));
                }
            } else {
                statements.add(new StringStatement("return this." + property.getName() + ";"));
            }
            return ((MethodBuilder)((MethodFluent.BlockNested)((MethodBuilder)((MethodBuilder)((MethodBuilder)((MethodBuilder)new MethodBuilder().withModifiers(TypeUtils.modifiersToInt((Modifier[])new Modifier[]{Modifier.PUBLIC}))).withName(methodName)).withReturnType(property.getTypeRef())).withArguments(new Property[0])).withNewBlock().withStatements(statements)).endBlock()).build();
        }
    });
    public static final Function<Property, Method> GETTER_ARRAY = FunctionFactory.cache((Function)new Function<Property, Method>(){

        public Method apply(Property property) {
            String prefix = BuilderUtils.isBoolean(property.getTypeRef()) ? "is" : "get";
            String methodName = prefix + property.getNameCapitalized();
            TypeRef type = property.getTypeRef();
            Boolean isBuildable = BuilderUtils.isBuildable(type);
            TypeRef targetType = isBuildable != false ? (TypeRef)TypeAs.VISITABLE_BUILDER.apply((Object)type) : (TypeRef)TypeAs.UNWRAP_ARRAY_OF.apply((Object)type);
            String body = String.format(isBuildable != false ? BUILDABLE_ARRAY_GETTER_TEXT : SIMPLE_ARRAY_GETTER_TEXT, type.toString(), targetType.toString(), property.getName(), targetType.toString(), property.getName());
            return ((MethodBuilder)((MethodFluent.BlockNested)((MethodBuilder)((MethodBuilder)((MethodBuilder)((MethodBuilder)new MethodBuilder().withModifiers(TypeUtils.modifiersToInt((Modifier[])new Modifier[]{Modifier.PUBLIC}))).withName(methodName)).withReturnType(property.getTypeRef())).withArguments(new Property[0])).withNewBlock().addNewStringStatementStatement(body)).endBlock()).build();
        }
    });
    public static final Function<Property, Method> SETTER = FunctionFactory.cache((Function)new Function<Property, Method>(){

        public Method apply(Property property) {
            String methodName = "set" + property.getNameCapitalized();
            return ((MethodBuilder)((MethodFluent.BlockNested)((MethodBuilder)((MethodBuilder)((MethodBuilder)((MethodBuilder)new MethodBuilder().withModifiers(TypeUtils.modifiersToInt((Modifier[])new Modifier[]{Modifier.PUBLIC}))).withName(methodName)).withReturnType((TypeRef)Constants.VOID)).withArguments(new Property[0])).withNewBlock().addNewStringStatementStatement("this." + property.getName() + "=" + property.getName() + ";")).endBlock()).build();
        }
    });
    public static final Function<Property, Method> ADD_TO_COLLECTION = FunctionFactory.cache((Function)new Function<Property, Method>(){

        public Method apply(Property property) {
            TypeParamRef returnType = property.getAttributes().containsKey("GENERIC_TYPE_REF") ? (TypeRef)property.getAttributes().get("GENERIC_TYPE_REF") : Constants.T_REF;
            TypeRef unwrapped = (TypeRef)TypeAs.combine(TypeAs.UNWRAP_COLLECTION_OF).apply((Object)property.getTypeRef());
            EditableProperty item = ((PropertyBuilder)((PropertyBuilder)new PropertyBuilder(property).withName("items")).withTypeRef(unwrapped.withDimensions(1))).build();
            LinkedHashSet parameters = new LinkedHashSet();
            String methodName = "addTo" + property.getNameCapitalized();
            ArrayList<StringStatement> statements = new ArrayList<StringStatement>();
            Set descendants = (Set)Decendants.PROPERTY_BUILDABLE_DESCENDANTS.apply((Object)property);
            if (BuilderUtils.isBuildable(unwrapped)) {
                Object attrValue;
                ClassRef targetType = (ClassRef)unwrapped;
                String propertyName = property.getName();
                if (property.getAttributes().containsKey("DESCENDANT_OF") && (attrValue = property.getAttributes().get("DESCENDANT_OF")) instanceof Property) {
                    propertyName = ((Property)attrValue).getName();
                }
                String targetClass = targetType.getDefinition().getName();
                parameters.addAll(targetType.getDefinition().getParameters());
                String builderClass = targetClass + "Builder";
                statements.add(new StringStatement("for (" + targetClass + " item : items) {" + builderClass + " builder = new " + builderClass + "(item);_visitables.add(builder);this." + propertyName + ".add(builder);} return (" + returnType + ")this;"));
            } else if (!descendants.isEmpty()) {
                ClassRef targetType = (ClassRef)unwrapped;
                parameters.addAll(targetType.getDefinition().getParameters());
                statements.add(new StringStatement("for (" + targetType.toString() + " item : items) {" + StringUtils.join((Iterable)descendants, (Function)new Function<Property, String>(){

                    public String apply(Property item) {
                        TypeRef itemRef = (TypeRef)TypeAs.combine(TypeAs.UNWRAP_COLLECTION_OF, TypeAs.ARRAY_OF).apply((Object)item.getTypeRef());
                        String className = ((ClassRef)itemRef).getDefinition().getName();
                        String addToMethodName = "addTo" + StringUtils.captializeFirst((String)item.getName());
                        return "if (item instanceof " + className + "){" + addToMethodName + "((" + className + ")item);}\n";
                    }
                }, (String)" else ") + "} return (" + returnType + ")this;"));
            } else {
                statements.add(new StringStatement("for (" + unwrapped.toString() + " item : items) {this." + property.getName() + ".add(item);} return (" + returnType + ")this;"));
            }
            return ((MethodBuilder)((MethodFluent.BlockNested)((MethodBuilder)((MethodBuilder)((MethodBuilder)((MethodBuilder)((MethodBuilder)((MethodBuilder)new MethodBuilder().withModifiers(TypeUtils.modifiersToInt((Modifier[])new Modifier[]{Modifier.PUBLIC}))).withParameters(parameters)).withName(methodName)).withReturnType((TypeRef)returnType)).withArguments(new Property[]{item})).withVarArgPreferred(true)).withNewBlock().withStatements(statements)).endBlock()).build();
        }
    });
    public static final Function<Property, Method> REMOVE_FROM_COLLECTION = FunctionFactory.cache((Function)new Function<Property, Method>(){

        public Method apply(Property property) {
            TypeParamRef returnType = property.getAttributes().containsKey("GENERIC_TYPE_REF") ? (TypeRef)property.getAttributes().get("GENERIC_TYPE_REF") : Constants.T_REF;
            TypeRef unwrapped = (TypeRef)TypeAs.combine(TypeAs.UNWRAP_COLLECTION_OF).apply((Object)property.getTypeRef());
            EditableProperty item = ((PropertyBuilder)((PropertyBuilder)new PropertyBuilder(property).withName("items")).withTypeRef(unwrapped.withDimensions(1))).build();
            LinkedHashSet parameters = new LinkedHashSet();
            String methodName = "removeFrom" + property.getNameCapitalized();
            ArrayList<StringStatement> statements = new ArrayList<StringStatement>();
            Set descendants = (Set)Decendants.PROPERTY_BUILDABLE_DESCENDANTS.apply((Object)property);
            if (BuilderUtils.isBuildable(unwrapped)) {
                Object attrValue;
                ClassRef targetType = (ClassRef)unwrapped;
                String propertyName = property.getName();
                if (property.getAttributes().containsKey("DESCENDANT_OF") && (attrValue = property.getAttributes().get("DESCENDANT_OF")) instanceof Property) {
                    propertyName = ((Property)attrValue).getName();
                }
                String targetClass = targetType.getDefinition().getName();
                parameters.addAll(targetType.getDefinition().getParameters());
                String builderClass = targetClass + "Builder";
                statements.add(new StringStatement("for (" + targetClass + " item : items) {" + builderClass + " builder = new " + builderClass + "(item);_visitables.remove(builder);this." + propertyName + ".remove(builder);} return (" + returnType + ")this;"));
            } else if (!descendants.isEmpty()) {
                ClassRef targetType = (ClassRef)unwrapped;
                parameters.addAll(targetType.getDefinition().getParameters());
                statements.add(new StringStatement("for (" + targetType.toString() + " item : items) {" + StringUtils.join((Iterable)descendants, (Function)new Function<Property, String>(){

                    public String apply(Property item) {
                        TypeRef itemRef = (TypeRef)TypeAs.combine(TypeAs.UNWRAP_COLLECTION_OF, TypeAs.ARRAY_OF).apply((Object)item.getTypeRef());
                        String className = ((ClassRef)itemRef).getDefinition().getName();
                        String removeFromMethodName = "removeFrom" + StringUtils.captializeFirst((String)item.getName());
                        return "if (item instanceof " + className + "){" + removeFromMethodName + "((" + className + ")item);}\n";
                    }
                }, (String)" else ") + "} return (" + returnType + ")this;"));
            } else {
                statements.add(new StringStatement("for (" + unwrapped.toString() + " item : items) {this." + property.getName() + ".remove(item);} return (" + returnType + ")this;"));
            }
            return ((MethodBuilder)((MethodFluent.BlockNested)((MethodBuilder)((MethodBuilder)((MethodBuilder)((MethodBuilder)((MethodBuilder)((MethodBuilder)new MethodBuilder().withModifiers(TypeUtils.modifiersToInt((Modifier[])new Modifier[]{Modifier.PUBLIC}))).withName(methodName)).withParameters(parameters)).withReturnType((TypeRef)returnType)).withArguments(new Property[]{item})).withVarArgPreferred(true)).withNewBlock().withStatements(statements)).endBlock()).build();
        }
    });
    public static final Function<Property, Method> ADD_MAP_TO_MAP = FunctionFactory.cache((Function)new Function<Property, Method>(){

        public Method apply(Property property) {
            TypeParamRef returnType = property.getAttributes().containsKey("GENERIC_TYPE_REF") ? (TypeRef)property.getAttributes().get("GENERIC_TYPE_REF") : Constants.T_REF;
            ClassRef mapType = (ClassRef)property.getTypeRef();
            EditableProperty mapProperty = ((PropertyBuilder)((PropertyBuilder)new PropertyBuilder().withName("map")).withTypeRef((TypeRef)mapType)).build();
            String methodName = "addTo" + property.getNameCapitalized();
            return ((MethodBuilder)((MethodFluent.BlockNested)((MethodBuilder)((MethodBuilder)((MethodBuilder)((MethodBuilder)new MethodBuilder().withModifiers(TypeUtils.modifiersToInt((Modifier[])new Modifier[]{Modifier.PUBLIC}))).withName(methodName)).withReturnType((TypeRef)returnType)).withArguments(new Property[]{mapProperty})).withNewBlock().addNewStringStatementStatement("if(map != null) { this." + property.getName() + ".putAll(map);} return (" + returnType + ")this;")).endBlock()).build();
        }
    });
    public static final Function<Property, Method> ADD_TO_MAP = FunctionFactory.cache((Function)new Function<Property, Method>(){

        public Method apply(Property property) {
            TypeParamRef returnType = property.getAttributes().containsKey("GENERIC_TYPE_REF") ? (TypeRef)property.getAttributes().get("GENERIC_TYPE_REF") : Constants.T_REF;
            ClassRef mapType = (ClassRef)property.getTypeRef();
            TypeRef keyType = (TypeRef)mapType.getArguments().get(0);
            TypeRef valueType = (TypeRef)mapType.getArguments().get(1);
            EditableProperty keyProperty = ((PropertyBuilder)((PropertyBuilder)new PropertyBuilder().withName("key")).withTypeRef(keyType)).build();
            EditableProperty valueProperty = ((PropertyBuilder)((PropertyBuilder)new PropertyBuilder().withName("value")).withTypeRef(valueType)).build();
            String methodName = "addTo" + property.getNameCapitalized();
            return ((MethodBuilder)((MethodFluent.BlockNested)((MethodBuilder)((MethodBuilder)((MethodBuilder)((MethodBuilder)new MethodBuilder().withModifiers(TypeUtils.modifiersToInt((Modifier[])new Modifier[]{Modifier.PUBLIC}))).withName(methodName)).withReturnType((TypeRef)returnType)).withArguments(new Property[]{keyProperty, valueProperty})).withNewBlock().addNewStringStatementStatement("if(key != null && value != null) {this." + property.getName() + ".put(key, value);} return (" + returnType + ")this;")).endBlock()).build();
        }
    });
    public static final Function<Property, Method> REMOVE_MAP_FROM_MAP = FunctionFactory.cache((Function)new Function<Property, Method>(){

        public Method apply(Property property) {
            TypeParamRef returnType = property.getAttributes().containsKey("GENERIC_TYPE_REF") ? (TypeRef)property.getAttributes().get("GENERIC_TYPE_REF") : Constants.T_REF;
            TypeRef mapType = property.getTypeRef();
            EditableProperty mapProperty = ((PropertyBuilder)((PropertyBuilder)new PropertyBuilder().withName("map")).withTypeRef(mapType)).build();
            String methodName = "removeFrom" + property.getNameCapitalized();
            return ((MethodBuilder)((MethodFluent.BlockNested)((MethodBuilder)((MethodBuilder)((MethodBuilder)((MethodBuilder)new MethodBuilder().withModifiers(TypeUtils.modifiersToInt((Modifier[])new Modifier[]{Modifier.PUBLIC}))).withName(methodName)).withReturnType((TypeRef)returnType)).withArguments(new Property[]{mapProperty})).withNewBlock().addNewStringStatementStatement("if(map != null) { for(Object key : map.keySet()) {this." + property.getName() + ".remove(key);}} return (" + returnType + ")this;")).endBlock()).build();
        }
    });
    public static final Function<Property, Method> REMOVE_FROM_MAP = FunctionFactory.cache((Function)new Function<Property, Method>(){

        public Method apply(Property property) {
            TypeParamRef returnType = property.getAttributes().containsKey("GENERIC_TYPE_REF") ? (TypeRef)property.getAttributes().get("GENERIC_TYPE_REF") : Constants.T_REF;
            ClassRef mapType = (ClassRef)property.getTypeRef();
            TypeRef keyType = (TypeRef)mapType.getArguments().get(0);
            EditableProperty keyProperty = ((PropertyBuilder)((PropertyBuilder)new PropertyBuilder().withName("key")).withTypeRef(keyType)).build();
            String methodName = "removeFrom" + property.getNameCapitalized();
            return ((MethodBuilder)((MethodFluent.BlockNested)((MethodBuilder)((MethodBuilder)((MethodBuilder)((MethodBuilder)new MethodBuilder().withModifiers(TypeUtils.modifiersToInt((Modifier[])new Modifier[]{Modifier.PUBLIC}))).withName(methodName)).withReturnType((TypeRef)returnType)).withArguments(new Property[]{keyProperty})).withNewBlock().addNewStringStatementStatement("if(key != null) {this." + property.getName() + ".remove(key);} return (" + returnType + ")this;")).endBlock()).build();
        }
    });
    public static final Function<Property, Method> WITH_NEW_NESTED = new Function<Property, Method>(){

        public Method apply(Property property) {
            TypeParamRef returnType = property.getAttributes().containsKey("GENERIC_TYPE_REF") ? (TypeRef)property.getAttributes().get("GENERIC_TYPE_REF") : Constants.T_REF;
            ClassRef baseType = (ClassRef)TypeAs.UNWRAP_COLLECTION_OF.apply((Object)property.getTypeRef());
            TypeDef nestedType = (TypeDef)PropertyAs.NESTED_INTERFACE_TYPE.apply((Object)property);
            TypeDef nestedTypeImpl = (TypeDef)PropertyAs.NESTED_CLASS_TYPE.apply((Object)property);
            LinkedHashSet parameters = new LinkedHashSet(baseType.getDefinition().getParameters());
            ArrayList<Object> typeArguments = new ArrayList<Object>();
            for (TypeRef arg : baseType.getArguments()) {
                typeArguments.add(arg);
            }
            typeArguments.add(returnType);
            ClassRef rewraped = nestedType.toReference(typeArguments.toArray(new TypeRef[typeArguments.size()]));
            ClassRef rewrapedImpl = nestedTypeImpl.toReference(typeArguments.toArray(new TypeRef[typeArguments.size()]));
            boolean isCollection = (Boolean)CollectionTypes.IS_COLLECTION.apply((Object)property.getTypeRef());
            String prefix = isCollection ? "addNew" : "withNew";
            String methodName = prefix + StringUtils.captializeFirst((String)(isCollection ? Singularize.FUNCTION.apply(property.getName()) : property.getName()));
            return ((MethodBuilder)((MethodFluent.BlockNested)((MethodBuilder)((MethodBuilder)((MethodBuilder)((MethodBuilder)new MethodBuilder().withModifiers(TypeUtils.modifiersToInt((Modifier[])new Modifier[]{Modifier.PUBLIC}))).withParameters(parameters)).withReturnType((TypeRef)rewraped)).withName(methodName)).withNewBlock().addNewStringStatementStatement("return new " + rewrapedImpl.getDefinition().getName() + "();")).endBlock()).build();
        }
    };
    public static final Function<Property, Set<Method>> WITH_NESTED_INLINE = new Function<Property, Set<Method>>(){

        public Set<Method> apply(Property property) {
            TypeParamRef returnType = property.getAttributes().containsKey("GENERIC_TYPE_REF") ? (TypeRef)property.getAttributes().get("GENERIC_TYPE_REF") : Constants.T_REF;
            LinkedHashSet<Method> result = new LinkedHashSet<Method>();
            TypeRef unwrappedType = (TypeRef)TypeAs.combine(TypeAs.UNWRAP_COLLECTION_OF, TypeAs.UNWRAP_ARRAY_OF).apply((Object)property.getTypeRef());
            TypeDef baseType = BuilderContextManager.getContext().getBuildableRepository().getBuildable(unwrappedType);
            for (Method constructor : BuilderUtils.getInlineableConstructors(property)) {
                boolean isCollection = (Boolean)CollectionTypes.IS_COLLECTION.apply((Object)property.getTypeRef());
                String ownPrefix = isCollection ? "addNew" : "withNew";
                String ownName = ownPrefix + StringUtils.captializeFirst((String)(isCollection ? Singularize.FUNCTION.apply(property.getName()) : property.getName()));
                String delegatePrefix = (Boolean)CollectionTypes.IS_COLLECTION.apply((Object)property.getTypeRef()) != false ? "addTo" : "with";
                String delegateName = delegatePrefix + StringUtils.captializeFirst((String)property.getName());
                String args = StringUtils.join((Iterable)constructor.getArguments(), (Function)new Function<Property, String>(){

                    public String apply(Property item) {
                        return item.getName();
                    }
                }, (String)", ");
                result.add((Method)((MethodBuilder)((MethodFluent.BlockNested)((MethodBuilder)((MethodBuilder)((MethodBuilder)((MethodBuilder)((MethodBuilder)new MethodBuilder().withModifiers(TypeUtils.modifiersToInt((Modifier[])new Modifier[]{Modifier.PUBLIC}))).withReturnType((TypeRef)returnType)).withArguments(constructor.getArguments())).withName(ownName)).withParameters(new LinkedHashSet(baseType.getParameters()))).withNewBlock().addNewStringStatementStatement("return (" + returnType + ")" + delegateName + "(new " + baseType.getName() + "(" + args + "));")).endBlock()).build());
            }
            return result;
        }
    };
    public static final Function<Property, Method> WITH_NEW_LIKE_NESTED = new Function<Property, Method>(){

        public Method apply(Property property) {
            TypeParamRef returnType = property.getAttributes().containsKey("GENERIC_TYPE_REF") ? (TypeRef)property.getAttributes().get("GENERIC_TYPE_REF") : Constants.T_REF;
            ClassRef baseType = (ClassRef)TypeAs.UNWRAP_COLLECTION_OF.apply((Object)property.getTypeRef());
            TypeDef nestedType = (TypeDef)PropertyAs.NESTED_INTERFACE_TYPE.apply((Object)property);
            TypeDef nestedTypeImpl = (TypeDef)PropertyAs.NESTED_CLASS_TYPE.apply((Object)property);
            LinkedHashSet parameters = new LinkedHashSet(baseType.getDefinition().getParameters());
            ArrayList<Object> typeArguments = new ArrayList<Object>();
            for (TypeRef ignore : baseType.getArguments()) {
                typeArguments.add(Constants.Q);
            }
            typeArguments.add(returnType);
            ClassRef rewraped = TypeUtils.classRefOf((TypeDef)nestedType, (Object[])typeArguments.toArray());
            ClassRef rewrapedImpl = TypeUtils.classRefOf((TypeDef)nestedTypeImpl, (Object[])typeArguments.toArray());
            boolean isCollection = (Boolean)CollectionTypes.IS_COLLECTION.apply((Object)property.getTypeRef());
            String prefix = isCollection ? "addNew" : "withNew";
            String suffix = "Like";
            String methodName = prefix + StringUtils.captializeFirst((String)(isCollection ? Singularize.FUNCTION.apply(property.getName()) : property.getName())) + suffix;
            return ((MethodBuilder)((MethodFluent.BlockNested)((MethodBuilder)((MethodFluent.ArgumentsNested)((MethodFluent.ArgumentsNested)((MethodBuilder)((MethodBuilder)((MethodBuilder)((MethodBuilder)new MethodBuilder().withModifiers(TypeUtils.modifiersToInt((Modifier[])new Modifier[]{Modifier.PUBLIC}))).withParameters(parameters)).withReturnType((TypeRef)rewraped)).withName(methodName)).addNewArgument().withName("item")).withTypeRef((TypeRef)baseType)).endArgument()).withNewBlock().addNewStringStatementStatement("return new " + rewrapedImpl.getDefinition().getName() + "(item);")).endBlock()).build();
        }
    };
    public static final Function<Property, Method> EDIT_NESTED = new Function<Property, Method>(){

        public Method apply(Property property) {
            TypeParamRef returnType = property.getAttributes().containsKey("GENERIC_TYPE_REF") ? (TypeRef)property.getAttributes().get("GENERIC_TYPE_REF") : Constants.T_REF;
            TypeDef nestedType = (TypeDef)PropertyAs.NESTED_INTERFACE_TYPE.apply((Object)property);
            ClassRef rewraped = TypeUtils.classRefOf((TypeDef)nestedType, (Object[])new Object[]{returnType});
            String prefix = "edit";
            String methodNameBase = StringUtils.captializeFirst((String)property.getName());
            String methodName = prefix + methodNameBase;
            return ((MethodBuilder)((MethodFluent.BlockNested)((MethodBuilder)((MethodBuilder)((MethodBuilder)new MethodBuilder().withModifiers(TypeUtils.modifiersToInt((Modifier[])new Modifier[]{Modifier.PUBLIC}))).withReturnType((TypeRef)rewraped)).withName(methodName)).withNewBlock().addNewStringStatementStatement("return withNew" + methodNameBase + "Like(get" + methodNameBase + "());")).endBlock()).build();
        }
    };
    public static final Function<Property, Method> AND = new Function<Property, Method>(){

        public Method apply(Property property) {
            String classPrefix = this.getClassPrefix(property);
            String prefix = (Boolean)CollectionTypes.IS_COLLECTION.apply((Object)property.getTypeRef()) != false ? "addTo" : "with";
            String withMethodName = prefix + StringUtils.captializeFirst((String)property.getName());
            return ((MethodBuilder)((MethodFluent.BlockNested)((MethodBuilder)((MethodBuilder)((MethodBuilder)new MethodBuilder().withModifiers(TypeUtils.modifiersToInt((Modifier[])new Modifier[]{Modifier.PUBLIC}))).withReturnType((TypeRef)Constants.N_REF)).withName("and")).withNewBlock().addNewStringStatementStatement("return (N) " + classPrefix + withMethodName + "(builder.build());")).endBlock()).build();
        }

        private String getClassPrefix(Property property) {
            Object memberOf = property.getAttributes().get("OUTER_CLASS");
            if (memberOf instanceof TypeDef) {
                return ((TypeDef)memberOf).getName() + ".this.";
            }
            return "";
        }
    };
    public static final Function<Property, Method> END = FunctionFactory.cache((Function)new Function<Property, Method>(){

        public Method apply(Property property) {
            String methodName = "end" + StringUtils.captializeFirst((String)((Boolean)CollectionTypes.IS_COLLECTION.apply((Object)property.getTypeRef()) != false ? Singularize.FUNCTION.apply(property.getName()) : property.getName()));
            return ((MethodBuilder)((MethodFluent.BlockNested)((MethodBuilder)((MethodBuilder)((MethodBuilder)new MethodBuilder().withModifiers(TypeUtils.modifiersToInt((Modifier[])new Modifier[]{Modifier.PUBLIC}))).withReturnType((TypeRef)Constants.N_REF)).withName(methodName)).withNewBlock().addNewStringStatementStatement("return and();")).endBlock()).build();
        }
    });
}

