/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen.languages;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.codegen.CodegenConfig;
import io.swagger.codegen.CodegenType;
import io.swagger.codegen.DefaultCodegen;
import io.swagger.codegen.SupportingFile;
import io.swagger.models.Swagger;
import io.swagger.models.properties.ArrayProperty;
import io.swagger.models.properties.MapProperty;
import io.swagger.models.properties.Property;
import io.swagger.util.Yaml;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Rails5ServerCodegen
extends DefaultCodegen
implements CodegenConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(Rails5ServerCodegen.class);
    private static final SimpleDateFormat MIGRATE_FILE_NAME_FORMAT = new SimpleDateFormat("yyyyMMddHHmmss");
    protected String gemName;
    protected String moduleName;
    protected String gemVersion = "1.0.0";
    protected String appFolder = "app";
    protected String channelsFolder = this.appFolder + File.separator + "channels";
    protected String applicationCableFolder = this.channelsFolder + File.separator + "application_cable";
    protected String controllersFolder = this.appFolder + File.separator + "controllers";
    protected String jobsFolder = this.appFolder + File.separator + "jobs";
    protected String mailersFolder = this.appFolder + File.separator + "mailers";
    protected String modelsFolder = this.appFolder + File.separator + "models";
    protected String viewsFolder = this.appFolder + File.separator + "views";
    protected String layoutsFolder = this.viewsFolder + File.separator + "layouts";
    protected String binFolder = "bin";
    protected String configFolder = "config";
    protected String environmentsFolder = this.configFolder + File.separator + "environments";
    protected String initializersFolder = this.configFolder + File.separator + "initializers";
    protected String localesFolder = this.configFolder + File.separator + "locales";
    protected String dbFolder = "db";
    protected String migrateFolder = this.dbFolder + File.separator + "migrate";
    protected String libFolder = "lib";
    protected String tasksFolder = this.libFolder + File.separator + "tasks";
    protected String logFolder = "log";
    protected String publicFolder = "public";
    protected String testFolder = "test";
    protected String tmpFolder = "tmp";
    protected String cacheFolder = this.tmpFolder + File.separator + "cache";
    protected String pidFolder = this.tmpFolder + File.separator + "pids";
    protected String socketsFolder = this.tmpFolder + File.separator + "sockets";
    protected String vendorFolder = "vendor";

    public Rails5ServerCodegen() {
        this.outputFolder = "generated-code" + File.separator + "rails5";
        this.apiPackage = "app/controllers";
        this.apiTemplateFiles.put("controller.mustache", ".rb");
        this.modelPackage = "app/models";
        this.modelTemplateFiles.put("model.mustache", ".rb");
        this.templateDir = "rails5";
        this.embeddedTemplateDir = "rails5";
        this.typeMapping.clear();
        this.languageSpecificPrimitives.clear();
        this.setReservedWordsLowerCase(Arrays.asList("__FILE__", "and", "def", "end", "in", "or", "self", "unless", "__LINE__", "begin", "defined?", "ensure", "module", "redo", "super", "until", "BEGIN", "break", "do", "false", "next", "rescue", "then", "when", "END", "case", "else", "for", "nil", "retry", "true", "while", "alias", "class", "elsif", "if", "not", "return", "undef", "yield"));
        this.typeMapping.put("string", "string");
        this.typeMapping.put("char", "string");
        this.typeMapping.put("int", "integer");
        this.typeMapping.put("integer", "integer");
        this.typeMapping.put("long", "integer");
        this.typeMapping.put("short", "integer");
        this.typeMapping.put("float", "float");
        this.typeMapping.put("double", "decimal");
        this.typeMapping.put("number", "float");
        this.typeMapping.put("date", "date");
        this.typeMapping.put("DateTime", "datetime");
        this.typeMapping.put("boolean", "boolean");
        this.typeMapping.put("binary", "string");
        this.typeMapping.put("ByteArray", "string");
        this.typeMapping.put("UUID", "string");
        this.cliOptions.clear();
    }

    @Override
    public void processOpts() {
        super.processOpts();
        this.setApiPackage("app/controllers");
        this.supportingFiles.add(new SupportingFile("Gemfile", "", "Gemfile"));
        this.supportingFiles.add(new SupportingFile("README.md", "", "README.md"));
        this.supportingFiles.add(new SupportingFile("Rakefile", "", "Rakefile"));
        this.supportingFiles.add(new SupportingFile("config.ru", "", "config.ru"));
        this.supportingFiles.add(new SupportingFile("channel.rb", this.applicationCableFolder, "channel.rb"));
        this.supportingFiles.add(new SupportingFile("connection.rb", this.applicationCableFolder, "connection.rb"));
        this.supportingFiles.add(new SupportingFile("application_controller.rb", this.controllersFolder, "application_controller.rb"));
        this.supportingFiles.add(new SupportingFile("application_job.rb", this.jobsFolder, "application_job.rb"));
        this.supportingFiles.add(new SupportingFile("application_mailer.rb", this.mailersFolder, "application_mailer.rb"));
        this.supportingFiles.add(new SupportingFile("application_record.rb", this.modelsFolder, "application_record.rb"));
        this.supportingFiles.add(new SupportingFile("mailer.html.erb", this.layoutsFolder, "mailer.html.erb"));
        this.supportingFiles.add(new SupportingFile("mailer.text.erb", this.layoutsFolder, "mailer.text.erb"));
        this.supportingFiles.add(new SupportingFile("bundle", this.binFolder, "bundle"));
        this.supportingFiles.add(new SupportingFile("rails", this.binFolder, "rails"));
        this.supportingFiles.add(new SupportingFile("rake", this.binFolder, "rake"));
        this.supportingFiles.add(new SupportingFile("setup", this.binFolder, "setup"));
        this.supportingFiles.add(new SupportingFile("update", this.binFolder, "update"));
        this.supportingFiles.add(new SupportingFile("development.rb", this.environmentsFolder, "development.rb"));
        this.supportingFiles.add(new SupportingFile("production.rb", this.environmentsFolder, "production.rb"));
        this.supportingFiles.add(new SupportingFile("active_record_belongs_to_required_by_default.rb", this.initializersFolder, "active_record_belongs_to_required_by_default.rb"));
        this.supportingFiles.add(new SupportingFile("application_controller_renderer.rb", this.initializersFolder, "application_controller_renderer.rb"));
        this.supportingFiles.add(new SupportingFile("backtrace_silencers.rb", this.initializersFolder, "backtrace_silencers.rb"));
        this.supportingFiles.add(new SupportingFile("callback_terminator.rb", this.initializersFolder, "callback_terminator.rb"));
        this.supportingFiles.add(new SupportingFile("cors.rb", this.initializersFolder, "cors.rb"));
        this.supportingFiles.add(new SupportingFile("filter_parameter_logging.rb", this.initializersFolder, "filter_parameter_logging.rb"));
        this.supportingFiles.add(new SupportingFile("inflections.rb", this.initializersFolder, "inflections.rb"));
        this.supportingFiles.add(new SupportingFile("mime_types.rb", this.initializersFolder, "mime_types.rb"));
        this.supportingFiles.add(new SupportingFile("ssl_options.rb", this.initializersFolder, "ssl_options.rb"));
        this.supportingFiles.add(new SupportingFile("to_time_preserves_timezone.rb", this.initializersFolder, "to_time_preserves_timezone.rb"));
        this.supportingFiles.add(new SupportingFile("en.yml", this.localesFolder, "en.yml"));
        this.supportingFiles.add(new SupportingFile("application.rb", this.configFolder, "application.rb"));
        this.supportingFiles.add(new SupportingFile("boot.rb", this.configFolder, "boot.rb"));
        this.supportingFiles.add(new SupportingFile("cable.yml", this.configFolder, "cable.yml"));
        this.supportingFiles.add(new SupportingFile("database.yml", this.configFolder, "database.yml"));
        this.supportingFiles.add(new SupportingFile("environment.rb", this.configFolder, "environment.rb"));
        this.supportingFiles.add(new SupportingFile("puma.rb", this.configFolder, "puma.rb"));
        this.supportingFiles.add(new SupportingFile("routes.mustache", this.configFolder, "routes.rb"));
        this.supportingFiles.add(new SupportingFile("secrets.yml", this.configFolder, "secrets.yml"));
        this.supportingFiles.add(new SupportingFile("spring.rb", this.configFolder, "spring.rb"));
        this.supportingFiles.add(new SupportingFile(".keep", this.migrateFolder, ".keep"));
        this.supportingFiles.add(new SupportingFile("migrate.mustache", this.migrateFolder, "0_init_tables.rb"));
        this.supportingFiles.add(new SupportingFile("schema.rb", this.dbFolder, "schema.rb"));
        this.supportingFiles.add(new SupportingFile("seeds.rb", this.dbFolder, "seeds.rb"));
        this.supportingFiles.add(new SupportingFile(".keep", this.tasksFolder, ".keep"));
        this.supportingFiles.add(new SupportingFile(".keep", this.logFolder, ".keep"));
        this.supportingFiles.add(new SupportingFile("404.html", this.publicFolder, "404.html"));
        this.supportingFiles.add(new SupportingFile("422.html", this.publicFolder, "422.html"));
        this.supportingFiles.add(new SupportingFile("500.html", this.publicFolder, "500.html"));
        this.supportingFiles.add(new SupportingFile("apple-touch-icon-precomposed.png", this.publicFolder, "apple-touch-icon-precomposed.png"));
        this.supportingFiles.add(new SupportingFile("apple-touch-icon.png", this.publicFolder, "apple-touch-icon.png"));
        this.supportingFiles.add(new SupportingFile("favicon.ico", this.publicFolder, "favicon.ico"));
        this.supportingFiles.add(new SupportingFile("robots.txt", this.publicFolder, "robots.txt"));
        this.supportingFiles.add(new SupportingFile("robots.txt", this.publicFolder, "robots.txt"));
        this.supportingFiles.add(new SupportingFile("test_helper.rb", this.testFolder, "test_helper.rb"));
        this.supportingFiles.add(new SupportingFile(".keep", this.cacheFolder, ".keep"));
        this.supportingFiles.add(new SupportingFile(".keep", this.pidFolder, ".keep"));
        this.supportingFiles.add(new SupportingFile(".keep", this.socketsFolder, ".keep"));
        this.supportingFiles.add(new SupportingFile("restart.txt", this.tmpFolder, "restart.txt"));
        this.supportingFiles.add(new SupportingFile(".keep", this.vendorFolder, ".keep"));
    }

    @Override
    public CodegenType getTag() {
        return CodegenType.SERVER;
    }

    @Override
    public String getName() {
        return "rails5";
    }

    @Override
    public String getHelp() {
        return "Generates a Rails5 server library.";
    }

    @Override
    public String escapeReservedWord(String name) {
        if (this.reservedWordsMappings().containsKey(name)) {
            return this.reservedWordsMappings().get(name);
        }
        return "_" + name;
    }

    @Override
    public String apiFileFolder() {
        return this.outputFolder + File.separator + this.apiPackage.replace("/", File.separator);
    }

    @Override
    public String getTypeDeclaration(Property p) {
        if (p instanceof ArrayProperty) {
            ArrayProperty ap = (ArrayProperty)p;
            Property inner = ap.getItems();
            return this.getSwaggerType(p) + "[" + this.getTypeDeclaration(inner) + "]";
        }
        if (p instanceof MapProperty) {
            MapProperty mp = (MapProperty)p;
            Property inner = mp.getAdditionalProperties();
            return this.getSwaggerType(p) + "[string," + this.getTypeDeclaration(inner) + "]";
        }
        return super.getTypeDeclaration(p);
    }

    @Override
    public String toDefaultValue(Property p) {
        return "null";
    }

    @Override
    public String toVarName(String name) {
        if ((name = name.replaceAll("-", "_")).matches("^[A-Z_]*$")) {
            name = name.toLowerCase();
        }
        if (this.isReservedWord(name = Rails5ServerCodegen.underscore(name)) || name.matches("^\\d.*")) {
            name = this.escapeReservedWord(name);
        }
        return name;
    }

    @Override
    public String getSwaggerType(Property p) {
        String swaggerType = super.getSwaggerType(p);
        Object type = null;
        if (this.typeMapping.containsKey(swaggerType)) {
            return (String)this.typeMapping.get(swaggerType);
        }
        return "string";
    }

    @Override
    public String toParamName(String name) {
        return this.toVarName(name);
    }

    @Override
    public String toModelName(String name) {
        if (this.isReservedWord(name)) {
            String modelName = Rails5ServerCodegen.camelize("Model" + name);
            LOGGER.warn(name + " (reserved word) cannot be used as model name. Renamed to " + modelName);
            return modelName;
        }
        return Rails5ServerCodegen.camelize(name);
    }

    @Override
    public String toModelFilename(String name) {
        if (this.isReservedWord(name)) {
            String filename = Rails5ServerCodegen.underscore("model_" + name);
            LOGGER.warn(name + " (reserved word) cannot be used as model filename. Renamed to " + filename);
            return filename;
        }
        return Rails5ServerCodegen.underscore(name);
    }

    @Override
    public String toApiFilename(String name) {
        name = name.replaceAll("-", "_");
        return Rails5ServerCodegen.underscore(name) + "_controller";
    }

    @Override
    public String toApiName(String name) {
        if (name.length() == 0) {
            return "ApiController";
        }
        return Rails5ServerCodegen.camelize(name) + "Controller";
    }

    @Override
    public String toOperationId(String operationId) {
        if (this.isReservedWord(operationId)) {
            String newOperationId = Rails5ServerCodegen.underscore("call_" + operationId);
            LOGGER.warn(operationId + " (reserved word) cannot be used as method name. Renamed to " + newOperationId);
            return newOperationId;
        }
        return Rails5ServerCodegen.underscore(operationId);
    }

    @Override
    public Map<String, Object> postProcessSupportingFileData(Map<String, Object> objs) {
        Swagger swagger = (Swagger)objs.get("swagger");
        if (swagger != null) {
            try {
                objs.put("swagger-yaml", Yaml.mapper().writeValueAsString((Object)swagger));
            }
            catch (JsonProcessingException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
        }
        return super.postProcessSupportingFileData(objs);
    }

    @Override
    public String escapeQuotationMark(String input) {
        return input.replace("'", "");
    }

    @Override
    public String escapeUnsafeCharacters(String input) {
        return input.replace("=end", "=_end").replace("=begin", "=_begin");
    }
}

