/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.protocols.http2;

import io.undertow.UndertowMessages;
import io.undertow.protocols.http2.Http2FrameHeaderParser;
import io.undertow.protocols.http2.Http2PushBackParser;
import java.io.IOException;
import java.nio.ByteBuffer;

class Http2PingParser
extends Http2PushBackParser {
    final byte[] data = new byte[8];

    public Http2PingParser(int frameLength) {
        super(frameLength);
    }

    @Override
    protected void handleData(ByteBuffer resource, Http2FrameHeaderParser parser) throws IOException {
        if (parser.length != 8) {
            throw new IOException(UndertowMessages.MESSAGES.httpPingDataMustBeLength8());
        }
        if (parser.streamId != 0) {
            throw new IOException(UndertowMessages.MESSAGES.streamIdMustBeZeroForFrameType(6));
        }
        if (resource.remaining() < 8) {
            return;
        }
        resource.get(this.data);
    }

    byte[] getData() {
        return this.data;
    }
}

