/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.spi.cluster.jgroups.impl.domain;

import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.core.shareddata.Lock;
import io.vertx.spi.cluster.jgroups.impl.support.LambdaLogger;
import java.util.concurrent.TimeUnit;
import org.jgroups.blocks.locking.LockService;

public class ClusteredLockImpl
implements Lock,
LambdaLogger {
    private static final Logger LOG = LoggerFactory.getLogger(ClusteredLockImpl.class);
    private final java.util.concurrent.locks.Lock lock;

    public ClusteredLockImpl(LockService lockService, String name) {
        this.lock = lockService.getLock(name);
    }

    public boolean acquire(long timeout) {
        try {
            this.logDebug(() -> String.format("Acquire lock on [%s] with timeout [%d]", this.lock, timeout));
            return this.lock.tryLock(timeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.interrupted();
            return false;
        }
    }

    public void release() {
        this.lock.unlock();
    }

    @Override
    public Logger log() {
        return LOG;
    }
}

