/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.spi.cluster.jgroups.impl.domain;

import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.spi.cluster.jgroups.impl.domain.ChoosableArrayList;
import io.vertx.spi.cluster.jgroups.impl.domain.MultiMap;
import io.vertx.spi.cluster.jgroups.impl.support.LambdaLogger;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;

public class MultiMapImpl<K, V>
implements MultiMap<K, V>,
LambdaLogger {
    private static final Logger log = LoggerFactory.getLogger(MultiMapImpl.class);
    private String name;
    private Map<K, ChoosableArrayList<V>> cache = new ConcurrentHashMap<K, ChoosableArrayList<V>>();

    public MultiMapImpl() {
    }

    public MultiMapImpl(String name) {
        this.name = name;
    }

    @Override
    public void add(K k, V v) {
        this.logTrace(() -> String.format("MultiMapImpl.add name = [%s] and  k = [%s], v = [%s]", this.name, k, v));
        this.cache.compute(k, (key, oldValue) -> Optional.ofNullable(oldValue).orElseGet(() -> ChoosableArrayList.emptyChoosable).add(v));
    }

    @Override
    public ChoosableArrayList<V> get(K k) {
        ChoosableArrayList v = this.cache.getOrDefault(k, ChoosableArrayList.emptyChoosable);
        this.logTrace(() -> String.format("MultiMapImpl.get name = [%s] and  k = [%s], v = [%s]", this.name, k, v));
        return v;
    }

    @Override
    public boolean remove(K k, V v) {
        this.logTrace(() -> String.format("MultiMapImpl.remove name = [%s] and  k = [%s], v = [%s]", this.name, k, v));
        boolean[] result = new boolean[]{false};
        this.cache.computeIfPresent(k, (key, oldValue) -> {
            result[0] = true;
            return oldValue.remove(v);
        });
        return result[0];
    }

    @Override
    public void removeAll(V v) {
        this.logTrace(() -> String.format("MultiMapImpl.removeAll name = [%s] and  v = [%s]", this.name, v));
        this.cache.replaceAll((k, oldValue) -> oldValue.remove(v));
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        this.logTrace(() -> String.format("MultiMapImpl.writeExternal name = [%s] and  cache = {%s}", this.name, this.cache));
        out.writeInt(this.cache.size());
        out.writeUTF(this.name);
        for (Map.Entry<K, ChoosableArrayList<V>> entry : this.cache.entrySet()) {
            out.writeObject(entry.getKey());
            out.writeObject(entry.getValue());
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.logTrace(() -> String.format("MultiMapImpl.readExternal name = [%s] and  cache = {%s}", this.name, this.cache));
        int size = in.readInt();
        this.name = in.readUTF();
        for (int i = 0; i < size; ++i) {
            Object key = in.readObject();
            ChoosableArrayList value = (ChoosableArrayList)in.readObject();
            this.cache.put(key, value);
        }
    }

    public String toString() {
        return "MultiMapImpl{name=" + this.name + ",cache=" + this.cache + '}';
    }

    @Override
    public Logger log() {
        return log;
    }
}

