/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.spi.cluster.jgroups.impl.listeners;

import io.vertx.core.Vertx;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.core.spi.cluster.NodeListener;
import io.vertx.spi.cluster.jgroups.impl.support.ArrayUtils;
import io.vertx.spi.cluster.jgroups.impl.support.ComparedValue;
import io.vertx.spi.cluster.jgroups.impl.support.LambdaLogger;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jgroups.Address;
import org.jgroups.Message;
import org.jgroups.ReceiverAdapter;
import org.jgroups.View;
import org.jgroups.ViewId;

public class TopologyListener
extends ReceiverAdapter
implements LambdaLogger {
    private static final Logger LOG = LoggerFactory.getLogger(TopologyListener.class);
    private final Vertx vertx;
    private final String lock = "lock";
    private volatile ViewId viewId;
    private volatile Address[] members = new Address[0];
    private Optional<NodeListener> nodeListener = Optional.empty();

    public TopologyListener(Vertx vertx) {
        this.vertx = vertx;
    }

    public void receive(Message msg) {
        this.logTrace(() -> String.format("Message receive [%s]", msg));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void viewAccepted(View view) {
        this.logDebug(() -> String.format("Called View accepted [%s]", view));
        if (view.getViewId() == null) {
            this.logWarn(() -> String.format("Called View accepted [%s] with ViewId null.", view));
            return;
        }
        if (this.viewId != null && view.getViewId().compareToIDs(this.viewId) <= 0) {
            this.logWarn(() -> String.format("Called View accepted [%s] but there's no changes.", view));
            return;
        }
        String string = "lock";
        synchronized ("lock") {
            this.viewId = view.getViewId().copy();
            Address[] oldMembers = this.members;
            this.members = (Address[])ArrayUtils.copySortAndFilter((Comparable[])view.getMembersRaw());
            this.nodeListener.ifPresent(listener -> {
                List comparedValues = ArrayUtils.compareSorted((Comparable[])oldMembers, (Comparable[])this.members);
                comparedValues.stream().filter(ComparedValue::isLeft).map(ComparedValue::getValue).forEach(left -> {
                    this.logTrace(() -> String.format("Node [%s] removed to the view", left));
                    this.vertx.executeBlocking(future -> listener.nodeLeft(left.toString()), h -> Function.identity());
                });
                comparedValues.stream().filter(ComparedValue::isRight).map(ComparedValue::getValue).forEach(right -> {
                    this.logTrace(() -> String.format("Node [%s] added to the view", right));
                    this.vertx.executeBlocking(future -> listener.nodeAdded(right.toString()), h -> Function.identity());
                });
            });
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public void setNodeListener(NodeListener nodeListener) {
        this.logDebug(() -> String.format("Set topology listener [%s]", nodeListener));
        this.nodeListener = Optional.of(nodeListener);
    }

    public List<String> getNodes() {
        this.logDebug(() -> String.format("Get Nodes from topology [%s]", Arrays.toString(this.members)));
        return Arrays.stream(this.members).map(Object::toString).collect(Collectors.toList());
    }

    @Override
    public Logger log() {
        return LOG;
    }
}

