/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.spi.cluster.jgroups.impl.services;

import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.spi.cluster.jgroups.impl.domain.MultiMap;
import io.vertx.spi.cluster.jgroups.impl.domain.MultiMapImpl;
import io.vertx.spi.cluster.jgroups.impl.services.RpcMultiMapService;
import io.vertx.spi.cluster.jgroups.impl.support.DataHolder;
import io.vertx.spi.cluster.jgroups.impl.support.LambdaLogger;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;

public class DefaultRpcMultiMapService
implements RpcMultiMapService,
LambdaLogger {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultRpcMultiMapService.class);
    private final Map<String, MultiMap> maps = new ConcurrentHashMap<String, MultiMap>();

    @Override
    public <K, V> MultiMap<K, V> multiMapCreate(String name) {
        this.logDebug(() -> String.format("method multiMapCreate key[%s]", name));
        return (MultiMap)this.executeAndReturn(name, Function.identity());
    }

    @Override
    public <K, V> void multiMapAdd(String name, DataHolder<K> k, DataHolder<V> v) {
        this.logDebug(() -> String.format("method multiMapAdd name[%s] key[%s] value[%s]", name, k, v));
        this.executeAndReturn(name, map -> {
            map.add(k.unwrap(), v.unwrap());
            return null;
        });
    }

    @Override
    public <K, V> boolean multiMapRemove(String name, DataHolder<K> k, DataHolder<V> v) {
        this.logDebug(() -> String.format("method multiMapRemove name[%s] key[%s] value[%s]", name, k, v));
        return this.executeAndReturn(name, map -> map.remove(k.unwrap(), v.unwrap()));
    }

    @Override
    public <K, V> void multiMapRemoveAll(String name, DataHolder<V> v) {
        this.logDebug(() -> String.format("method multiMapRemoveAll name[%s] value[%s]", name, v));
        this.executeAndReturn(name, map -> {
            map.removeAll(v.unwrap());
            return null;
        });
    }

    @Override
    public void writeTo(OutputStream output) throws IOException {
        try (ObjectOutputStream oos = new ObjectOutputStream(output);){
            oos.writeObject(this.maps);
        }
    }

    @Override
    public void readFrom(InputStream input) throws IOException, ClassNotFoundException {
        try (ObjectInputStream oos = new ObjectInputStream(input);){
            Map m = (Map)oos.readObject();
            this.maps.putAll(m);
        }
    }

    private <K, V, R> R executeAndReturn(String name, Function<MultiMap<K, V>, R> function) {
        MultiMap map = this.maps.computeIfAbsent(name, key -> {
            this.logDebug(() -> String.format("create multiMap with name[%s]", key));
            return new MultiMapImpl((String)key);
        });
        return function.apply(map);
    }

    @Override
    public Logger log() {
        return LOG;
    }
}

