/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.test.redis;

import io.vertx.core.Vertx;
import io.vertx.redis.RedisClient;
import io.vertx.redis.RedisOptions;
import io.vertx.test.core.VertxTestBase;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import redis.embedded.RedisServer;

public abstract class AbstractRedisClientBase
extends VertxTestBase {
    private static final Integer DEFAULT_PORT = 6379;
    private static final Map<Integer, RedisServer> instances = new ConcurrentHashMap<Integer, RedisServer>();
    protected RedisClient redis;

    private static String getHost() {
        return AbstractRedisClientBase.getProperty("host");
    }

    private static String getPort() {
        return AbstractRedisClientBase.getProperty("port");
    }

    private static String getProperty(String name) {
        String s = System.getProperty(name);
        return s != null && s.trim().length() > 0 ? s : null;
    }

    @BeforeClass
    public static void startRedis() throws Exception {
        if (AbstractRedisClientBase.getHost() == null && AbstractRedisClientBase.getPort() == null) {
            AbstractRedisClientBase.createRedisInstance(DEFAULT_PORT);
            instances.get(DEFAULT_PORT).start();
            System.out.println("** Using embedded redis");
        } else {
            System.out.println("** Using standalone redis");
        }
    }

    @AfterClass
    public static void stopRedis() throws Exception {
        for (Map.Entry<Integer, RedisServer> entry : instances.entrySet()) {
            if (entry == null) continue;
            entry.getValue().stop();
        }
    }

    public static void createRedisCount(int count) throws Exception {
        Integer[] ports = new Integer[count];
        Integer basePort = DEFAULT_PORT;
        for (int i = 0; i < count; ++i) {
            Integer n = basePort;
            Integer n2 = basePort = Integer.valueOf(basePort + 1);
            ports[i] = n;
        }
        AbstractRedisClientBase.createRedisInstance(ports);
    }

    public static void createRedisInstance(Integer ... ports) throws Exception {
        for (Integer port : ports) {
            System.out.println("Creating redis server on port: " + port);
            instances.put(port, new RedisServer(port));
            System.out.println("Created embedded redis server on port " + port);
        }
    }

    protected static String makeKey() {
        return UUID.randomUUID().toString();
    }

    public void setUp() throws Exception {
        super.setUp();
        this.redis = RedisClient.create((Vertx)this.vertx, (RedisOptions)this.getConfig());
    }

    public void tearDown() throws Exception {
        CountDownLatch latch = new CountDownLatch(1);
        this.redis.close(asyncResult -> {
            if (!asyncResult.succeeded()) {
                throw new RuntimeException("failed to setup", asyncResult.cause());
            }
            latch.countDown();
        });
        this.awaitLatch(latch);
        super.tearDown();
    }

    protected RedisOptions getConfig() {
        String host = AbstractRedisClientBase.getHost();
        String port = AbstractRedisClientBase.getPort();
        RedisOptions config = new RedisOptions();
        if (host != null) {
            config.setHost(host);
        }
        if (port != null) {
            config.setPort(Integer.parseInt(port));
        }
        return config;
    }
}

