/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.test.redis;

import io.vertx.core.Vertx;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.redis.RedisClient;
import io.vertx.redis.RedisOptions;
import io.vertx.test.redis.AbstractRedisClientBase;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.Test;

public class PubSubTest
extends AbstractRedisClientBase {
    @Test
    public void testPubSub() {
        String message = PubSubTest.makeKey();
        this.vertx.eventBus().consumer("io.vertx.redis.ch1", msg -> {
            JsonObject value = ((JsonObject)msg.body()).getJsonObject("value");
            this.assertEquals("ch1", value.getString("channel"));
            this.assertEquals(message, value.getString("message"));
            this.testComplete();
        });
        this.redis.subscribe("ch1", subscribe -> {
            this.assertTrue(subscribe.succeeded());
            this.assertEquals("subscribe", ((JsonArray)subscribe.result()).getValue(0));
            this.assertEquals("ch1", ((JsonArray)subscribe.result()).getValue(1));
            this.assertEquals(1L, ((JsonArray)subscribe.result()).getValue(2));
            this.redis.publish("ch1", message, res -> {
                this.assertTrue(res.succeeded());
                this.assertEquals(1L, res.result());
            });
        });
        this.await();
    }

    @Test
    public void testPubSubPattern() {
        String worldNews = "hello world";
        String technologyNews = "hello vertx";
        ArrayList inbox = new ArrayList();
        this.vertx.eventBus().consumer("io.vertx.redis.news.*", msg -> {
            inbox.add(((JsonObject)msg.body()).getJsonObject("value"));
            if (inbox.size() == 2 && ("hello world".equals(((JsonObject)inbox.get(0)).getString("message")) && "hello vertx".equals(((JsonObject)inbox.get(1)).getString("message")) || "hello world".equals(((JsonObject)inbox.get(1)).getString("message")) && "hello vertx".equals(((JsonObject)inbox.get(0)).getString("message")))) {
                this.testComplete();
            }
        });
        this.redis.psubscribe("news.*", subscribe -> {
            this.assertTrue(subscribe.succeeded());
            this.assertEquals("psubscribe", ((JsonArray)subscribe.result()).getValue(0));
            this.assertEquals("news.*", ((JsonArray)subscribe.result()).getValue(1));
            this.assertEquals(1L, ((JsonArray)subscribe.result()).getValue(2));
            this.redis.publish("news.world", "hello world", r0 -> {
                this.assertTrue(r0.succeeded());
                this.assertEquals(1L, (Long)r0.result());
            });
            this.redis.publish("news.technology", "hello vertx", r0 -> {
                this.assertTrue(r0.succeeded());
                this.assertEquals(1L, (Long)r0.result());
            });
        });
        this.await();
    }

    @Test
    public void testLateJoin() {
        String message = PubSubTest.makeKey();
        AtomicInteger cnt = new AtomicInteger(0);
        this.vertx.eventBus().consumer("io.vertx.redis.ch2", msg -> {
            JsonObject value = ((JsonObject)msg.body()).getJsonObject("value");
            this.assertEquals("ch2", value.getString("channel"));
            this.assertEquals(message, value.getString("message"));
            if (cnt.incrementAndGet() == 2) {
                this.testComplete();
            }
        });
        this.redis.subscribe("ch2", subscribe -> {
            this.assertTrue(subscribe.succeeded());
            this.assertEquals("subscribe", ((JsonArray)subscribe.result()).getValue(0));
            this.assertEquals("ch2", ((JsonArray)subscribe.result()).getValue(1));
            this.assertEquals(1L, ((JsonArray)subscribe.result()).getValue(2));
            RedisClient redis2 = RedisClient.create((Vertx)this.vertx, (RedisOptions)this.getConfig());
            redis2.subscribe("ch2", subscribe2 -> {
                this.assertTrue(subscribe2.succeeded());
                this.assertEquals("subscribe", ((JsonArray)subscribe2.result()).getValue(0));
                this.assertEquals("ch2", ((JsonArray)subscribe2.result()).getValue(1));
                this.assertEquals(1L, ((JsonArray)subscribe2.result()).getValue(2));
                redis2.publish("ch2", message, r0 -> {
                    this.assertTrue(r0.succeeded());
                    this.assertEquals(2L, (Long)r0.result());
                });
            });
        });
        this.await();
    }

    @Test
    public void testReconnect() {
        String message = PubSubTest.makeKey();
        AtomicInteger cnt = new AtomicInteger(0);
        this.vertx.eventBus().consumer("io.vertx.redis.ch3", msg -> {
            JsonObject value = ((JsonObject)msg.body()).getJsonObject("value");
            this.assertEquals("ch3", value.getString("channel"));
            this.assertEquals(message, value.getString("message"));
            if (cnt.incrementAndGet() == 2) {
                this.testComplete();
            }
        });
        this.redis.subscribe("ch3", subscribe -> {
            this.assertTrue(subscribe.succeeded());
            this.assertEquals("subscribe", ((JsonArray)subscribe.result()).getValue(0));
            this.assertEquals("ch3", ((JsonArray)subscribe.result()).getValue(1));
            this.assertEquals(1L, ((JsonArray)subscribe.result()).getValue(2));
            this.redis.publish("ch3", message, r0 -> {
                this.assertTrue(r0.succeeded());
                try {
                    PubSubTest.stopRedis();
                    this.vertx.setTimer(500L, v -> {
                        try {
                            PubSubTest.startRedis();
                            this.vertx.setTimer(500L, v1 -> this.redis.ping(v2 -> {
                                this.assertTrue(v2.succeeded());
                                this.vertx.setTimer(500L, v3 -> this.redis.publish("ch3", message, r1 -> this.assertTrue(r1.succeeded())));
                            }));
                        }
                        catch (Exception e) {
                            this.fail(e);
                        }
                    });
                }
                catch (Exception e) {
                    this.fail(e);
                }
            });
        });
        this.await();
    }
}

