/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.redis;

import java.util.Map;
import io.reactivex.Observable;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import io.vertx.redis.op.BitOperation;
import io.vertx.redis.op.ResetOptions;
import io.vertx.redis.op.ObjectCmd;
import io.vertx.redis.op.KillFilter;
import java.util.Map;
import io.vertx.redis.op.GeoUnit;
import io.vertx.core.json.JsonObject;
import io.vertx.core.AsyncResult;
import io.vertx.redis.op.RangeOptions;
import io.vertx.redis.op.GeoMember;
import io.vertx.redis.op.GeoRadiusOptions;
import io.vertx.redis.op.InsertOptions;
import io.vertx.redis.op.AggregateOptions;
import io.vertx.redis.op.SetOptions;
import io.vertx.redis.op.SortOptions;
import io.vertx.redis.op.MigrateOptions;
import io.vertx.redis.op.ScanOptions;
import io.vertx.redis.op.FailoverOptions;
import io.vertx.redis.op.SlotCmd;
import io.vertx.redis.op.RangeLimitOptions;
import io.vertx.redis.op.LimitOptions;
import io.vertx.core.json.JsonArray;
import java.util.List;
import io.vertx.reactivex.core.buffer.Buffer;
import io.vertx.core.Handler;

/**
 * This Interface represents a TX
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.redis.RedisTransaction original} non RX-ified interface using Vert.x codegen.
 */

@io.vertx.lang.reactivex.RxGen(io.vertx.redis.RedisTransaction.class)
public class RedisTransaction {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    RedisTransaction that = (RedisTransaction) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final io.vertx.lang.reactivex.TypeArg<RedisTransaction> __TYPE_ARG = new io.vertx.lang.reactivex.TypeArg<>(
    obj -> new RedisTransaction((io.vertx.redis.RedisTransaction) obj),
    RedisTransaction::getDelegate
  );

  private final io.vertx.redis.RedisTransaction delegate;
  
  public RedisTransaction(io.vertx.redis.RedisTransaction delegate) {
    this.delegate = delegate;
  }

  public io.vertx.redis.RedisTransaction getDelegate() {
    return delegate;
  }

  /**
   * Close the client - when it is fully closed the handler will be called.
   * @param handler 
   */
  public void close(Handler<AsyncResult<Void>> handler) { 
    delegate.close(handler);
  }

  /**
   * Close the client - when it is fully closed the handler will be called.
   * @return 
   */
  public Completable rxClose() { 
    return new io.vertx.reactivex.core.impl.AsyncResultCompletable(handler -> {
      close(handler);
    });
  }

  /**
   * Append a value to a key
   * @param key Key string
   * @param value Value to append
   * @param handler Handler for the result of this call.
   * @return 
   */
  public RedisTransaction append(String key, String value, Handler<AsyncResult<String>> handler) { 
    delegate.append(key, value, handler);
    return this;
  }

  /**
   * Append a value to a key
   * @param key Key string
   * @param value Value to append
   * @return 
   */
  public Single<String> rxAppend(String key, String value) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      append(key, value, handler);
    });
  }

  /**
   * Authenticate to the server
   * @param password Password for authentication
   * @param handler Handler for the result of this call.
   * @return 
   */
  public RedisTransaction auth(String password, Handler<AsyncResult<String>> handler) { 
    delegate.auth(password, handler);
    return this;
  }

  /**
   * Authenticate to the server
   * @param password Password for authentication
   * @return 
   */
  public Single<String> rxAuth(String password) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      auth(password, handler);
    });
  }

  /**
   * Asynchronously rewrite the append-only file
   * @param handler 
   * @return 
   */
  public RedisTransaction bgrewriteaof(Handler<AsyncResult<String>> handler) { 
    delegate.bgrewriteaof(handler);
    return this;
  }

  /**
   * Asynchronously rewrite the append-only file
   * @return 
   */
  public Single<String> rxBgrewriteaof() { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      bgrewriteaof(handler);
    });
  }

  /**
   * Asynchronously save the dataset to disk
   * @param handler 
   * @return 
   */
  public RedisTransaction bgsave(Handler<AsyncResult<String>> handler) { 
    delegate.bgsave(handler);
    return this;
  }

  /**
   * Asynchronously save the dataset to disk
   * @return 
   */
  public Single<String> rxBgsave() { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      bgsave(handler);
    });
  }

  /**
   * Count set bits in a string
   * @param key Key string
   * @param handler Handler for the result of this call.
   * @return 
   */
  public RedisTransaction bitcount(String key, Handler<AsyncResult<String>> handler) { 
    delegate.bitcount(key, handler);
    return this;
  }

  /**
   * Count set bits in a string
   * @param key Key string
   * @return 
   */
  public Single<String> rxBitcount(String key) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      bitcount(key, handler);
    });
  }

  /**
   * Count set bits in a string
   * @param key Key string
   * @param start Start index
   * @param end End index
   * @param handler Handler for the result of this call.
   * @return 
   */
  public RedisTransaction bitcountRange(String key, long start, long end, Handler<AsyncResult<String>> handler) { 
    delegate.bitcountRange(key, start, end, handler);
    return this;
  }

  /**
   * Count set bits in a string
   * @param key Key string
   * @param start Start index
   * @param end End index
   * @return 
   */
  public Single<String> rxBitcountRange(String key, long start, long end) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      bitcountRange(key, start, end, handler);
    });
  }

  /**
   * Perform bitwise operations between strings
   * @param operation Bitwise operation to perform
   * @param destkey Destination key where result is stored
   * @param keys List of keys on which to perform the operation
   * @param handler Handler for the result of this call.
   * @return 
   */
  public RedisTransaction bitop(BitOperation operation, String destkey, List<String> keys, Handler<AsyncResult<String>> handler) { 
    delegate.bitop(operation, destkey, keys, handler);
    return this;
  }

  /**
   * Perform bitwise operations between strings
   * @param operation Bitwise operation to perform
   * @param destkey Destination key where result is stored
   * @param keys List of keys on which to perform the operation
   * @return 
   */
  public Single<String> rxBitop(BitOperation operation, String destkey, List<String> keys) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      bitop(operation, destkey, keys, handler);
    });
  }

  /**
   * Find first bit set or clear in a string
   * @param key Key string
   * @param bit What bit value to look for - must be 1, or 0
   * @param handler Handler for the result of this call.
   * @return 
   */
  public RedisTransaction bitpos(String key, int bit, Handler<AsyncResult<String>> handler) { 
    delegate.bitpos(key, bit, handler);
    return this;
  }

  /**
   * Find first bit set or clear in a string
   * @param key Key string
   * @param bit What bit value to look for - must be 1, or 0
   * @return 
   */
  public Single<String> rxBitpos(String key, int bit) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      bitpos(key, bit, handler);
    });
  }

  /**
   * Find first bit set or clear in a string
   * <p>
   * See also bitposRange() method, which takes start, and stop offset.
   * @param key Key string
   * @param bit What bit value to look for - must be 1, or 0
   * @param start Start offset
   * @param handler Handler for the result of this call.
   * @return 
   */
  public RedisTransaction bitposFrom(String key, int bit, int start, Handler<AsyncResult<String>> handler) { 
    delegate.bitposFrom(key, bit, start, handler);
    return this;
  }

  /**
   * Find first bit set or clear in a string
   * <p>
   * See also bitposRange() method, which takes start, and stop offset.
   * @param key Key string
   * @param bit What bit value to look for - must be 1, or 0
   * @param start Start offset
   * @return 
   */
  public Single<String> rxBitposFrom(String key, int bit, int start) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      bitposFrom(key, bit, start, handler);
    });
  }

  /**
   * Find first bit set or clear in a string
   * <p>
   * Note: when both start, and stop offsets are specified,
   * behaviour is slightly different than if only start is specified
   * @param key Key string
   * @param bit What bit value to look for - must be 1, or 0
   * @param start Start offset
   * @param stop End offset - inclusive
   * @param handler Handler for the result of this call.
   * @return 
   */
  public RedisTransaction bitposRange(String key, int bit, int start, int stop, Handler<AsyncResult<String>> handler) { 
    delegate.bitposRange(key, bit, start, stop, handler);
    return this;
  }

  /**
   * Find first bit set or clear in a string
   * <p>
   * Note: when both start, and stop offsets are specified,
   * behaviour is slightly different than if only start is specified
   * @param key Key string
   * @param bit What bit value to look for - must be 1, or 0
   * @param start Start offset
   * @param stop End offset - inclusive
   * @return 
   */
  public Single<String> rxBitposRange(String key, int bit, int start, int stop) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      bitposRange(key, bit, start, stop, handler);
    });
  }

  /**
   * Remove and get the first element in a list, or block until one is available
   * @param key Key string identifying a list to watch
   * @param seconds Timeout in seconds
   * @param handler Handler for the result of this call.
   * @return 
   */
  public RedisTransaction blpop(String key, int seconds, Handler<AsyncResult<String>> handler) { 
    delegate.blpop(key, seconds, handler);
    return this;
  }

  /**
   * Remove and get the first element in a list, or block until one is available
   * @param key Key string identifying a list to watch
   * @param seconds Timeout in seconds
   * @return 
   */
  public Single<String> rxBlpop(String key, int seconds) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      blpop(key, seconds, handler);
    });
  }

  /**
   * Remove and get the first element in any of the lists, or block until one is available
   * @param keys List of key strings identifying lists to watch
   * @param seconds Timeout in seconds
   * @param handler Handler for the result of this call.
   * @return 
   */
  public RedisTransaction blpopMany(List<String> keys, int seconds, Handler<AsyncResult<String>> handler) { 
    delegate.blpopMany(keys, seconds, handler);
    return this;
  }

  /**
   * Remove and get the first element in any of the lists, or block until one is available
   * @param keys List of key strings identifying lists to watch
   * @param seconds Timeout in seconds
   * @return 
   */
  public Single<String> rxBlpopMany(List<String> keys, int seconds) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      blpopMany(keys, seconds, handler);
    });
  }

  /**
   * Remove and get the last element in a list, or block until one is available
   * @param key Key string identifying a list to watch
   * @param seconds Timeout in seconds
   * @param handler Handler for the result of this call.
   * @return 
   */
  public RedisTransaction brpop(String key, int seconds, Handler<AsyncResult<String>> handler) { 
    delegate.brpop(key, seconds, handler);
    return this;
  }

  /**
   * Remove and get the last element in a list, or block until one is available
   * @param key Key string identifying a list to watch
   * @param seconds Timeout in seconds
   * @return 
   */
  public Single<String> rxBrpop(String key, int seconds) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      brpop(key, seconds, handler);
    });
  }

  /**
   * Remove and get the last element in any of the lists, or block until one is available
   * @param keys List of key strings identifying lists to watch
   * @param seconds Timeout in seconds
   * @param handler Handler for the result of this call.
   * @return 
   */
  public RedisTransaction brpopMany(List<String> keys, int seconds, Handler<AsyncResult<String>> handler) { 
    delegate.brpopMany(keys, seconds, handler);
    return this;
  }

  /**
   * Remove and get the last element in any of the lists, or block until one is available
   * @param keys List of key strings identifying lists to watch
   * @param seconds Timeout in seconds
   * @return 
   */
  public Single<String> rxBrpopMany(List<String> keys, int seconds) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      brpopMany(keys, seconds, handler);
    });
  }

  /**
   * Pop a value from a list, push it to another list and return it; or block until one is available
   * @param key Key string identifying the source list
   * @param destkey Key string identifying the destination list
   * @param seconds Timeout in seconds
   * @param handler Handler for the result of this call.
   * @return 
   */
  public RedisTransaction brpoplpush(String key, String destkey, int seconds, Handler<AsyncResult<String>> handler) { 
    delegate.brpoplpush(key, destkey, seconds, handler);
    return this;
  }

  /**
   * Pop a value from a list, push it to another list and return it; or block until one is available
   * @param key Key string identifying the source list
   * @param destkey Key string identifying the destination list
   * @param seconds Timeout in seconds
   * @return 
   */
  public Single<String> rxBrpoplpush(String key, String destkey, int seconds) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      brpoplpush(key, destkey, seconds, handler);
    });
  }

  /**
   * Kill the connection of a client
   * @param filter Filter options
   * @param handler Handler for the result of this call.
   * @return 
   */
  public RedisTransaction clientKill(KillFilter filter, Handler<AsyncResult<String>> handler) { 
    delegate.clientKill(filter, handler);
    return this;
  }

  /**
   * Kill the connection of a client
   * @param filter Filter options
   * @return 
   */
  public Single<String> rxClientKill(KillFilter filter) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      clientKill(filter, handler);
    });
  }

  /**
   * Get the list of client connections
   * @param handler 
   * @return 
   */
  public RedisTransaction clientList(Handler<AsyncResult<String>> handler) { 
    delegate.clientList(handler);
    return this;
  }

  /**
   * Get the list of client connections
   * @return 
   */
  public Single<String> rxClientList() { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      clientList(handler);
    });
  }

  /**
   * Get the current connection name
   * @param handler 
   * @return 
   */
  public RedisTransaction clientGetname(Handler<AsyncResult<String>> handler) { 
    delegate.clientGetname(handler);
    return this;
  }

  /**
   * Get the current connection name
   * @return 
   */
  public Single<String> rxClientGetname() { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      clientGetname(handler);
    });
  }

  /**
   * Stop processing commands from clients for some time
   * @param millis Pause time in milliseconds
   * @param handler Handler for the result of this call.
   * @return 
   */
  public RedisTransaction clientPause(long millis, Handler<AsyncResult<String>> handler) { 
    delegate.clientPause(millis, handler);
    return this;
  }

  /**
   * Stop processing commands from clients for some time
   * @param millis Pause time in milliseconds
   * @return 
   */
  public Single<String> rxClientPause(long millis) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      clientPause(millis, handler);
    });
  }

  /**
   * Set the current connection name
   * @param name New name for current connection
   * @param handler Handler for the result of this call.
   * @return 
   */
  public RedisTransaction clientSetname(String name, Handler<AsyncResult<String>> handler) { 
    delegate.clientSetname(name, handler);
    return this;
  }

  /**
   * Set the current connection name
   * @param name New name for current connection
   * @return 
   */
  public Single<String> rxClientSetname(String name) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      clientSetname(name, handler);
    });
  }

  /**
   * Assign new hash slots to receiving node.
   * @param slots 
   * @param handler Handler for the result of this call.
   * @return 
   */
  public RedisTransaction clusterAddslots(List<String> slots, Handler<AsyncResult<String>> handler) { 
    delegate.clusterAddslots(slots, handler);
    return this;
  }

  /**
   * Assign new hash slots to receiving node.
   * @param slots 
   * @return 
   */
  public Single<String> rxClusterAddslots(List<String> slots) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      clusterAddslots(slots, handler);
    });
  }

  /**
   * Return the number of failure reports active for a given node.
   * @param nodeId 
   * @param handler Handler for the result of this call.
   * @return 
   */
  public RedisTransaction clusterCountFailureReports(String nodeId, Handler<AsyncResult<String>> handler) { 
    delegate.clusterCountFailureReports(nodeId, handler);
    return this;
  }

  /**
   * Return the number of failure reports active for a given node.
   * @param nodeId 
   * @return 
   */
  public Single<String> rxClusterCountFailureReports(String nodeId) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      clusterCountFailureReports(nodeId, handler);
    });
  }

  /**
   * Return the number of local keys in the specified hash slot.
   * @param slot 
   * @param handler Handler for the result of this call.
   * @return 
   */
  public RedisTransaction clusterCountkeysinslot(long slot, Handler<AsyncResult<String>> handler) { 
    delegate.clusterCountkeysinslot(slot, handler);
    return this;
  }

  /**
   * Return the number of local keys in the specified hash slot.
   * @param slot 
   * @return 
   */
  public Single<String> rxClusterCountkeysinslot(long slot) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      clusterCountkeysinslot(slot, handler);
    });
  }

  /**
   * Set hash slots as unbound in receiving node.
   * @param slot 
   * @param handler Handler for the result of this call.
   * @return 
   */
  public RedisTransaction clusterDelslots(long slot, Handler<AsyncResult<String>> handler) { 
    delegate.clusterDelslots(slot, handler);
    return this;
  }

  /**
   * Set hash slots as unbound in receiving node.
   * @param slot 
   * @return 
   */
  public Single<String> rxClusterDelslots(long slot) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      clusterDelslots(slot, handler);
    });
  }

  /**
   * Set hash slots as unbound in receiving node.
   * @param slots 
   * @param handler Handler for the result of this call.
   * @return 
   */
  public RedisTransaction clusterDelslotsMany(List<String> slots, Handler<AsyncResult<String>> handler) { 
    delegate.clusterDelslotsMany(slots, handler);
    return this;
  }

  /**
   * Set hash slots as unbound in receiving node.
   * @param slots 
   * @return 
   */
  public Single<String> rxClusterDelslotsMany(List<String> slots) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      clusterDelslotsMany(slots, handler);
    });
  }

  /**
   * Forces a slave to perform a manual failover of its master.
   * @param handler Handler for the result of this call.
   * @return 
   */
  public RedisTransaction clusterFailover(Handler<AsyncResult<String>> handler) { 
    delegate.clusterFailover(handler);
    return this;
  }

  /**
   * Forces a slave to perform a manual failover of its master.
   * @return 
   */
  public Single<String> rxClusterFailover() { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      clusterFailover(handler);
    });
  }

  /**
   * Forces a slave to perform a manual failover of its master.
   * @param options 
   * @param handler Handler for the result of this call.
   * @return 
   */
  public RedisTransaction clusterFailOverWithOptions(FailoverOptions options, Handler<AsyncResult<String>> handler) { 
    delegate.clusterFailOverWithOptions(options, handler);
    return this;
  }

  /**
   * Forces a slave to perform a manual failover of its master.
   * @param options 
   * @return 
   */
  public Single<String> rxClusterFailOverWithOptions(FailoverOptions options) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      clusterFailOverWithOptions(options, handler);
    });
  }

  /**
   * Remove a node from the nodes table.
   * @param nodeId 
   * @param handler Handler for the result of this call.
   * @return 
   */
  public RedisTransaction clusterForget(String nodeId, Handler<AsyncResult<String>> handler) { 
    delegate.clusterForget(nodeId, handler);
    return this;
  }

  /**
   * Remove a node from the nodes table.
   * @param nodeId 
   * @return 
   */
  public Single<String> rxClusterForget(String nodeId) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      clusterForget(nodeId, handler);
    });
  }

  /**
   * Return local key names in the specified hash slot.
   * @param slot 
   * @param count 
   * @param handler Handler for the result of this call.
   * @return 
   */
  public RedisTransaction clusterGetkeysinslot(long slot, long count, Handler<AsyncResult<String>> handler) { 
    delegate.clusterGetkeysinslot(slot, count, handler);
    return this;
  }

  /**
   * Return local key names in the specified hash slot.
   * @param slot 
   * @param count 
   * @return 
   */
  public Single<String> rxClusterGetkeysinslot(long slot, long count) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      clusterGetkeysinslot(slot, count, handler);
    });
  }

  /**
   * Provides info about Redis Cluster node state.
   * @param handler Handler for the result of this call.
   * @return 
   */
  public RedisTransaction clusterInfo(Handler<AsyncResult<String>> handler) { 
    delegate.clusterInfo(handler);
    return this;
  }

  /**
   * Provides info about Redis Cluster node state.
   * @return 
   */
  public Single<String> rxClusterInfo() { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      clusterInfo(handler);
    });
  }

  /**
   * Returns the hash slot of the specified key.
   * @param key 
   * @param handler Handler for the result of this call.
   * @return 
   */
  public RedisTransaction clusterKeyslot(String key, Handler<AsyncResult<String>> handler) { 
    delegate.clusterKeyslot(key, handler);
    return this;
  }

  /**
   * Returns the hash slot of the specified key.
   * @param key 
   * @return 
   */
  public Single<String> rxClusterKeyslot(String key) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      clusterKeyslot(key, handler);
    });
  }

  /**
   * Force a node cluster to handshake with another node.
   * @param ip 
   * @param port 
   * @param handler Handler for the result of this call.
   * @return 
   */
  public RedisTransaction clusterMeet(String ip, long port, Handler<AsyncResult<String>> handler) { 
    delegate.clusterMeet(ip, port, handler);
    return this;
  }

  /**
   * Force a node cluster to handshake with another node.
   * @param ip 
   * @param port 
   * @return 
   */
  public Single<String> rxClusterMeet(String ip, long port) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      clusterMeet(ip, port, handler);
    });
  }

  /**
   * Get Cluster config for the node.
   * @param handler Handler for the result of this call.
   * @return 
   */
  public RedisTransaction clusterNodes(Handler<AsyncResult<String>> handler) { 
    delegate.clusterNodes(handler);
    return this;
  }

  /**
   * Get Cluster config for the node.
   * @return 
   */
  public Single<String> rxClusterNodes() { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      clusterNodes(handler);
    });
  }

  /**
   * Reconfigure a node as a slave of the specified master node.
   * @param nodeId 
   * @param handler Handler for the result of this call.
   * @return 
   */
  public RedisTransaction clusterReplicate(String nodeId, Handler<AsyncResult<String>> handler) { 
    delegate.clusterReplicate(nodeId, handler);
    return this;
  }

  /**
   * Reconfigure a node as a slave of the specified master node.
   * @param nodeId 
   * @return 
   */
  public Single<String> rxClusterReplicate(String nodeId) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      clusterReplicate(nodeId, handler);
    });
  }

  /**
   * Reset a Redis Cluster node.
   * @param handler Handler for the result of this call.
   * @return 
   */
  public RedisTransaction clusterReset(Handler<AsyncResult<String>> handler) { 
    delegate.clusterReset(handler);
    return this;
  }

  /**
   * Reset a Redis Cluster node.
   * @return 
   */
  public Single<String> rxClusterReset() { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      clusterReset(handler);
    });
  }

  /**
   * Reset a Redis Cluster node.
   * @param options 
   * @param handler Handler for the result of this call.
   * @return 
   */
  public RedisTransaction clusterResetWithOptions(ResetOptions options, Handler<AsyncResult<String>> handler) { 
    delegate.clusterResetWithOptions(options, handler);
    return this;
  }

  /**
   * Reset a Redis Cluster node.
   * @param options 
   * @return 
   */
  public Single<String> rxClusterResetWithOptions(ResetOptions options) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      clusterResetWithOptions(options, handler);
    });
  }

  /**
   * Forces the node to save cluster state on disk.
   * @param handler Handler for the result of this call.
   * @return 
   */
  public RedisTransaction clusterSaveconfig(Handler<AsyncResult<String>> handler) { 
    delegate.clusterSaveconfig(handler);
    return this;
  }

  /**
   * Forces the node to save cluster state on disk.
   * @return 
   */
  public Single<String> rxClusterSaveconfig() { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      clusterSaveconfig(handler);
    });
  }

  /**
   * Set the configuration epoch in a new node.
   * @param epoch 
   * @param handler Handler for the result of this call.
   * @return 
   */
  public RedisTransaction clusterSetConfigEpoch(long epoch, Handler<AsyncResult<String>> handler) { 
    delegate.clusterSetConfigEpoch(epoch, handler);
    return this;
  }

  /**
   * Set the configuration epoch in a new node.
   * @param epoch 
   * @return 
   */
  public Single<String> rxClusterSetConfigEpoch(long epoch) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      clusterSetConfigEpoch(epoch, handler);
    });
  }

  /**
   * Bind an hash slot to a specific node.
   * @param slot 
   * @param subcommand 
   * @param handler Handler for the result of this call.
   * @return 
   */
  public RedisTransaction clusterSetslot(long slot, SlotCmd subcommand, Handler<AsyncResult<String>> handler) { 
    delegate.clusterSetslot(slot, subcommand, handler);
    return this;
  }

  /**
   * Bind an hash slot to a specific node.
   * @param slot 
   * @param subcommand 
   * @return 
   */
  public Single<String> rxClusterSetslot(long slot, SlotCmd subcommand) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      clusterSetslot(slot, subcommand, handler);
    });
  }

  /**
   * Bind an hash slot to a specific node.
   * @param slot 
   * @param subcommand 
   * @param nodeId 
   * @param handler Handler for the result of this call.
   * @return 
   */
  public RedisTransaction clusterSetslotWithNode(long slot, SlotCmd subcommand, String nodeId, Handler<AsyncResult<String>> handler) { 
    delegate.clusterSetslotWithNode(slot, subcommand, nodeId, handler);
    return this;
  }

  /**
   * Bind an hash slot to a specific node.
   * @param slot 
   * @param subcommand 
   * @param nodeId 
   * @return 
   */
  public Single<String> rxClusterSetslotWithNode(long slot, SlotCmd subcommand, String nodeId) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      clusterSetslotWithNode(slot, subcommand, nodeId, handler);
    });
  }

  /**
   * List slave nodes of the specified master node.
   * @param nodeId 
   * @param handler Handler for the result of this call.
   * @return 
   */
  public RedisTransaction clusterSlaves(String nodeId, Handler<AsyncResult<String>> handler) { 
    delegate.clusterSlaves(nodeId, handler);
    return this;
  }

  /**
   * List slave nodes of the specified master node.
   * @param nodeId 
   * @return 
   */
  public Single<String> rxClusterSlaves(String nodeId) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      clusterSlaves(nodeId, handler);
    });
  }

  /**
   * Get array of Cluster slot to node mappings
   * @param handler 
   * @return 
   */
  public RedisTransaction clusterSlots(Handler<AsyncResult<String>> handler) { 
    delegate.clusterSlots(handler);
    return this;
  }

  /**
   * Get array of Cluster slot to node mappings
   * @return 
   */
  public Single<String> rxClusterSlots() { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      clusterSlots(handler);
    });
  }

  /**
   * Get array of Redis command details
   * @param handler 
   * @return 
   */
  public RedisTransaction command(Handler<AsyncResult<String>> handler) { 
    delegate.command(handler);
    return this;
  }

  /**
   * Get array of Redis command details
   * @return 
   */
  public Single<String> rxCommand() { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      command(handler);
    });
  }

  /**
   * Get total number of Redis commands
   * @param handler 
   * @return 
   */
  public RedisTransaction commandCount(Handler<AsyncResult<String>> handler) { 
    delegate.commandCount(handler);
    return this;
  }

  /**
   * Get total number of Redis commands
   * @return 
   */
  public Single<String> rxCommandCount() { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      commandCount(handler);
    });
  }

  /**
   * Extract keys given a full Redis command
   * @param handler 
   * @return 
   */
  public RedisTransaction commandGetkeys(Handler<AsyncResult<String>> handler) { 
    delegate.commandGetkeys(handler);
    return this;
  }

  /**
   * Extract keys given a full Redis command
   * @return 
   */
  public Single<String> rxCommandGetkeys() { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      commandGetkeys(handler);
    });
  }

  /**
   * Get array of specific Redis command details
   * @param commands List of commands to get info for
   * @param handler Handler for the result of this call.
   * @return 
   */
  public RedisTransaction commandInfo(List<String> commands, Handler<AsyncResult<String>> handler) { 
    delegate.commandInfo(commands, handler);
    return this;
  }

  /**
   * Get array of specific Redis command details
   * @param commands List of commands to get info for
   * @return 
   */
  public Single<String> rxCommandInfo(List<String> commands) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      commandInfo(commands, handler);
    });
  }

  /**
   * Get the value of a configuration parameter
   * @param parameter Configuration parameter
   * @param handler Handler for the result of this call.
   * @return 
   */
  public RedisTransaction configGet(String parameter, Handler<AsyncResult<String>> handler) { 
    delegate.configGet(parameter, handler);
    return this;
  }

  /**
   * Get the value of a configuration parameter
   * @param parameter Configuration parameter
   * @return 
   */
  public Single<String> rxConfigGet(String parameter) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      configGet(parameter, handler);
    });
  }

  /**
   * Rewrite the configuration file with the in memory configuration
   * @param handler 
   * @return 
   */
  public RedisTransaction configRewrite(Handler<AsyncResult<String>> handler) { 
    delegate.configRewrite(handler);
    return this;
  }

  /**
   * Rewrite the configuration file with the in memory configuration
   * @return 
   */
  public Single<String> rxConfigRewrite() { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      configRewrite(handler);
    });
  }

  /**
   * Set a configuration parameter to the given value
   * @param parameter Configuration parameter
   * @param value New value
   * @param handler Handler for the result of this call.
   * @return 
   */
  public RedisTransaction configSet(String parameter, String value, Handler<AsyncResult<String>> handler) { 
    delegate.configSet(parameter, value, handler);
    return this;
  }

  /**
   * Set a configuration parameter to the given value
   * @param parameter Configuration parameter
   * @param value New value
   * @return 
   */
  public Single<String> rxConfigSet(String parameter, String value) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      configSet(parameter, value, handler);
    });
  }

  /**
   * Reset the stats returned by INFO
   * @param handler 
   * @return 
   */
  public RedisTransaction configResetstat(Handler<AsyncResult<String>> handler) { 
    delegate.configResetstat(handler);
    return this;
  }

  /**
   * Reset the stats returned by INFO
   * @return 
   */
  public Single<String> rxConfigResetstat() { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      configResetstat(handler);
    });
  }

  /**
   * Return the number of keys in the selected database
   * @param handler 
   * @return 
   */
  public RedisTransaction dbsize(Handler<AsyncResult<String>> handler) { 
    delegate.dbsize(handler);
    return this;
  }

  /**
   * Return the number of keys in the selected database
   * @return 
   */
  public Single<String> rxDbsize() { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      dbsize(handler);
    });
  }

  /**
   * Get debugging information about a key
   * @param key Key string
   * @param handler Handler for the result of this call.
   * @return 
   */
  public RedisTransaction debugObject(String key, Handler<AsyncResult<String>> handler) { 
    delegate.debugObject(key, handler);
    return this;
  }

  /**
   * Get debugging information about a key
   * @param key Key string
   * @return 
   */
  public Single<String> rxDebugObject(String key) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      debugObject(key, handler);
    });
  }

  /**
   * Make the server crash
   * @param handler 
   * @return 
   */
  public RedisTransaction debugSegfault(Handler<AsyncResult<String>> handler) { 
    delegate.debugSegfault(handler);
    return this;
  }

  /**
   * Make the server crash
   * @return 
   */
  public Single<String> rxDebugSegfault() { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      debugSegfault(handler);
    });
  }

  /**
   * Decrement the integer value of a key by one
   * @param key Key string
   * @param handler Handler for the result of this call.
   * @return 
   */
  public RedisTransaction decr(String key, Handler<AsyncResult<String>> handler) { 
    delegate.decr(key, handler);
    return this;
  }

  /**
   * Decrement the integer value of a key by one
   * @param key Key string
   * @return 
   */
  public Single<String> rxDecr(String key) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      decr(key, handler);
    });
  }

  /**
   * Decrement the integer value of a key by the given number
   * @param key Key string
   * @param decrement Value by which to decrement
   * @param handler Handler for the result of this call.
   * @return 
   */
  public RedisTransaction decrby(String key, long decrement, Handler<AsyncResult<String>> handler) { 
    delegate.decrby(key, decrement, handler);
    return this;
  }

  /**
   * Decrement the integer value of a key by the given number
   * @param key Key string
   * @param decrement Value by which to decrement
   * @return 
   */
  public Single<String> rxDecrby(String key, long decrement) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      decrby(key, decrement, handler);
    });
  }

  /**
   * Delete a key
   * @param key Keys to delete
   * @param handler Handler for the result of this call.
   * @return 
   */
  public RedisTransaction del(String key, Handler<AsyncResult<String>> handler) { 
    delegate.del(key, handler);
    return this;
  }

  /**
   * Delete a key
   * @param key Keys to delete
   * @return 
   */
  public Single<String> rxDel(String key) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      del(key, handler);
    });
  }

  /**
   * Delete many keys
   * @param keys List of keys to delete
   * @param handler Handler for the result of this call.
   * @return 
   */
  public RedisTransaction delMany(List<String> keys, Handler<AsyncResult<String>> handler) { 
    delegate.delMany(keys, handler);
    return this;
  }

  /**
   * Delete many keys
   * @param keys List of keys to delete
   * @return 
   */
  public Single<String> rxDelMany(List<String> keys) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      delMany(keys, handler);
    });
  }

  /**
   * Discard all commands issued after MULTI
   * @param handler 
   * @return 
   */
  public RedisTransaction discard(Handler<AsyncResult<String>> handler) { 
    delegate.discard(handler);
    return this;
  }

  /**
   * Discard all commands issued after MULTI
   * @return 
   */
  public Single<String> rxDiscard() { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      discard(handler);
    });
  }

  /**
   * Return a serialized version of the value stored at the specified key.
   * @param key Key string
   * @param handler Handler for the result of this call.
   * @return 
   */
  public RedisTransaction dump(String key, Handler<AsyncResult<String>> handler) { 
    delegate.dump(key, handler);
    return this;
  }

  /**
   * Return a serialized version of the value stored at the specified key.
   * @param key Key string
   * @return 
   */
  public Single<String> rxDump(String key) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      dump(key, handler);
    });
  }

  /**
   * Echo the given string
   * @param message String to echo
   * @param handler Handler for the result of this call.
   * @return 
   */
  public RedisTransaction echo(String message, Handler<AsyncResult<String>> handler) { 
    delegate.echo(message, handler);
    return this;
  }

  /**
   * Echo the given string
   * @param message String to echo
   * @return 
   */
  public Single<String> rxEcho(String message) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      echo(message, handler);
    });
  }

  /**
   * Execute a Lua script server side. Due to the dynamic nature of this command any response type could be returned
   * for This reason and to ensure type safety the reply is always guaranteed to be a JsonArray.
   * <p>
   * When a reply if for example a String the handler will be called with a JsonArray with a single element containing
   * the String.
   * @param script Lua script to evaluate
   * @param keys List of keys
   * @param args List of argument values
   * @param handler Handler for the result of this call.
   * @return 
   */
  public RedisTransaction eval(String script, List<String> keys, List<String> args, Handler<AsyncResult<String>> handler) { 
    delegate.eval(script, keys, args, handler);
    return this;
  }

  /**
   * Execute a Lua script server side. Due to the dynamic nature of this command any response type could be returned
   * for This reason and to ensure type safety the reply is always guaranteed to be a JsonArray.
   * <p>
   * When a reply if for example a String the handler will be called with a JsonArray with a single element containing
   * the String.
   * @param script Lua script to evaluate
   * @param keys List of keys
   * @param args List of argument values
   * @return 
   */
  public Single<String> rxEval(String script, List<String> keys, List<String> args) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      eval(script, keys, args, handler);
    });
  }

  /**
   * Execute a Lua script server side. Due to the dynamic nature of this command any response type could be returned
   * for This reason and to ensure type safety the reply is always guaranteed to be a JsonArray.
   * <p>
   * When a reply if for example a String the handler will be called with a JsonArray with a single element containing
   * the String.
   * @param sha1 SHA1 digest of the script cached on the server
   * @param keys List of keys
   * @param values List of values
   * @param handler Handler for the result of this call.
   * @return 
   */
  public RedisTransaction evalsha(String sha1, List<String> keys, List<String> values, Handler<AsyncResult<String>> handler) { 
    delegate.evalsha(sha1, keys, values, handler);
    return this;
  }

  /**
   * Execute a Lua script server side. Due to the dynamic nature of this command any response type could be returned
   * for This reason and to ensure type safety the reply is always guaranteed to be a JsonArray.
   * <p>
   * When a reply if for example a String the handler will be called with a JsonArray with a single element containing
   * the String.
   * @param sha1 SHA1 digest of the script cached on the server
   * @param keys List of keys
   * @param values List of values
   * @return 
   */
  public Single<String> rxEvalsha(String sha1, List<String> keys, List<String> values) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      evalsha(sha1, keys, values, handler);
    });
  }

  /**
   * Execute all commands issued after MULTI
   * @param handler 
   * @return 
   */
  public RedisTransaction exec(Handler<AsyncResult<JsonArray>> handler) { 
    delegate.exec(handler);
    return this;
  }

  /**
   * Execute all commands issued after MULTI
   * @return 
   */
  public Single<JsonArray> rxExec() { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<JsonArray>(handler -> {
      exec(handler);
    });
  }

  /**
   * Determine if a key exists
   * @param key Key string
   * @param handler Handler for the result of this call.
   * @return 
   */
  public RedisTransaction exists(String key, Handler<AsyncResult<String>> handler) { 
    delegate.exists(key, handler);
    return this;
  }

  /**
   * Determine if a key exists
   * @param key Key string
   * @return 
   */
  public Single<String> rxExists(String key) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      exists(key, handler);
    });
  }

  /**
   * Determine if one or many keys exist
   * @param keys List of key strings
   * @param handler Handler for the result of this call.
   * @return 
   */
  public RedisTransaction existsMany(List<String> keys, Handler<AsyncResult<String>> handler) { 
    delegate.existsMany(keys, handler);
    return this;
  }

  /**
   * Determine if one or many keys exist
   * @param keys List of key strings
   * @return 
   */
  public Single<String> rxExistsMany(List<String> keys) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      existsMany(keys, handler);
    });
  }

  /**
   * Set a key's time to live in seconds
   * @param key Key string
   * @param seconds Time to live in seconds
   * @param handler Handler for the result of this call.
   * @return 
   */
  public RedisTransaction expire(String key, int seconds, Handler<AsyncResult<String>> handler) { 
    delegate.expire(key, seconds, handler);
    return this;
  }

  /**
   * Set a key's time to live in seconds
   * @param key Key string
   * @param seconds Time to live in seconds
   * @return 
   */
  public Single<String> rxExpire(String key, int seconds) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      expire(key, seconds, handler);
    });
  }

  /**
   * Set the expiration for a key as a UNIX timestamp
   * @param key Key string
   * @param seconds Expiry time as Unix timestamp in seconds
   * @param handler Handler for the result of this call.
   * @return 
   */
  public RedisTransaction expireat(String key, long seconds, Handler<AsyncResult<String>> handler) { 
    delegate.expireat(key, seconds, handler);
    return this;
  }

  /**
   * Set the expiration for a key as a UNIX timestamp
   * @param key Key string
   * @param seconds Expiry time as Unix timestamp in seconds
   * @return 
   */
  public Single<String> rxExpireat(String key, long seconds) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      expireat(key, seconds, handler);
    });
  }

  /**
   * Remove all keys from all databases
   * @param handler 
   * @return 
   */
  public RedisTransaction flushall(Handler<AsyncResult<String>> handler) { 
    delegate.flushall(handler);
    return this;
  }

  /**
   * Remove all keys from all databases
   * @return 
   */
  public Single<String> rxFlushall() { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      flushall(handler);
    });
  }

  /**
   * Remove all keys from the current database
   * @param handler 
   * @return 
   */
  public RedisTransaction flushdb(Handler<AsyncResult<String>> handler) { 
    delegate.flushdb(handler);
    return this;
  }

  /**
   * Remove all keys from the current database
   * @return 
   */
  public Single<String> rxFlushdb() { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      flushdb(handler);
    });
  }

  /**
   * Get the value of a key
   * @param key Key string
   * @param handler Handler for the result of this call.
   * @return 
   */
  public RedisTransaction get(String key, Handler<AsyncResult<String>> handler) { 
    delegate.get(key, handler);
    return this;
  }

  /**
   * Get the value of a key
   * @param key Key string
   * @return 
   */
  public Single<String> rxGet(String key) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      get(key, handler);
    });
  }

  /**
   * Get the value of a key - without decoding as utf-8
   * @param key Key string
   * @param handler Handler for the result of this call.
   * @return 
   */
  public RedisTransaction getBinary(String key, Handler<AsyncResult<Buffer>> handler) { 
    delegate.getBinary(key, new Handler<AsyncResult<io.vertx.core.buffer.Buffer>>() {
      public void handle(AsyncResult<io.vertx.core.buffer.Buffer> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(Buffer.newInstance(ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Get the value of a key - without decoding as utf-8
   * @param key Key string
   * @return 
   */
  public Single<Buffer> rxGetBinary(String key) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<Buffer>(handler -> {
      getBinary(key, handler);
    });
  }

  /**
   * Returns the bit value at offset in the string value stored at key
   * @param key Key string
   * @param offset Offset in bits
   * @param handler Handler for the result of this call.
   * @return 
   */
  public RedisTransaction getbit(String key, long offset, Handler<AsyncResult<String>> handler) { 
    delegate.getbit(key, offset, handler);
    return this;
  }

  /**
   * Returns the bit value at offset in the string value stored at key
   * @param key Key string
   * @param offset Offset in bits
   * @return 
   */
  public Single<String> rxGetbit(String key, long offset) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      getbit(key, offset, handler);
    });
  }

  /**
   * Get a substring of the string stored at a key
   * @param key Key string
   * @param start Start offset
   * @param end End offset - inclusive
   * @param handler Handler for the result of this call.
   * @return 
   */
  public RedisTransaction getrange(String key, long start, long end, Handler<AsyncResult<String>> handler) { 
    delegate.getrange(key, start, end, handler);
    return this;
  }

  /**
   * Get a substring of the string stored at a key
   * @param key Key string
   * @param start Start offset
   * @param end End offset - inclusive
   * @return 
   */
  public Single<String> rxGetrange(String key, long start, long end) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      getrange(key, start, end, handler);
    });
  }

  /**
   * Set the string value of a key and return its old value
   * @param key Key of which value to set
   * @param value New value for the key
   * @param handler Handler for the result of this call.
   * @return 
   */
  public RedisTransaction getset(String key, String value, Handler<AsyncResult<String>> handler) { 
    delegate.getset(key, value, handler);
    return this;
  }

  /**
   * Set the string value of a key and return its old value
   * @param key Key of which value to set
   * @param value New value for the key
   * @return 
   */
  public Single<String> rxGetset(String key, String value) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      getset(key, value, handler);
    });
  }

  /**
   * Delete one or more hash fields
   * @param key Key string
   * @param field Field name
   * @param handler Handler for the result of this call.
   * @return 
   */
  public RedisTransaction hdel(String key, String field, Handler<AsyncResult<String>> handler) { 
    delegate.hdel(key, field, handler);
    return this;
  }

  /**
   * Delete one or more hash fields
   * @param key Key string
   * @param field Field name
   * @return 
   */
  public Single<String> rxHdel(String key, String field) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      hdel(key, field, handler);
    });
  }

  /**
   * Delete one or more hash fields
   * @param key Key string
   * @param fields Field names
   * @param handler Handler for the result of this call.
   * @return 
   */
  public RedisTransaction hdelMany(String key, List<String> fields, Handler<AsyncResult<String>> handler) { 
    delegate.hdelMany(key, fields, handler);
    return this;
  }

  /**
   * Delete one or more hash fields
   * @param key Key string
   * @param fields Field names
   * @return 
   */
  public Single<String> rxHdelMany(String key, List<String> fields) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      hdelMany(key, fields, handler);
    });
  }

  /**
   * Determine if a hash field exists
   * @param key Key string
   * @param field Field name
   * @param handler Handler for the result of this call.
   * @return 
   */
  public RedisTransaction hexists(String key, String field, Handler<AsyncResult<String>> handler) { 
    delegate.hexists(key, field, handler);
    return this;
  }

  /**
   * Determine if a hash field exists
   * @param key Key string
   * @param field Field name
   * @return 
   */
  public Single<String> rxHexists(String key, String field) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      hexists(key, field, handler);
    });
  }

  /**
   * Get the value of a hash field
   * @param key Key string
   * @param field Field name
   * @param handler Handler for the result of this call.
   * @return 
   */
  public RedisTransaction hget(String key, String field, Handler<AsyncResult<String>> handler) { 
    delegate.hget(key, field, handler);
    return this;
  }

  /**
   * Get the value of a hash field
   * @param key Key string
   * @param field Field name
   * @return 
   */
  public Single<String> rxHget(String key, String field) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      hget(key, field, handler);
    });
  }

  /**
   * Get all the fields and values in a hash
   * @param key Key string
   * @param handler Handler for the result of this call.
   * @return 
   */
  public RedisTransaction hgetall(String key, Handler<AsyncResult<String>> handler) { 
    delegate.hgetall(key, handler);
    return this;
  }

  /**
   * Get all the fields and values in a hash
   * @param key Key string
   * @return 
   */
  public Single<String> rxHgetall(String key) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      hgetall(key, handler);
    });
  }

  /**
   * Increment the integer value of a hash field by the given number
   * @param key Key string
   * @param field Field name
   * @param increment Value by which to increment
   * @param handler Handler for the result of this call.
   * @return 
   */
  public RedisTransaction hincrby(String key, String field, long increment, Handler<AsyncResult<String>> handler) { 
    delegate.hincrby(key, field, increment, handler);
    return this;
  }

  /**
   * Increment the integer value of a hash field by the given number
   * @param key Key string
   * @param field Field name
   * @param increment Value by which to increment
   * @return 
   */
  public Single<String> rxHincrby(String key, String field, long increment) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      hincrby(key, field, increment, handler);
    });
  }

  /**
   * Increment the float value of a hash field by the given amount
   * @param key Key string
   * @param field Field name
   * @param increment Value by which to increment
   * @param handler Handler for the result of this call.
   * @return 
   */
  public RedisTransaction hincrbyfloat(String key, String field, double increment, Handler<AsyncResult<String>> handler) { 
    delegate.hincrbyfloat(key, field, increment, handler);
    return this;
  }

  /**
   * Increment the float value of a hash field by the given amount
   * @param key Key string
   * @param field Field name
   * @param increment Value by which to increment
   * @return 
   */
  public Single<String> rxHincrbyfloat(String key, String field, double increment) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      hincrbyfloat(key, field, increment, handler);
    });
  }

  /**
   * Get all the fields in a hash
   * @param key Key string
   * @param handler Handler for the result of this call.
   * @return 
   */
  public RedisTransaction hkeys(String key, Handler<AsyncResult<String>> handler) { 
    delegate.hkeys(key, handler);
    return this;
  }

  /**
   * Get all the fields in a hash
   * @param key Key string
   * @return 
   */
  public Single<String> rxHkeys(String key) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      hkeys(key, handler);
    });
  }

  /**
   * Get the number of fields in a hash
   * @param key Key string
   * @param handler Handler for the result of this call.
   * @return 
   */
  public RedisTransaction hlen(String key, Handler<AsyncResult<String>> handler) { 
    delegate.hlen(key, handler);
    return this;
  }

  /**
   * Get the number of fields in a hash
   * @param key Key string
   * @return 
   */
  public Single<String> rxHlen(String key) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      hlen(key, handler);
    });
  }

  /**
   * Get the values of all the given hash fields
   * @param key Key string
   * @param fields Field names
   * @param handler Handler for the result of this call.
   * @return 
   */
  public RedisTransaction hmget(String key, List<String> fields, Handler<AsyncResult<String>> handler) { 
    delegate.hmget(key, fields, handler);
    return this;
  }

  /**
   * Get the values of all the given hash fields
   * @param key Key string
   * @param fields Field names
   * @return 
   */
  public Single<String> rxHmget(String key, List<String> fields) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      hmget(key, fields, handler);
    });
  }

  /**
   * Set multiple hash fields to multiple values
   * @param key Key string
   * @param values Map of field:value pairs
   * @param handler Handler for the result of this call.
   * @return 
   */
  public RedisTransaction hmset(String key, JsonObject values, Handler<AsyncResult<String>> handler) { 
    delegate.hmset(key, values, handler);
    return this;
  }

  /**
   * Set multiple hash fields to multiple values
   * @param key Key string
   * @param values Map of field:value pairs
   * @return 
   */
  public Single<String> rxHmset(String key, JsonObject values) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      hmset(key, values, handler);
    });
  }

  /**
   * Set the string value of a hash field
   * @param key Key string
   * @param field Field name
   * @param value New value
   * @param handler Handler for the result of this call.
   * @return 
   */
  public RedisTransaction hset(String key, String field, String value, Handler<AsyncResult<String>> handler) { 
    delegate.hset(key, field, value, handler);
    return this;
  }

  /**
   * Set the string value of a hash field
   * @param key Key string
   * @param field Field name
   * @param value New value
   * @return 
   */
  public Single<String> rxHset(String key, String field, String value) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      hset(key, field, value, handler);
    });
  }

  /**
   * Set the value of a hash field, only if the field does not exist
   * @param key Key string
   * @param field Field name
   * @param value New value
   * @param handler Handler for the result of this call.
   * @return 
   */
  public RedisTransaction hsetnx(String key, String field, String value, Handler<AsyncResult<String>> handler) { 
    delegate.hsetnx(key, field, value, handler);
    return this;
  }

  /**
   * Set the value of a hash field, only if the field does not exist
   * @param key Key string
   * @param field Field name
   * @param value New value
   * @return 
   */
  public Single<String> rxHsetnx(String key, String field, String value) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      hsetnx(key, field, value, handler);
    });
  }

  /**
   * Get all the values in a hash
   * @param key Key string
   * @param handler Handler for the result of this call.
   * @return 
   */
  public RedisTransaction hvals(String key, Handler<AsyncResult<String>> handler) { 
    delegate.hvals(key, handler);
    return this;
  }

  /**
   * Get all the values in a hash
   * @param key Key string
   * @return 
   */
  public Single<String> rxHvals(String key) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      hvals(key, handler);
    });
  }

  /**
   * Increment the integer value of a key by one
   * @param key Key string
   * @param handler Handler for the result of this call.
   * @return 
   */
  public RedisTransaction incr(String key, Handler<AsyncResult<String>> handler) { 
    delegate.incr(key, handler);
    return this;
  }

  /**
   * Increment the integer value of a key by one
   * @param key Key string
   * @return 
   */
  public Single<String> rxIncr(String key) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      incr(key, handler);
    });
  }

  /**
   * Increment the integer value of a key by the given amount
   * @param key Key string
   * @param increment Value by which to increment
   * @param handler Handler for the result of this call.
   * @return 
   */
  public RedisTransaction incrby(String key, long increment, Handler<AsyncResult<String>> handler) { 
    delegate.incrby(key, increment, handler);
    return this;
  }

  /**
   * Increment the integer value of a key by the given amount
   * @param key Key string
   * @param increment Value by which to increment
   * @return 
   */
  public Single<String> rxIncrby(String key, long increment) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      incrby(key, increment, handler);
    });
  }

  /**
   * Increment the float value of a key by the given amount
   * @param key Key string
   * @param increment Value by which to increment
   * @param handler Handler for the result of this call.
   * @return 
   */
  public RedisTransaction incrbyfloat(String key, double increment, Handler<AsyncResult<String>> handler) { 
    delegate.incrbyfloat(key, increment, handler);
    return this;
  }

  /**
   * Increment the float value of a key by the given amount
   * @param key Key string
   * @param increment Value by which to increment
   * @return 
   */
  public Single<String> rxIncrbyfloat(String key, double increment) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      incrbyfloat(key, increment, handler);
    });
  }

  /**
   * Get information and statistics about the server
   * @param handler Handler for the result of this call.
   * @return 
   */
  public RedisTransaction info(Handler<AsyncResult<String>> handler) { 
    delegate.info(handler);
    return this;
  }

  /**
   * Get information and statistics about the server
   * @return 
   */
  public Single<String> rxInfo() { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      info(handler);
    });
  }

  /**
   * Get information and statistics about the server
   * @param section Specific section of information to return
   * @param handler Handler for the result of this call.
   * @return 
   */
  public RedisTransaction infoSection(String section, Handler<AsyncResult<String>> handler) { 
    delegate.infoSection(section, handler);
    return this;
  }

  /**
   * Get information and statistics about the server
   * @param section Specific section of information to return
   * @return 
   */
  public Single<String> rxInfoSection(String section) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      infoSection(section, handler);
    });
  }

  /**
   * Find all keys matching the given pattern
   * @param pattern Pattern to limit the keys returned
   * @param handler Handler for the result of this call.
   * @return 
   */
  public RedisTransaction keys(String pattern, Handler<AsyncResult<String>> handler) { 
    delegate.keys(pattern, handler);
    return this;
  }

  /**
   * Find all keys matching the given pattern
   * @param pattern Pattern to limit the keys returned
   * @return 
   */
  public Single<String> rxKeys(String pattern) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      keys(pattern, handler);
    });
  }

  /**
   * Get the UNIX time stamp of the last successful save to disk
   * @param handler 
   * @return 
   */
  public RedisTransaction lastsave(Handler<AsyncResult<String>> handler) { 
    delegate.lastsave(handler);
    return this;
  }

  /**
   * Get the UNIX time stamp of the last successful save to disk
   * @return 
   */
  public Single<String> rxLastsave() { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      lastsave(handler);
    });
  }

  /**
   * Get an element from a list by its index
   * @param key Key string
   * @param index Index of list element to get
   * @param handler Handler for the result of this call.
   * @return 
   */
  public RedisTransaction lindex(String key, int index, Handler<AsyncResult<String>> handler) { 
    delegate.lindex(key, index, handler);
    return this;
  }

  /**
   * Get an element from a list by its index
   * @param key Key string
   * @param index Index of list element to get
   * @return 
   */
  public Single<String> rxLindex(String key, int index) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      lindex(key, index, handler);
    });
  }

  /**
   * Insert an element before or after another element in a list
   * @param key Key string
   * @param option BEFORE or AFTER
   * @param pivot Key to use as a pivot
   * @param value Value to be inserted before or after the pivot
   * @param handler Handler for the result of this call.
   * @return 
   */
  public RedisTransaction linsert(String key, InsertOptions option, String pivot, String value, Handler<AsyncResult<String>> handler) { 
    delegate.linsert(key, option, pivot, value, handler);
    return this;
  }

  /**
   * Insert an element before or after another element in a list
   * @param key Key string
   * @param option BEFORE or AFTER
   * @param pivot Key to use as a pivot
   * @param value Value to be inserted before or after the pivot
   * @return 
   */
  public Single<String> rxLinsert(String key, InsertOptions option, String pivot, String value) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      linsert(key, option, pivot, value, handler);
    });
  }

  /**
   * Get the length of a list
   * @param key String key
   * @param handler Handler for the result of this call.
   * @return 
   */
  public RedisTransaction llen(String key, Handler<AsyncResult<String>> handler) { 
    delegate.llen(key, handler);
    return this;
  }

  /**
   * Get the length of a list
   * @param key String key
   * @return 
   */
  public Single<String> rxLlen(String key) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      llen(key, handler);
    });
  }

  /**
   * Remove and get the first element in a list
   * @param key String key
   * @param handler Handler for the result of this call.
   * @return 
   */
  public RedisTransaction lpop(String key, Handler<AsyncResult<String>> handler) { 
    delegate.lpop(key, handler);
    return this;
  }

  /**
   * Remove and get the first element in a list
   * @param key String key
   * @return 
   */
  public Single<String> rxLpop(String key) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      lpop(key, handler);
    });
  }

  /**
   * Prepend one or multiple values to a list
   * @param key Key string
   * @param values Values to be added at the beginning of the list, one by one
   * @param handler Handler for the result of this call.
   * @return 
   */
  public RedisTransaction lpushMany(String key, List<String> values, Handler<AsyncResult<String>> handler) { 
    delegate.lpushMany(key, values, handler);
    return this;
  }

  /**
   * Prepend one or multiple values to a list
   * @param key Key string
   * @param values Values to be added at the beginning of the list, one by one
   * @return 
   */
  public Single<String> rxLpushMany(String key, List<String> values) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      lpushMany(key, values, handler);
    });
  }

  /**
   * Prepend one value to a list
   * @param key Key string
   * @param value Value to be added at the beginning of the list
   * @param handler Handler for the result of this call.
   * @return 
   */
  public RedisTransaction lpush(String key, String value, Handler<AsyncResult<String>> handler) { 
    delegate.lpush(key, value, handler);
    return this;
  }

  /**
   * Prepend one value to a list
   * @param key Key string
   * @param value Value to be added at the beginning of the list
   * @return 
   */
  public Single<String> rxLpush(String key, String value) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      lpush(key, value, handler);
    });
  }

  /**
   * Prepend a value to a list, only if the list exists
   * @param key Key string
   * @param value Value to add at the beginning of the list
   * @param handler Handler for the result of this call.
   * @return 
   */
  public RedisTransaction lpushx(String key, String value, Handler<AsyncResult<String>> handler) { 
    delegate.lpushx(key, value, handler);
    return this;
  }

  /**
   * Prepend a value to a list, only if the list exists
   * @param key Key string
   * @param value Value to add at the beginning of the list
   * @return 
   */
  public Single<String> rxLpushx(String key, String value) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      lpushx(key, value, handler);
    });
  }

  /**
   * Get a range of elements from a list
   * @param key Key string
   * @param from Start index
   * @param to Stop index
   * @param handler Handler for the result of this call.
   * @return 
   */
  public RedisTransaction lrange(String key, long from, long to, Handler<AsyncResult<String>> handler) { 
    delegate.lrange(key, from, to, handler);
    return this;
  }

  /**
   * Get a range of elements from a list
   * @param key Key string
   * @param from Start index
   * @param to Stop index
   * @return 
   */
  public Single<String> rxLrange(String key, long from, long to) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      lrange(key, from, to, handler);
    });
  }

  /**
   * Remove elements from a list
   * @param key Key string
   * @param count Number of first found occurrences equal to $value to remove from the list
   * @param value Value to be removed
   * @param handler Handler for the result of this call.
   * @return 
   */
  public RedisTransaction lrem(String key, long count, String value, Handler<AsyncResult<String>> handler) { 
    delegate.lrem(key, count, value, handler);
    return this;
  }

  /**
   * Remove elements from a list
   * @param key Key string
   * @param count Number of first found occurrences equal to $value to remove from the list
   * @param value Value to be removed
   * @return 
   */
  public Single<String> rxLrem(String key, long count, String value) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      lrem(key, count, value, handler);
    });
  }

  /**
   * Set the value of an element in a list by its index
   * @param key Key string
   * @param index Position within list
   * @param value New value
   * @param handler Handler for the result of this call.
   * @return 
   */
  public RedisTransaction lset(String key, long index, String value, Handler<AsyncResult<String>> handler) { 
    delegate.lset(key, index, value, handler);
    return this;
  }

  /**
   * Set the value of an element in a list by its index
   * @param key Key string
   * @param index Position within list
   * @param value New value
   * @return 
   */
  public Single<String> rxLset(String key, long index, String value) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      lset(key, index, value, handler);
    });
  }

  /**
   * Trim a list to the specified range
   * @param key Key string
   * @param from Start index
   * @param to Stop index
   * @param handler Handler for the result of this call.
   * @return 
   */
  public RedisTransaction ltrim(String key, long from, long to, Handler<AsyncResult<String>> handler) { 
    delegate.ltrim(key, from, to, handler);
    return this;
  }

  /**
   * Trim a list to the specified range
   * @param key Key string
   * @param from Start index
   * @param to Stop index
   * @return 
   */
  public Single<String> rxLtrim(String key, long from, long to) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      ltrim(key, from, to, handler);
    });
  }

  /**
   * Get the value of the given key
   * @param key Key string
   * @param handler Handler for the result of this call.
   * @return 
   */
  public RedisTransaction mget(String key, Handler<AsyncResult<String>> handler) { 
    delegate.mget(key, handler);
    return this;
  }

  /**
   * Get the value of the given key
   * @param key Key string
   * @return 
   */
  public Single<String> rxMget(String key) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      mget(key, handler);
    });
  }

  /**
   * Get the values of all the given keys
   * @param keys List of keys to get
   * @param handler Handler for the result of this call.
   * @return 
   */
  public RedisTransaction mgetMany(List<String> keys, Handler<AsyncResult<String>> handler) { 
    delegate.mgetMany(keys, handler);
    return this;
  }

  /**
   * Get the values of all the given keys
   * @param keys List of keys to get
   * @return 
   */
  public Single<String> rxMgetMany(List<String> keys) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      mgetMany(keys, handler);
    });
  }

  /**
   * Atomically transfer a key from a Redis instance to another one.
   * @param host Destination host
   * @param port Destination port
   * @param key Key to migrate
   * @param destdb Destination database index
   * @param timeout 
   * @param options Migrate options
   * @param handler Handler for the result of this call.
   * @return 
   */
  public RedisTransaction migrate(String host, int port, String key, int destdb, long timeout, MigrateOptions options, Handler<AsyncResult<String>> handler) { 
    delegate.migrate(host, port, key, destdb, timeout, options, handler);
    return this;
  }

  /**
   * Atomically transfer a key from a Redis instance to another one.
   * @param host Destination host
   * @param port Destination port
   * @param key Key to migrate
   * @param destdb Destination database index
   * @param timeout 
   * @param options Migrate options
   * @return 
   */
  public Single<String> rxMigrate(String host, int port, String key, int destdb, long timeout, MigrateOptions options) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      migrate(host, port, key, destdb, timeout, options, handler);
    });
  }

  /**
   * Listen for all requests received by the server in real time
   * @param handler 
   * @return 
   */
  public RedisTransaction monitor(Handler<AsyncResult<String>> handler) { 
    delegate.monitor(handler);
    return this;
  }

  /**
   * Listen for all requests received by the server in real time
   * @return 
   */
  public Single<String> rxMonitor() { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      monitor(handler);
    });
  }

  /**
   * Move a key to another database
   * @param key Key to migrate
   * @param destdb Destination database index
   * @param handler Handler for the result of this call.
   * @return 
   */
  public RedisTransaction move(String key, int destdb, Handler<AsyncResult<String>> handler) { 
    delegate.move(key, destdb, handler);
    return this;
  }

  /**
   * Move a key to another database
   * @param key Key to migrate
   * @param destdb Destination database index
   * @return 
   */
  public Single<String> rxMove(String key, int destdb) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      move(key, destdb, handler);
    });
  }

  /**
   * Set multiple keys to multiple values
   * @param keyvals Key value pairs to set
   * @param handler Handler for the result of this call.
   * @return 
   */
  public RedisTransaction mset(JsonObject keyvals, Handler<AsyncResult<String>> handler) { 
    delegate.mset(keyvals, handler);
    return this;
  }

  /**
   * Set multiple keys to multiple values
   * @param keyvals Key value pairs to set
   * @return 
   */
  public Single<String> rxMset(JsonObject keyvals) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      mset(keyvals, handler);
    });
  }

  /**
   * Set multiple keys to multiple values, only if none of the keys exist
   * @param keyvals Key value pairs to set
   * @param handler Handler for the result of this call.
   * @return 
   */
  public RedisTransaction msetnx(JsonObject keyvals, Handler<AsyncResult<String>> handler) { 
    delegate.msetnx(keyvals, handler);
    return this;
  }

  /**
   * Set multiple keys to multiple values, only if none of the keys exist
   * @param keyvals Key value pairs to set
   * @return 
   */
  public Single<String> rxMsetnx(JsonObject keyvals) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      msetnx(keyvals, handler);
    });
  }

  /**
   * Mark the start of a RedisTransaction block
   * @param handler 
   * @return 
   */
  public RedisTransaction multi(Handler<AsyncResult<String>> handler) { 
    delegate.multi(handler);
    return this;
  }

  /**
   * Mark the start of a RedisTransaction block
   * @return 
   */
  public Single<String> rxMulti() { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      multi(handler);
    });
  }

  /**
   * Inspect the internals of Redis objects
   * @param key Key string
   * @param cmd Object sub command
   * @param handler Handler for the result of this call.
   * @return 
   */
  public RedisTransaction object(String key, ObjectCmd cmd, Handler<AsyncResult<String>> handler) { 
    delegate.object(key, cmd, handler);
    return this;
  }

  /**
   * Inspect the internals of Redis objects
   * @param key Key string
   * @param cmd Object sub command
   * @return 
   */
  public Single<String> rxObject(String key, ObjectCmd cmd) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      object(key, cmd, handler);
    });
  }

  /**
   * Remove the expiration from a key
   * @param key Key string
   * @param handler Handler for the result of this call.
   * @return 
   */
  public RedisTransaction persist(String key, Handler<AsyncResult<String>> handler) { 
    delegate.persist(key, handler);
    return this;
  }

  /**
   * Remove the expiration from a key
   * @param key Key string
   * @return 
   */
  public Single<String> rxPersist(String key) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      persist(key, handler);
    });
  }

  /**
   * Set a key's time to live in milliseconds
   * @param key String key
   * @param millis Time to live in milliseconds
   * @param handler Handler for the result of this call.
   * @return 
   */
  public RedisTransaction pexpire(String key, long millis, Handler<AsyncResult<String>> handler) { 
    delegate.pexpire(key, millis, handler);
    return this;
  }

  /**
   * Set a key's time to live in milliseconds
   * @param key String key
   * @param millis Time to live in milliseconds
   * @return 
   */
  public Single<String> rxPexpire(String key, long millis) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      pexpire(key, millis, handler);
    });
  }

  /**
   * Set the expiration for a key as a UNIX timestamp specified in milliseconds
   * @param key Key string
   * @param millis Expiry time as Unix timestamp in milliseconds
   * @param handler Handler for the result of this call.
   * @return 
   */
  public RedisTransaction pexpireat(String key, long millis, Handler<AsyncResult<String>> handler) { 
    delegate.pexpireat(key, millis, handler);
    return this;
  }

  /**
   * Set the expiration for a key as a UNIX timestamp specified in milliseconds
   * @param key Key string
   * @param millis Expiry time as Unix timestamp in milliseconds
   * @return 
   */
  public Single<String> rxPexpireat(String key, long millis) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      pexpireat(key, millis, handler);
    });
  }

  /**
   * Adds the specified element to the specified HyperLogLog.
   * @param key Key string
   * @param element Element to add
   * @param handler Handler for the result of this call.
   * @return 
   */
  public RedisTransaction pfadd(String key, String element, Handler<AsyncResult<String>> handler) { 
    delegate.pfadd(key, element, handler);
    return this;
  }

  /**
   * Adds the specified element to the specified HyperLogLog.
   * @param key Key string
   * @param element Element to add
   * @return 
   */
  public Single<String> rxPfadd(String key, String element) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      pfadd(key, element, handler);
    });
  }

  /**
   * Adds the specified elements to the specified HyperLogLog.
   * @param key Key string
   * @param elements Elementa to add
   * @param handler Handler for the result of this call.
   * @return 
   */
  public RedisTransaction pfaddMany(String key, List<String> elements, Handler<AsyncResult<String>> handler) { 
    delegate.pfaddMany(key, elements, handler);
    return this;
  }

  /**
   * Adds the specified elements to the specified HyperLogLog.
   * @param key Key string
   * @param elements Elementa to add
   * @return 
   */
  public Single<String> rxPfaddMany(String key, List<String> elements) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      pfaddMany(key, elements, handler);
    });
  }

  /**
   * Return the approximated cardinality of the set observed by the HyperLogLog at key.
   * @param key Key string
   * @param handler Handler for the result of this call.
   * @return 
   */
  public RedisTransaction pfcount(String key, Handler<AsyncResult<String>> handler) { 
    delegate.pfcount(key, handler);
    return this;
  }

  /**
   * Return the approximated cardinality of the set observed by the HyperLogLog at key.
   * @param key Key string
   * @return 
   */
  public Single<String> rxPfcount(String key) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      pfcount(key, handler);
    });
  }

  /**
   * Return the approximated cardinality of the set(s) observed by the HyperLogLog at key(s).
   * @param keys List of keys
   * @param handler Handler for the result of this call.
   * @return 
   */
  public RedisTransaction pfcountMany(List<String> keys, Handler<AsyncResult<String>> handler) { 
    delegate.pfcountMany(keys, handler);
    return this;
  }

  /**
   * Return the approximated cardinality of the set(s) observed by the HyperLogLog at key(s).
   * @param keys List of keys
   * @return 
   */
  public Single<String> rxPfcountMany(List<String> keys) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      pfcountMany(keys, handler);
    });
  }

  /**
   * Merge N different HyperLogLogs into a single one.
   * @param destkey Destination key
   * @param keys List of source keys
   * @param handler Handler for the result of this call.
   * @return 
   */
  public RedisTransaction pfmerge(String destkey, List<String> keys, Handler<AsyncResult<String>> handler) { 
    delegate.pfmerge(destkey, keys, handler);
    return this;
  }

  /**
   * Merge N different HyperLogLogs into a single one.
   * @param destkey Destination key
   * @param keys List of source keys
   * @return 
   */
  public Single<String> rxPfmerge(String destkey, List<String> keys) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      pfmerge(destkey, keys, handler);
    });
  }

  /**
   * Ping the server
   * @param handler 
   * @return 
   */
  public RedisTransaction ping(Handler<AsyncResult<String>> handler) { 
    delegate.ping(handler);
    return this;
  }

  /**
   * Ping the server
   * @return 
   */
  public Single<String> rxPing() { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      ping(handler);
    });
  }

  /**
   * Set the value and expiration in milliseconds of a key
   * @param key Key string
   * @param millis Number of milliseconds until the key expires
   * @param value New value for key
   * @param handler Handler for the result of this call.
   * @return 
   */
  public RedisTransaction psetex(String key, long millis, String value, Handler<AsyncResult<String>> handler) { 
    delegate.psetex(key, millis, value, handler);
    return this;
  }

  /**
   * Set the value and expiration in milliseconds of a key
   * @param key Key string
   * @param millis Number of milliseconds until the key expires
   * @param value New value for key
   * @return 
   */
  public Single<String> rxPsetex(String key, long millis, String value) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      psetex(key, millis, value, handler);
    });
  }

  /**
   * Listen for messages published to channels matching the given pattern
   * @param pattern Pattern string
   * @param handler Handler for the result of this call.
   * @return 
   */
  public RedisTransaction psubscribe(String pattern, Handler<AsyncResult<String>> handler) { 
    delegate.psubscribe(pattern, handler);
    return this;
  }

  /**
   * Listen for messages published to channels matching the given pattern
   * @param pattern Pattern string
   * @return 
   */
  public Single<String> rxPsubscribe(String pattern) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      psubscribe(pattern, handler);
    });
  }

  /**
   * Listen for messages published to channels matching the given patterns
   * @param patterns List of patterns
   * @param handler Handler for the result of this call.
   * @return 
   */
  public RedisTransaction psubscribeMany(List<String> patterns, Handler<AsyncResult<String>> handler) { 
    delegate.psubscribeMany(patterns, handler);
    return this;
  }

  /**
   * Listen for messages published to channels matching the given patterns
   * @param patterns List of patterns
   * @return 
   */
  public Single<String> rxPsubscribeMany(List<String> patterns) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      psubscribeMany(patterns, handler);
    });
  }

  /**
   * Lists the currently active channels - only those matching the pattern
   * @param pattern A glob-style pattern - an empty string means no pattern
   * @param handler Handler for the result of this call.
   * @return 
   */
  public RedisTransaction pubsubChannels(String pattern, Handler<AsyncResult<String>> handler) { 
    delegate.pubsubChannels(pattern, handler);
    return this;
  }

  /**
   * Lists the currently active channels - only those matching the pattern
   * @param pattern A glob-style pattern - an empty string means no pattern
   * @return 
   */
  public Single<String> rxPubsubChannels(String pattern) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      pubsubChannels(pattern, handler);
    });
  }

  /**
   * Returns the number of subscribers (not counting clients subscribed to patterns) for the specified channels
   * @param channels List of channels
   * @param handler Handler for the result of this call.
   * @return 
   */
  public RedisTransaction pubsubNumsub(List<String> channels, Handler<AsyncResult<String>> handler) { 
    delegate.pubsubNumsub(channels, handler);
    return this;
  }

  /**
   * Returns the number of subscribers (not counting clients subscribed to patterns) for the specified channels
   * @param channels List of channels
   * @return 
   */
  public Single<String> rxPubsubNumsub(List<String> channels) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      pubsubNumsub(channels, handler);
    });
  }

  /**
   * Returns the number of subscriptions to patterns (that are performed using the PSUBSCRIBE command)
   * @param handler Handler for the result of this call.
   * @return 
   */
  public RedisTransaction pubsubNumpat(Handler<AsyncResult<String>> handler) { 
    delegate.pubsubNumpat(handler);
    return this;
  }

  /**
   * Returns the number of subscriptions to patterns (that are performed using the PSUBSCRIBE command)
   * @return 
   */
  public Single<String> rxPubsubNumpat() { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      pubsubNumpat(handler);
    });
  }

  /**
   * Get the time to live for a key in milliseconds
   * @param key Key string
   * @param handler Handler for the result of this call.
   * @return 
   */
  public RedisTransaction pttl(String key, Handler<AsyncResult<String>> handler) { 
    delegate.pttl(key, handler);
    return this;
  }

  /**
   * Get the time to live for a key in milliseconds
   * @param key Key string
   * @return 
   */
  public Single<String> rxPttl(String key) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      pttl(key, handler);
    });
  }

  /**
   * Post a message to a channel
   * @param channel Channel key
   * @param message Message to send to channel
   * @param handler Handler for the result of this call.
   * @return 
   */
  public RedisTransaction publish(String channel, String message, Handler<AsyncResult<String>> handler) { 
    delegate.publish(channel, message, handler);
    return this;
  }

  /**
   * Post a message to a channel
   * @param channel Channel key
   * @param message Message to send to channel
   * @return 
   */
  public Single<String> rxPublish(String channel, String message) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      publish(channel, message, handler);
    });
  }

  /**
   * Stop listening for messages posted to channels matching the given patterns
   * @param patterns List of patterns to match against
   * @param handler Handler for the result of this call.
   * @return 
   */
  public RedisTransaction punsubscribe(List<String> patterns, Handler<AsyncResult<String>> handler) { 
    delegate.punsubscribe(patterns, handler);
    return this;
  }

  /**
   * Stop listening for messages posted to channels matching the given patterns
   * @param patterns List of patterns to match against
   * @return 
   */
  public Single<String> rxPunsubscribe(List<String> patterns) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      punsubscribe(patterns, handler);
    });
  }

  /**
   * Return a random key from the keyspace
   * @param handler 
   * @return 
   */
  public RedisTransaction randomkey(Handler<AsyncResult<String>> handler) { 
    delegate.randomkey(handler);
    return this;
  }

  /**
   * Return a random key from the keyspace
   * @return 
   */
  public Single<String> rxRandomkey() { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      randomkey(handler);
    });
  }

  /**
   * Rename a key
   * @param key Key string to be renamed
   * @param newkey New key string
   * @param handler Handler for the result of this call.
   * @return 
   */
  public RedisTransaction rename(String key, String newkey, Handler<AsyncResult<String>> handler) { 
    delegate.rename(key, newkey, handler);
    return this;
  }

  /**
   * Rename a key
   * @param key Key string to be renamed
   * @param newkey New key string
   * @return 
   */
  public Single<String> rxRename(String key, String newkey) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      rename(key, newkey, handler);
    });
  }

  /**
   * Rename a key, only if the new key does not exist
   * @param key Key string to be renamed
   * @param newkey New key string
   * @param handler Handler for the result of this call.
   * @return 
   */
  public RedisTransaction renamenx(String key, String newkey, Handler<AsyncResult<String>> handler) { 
    delegate.renamenx(key, newkey, handler);
    return this;
  }

  /**
   * Rename a key, only if the new key does not exist
   * @param key Key string to be renamed
   * @param newkey New key string
   * @return 
   */
  public Single<String> rxRenamenx(String key, String newkey) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      renamenx(key, newkey, handler);
    });
  }

  /**
   * Create a key using the provided serialized value, previously obtained using DUMP.
   * @param key Key string
   * @param millis Expiry time in milliseconds to set on the key
   * @param serialized Serialized form of the key value as obtained using DUMP
   * @param handler Handler for the result of this call.
   * @return 
   */
  public RedisTransaction restore(String key, long millis, String serialized, Handler<AsyncResult<String>> handler) { 
    delegate.restore(key, millis, serialized, handler);
    return this;
  }

  /**
   * Create a key using the provided serialized value, previously obtained using DUMP.
   * @param key Key string
   * @param millis Expiry time in milliseconds to set on the key
   * @param serialized Serialized form of the key value as obtained using DUMP
   * @return 
   */
  public Single<String> rxRestore(String key, long millis, String serialized) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      restore(key, millis, serialized, handler);
    });
  }

  /**
   * Return the role of the instance in the context of replication
   * @param handler 
   * @return 
   */
  public RedisTransaction role(Handler<AsyncResult<String>> handler) { 
    delegate.role(handler);
    return this;
  }

  /**
   * Return the role of the instance in the context of replication
   * @return 
   */
  public Single<String> rxRole() { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      role(handler);
    });
  }

  /**
   * Remove and get the last element in a list
   * @param key Key string
   * @param handler Handler for the result of this call.
   * @return 
   */
  public RedisTransaction rpop(String key, Handler<AsyncResult<String>> handler) { 
    delegate.rpop(key, handler);
    return this;
  }

  /**
   * Remove and get the last element in a list
   * @param key Key string
   * @return 
   */
  public Single<String> rxRpop(String key) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      rpop(key, handler);
    });
  }

  /**
   * Remove the last element in a list, append it to another list and return it
   * @param key Key string identifying source list
   * @param destkey Key string identifying destination list
   * @param handler Handler for the result of this call.
   * @return 
   */
  public RedisTransaction rpoplpush(String key, String destkey, Handler<AsyncResult<String>> handler) { 
    delegate.rpoplpush(key, destkey, handler);
    return this;
  }

  /**
   * Remove the last element in a list, append it to another list and return it
   * @param key Key string identifying source list
   * @param destkey Key string identifying destination list
   * @return 
   */
  public Single<String> rxRpoplpush(String key, String destkey) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      rpoplpush(key, destkey, handler);
    });
  }

  /**
   * Append one or multiple values to a list
   * @param key Key string
   * @param values List of values to add to the end of the list
   * @param handler Handler for the result of this call.
   * @return 
   */
  public RedisTransaction rpushMany(String key, List<String> values, Handler<AsyncResult<String>> handler) { 
    delegate.rpushMany(key, values, handler);
    return this;
  }

  /**
   * Append one or multiple values to a list
   * @param key Key string
   * @param values List of values to add to the end of the list
   * @return 
   */
  public Single<String> rxRpushMany(String key, List<String> values) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      rpushMany(key, values, handler);
    });
  }

  /**
   * Append one or multiple values to a list
   * @param key Key string
   * @param value Value to be added to the end of the list
   * @param handler Handler for the result of this call.
   * @return 
   */
  public RedisTransaction rpush(String key, String value, Handler<AsyncResult<String>> handler) { 
    delegate.rpush(key, value, handler);
    return this;
  }

  /**
   * Append one or multiple values to a list
   * @param key Key string
   * @param value Value to be added to the end of the list
   * @return 
   */
  public Single<String> rxRpush(String key, String value) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      rpush(key, value, handler);
    });
  }

  /**
   * Append a value to a list, only if the list exists
   * @param key Key string
   * @param value Value to be added to the end of the list
   * @param handler Handler for the result of this call.
   * @return 
   */
  public RedisTransaction rpushx(String key, String value, Handler<AsyncResult<String>> handler) { 
    delegate.rpushx(key, value, handler);
    return this;
  }

  /**
   * Append a value to a list, only if the list exists
   * @param key Key string
   * @param value Value to be added to the end of the list
   * @return 
   */
  public Single<String> rxRpushx(String key, String value) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      rpushx(key, value, handler);
    });
  }

  /**
   * Add a member to a set
   * @param key Key string
   * @param member Value to be added to the set
   * @param handler Handler for the result of this call.
   * @return 
   */
  public RedisTransaction sadd(String key, String member, Handler<AsyncResult<String>> handler) { 
    delegate.sadd(key, member, handler);
    return this;
  }

  /**
   * Add a member to a set
   * @param key Key string
   * @param member Value to be added to the set
   * @return 
   */
  public Single<String> rxSadd(String key, String member) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      sadd(key, member, handler);
    });
  }

  /**
   * Add one or more members to a set
   * @param key Key string
   * @param members Values to be added to the set
   * @param handler Handler for the result of this call.
   * @return 
   */
  public RedisTransaction saddMany(String key, List<String> members, Handler<AsyncResult<String>> handler) { 
    delegate.saddMany(key, members, handler);
    return this;
  }

  /**
   * Add one or more members to a set
   * @param key Key string
   * @param members Values to be added to the set
   * @return 
   */
  public Single<String> rxSaddMany(String key, List<String> members) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      saddMany(key, members, handler);
    });
  }

  /**
   * Synchronously save the dataset to disk
   * @param handler 
   * @return 
   */
  public RedisTransaction save(Handler<AsyncResult<String>> handler) { 
    delegate.save(handler);
    return this;
  }

  /**
   * Synchronously save the dataset to disk
   * @return 
   */
  public Single<String> rxSave() { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      save(handler);
    });
  }

  /**
   * Get the number of members in a set
   * @param key Key string
   * @param handler Handler for the result of this call.
   * @return 
   */
  public RedisTransaction scard(String key, Handler<AsyncResult<String>> handler) { 
    delegate.scard(key, handler);
    return this;
  }

  /**
   * Get the number of members in a set
   * @param key Key string
   * @return 
   */
  public Single<String> rxScard(String key) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      scard(key, handler);
    });
  }

  /**
   * Check existence of script in the script cache.
   * @param script SHA1 digest identifying a script in the script cache
   * @param handler Handler for the result of this call.
   * @return 
   */
  public RedisTransaction scriptExists(String script, Handler<AsyncResult<String>> handler) { 
    delegate.scriptExists(script, handler);
    return this;
  }

  /**
   * Check existence of script in the script cache.
   * @param script SHA1 digest identifying a script in the script cache
   * @return 
   */
  public Single<String> rxScriptExists(String script) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      scriptExists(script, handler);
    });
  }

  /**
   * Check existence of scripts in the script cache.
   * @param scripts List of SHA1 digests identifying scripts in the script cache
   * @param handler Handler for the result of this call.
   * @return 
   */
  public RedisTransaction scriptExistsMany(List<String> scripts, Handler<AsyncResult<String>> handler) { 
    delegate.scriptExistsMany(scripts, handler);
    return this;
  }

  /**
   * Check existence of scripts in the script cache.
   * @param scripts List of SHA1 digests identifying scripts in the script cache
   * @return 
   */
  public Single<String> rxScriptExistsMany(List<String> scripts) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      scriptExistsMany(scripts, handler);
    });
  }

  /**
   * Remove all the scripts from the script cache.
   * @param handler 
   * @return 
   */
  public RedisTransaction scriptFlush(Handler<AsyncResult<String>> handler) { 
    delegate.scriptFlush(handler);
    return this;
  }

  /**
   * Remove all the scripts from the script cache.
   * @return 
   */
  public Single<String> rxScriptFlush() { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      scriptFlush(handler);
    });
  }

  /**
   * Kill the script currently in execution.
   * @param handler 
   * @return 
   */
  public RedisTransaction scriptKill(Handler<AsyncResult<String>> handler) { 
    delegate.scriptKill(handler);
    return this;
  }

  /**
   * Kill the script currently in execution.
   * @return 
   */
  public Single<String> rxScriptKill() { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      scriptKill(handler);
    });
  }

  /**
   * Load the specified Lua script into the script cache.
   * @param script Lua script
   * @param handler Handler for the result of this call.
   * @return 
   */
  public RedisTransaction scriptLoad(String script, Handler<AsyncResult<String>> handler) { 
    delegate.scriptLoad(script, handler);
    return this;
  }

  /**
   * Load the specified Lua script into the script cache.
   * @param script Lua script
   * @return 
   */
  public Single<String> rxScriptLoad(String script) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      scriptLoad(script, handler);
    });
  }

  /**
   * Subtract multiple sets
   * @param key Key identifying the set to compare with all other sets combined
   * @param cmpkeys List of keys identifying sets to subtract from the key set
   * @param handler Handler for the result of this call.
   * @return 
   */
  public RedisTransaction sdiff(String key, List<String> cmpkeys, Handler<AsyncResult<String>> handler) { 
    delegate.sdiff(key, cmpkeys, handler);
    return this;
  }

  /**
   * Subtract multiple sets
   * @param key Key identifying the set to compare with all other sets combined
   * @param cmpkeys List of keys identifying sets to subtract from the key set
   * @return 
   */
  public Single<String> rxSdiff(String key, List<String> cmpkeys) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      sdiff(key, cmpkeys, handler);
    });
  }

  /**
   * Subtract multiple sets and store the resulting set in a key
   * @param destkey Destination key where the result should be stored
   * @param key Key identifying the set to compare with all other sets combined
   * @param cmpkeys List of keys identifying sets to subtract from the key set
   * @param handler Handler for the result of this call.
   * @return 
   */
  public RedisTransaction sdiffstore(String destkey, String key, List<String> cmpkeys, Handler<AsyncResult<String>> handler) { 
    delegate.sdiffstore(destkey, key, cmpkeys, handler);
    return this;
  }

  /**
   * Subtract multiple sets and store the resulting set in a key
   * @param destkey Destination key where the result should be stored
   * @param key Key identifying the set to compare with all other sets combined
   * @param cmpkeys List of keys identifying sets to subtract from the key set
   * @return 
   */
  public Single<String> rxSdiffstore(String destkey, String key, List<String> cmpkeys) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      sdiffstore(destkey, key, cmpkeys, handler);
    });
  }

  /**
   * Change the selected database for the current connection
   * @param dbindex Index identifying the new active database
   * @param handler Handler for the result of this call.
   * @return 
   */
  public RedisTransaction select(int dbindex, Handler<AsyncResult<String>> handler) { 
    delegate.select(dbindex, handler);
    return this;
  }

  /**
   * Change the selected database for the current connection
   * @param dbindex Index identifying the new active database
   * @return 
   */
  public Single<String> rxSelect(int dbindex) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      select(dbindex, handler);
    });
  }

  /**
   * Set the string value of a key
   * @param key Key of which value to set
   * @param value New value for the key
   * @param handler Handler for the result of this call.
   * @return 
   */
  public RedisTransaction set(String key, String value, Handler<AsyncResult<String>> handler) { 
    delegate.set(key, value, handler);
    return this;
  }

  /**
   * Set the string value of a key
   * @param key Key of which value to set
   * @param value New value for the key
   * @return 
   */
  public Single<String> rxSet(String key, String value) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      set(key, value, handler);
    });
  }

  /**
   * Set the string value of a key
   * @param key Key of which value to set
   * @param value New value for the key
   * @param options Set options
   * @param handler Handler for the result of this call.
   * @return 
   */
  public RedisTransaction setWithOptions(String key, String value, SetOptions options, Handler<AsyncResult<String>> handler) { 
    delegate.setWithOptions(key, value, options, handler);
    return this;
  }

  /**
   * Set the string value of a key
   * @param key Key of which value to set
   * @param value New value for the key
   * @param options Set options
   * @return 
   */
  public Single<String> rxSetWithOptions(String key, String value, SetOptions options) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      setWithOptions(key, value, options, handler);
    });
  }

  /**
   * Set the binary string value of a key - without encoding as utf-8
   * @param key Key of which value to set
   * @param value New value for the key
   * @param handler Handler for the result of this call.
   * @return 
   */
  public RedisTransaction setBinary(String key, Buffer value, Handler<AsyncResult<String>> handler) { 
    delegate.setBinary(key, value.getDelegate(), handler);
    return this;
  }

  /**
   * Set the binary string value of a key - without encoding as utf-8
   * @param key Key of which value to set
   * @param value New value for the key
   * @return 
   */
  public Single<String> rxSetBinary(String key, Buffer value) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      setBinary(key, value, handler);
    });
  }

  /**
   * Set the string value of a key
   * @param key Key of which value to set
   * @param value New value for the key
   * @param options Set options
   * @param handler Handler for the result of this call.
   * @return 
   */
  public RedisTransaction setBinaryWithOptions(String key, Buffer value, SetOptions options, Handler<AsyncResult<String>> handler) { 
    delegate.setBinaryWithOptions(key, value.getDelegate(), options, handler);
    return this;
  }

  /**
   * Set the string value of a key
   * @param key Key of which value to set
   * @param value New value for the key
   * @param options Set options
   * @return 
   */
  public Single<String> rxSetBinaryWithOptions(String key, Buffer value, SetOptions options) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      setBinaryWithOptions(key, value, options, handler);
    });
  }

  /**
   * Sets or clears the bit at offset in the string value stored at key
   * @param key Key string
   * @param offset Bit offset
   * @param bit New value - must be 1 or 0
   * @param handler Handler for the result of this call.
   * @return 
   */
  public RedisTransaction setbit(String key, long offset, int bit, Handler<AsyncResult<String>> handler) { 
    delegate.setbit(key, offset, bit, handler);
    return this;
  }

  /**
   * Sets or clears the bit at offset in the string value stored at key
   * @param key Key string
   * @param offset Bit offset
   * @param bit New value - must be 1 or 0
   * @return 
   */
  public Single<String> rxSetbit(String key, long offset, int bit) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      setbit(key, offset, bit, handler);
    });
  }

  /**
   * Set the value and expiration of a key
   * @param key Key string
   * @param seconds Number of seconds until the key expires
   * @param value New value for key
   * @param handler Handler for the result of this call.
   * @return 
   */
  public RedisTransaction setex(String key, long seconds, String value, Handler<AsyncResult<String>> handler) { 
    delegate.setex(key, seconds, value, handler);
    return this;
  }

  /**
   * Set the value and expiration of a key
   * @param key Key string
   * @param seconds Number of seconds until the key expires
   * @param value New value for key
   * @return 
   */
  public Single<String> rxSetex(String key, long seconds, String value) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      setex(key, seconds, value, handler);
    });
  }

  /**
   * Set the value of a key, only if the key does not exist
   * @param key Key of which value to set
   * @param value New value for the key
   * @param handler Handler for the result of this call.
   * @return 
   */
  public RedisTransaction setnx(String key, String value, Handler<AsyncResult<String>> handler) { 
    delegate.setnx(key, value, handler);
    return this;
  }

  /**
   * Set the value of a key, only if the key does not exist
   * @param key Key of which value to set
   * @param value New value for the key
   * @return 
   */
  public Single<String> rxSetnx(String key, String value) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      setnx(key, value, handler);
    });
  }

  /**
   * Overwrite part of a string at key starting at the specified offset
   * @param key Key string
   * @param offset Offset - the maximum offset that you can set is 2^29 -1 (536870911), as Redis Strings are limited to 512 megabytes
   * @param value Value to overwrite with
   * @param handler Handler for the result of this call.
   * @return 
   */
  public RedisTransaction setrange(String key, int offset, String value, Handler<AsyncResult<String>> handler) { 
    delegate.setrange(key, offset, value, handler);
    return this;
  }

  /**
   * Overwrite part of a string at key starting at the specified offset
   * @param key Key string
   * @param offset Offset - the maximum offset that you can set is 2^29 -1 (536870911), as Redis Strings are limited to 512 megabytes
   * @param value Value to overwrite with
   * @return 
   */
  public Single<String> rxSetrange(String key, int offset, String value) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      setrange(key, offset, value, handler);
    });
  }

  /**
   * Intersect multiple sets
   * @param keys List of keys to perform intersection on
   * @param handler Handler for the result of this call.
   * @return 
   */
  public RedisTransaction sinter(List<String> keys, Handler<AsyncResult<String>> handler) { 
    delegate.sinter(keys, handler);
    return this;
  }

  /**
   * Intersect multiple sets
   * @param keys List of keys to perform intersection on
   * @return 
   */
  public Single<String> rxSinter(List<String> keys) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      sinter(keys, handler);
    });
  }

  /**
   * Intersect multiple sets and store the resulting set in a key
   * @param destkey Key where to store the results
   * @param keys List of keys to perform intersection on
   * @param handler Handler for the result of this call.
   * @return 
   */
  public RedisTransaction sinterstore(String destkey, List<String> keys, Handler<AsyncResult<String>> handler) { 
    delegate.sinterstore(destkey, keys, handler);
    return this;
  }

  /**
   * Intersect multiple sets and store the resulting set in a key
   * @param destkey Key where to store the results
   * @param keys List of keys to perform intersection on
   * @return 
   */
  public Single<String> rxSinterstore(String destkey, List<String> keys) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      sinterstore(destkey, keys, handler);
    });
  }

  /**
   * Determine if a given value is a member of a set
   * @param key Key string
   * @param member Member to look for
   * @param handler Handler for the result of this call.
   * @return 
   */
  public RedisTransaction sismember(String key, String member, Handler<AsyncResult<String>> handler) { 
    delegate.sismember(key, member, handler);
    return this;
  }

  /**
   * Determine if a given value is a member of a set
   * @param key Key string
   * @param member Member to look for
   * @return 
   */
  public Single<String> rxSismember(String key, String member) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      sismember(key, member, handler);
    });
  }

  /**
   * Make the server a slave of another instance
   * @param host Host to become this server's master
   * @param port Port of our new master
   * @param handler Handler for the result of this call.
   * @return 
   */
  public RedisTransaction slaveof(String host, int port, Handler<AsyncResult<String>> handler) { 
    delegate.slaveof(host, port, handler);
    return this;
  }

  /**
   * Make the server a slave of another instance
   * @param host Host to become this server's master
   * @param port Port of our new master
   * @return 
   */
  public Single<String> rxSlaveof(String host, int port) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      slaveof(host, port, handler);
    });
  }

  /**
   * Make this server a master
   * @param handler Handler for the result of this call.
   * @return 
   */
  public RedisTransaction slaveofNoone(Handler<AsyncResult<String>> handler) { 
    delegate.slaveofNoone(handler);
    return this;
  }

  /**
   * Make this server a master
   * @return 
   */
  public Single<String> rxSlaveofNoone() { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      slaveofNoone(handler);
    });
  }

  /**
   * Read the Redis slow queries log
   * @param limit Number of log entries to return. If value is less than zero all entries are returned
   * @param handler Handler for the result of this call.
   * @return 
   */
  public RedisTransaction slowlogGet(int limit, Handler<AsyncResult<String>> handler) { 
    delegate.slowlogGet(limit, handler);
    return this;
  }

  /**
   * Read the Redis slow queries log
   * @param limit Number of log entries to return. If value is less than zero all entries are returned
   * @return 
   */
  public Single<String> rxSlowlogGet(int limit) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      slowlogGet(limit, handler);
    });
  }

  /**
   * Get the length of the Redis slow queries log
   * @param handler Handler for the result of this call.
   * @return 
   */
  public RedisTransaction slowlogLen(Handler<AsyncResult<String>> handler) { 
    delegate.slowlogLen(handler);
    return this;
  }

  /**
   * Get the length of the Redis slow queries log
   * @return 
   */
  public Single<String> rxSlowlogLen() { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      slowlogLen(handler);
    });
  }

  /**
   * Reset the Redis slow queries log
   * @param handler Handler for the result of this call.
   * @return 
   */
  public RedisTransaction slowlogReset(Handler<AsyncResult<String>> handler) { 
    delegate.slowlogReset(handler);
    return this;
  }

  /**
   * Reset the Redis slow queries log
   * @return 
   */
  public Single<String> rxSlowlogReset() { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      slowlogReset(handler);
    });
  }

  /**
   * Get all the members in a set
   * @param key Key string
   * @param handler Handler for the result of this call.
   * @return 
   */
  public RedisTransaction smembers(String key, Handler<AsyncResult<JsonArray>> handler) { 
    delegate.smembers(key, handler);
    return this;
  }

  /**
   * Get all the members in a set
   * @param key Key string
   * @return 
   */
  public Single<JsonArray> rxSmembers(String key) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<JsonArray>(handler -> {
      smembers(key, handler);
    });
  }

  /**
   * Move a member from one set to another
   * @param key Key of source set currently containing the member
   * @param destkey Key identifying the destination set
   * @param member Member to move
   * @param handler Handler for the result of this call.
   * @return 
   */
  public RedisTransaction smove(String key, String destkey, String member, Handler<AsyncResult<String>> handler) { 
    delegate.smove(key, destkey, member, handler);
    return this;
  }

  /**
   * Move a member from one set to another
   * @param key Key of source set currently containing the member
   * @param destkey Key identifying the destination set
   * @param member Member to move
   * @return 
   */
  public Single<String> rxSmove(String key, String destkey, String member) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      smove(key, destkey, member, handler);
    });
  }

  /**
   * Sort the elements in a list, set or sorted set
   * @param key Key string
   * @param options Sort options
   * @param handler Handler for the result of this call.
   * @return 
   */
  public RedisTransaction sort(String key, SortOptions options, Handler<AsyncResult<String>> handler) { 
    delegate.sort(key, options, handler);
    return this;
  }

  /**
   * Sort the elements in a list, set or sorted set
   * @param key Key string
   * @param options Sort options
   * @return 
   */
  public Single<String> rxSort(String key, SortOptions options) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      sort(key, options, handler);
    });
  }

  /**
   * Remove and return a random member from a set
   * @param key Key string
   * @param handler Handler for the result of this call.
   * @return 
   */
  public RedisTransaction spop(String key, Handler<AsyncResult<String>> handler) { 
    delegate.spop(key, handler);
    return this;
  }

  /**
   * Remove and return a random member from a set
   * @param key Key string
   * @return 
   */
  public Single<String> rxSpop(String key) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      spop(key, handler);
    });
  }

  /**
   * Remove and return random members from a set
   * @param key Key string
   * @param count Number of members to remove
   * @param handler Handler for the result of this call.
   * @return 
   */
  public RedisTransaction spopMany(String key, int count, Handler<AsyncResult<String>> handler) { 
    delegate.spopMany(key, count, handler);
    return this;
  }

  /**
   * Remove and return random members from a set
   * @param key Key string
   * @param count Number of members to remove
   * @return 
   */
  public Single<String> rxSpopMany(String key, int count) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      spopMany(key, count, handler);
    });
  }

  /**
   * Get one or multiple random members from a set
   * @param key Key string
   * @param handler Handler for the result of this call.
   * @return 
   */
  public RedisTransaction srandmember(String key, Handler<AsyncResult<String>> handler) { 
    delegate.srandmember(key, handler);
    return this;
  }

  /**
   * Get one or multiple random members from a set
   * @param key Key string
   * @return 
   */
  public Single<String> rxSrandmember(String key) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      srandmember(key, handler);
    });
  }

  /**
   * Get one or multiple random members from a set
   * @param key Key string
   * @param count Number of members to get
   * @param handler Handler for the result of this call.
   * @return 
   */
  public RedisTransaction srandmemberCount(String key, int count, Handler<AsyncResult<String>> handler) { 
    delegate.srandmemberCount(key, count, handler);
    return this;
  }

  /**
   * Get one or multiple random members from a set
   * @param key Key string
   * @param count Number of members to get
   * @return 
   */
  public Single<String> rxSrandmemberCount(String key, int count) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      srandmemberCount(key, count, handler);
    });
  }

  /**
   * Remove one member from a set
   * @param key Key string
   * @param member Member to remove
   * @param handler Handler for the result of this call.
   * @return 
   */
  public RedisTransaction srem(String key, String member, Handler<AsyncResult<String>> handler) { 
    delegate.srem(key, member, handler);
    return this;
  }

  /**
   * Remove one member from a set
   * @param key Key string
   * @param member Member to remove
   * @return 
   */
  public Single<String> rxSrem(String key, String member) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      srem(key, member, handler);
    });
  }

  /**
   * Remove one or more members from a set
   * @param key Key string
   * @param members Members to remove
   * @param handler Handler for the result of this call.
   * @return 
   */
  public RedisTransaction sremMany(String key, List<String> members, Handler<AsyncResult<String>> handler) { 
    delegate.sremMany(key, members, handler);
    return this;
  }

  /**
   * Remove one or more members from a set
   * @param key Key string
   * @param members Members to remove
   * @return 
   */
  public Single<String> rxSremMany(String key, List<String> members) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      sremMany(key, members, handler);
    });
  }

  /**
   * Get the length of the value stored in a key
   * @param key Key string
   * @param handler Handler for the result of this call.
   * @return 
   */
  public RedisTransaction strlen(String key, Handler<AsyncResult<String>> handler) { 
    delegate.strlen(key, handler);
    return this;
  }

  /**
   * Get the length of the value stored in a key
   * @param key Key string
   * @return 
   */
  public Single<String> rxStrlen(String key) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      strlen(key, handler);
    });
  }

  /**
   * Listen for messages published to the given channels
   * @param channel Channel to subscribe to
   * @param handler Handler for the result of this call.
   * @return 
   */
  public RedisTransaction subscribe(String channel, Handler<AsyncResult<String>> handler) { 
    delegate.subscribe(channel, handler);
    return this;
  }

  /**
   * Listen for messages published to the given channels
   * @param channel Channel to subscribe to
   * @return 
   */
  public Single<String> rxSubscribe(String channel) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      subscribe(channel, handler);
    });
  }

  /**
   * Listen for messages published to the given channels
   * @param channels List of channels to subscribe to
   * @param handler Handler for the result of this call.
   * @return 
   */
  public RedisTransaction subscribeMany(List<String> channels, Handler<AsyncResult<String>> handler) { 
    delegate.subscribeMany(channels, handler);
    return this;
  }

  /**
   * Listen for messages published to the given channels
   * @param channels List of channels to subscribe to
   * @return 
   */
  public Single<String> rxSubscribeMany(List<String> channels) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      subscribeMany(channels, handler);
    });
  }

  /**
   * Add multiple sets
   * @param keys List of keys identifying sets to add up
   * @param handler Handler for the result of this call.
   * @return 
   */
  public RedisTransaction sunion(List<String> keys, Handler<AsyncResult<String>> handler) { 
    delegate.sunion(keys, handler);
    return this;
  }

  /**
   * Add multiple sets
   * @param keys List of keys identifying sets to add up
   * @return 
   */
  public Single<String> rxSunion(List<String> keys) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      sunion(keys, handler);
    });
  }

  /**
   * Add multiple sets and store the resulting set in a key
   * @param destkey Destination key
   * @param keys List of keys identifying sets to add up
   * @param handler Handler for the result of this call.
   * @return 
   */
  public RedisTransaction sunionstore(String destkey, List<String> keys, Handler<AsyncResult<String>> handler) { 
    delegate.sunionstore(destkey, keys, handler);
    return this;
  }

  /**
   * Add multiple sets and store the resulting set in a key
   * @param destkey Destination key
   * @param keys List of keys identifying sets to add up
   * @return 
   */
  public Single<String> rxSunionstore(String destkey, List<String> keys) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      sunionstore(destkey, keys, handler);
    });
  }

  /**
   * Internal command used for replication
   * @param handler 
   * @return 
   */
  public RedisTransaction sync(Handler<AsyncResult<String>> handler) { 
    delegate.sync(handler);
    return this;
  }

  /**
   * Internal command used for replication
   * @return 
   */
  public Single<String> rxSync() { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      sync(handler);
    });
  }

  /**
   * Return the current server time
   * @param handler 
   * @return 
   */
  public RedisTransaction time(Handler<AsyncResult<String>> handler) { 
    delegate.time(handler);
    return this;
  }

  /**
   * Return the current server time
   * @return 
   */
  public Single<String> rxTime() { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      time(handler);
    });
  }

  /**
   * Get the time to live for a key
   * @param key Key string
   * @param handler Handler for the result of this call.
   * @return 
   */
  public RedisTransaction ttl(String key, Handler<AsyncResult<String>> handler) { 
    delegate.ttl(key, handler);
    return this;
  }

  /**
   * Get the time to live for a key
   * @param key Key string
   * @return 
   */
  public Single<String> rxTtl(String key) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      ttl(key, handler);
    });
  }

  /**
   * Determine the type stored at key
   * @param key Key string
   * @param handler Handler for the result of this call.
   * @return 
   */
  public RedisTransaction type(String key, Handler<AsyncResult<String>> handler) { 
    delegate.type(key, handler);
    return this;
  }

  /**
   * Determine the type stored at key
   * @param key Key string
   * @return 
   */
  public Single<String> rxType(String key) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      type(key, handler);
    });
  }

  /**
   * Stop listening for messages posted to the given channels
   * @param channels List of channels to subscribe to
   * @param handler Handler for the result of this call.
   * @return 
   */
  public RedisTransaction unsubscribe(List<String> channels, Handler<AsyncResult<String>> handler) { 
    delegate.unsubscribe(channels, handler);
    return this;
  }

  /**
   * Stop listening for messages posted to the given channels
   * @param channels List of channels to subscribe to
   * @return 
   */
  public Single<String> rxUnsubscribe(List<String> channels) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      unsubscribe(channels, handler);
    });
  }

  /**
   * Forget about all watched keys
   * @param handler 
   * @return 
   */
  public RedisTransaction unwatch(Handler<AsyncResult<String>> handler) { 
    delegate.unwatch(handler);
    return this;
  }

  /**
   * Forget about all watched keys
   * @return 
   */
  public Single<String> rxUnwatch() { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      unwatch(handler);
    });
  }

  /**
   * Wait for the synchronous replication of all the write commands sent in the context of the current connection.
   * @param numSlaves 
   * @param timeout 
   * @param handler Handler for the result of this call.
   * @return 
   */
  public RedisTransaction wait(long numSlaves, long timeout, Handler<AsyncResult<String>> handler) { 
    delegate.wait(numSlaves, timeout, handler);
    return this;
  }

  /**
   * Wait for the synchronous replication of all the write commands sent in the context of the current connection.
   * @param numSlaves 
   * @param timeout 
   * @return 
   */
  public Single<String> rxWait(long numSlaves, long timeout) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      wait(numSlaves, timeout, handler);
    });
  }

  /**
   * Watch the given keys to determine execution of the MULTI/EXEC block
   * @param key Key to watch
   * @param handler Handler for the result of this call.
   * @return 
   */
  public RedisTransaction watch(String key, Handler<AsyncResult<String>> handler) { 
    delegate.watch(key, handler);
    return this;
  }

  /**
   * Watch the given keys to determine execution of the MULTI/EXEC block
   * @param key Key to watch
   * @return 
   */
  public Single<String> rxWatch(String key) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      watch(key, handler);
    });
  }

  /**
   * Watch the given keys to determine execution of the MULTI/EXEC block
   * @param keys List of keys to watch
   * @param handler Handler for the result of this call.
   * @return 
   */
  public RedisTransaction watchMany(List<String> keys, Handler<AsyncResult<String>> handler) { 
    delegate.watchMany(keys, handler);
    return this;
  }

  /**
   * Watch the given keys to determine execution of the MULTI/EXEC block
   * @param keys List of keys to watch
   * @return 
   */
  public Single<String> rxWatchMany(List<String> keys) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      watchMany(keys, handler);
    });
  }

  /**
   * Add one or more members to a sorted set, or update its score if it already exists
   * @param key Key string
   * @param score Score used for sorting
   * @param member New member key
   * @param handler Handler for the result of this call.
   * @return 
   */
  public RedisTransaction zadd(String key, double score, String member, Handler<AsyncResult<String>> handler) { 
    delegate.zadd(key, score, member, handler);
    return this;
  }

  /**
   * Add one or more members to a sorted set, or update its score if it already exists
   * @param key Key string
   * @param score Score used for sorting
   * @param member New member key
   * @return 
   */
  public Single<String> rxZadd(String key, double score, String member) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      zadd(key, score, member, handler);
    });
  }

  /**
   * Add one or more members to a sorted set, or update its score if it already exists
   * @param key Key string
   * @param members New member keys and their scores
   * @param handler Handler for the result of this call.
   * @return 
   */
  public RedisTransaction zaddMany(String key, Map<String,Double> members, Handler<AsyncResult<String>> handler) { 
    delegate.zaddMany(key, members, handler);
    return this;
  }

  /**
   * Add one or more members to a sorted set, or update its score if it already exists
   * @param key Key string
   * @param members New member keys and their scores
   * @return 
   */
  public Single<String> rxZaddMany(String key, Map<String,Double> members) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      zaddMany(key, members, handler);
    });
  }

  /**
   * Get the number of members in a sorted set
   * @param key Key string
   * @param handler Handler for the result of this call.
   * @return 
   */
  public RedisTransaction zcard(String key, Handler<AsyncResult<String>> handler) { 
    delegate.zcard(key, handler);
    return this;
  }

  /**
   * Get the number of members in a sorted set
   * @param key Key string
   * @return 
   */
  public Single<String> rxZcard(String key) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      zcard(key, handler);
    });
  }

  /**
   * Count the members in a sorted set with scores within the given values
   * @param key Key string
   * @param min Minimum score
   * @param max Maximum score
   * @param handler Handler for the result of this call.
   * @return 
   */
  public RedisTransaction zcount(String key, double min, double max, Handler<AsyncResult<String>> handler) { 
    delegate.zcount(key, min, max, handler);
    return this;
  }

  /**
   * Count the members in a sorted set with scores within the given values
   * @param key Key string
   * @param min Minimum score
   * @param max Maximum score
   * @return 
   */
  public Single<String> rxZcount(String key, double min, double max) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      zcount(key, min, max, handler);
    });
  }

  /**
   * Increment the score of a member in a sorted set
   * @param key Key string
   * @param increment Increment amount
   * @param member Member key
   * @param handler Handler for the result of this call.
   * @return 
   */
  public RedisTransaction zincrby(String key, double increment, String member, Handler<AsyncResult<String>> handler) { 
    delegate.zincrby(key, increment, member, handler);
    return this;
  }

  /**
   * Increment the score of a member in a sorted set
   * @param key Key string
   * @param increment Increment amount
   * @param member Member key
   * @return 
   */
  public Single<String> rxZincrby(String key, double increment, String member) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      zincrby(key, increment, member, handler);
    });
  }

  /**
   * Intersect multiple sorted sets and store the resulting sorted set in a new key
   * @param destkey Destination key
   * @param sets List of keys identifying sorted sets to intersect
   * @param options Aggregation options
   * @param handler Handler for the result of this call.
   * @return 
   */
  public RedisTransaction zinterstore(String destkey, List<String> sets, AggregateOptions options, Handler<AsyncResult<String>> handler) { 
    delegate.zinterstore(destkey, sets, options, handler);
    return this;
  }

  /**
   * Intersect multiple sorted sets and store the resulting sorted set in a new key
   * @param destkey Destination key
   * @param sets List of keys identifying sorted sets to intersect
   * @param options Aggregation options
   * @return 
   */
  public Single<String> rxZinterstore(String destkey, List<String> sets, AggregateOptions options) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      zinterstore(destkey, sets, options, handler);
    });
  }

  /**
   * Intersect multiple sorted sets and store the resulting sorted set in a new key using weights for scoring
   * @param destkey Destination key
   * @param sets List of keys identifying sorted sets to intersect
   * @param options Aggregation options
   * @param handler Handler for the result of this call.
   * @return 
   */
  public RedisTransaction zinterstoreWeighed(String destkey, Map<String,Double> sets, AggregateOptions options, Handler<AsyncResult<String>> handler) { 
    delegate.zinterstoreWeighed(destkey, sets, options, handler);
    return this;
  }

  /**
   * Intersect multiple sorted sets and store the resulting sorted set in a new key using weights for scoring
   * @param destkey Destination key
   * @param sets List of keys identifying sorted sets to intersect
   * @param options Aggregation options
   * @return 
   */
  public Single<String> rxZinterstoreWeighed(String destkey, Map<String,Double> sets, AggregateOptions options) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      zinterstoreWeighed(destkey, sets, options, handler);
    });
  }

  /**
   * Count the number of members in a sorted set between a given lexicographical range
   * @param key Key string
   * @param min Pattern to compare against for minimum value
   * @param max Pattern to compare against for maximum value
   * @param handler Handler for the result of this call.
   * @return 
   */
  public RedisTransaction zlexcount(String key, String min, String max, Handler<AsyncResult<String>> handler) { 
    delegate.zlexcount(key, min, max, handler);
    return this;
  }

  /**
   * Count the number of members in a sorted set between a given lexicographical range
   * @param key Key string
   * @param min Pattern to compare against for minimum value
   * @param max Pattern to compare against for maximum value
   * @return 
   */
  public Single<String> rxZlexcount(String key, String min, String max) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      zlexcount(key, min, max, handler);
    });
  }

  /**
   * Return a range of members in a sorted set, by index
   * @param key Key string
   * @param start Start index for the range
   * @param stop Stop index for the range - inclusive
   * @param handler Handler for the result of this call.
   * @return 
   */
  public RedisTransaction zrange(String key, long start, long stop, Handler<AsyncResult<String>> handler) { 
    delegate.zrange(key, start, stop, handler);
    return this;
  }

  /**
   * Return a range of members in a sorted set, by index
   * @param key Key string
   * @param start Start index for the range
   * @param stop Stop index for the range - inclusive
   * @return 
   */
  public Single<String> rxZrange(String key, long start, long stop) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      zrange(key, start, stop, handler);
    });
  }

  /**
   * Return a range of members in a sorted set, by index
   * @param key Key string
   * @param start Start index for the range
   * @param stop Stop index for the range - inclusive
   * @param options Range options
   * @param handler Handler for the result of this call.
   * @return 
   */
  public RedisTransaction zrangeWithOptions(String key, long start, long stop, RangeOptions options, Handler<AsyncResult<String>> handler) { 
    delegate.zrangeWithOptions(key, start, stop, options, handler);
    return this;
  }

  /**
   * Return a range of members in a sorted set, by index
   * @param key Key string
   * @param start Start index for the range
   * @param stop Stop index for the range - inclusive
   * @param options Range options
   * @return 
   */
  public Single<String> rxZrangeWithOptions(String key, long start, long stop, RangeOptions options) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      zrangeWithOptions(key, start, stop, options, handler);
    });
  }

  /**
   * Return a range of members in a sorted set, by lexicographical range
   * @param key Key string
   * @param min Pattern representing a minimum allowed value
   * @param max Pattern representing a maximum allowed value
   * @param options Limit options where limit can be specified
   * @param handler Handler for the result of this call.
   * @return 
   */
  public RedisTransaction zrangebylex(String key, String min, String max, LimitOptions options, Handler<AsyncResult<String>> handler) { 
    delegate.zrangebylex(key, min, max, options, handler);
    return this;
  }

  /**
   * Return a range of members in a sorted set, by lexicographical range
   * @param key Key string
   * @param min Pattern representing a minimum allowed value
   * @param max Pattern representing a maximum allowed value
   * @param options Limit options where limit can be specified
   * @return 
   */
  public Single<String> rxZrangebylex(String key, String min, String max, LimitOptions options) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      zrangebylex(key, min, max, options, handler);
    });
  }

  /**
   * Return a range of members in a sorted set, by score
   * @param key Key string
   * @param min Pattern defining a minimum value
   * @param max Pattern defining a maximum value
   * @param options Range and limit options
   * @param handler Handler for the result of this call.
   * @return 
   */
  public RedisTransaction zrangebyscore(String key, String min, String max, RangeLimitOptions options, Handler<AsyncResult<String>> handler) { 
    delegate.zrangebyscore(key, min, max, options, handler);
    return this;
  }

  /**
   * Return a range of members in a sorted set, by score
   * @param key Key string
   * @param min Pattern defining a minimum value
   * @param max Pattern defining a maximum value
   * @param options Range and limit options
   * @return 
   */
  public Single<String> rxZrangebyscore(String key, String min, String max, RangeLimitOptions options) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      zrangebyscore(key, min, max, options, handler);
    });
  }

  /**
   * Determine the index of a member in a sorted set
   * @param key Key string
   * @param member Member in the sorted set identified by key
   * @param handler Handler for the result of this call.
   * @return 
   */
  public RedisTransaction zrank(String key, String member, Handler<AsyncResult<String>> handler) { 
    delegate.zrank(key, member, handler);
    return this;
  }

  /**
   * Determine the index of a member in a sorted set
   * @param key Key string
   * @param member Member in the sorted set identified by key
   * @return 
   */
  public Single<String> rxZrank(String key, String member) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      zrank(key, member, handler);
    });
  }

  /**
   * Remove one member from a sorted set
   * @param key Key string
   * @param member Member in the sorted set identified by key
   * @param handler Handler for the result of this call.
   * @return 
   */
  public RedisTransaction zrem(String key, String member, Handler<AsyncResult<String>> handler) { 
    delegate.zrem(key, member, handler);
    return this;
  }

  /**
   * Remove one member from a sorted set
   * @param key Key string
   * @param member Member in the sorted set identified by key
   * @return 
   */
  public Single<String> rxZrem(String key, String member) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      zrem(key, member, handler);
    });
  }

  /**
   * Remove one or more members from a sorted set
   * @param key Key string
   * @param members Members in the sorted set identified by key
   * @param handler Handler for the result of this call.
   * @return 
   */
  public RedisTransaction zremMany(String key, List<String> members, Handler<AsyncResult<String>> handler) { 
    delegate.zremMany(key, members, handler);
    return this;
  }

  /**
   * Remove one or more members from a sorted set
   * @param key Key string
   * @param members Members in the sorted set identified by key
   * @return 
   */
  public Single<String> rxZremMany(String key, List<String> members) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      zremMany(key, members, handler);
    });
  }

  /**
   * Remove all members in a sorted set between the given lexicographical range
   * @param key Key string
   * @param min Pattern defining a minimum value
   * @param max Pattern defining a maximum value
   * @param handler Handler for the result of this call.
   * @return 
   */
  public RedisTransaction zremrangebylex(String key, String min, String max, Handler<AsyncResult<String>> handler) { 
    delegate.zremrangebylex(key, min, max, handler);
    return this;
  }

  /**
   * Remove all members in a sorted set between the given lexicographical range
   * @param key Key string
   * @param min Pattern defining a minimum value
   * @param max Pattern defining a maximum value
   * @return 
   */
  public Single<String> rxZremrangebylex(String key, String min, String max) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      zremrangebylex(key, min, max, handler);
    });
  }

  /**
   * Remove all members in a sorted set within the given indexes
   * @param key Key string
   * @param start Start index
   * @param stop Stop index
   * @param handler Handler for the result of this call.
   * @return 
   */
  public RedisTransaction zremrangebyrank(String key, long start, long stop, Handler<AsyncResult<String>> handler) { 
    delegate.zremrangebyrank(key, start, stop, handler);
    return this;
  }

  /**
   * Remove all members in a sorted set within the given indexes
   * @param key Key string
   * @param start Start index
   * @param stop Stop index
   * @return 
   */
  public Single<String> rxZremrangebyrank(String key, long start, long stop) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      zremrangebyrank(key, start, stop, handler);
    });
  }

  /**
   * Remove all members in a sorted set within the given scores
   * @param key Key string
   * @param min Pattern defining a minimum value
   * @param max Pattern defining a maximum value
   * @param handler 
   * @return 
   */
  public RedisTransaction zremrangebyscore(String key, String min, String max, Handler<AsyncResult<String>> handler) { 
    delegate.zremrangebyscore(key, min, max, handler);
    return this;
  }

  /**
   * Remove all members in a sorted set within the given scores
   * @param key Key string
   * @param min Pattern defining a minimum value
   * @param max Pattern defining a maximum value
   * @return 
   */
  public Single<String> rxZremrangebyscore(String key, String min, String max) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      zremrangebyscore(key, min, max, handler);
    });
  }

  /**
   * Return a range of members in a sorted set, by index, with scores ordered from high to low
   * @param key Key string
   * @param start Start index for the range
   * @param stop Stop index for the range - inclusive
   * @param options Range options
   * @param handler Handler for the result of this call.
   * @return 
   */
  public RedisTransaction zrevrange(String key, long start, long stop, RangeOptions options, Handler<AsyncResult<String>> handler) { 
    delegate.zrevrange(key, start, stop, options, handler);
    return this;
  }

  /**
   * Return a range of members in a sorted set, by index, with scores ordered from high to low
   * @param key Key string
   * @param start Start index for the range
   * @param stop Stop index for the range - inclusive
   * @param options Range options
   * @return 
   */
  public Single<String> rxZrevrange(String key, long start, long stop, RangeOptions options) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      zrevrange(key, start, stop, options, handler);
    });
  }

  /**
   * Return a range of members in a sorted set, by score, between the given lexicographical range with scores ordered from high to low
   * @param key Key string
   * @param max Pattern defining a maximum value
   * @param min Pattern defining a minimum value
   * @param options Limit options
   * @param handler Handler for the result of this call.
   * @return 
   */
  public RedisTransaction zrevrangebylex(String key, String max, String min, LimitOptions options, Handler<AsyncResult<String>> handler) { 
    delegate.zrevrangebylex(key, max, min, options, handler);
    return this;
  }

  /**
   * Return a range of members in a sorted set, by score, between the given lexicographical range with scores ordered from high to low
   * @param key Key string
   * @param max Pattern defining a maximum value
   * @param min Pattern defining a minimum value
   * @param options Limit options
   * @return 
   */
  public Single<String> rxZrevrangebylex(String key, String max, String min, LimitOptions options) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      zrevrangebylex(key, max, min, options, handler);
    });
  }

  /**
   * Return a range of members in a sorted set, by score, with scores ordered from high to low
   * @param key Key string
   * @param max Pattern defining a maximum value
   * @param min Pattern defining a minimum value
   * @param options Range and limit options
   * @param handler Handler for the result of this call.
   * @return 
   */
  public RedisTransaction zrevrangebyscore(String key, String max, String min, RangeLimitOptions options, Handler<AsyncResult<String>> handler) { 
    delegate.zrevrangebyscore(key, max, min, options, handler);
    return this;
  }

  /**
   * Return a range of members in a sorted set, by score, with scores ordered from high to low
   * @param key Key string
   * @param max Pattern defining a maximum value
   * @param min Pattern defining a minimum value
   * @param options Range and limit options
   * @return 
   */
  public Single<String> rxZrevrangebyscore(String key, String max, String min, RangeLimitOptions options) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      zrevrangebyscore(key, max, min, options, handler);
    });
  }

  /**
   * Determine the index of a member in a sorted set, with scores ordered from high to low
   * @param key Key string
   * @param member Member in the sorted set identified by key
   * @param handler Handler for the result of this call.
   * @return 
   */
  public RedisTransaction zrevrank(String key, String member, Handler<AsyncResult<String>> handler) { 
    delegate.zrevrank(key, member, handler);
    return this;
  }

  /**
   * Determine the index of a member in a sorted set, with scores ordered from high to low
   * @param key Key string
   * @param member Member in the sorted set identified by key
   * @return 
   */
  public Single<String> rxZrevrank(String key, String member) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      zrevrank(key, member, handler);
    });
  }

  /**
   * Get the score associated with the given member in a sorted set
   * @param key Key string
   * @param member Member in the sorted set identified by key
   * @param handler Handler for the result of this call.
   * @return 
   */
  public RedisTransaction zscore(String key, String member, Handler<AsyncResult<String>> handler) { 
    delegate.zscore(key, member, handler);
    return this;
  }

  /**
   * Get the score associated with the given member in a sorted set
   * @param key Key string
   * @param member Member in the sorted set identified by key
   * @return 
   */
  public Single<String> rxZscore(String key, String member) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      zscore(key, member, handler);
    });
  }

  /**
   * Add multiple sorted sets and store the resulting sorted set in a new key
   * @param destkey Destination key
   * @param sets List of keys identifying sorted sets
   * @param options Aggregation options
   * @param handler Handler for the result of this call.
   * @return 
   */
  public RedisTransaction zunionstore(String destkey, List<String> sets, AggregateOptions options, Handler<AsyncResult<String>> handler) { 
    delegate.zunionstore(destkey, sets, options, handler);
    return this;
  }

  /**
   * Add multiple sorted sets and store the resulting sorted set in a new key
   * @param destkey Destination key
   * @param sets List of keys identifying sorted sets
   * @param options Aggregation options
   * @return 
   */
  public Single<String> rxZunionstore(String destkey, List<String> sets, AggregateOptions options) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      zunionstore(destkey, sets, options, handler);
    });
  }

  /**
   * Add multiple sorted sets using weights, and store the resulting sorted set in a new key
   * @param key Destination key
   * @param sets Map containing set-key:weight pairs
   * @param options Aggregation options
   * @param handler Handler for the result of this call.
   * @return 
   */
  public RedisTransaction zunionstoreWeighed(String key, Map<String,Double> sets, AggregateOptions options, Handler<AsyncResult<String>> handler) { 
    delegate.zunionstoreWeighed(key, sets, options, handler);
    return this;
  }

  /**
   * Add multiple sorted sets using weights, and store the resulting sorted set in a new key
   * @param key Destination key
   * @param sets Map containing set-key:weight pairs
   * @param options Aggregation options
   * @return 
   */
  public Single<String> rxZunionstoreWeighed(String key, Map<String,Double> sets, AggregateOptions options) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      zunionstoreWeighed(key, sets, options, handler);
    });
  }

  /**
   * Incrementally iterate the keys space
   * @param cursor Cursor id
   * @param options Scan options
   * @param handler Handler for the result of this call.
   * @return 
   */
  public RedisTransaction scan(String cursor, ScanOptions options, Handler<AsyncResult<String>> handler) { 
    delegate.scan(cursor, options, handler);
    return this;
  }

  /**
   * Incrementally iterate the keys space
   * @param cursor Cursor id
   * @param options Scan options
   * @return 
   */
  public Single<String> rxScan(String cursor, ScanOptions options) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      scan(cursor, options, handler);
    });
  }

  /**
   * Incrementally iterate Set elements
   * @param key Key string
   * @param cursor Cursor id
   * @param options Scan options
   * @param handler Handler for the result of this call.
   * @return 
   */
  public RedisTransaction sscan(String key, String cursor, ScanOptions options, Handler<AsyncResult<String>> handler) { 
    delegate.sscan(key, cursor, options, handler);
    return this;
  }

  /**
   * Incrementally iterate Set elements
   * @param key Key string
   * @param cursor Cursor id
   * @param options Scan options
   * @return 
   */
  public Single<String> rxSscan(String key, String cursor, ScanOptions options) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      sscan(key, cursor, options, handler);
    });
  }

  /**
   * Incrementally iterate hash fields and associated values
   * @param key Key string
   * @param cursor Cursor id
   * @param options Scan options
   * @param handler Handler for the result of this call.
   * @return 
   */
  public RedisTransaction hscan(String key, String cursor, ScanOptions options, Handler<AsyncResult<String>> handler) { 
    delegate.hscan(key, cursor, options, handler);
    return this;
  }

  /**
   * Incrementally iterate hash fields and associated values
   * @param key Key string
   * @param cursor Cursor id
   * @param options Scan options
   * @return 
   */
  public Single<String> rxHscan(String key, String cursor, ScanOptions options) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      hscan(key, cursor, options, handler);
    });
  }

  /**
   * Incrementally iterate sorted sets elements and associated scores
   * @param key Key string
   * @param cursor Cursor id
   * @param options Scan options
   * @param handler Handler for the result of this call.
   * @return 
   */
  public RedisTransaction zscan(String key, String cursor, ScanOptions options, Handler<AsyncResult<String>> handler) { 
    delegate.zscan(key, cursor, options, handler);
    return this;
  }

  /**
   * Incrementally iterate sorted sets elements and associated scores
   * @param key Key string
   * @param cursor Cursor id
   * @param options Scan options
   * @return 
   */
  public Single<String> rxZscan(String key, String cursor, ScanOptions options) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      zscan(key, cursor, options, handler);
    });
  }

  /**
   * Add one or more geospatial items in the geospatial index represented using a sorted set.
   * @param key Key string
   * @param longitude longitude
   * @param latitude latitude
   * @param member member
   * @param handler Handler for the result of this call.
   * @return 
   */
  public RedisTransaction geoadd(String key, double longitude, double latitude, String member, Handler<AsyncResult<String>> handler) { 
    delegate.geoadd(key, longitude, latitude, member, handler);
    return this;
  }

  /**
   * Add one or more geospatial items in the geospatial index represented using a sorted set.
   * @param key Key string
   * @param longitude longitude
   * @param latitude latitude
   * @param member member
   * @return 
   */
  public Single<String> rxGeoadd(String key, double longitude, double latitude, String member) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      geoadd(key, longitude, latitude, member, handler);
    });
  }

  /**
   * Add one or more geospatial items in the geospatial index represented using a sorted set.
   * @param key Key string
   * @param members list of &lt;lon, lat, member&gt;
   * @param handler Handler for the result of this call.
   * @return 
   */
  public RedisTransaction geoaddMany(String key, List<GeoMember> members, Handler<AsyncResult<String>> handler) { 
    delegate.geoaddMany(key, members, handler);
    return this;
  }

  /**
   * Add one or more geospatial items in the geospatial index represented using a sorted set.
   * @param key Key string
   * @param members list of &lt;lon, lat, member&gt;
   * @return 
   */
  public Single<String> rxGeoaddMany(String key, List<GeoMember> members) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      geoaddMany(key, members, handler);
    });
  }

  /**
   * Return valid Geohash strings representing the position of one or more elements in a sorted set value representing
   * a geospatial index (where elements were added using GEOADD).
   * @param key Key string
   * @param member member
   * @param handler Handler for the result of this call.
   * @return 
   */
  public RedisTransaction geohash(String key, String member, Handler<AsyncResult<String>> handler) { 
    delegate.geohash(key, member, handler);
    return this;
  }

  /**
   * Return valid Geohash strings representing the position of one or more elements in a sorted set value representing
   * a geospatial index (where elements were added using GEOADD).
   * @param key Key string
   * @param member member
   * @return 
   */
  public Single<String> rxGeohash(String key, String member) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      geohash(key, member, handler);
    });
  }

  /**
   * Return valid Geohash strings representing the position of one or more elements in a sorted set value representing
   * a geospatial index (where elements were added using GEOADD).
   * @param key Key string
   * @param members list of members
   * @param handler Handler for the result of this call.
   * @return 
   */
  public RedisTransaction geohashMany(String key, List<String> members, Handler<AsyncResult<String>> handler) { 
    delegate.geohashMany(key, members, handler);
    return this;
  }

  /**
   * Return valid Geohash strings representing the position of one or more elements in a sorted set value representing
   * a geospatial index (where elements were added using GEOADD).
   * @param key Key string
   * @param members list of members
   * @return 
   */
  public Single<String> rxGeohashMany(String key, List<String> members) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      geohashMany(key, members, handler);
    });
  }

  /**
   * Return the positions (longitude,latitude) of all the specified members of the geospatial index represented by the
   * sorted set at key.
   * @param key Key string
   * @param member member
   * @param handler Handler for the result of this call.
   * @return 
   */
  public RedisTransaction geopos(String key, String member, Handler<AsyncResult<String>> handler) { 
    delegate.geopos(key, member, handler);
    return this;
  }

  /**
   * Return the positions (longitude,latitude) of all the specified members of the geospatial index represented by the
   * sorted set at key.
   * @param key Key string
   * @param member member
   * @return 
   */
  public Single<String> rxGeopos(String key, String member) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      geopos(key, member, handler);
    });
  }

  /**
   * Return the positions (longitude,latitude) of all the specified members of the geospatial index represented by the
   * sorted set at key.
   * @param key Key string
   * @param members list of members
   * @param handler Handler for the result of this call.
   * @return 
   */
  public RedisTransaction geoposMany(String key, List<String> members, Handler<AsyncResult<String>> handler) { 
    delegate.geoposMany(key, members, handler);
    return this;
  }

  /**
   * Return the positions (longitude,latitude) of all the specified members of the geospatial index represented by the
   * sorted set at key.
   * @param key Key string
   * @param members list of members
   * @return 
   */
  public Single<String> rxGeoposMany(String key, List<String> members) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      geoposMany(key, members, handler);
    });
  }

  /**
   * Return the distance between two members in the geospatial index represented by the sorted set.
   * @param key Key string
   * @param member1 member 1
   * @param member2 member 2
   * @param handler Handler for the result of this call.
   * @return 
   */
  public RedisTransaction geodist(String key, String member1, String member2, Handler<AsyncResult<String>> handler) { 
    delegate.geodist(key, member1, member2, handler);
    return this;
  }

  /**
   * Return the distance between two members in the geospatial index represented by the sorted set.
   * @param key Key string
   * @param member1 member 1
   * @param member2 member 2
   * @return 
   */
  public Single<String> rxGeodist(String key, String member1, String member2) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      geodist(key, member1, member2, handler);
    });
  }

  /**
   * Return the distance between two members in the geospatial index represented by the sorted set.
   * @param key Key string
   * @param member1 member 1
   * @param member2 member 2
   * @param unit geo unit
   * @param handler Handler for the result of this call.
   * @return 
   */
  public RedisTransaction geodistWithUnit(String key, String member1, String member2, GeoUnit unit, Handler<AsyncResult<String>> handler) { 
    delegate.geodistWithUnit(key, member1, member2, unit, handler);
    return this;
  }

  /**
   * Return the distance between two members in the geospatial index represented by the sorted set.
   * @param key Key string
   * @param member1 member 1
   * @param member2 member 2
   * @param unit geo unit
   * @return 
   */
  public Single<String> rxGeodistWithUnit(String key, String member1, String member2, GeoUnit unit) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      geodistWithUnit(key, member1, member2, unit, handler);
    });
  }

  /**
   * Return the members of a sorted set populated with geospatial information using GEOADD, which are within the borders
   * of the area specified with the center location and the maximum distance from the center (the radius).
   * @param key Key string
   * @param longitude longitude
   * @param latitude latitude
   * @param radius radius
   * @param unit geo unit
   * @param handler Handler for the result of this call.
   * @return 
   */
  public RedisTransaction georadius(String key, double longitude, double latitude, double radius, GeoUnit unit, Handler<AsyncResult<String>> handler) { 
    delegate.georadius(key, longitude, latitude, radius, unit, handler);
    return this;
  }

  /**
   * Return the members of a sorted set populated with geospatial information using GEOADD, which are within the borders
   * of the area specified with the center location and the maximum distance from the center (the radius).
   * @param key Key string
   * @param longitude longitude
   * @param latitude latitude
   * @param radius radius
   * @param unit geo unit
   * @return 
   */
  public Single<String> rxGeoradius(String key, double longitude, double latitude, double radius, GeoUnit unit) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      georadius(key, longitude, latitude, radius, unit, handler);
    });
  }

  /**
   * Return the members of a sorted set populated with geospatial information using GEOADD, which are within the borders
   * of the area specified with the center location and the maximum distance from the center (the radius).
   * @param key Key string
   * @param longitude longitude
   * @param latitude latitude
   * @param radius radius
   * @param unit geo unit
   * @param options geo radius options
   * @param handler Handler for the result of this call.
   * @return 
   */
  public RedisTransaction georadiusWithOptions(String key, double longitude, double latitude, double radius, GeoUnit unit, GeoRadiusOptions options, Handler<AsyncResult<String>> handler) { 
    delegate.georadiusWithOptions(key, longitude, latitude, radius, unit, options, handler);
    return this;
  }

  /**
   * Return the members of a sorted set populated with geospatial information using GEOADD, which are within the borders
   * of the area specified with the center location and the maximum distance from the center (the radius).
   * @param key Key string
   * @param longitude longitude
   * @param latitude latitude
   * @param radius radius
   * @param unit geo unit
   * @param options geo radius options
   * @return 
   */
  public Single<String> rxGeoradiusWithOptions(String key, double longitude, double latitude, double radius, GeoUnit unit, GeoRadiusOptions options) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      georadiusWithOptions(key, longitude, latitude, radius, unit, options, handler);
    });
  }

  /**
   * This command is exactly like GEORADIUS with the sole difference that instead of taking, as the center of the area
   * to query, a longitude and latitude value, it takes the name of a member already existing inside the geospatial
   * index represented by the sorted set.
   * @param key Key string
   * @param member member
   * @param radius radius
   * @param unit geo unit
   * @param handler Handler for the result of this call.
   * @return 
   */
  public RedisTransaction georadiusbymember(String key, String member, double radius, GeoUnit unit, Handler<AsyncResult<String>> handler) { 
    delegate.georadiusbymember(key, member, radius, unit, handler);
    return this;
  }

  /**
   * This command is exactly like GEORADIUS with the sole difference that instead of taking, as the center of the area
   * to query, a longitude and latitude value, it takes the name of a member already existing inside the geospatial
   * index represented by the sorted set.
   * @param key Key string
   * @param member member
   * @param radius radius
   * @param unit geo unit
   * @return 
   */
  public Single<String> rxGeoradiusbymember(String key, String member, double radius, GeoUnit unit) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      georadiusbymember(key, member, radius, unit, handler);
    });
  }

  /**
   * This command is exactly like GEORADIUS with the sole difference that instead of taking, as the center of the area
   * to query, a longitude and latitude value, it takes the name of a member already existing inside the geospatial
   * index represented by the sorted set.
   * @param key Key string
   * @param member member
   * @param radius radius
   * @param unit geo unit
   * @param options geo radius options
   * @param handler Handler for the result of this call.
   * @return 
   */
  public RedisTransaction georadiusbymemberWithOptions(String key, String member, double radius, GeoUnit unit, GeoRadiusOptions options, Handler<AsyncResult<String>> handler) { 
    delegate.georadiusbymemberWithOptions(key, member, radius, unit, options, handler);
    return this;
  }

  /**
   * This command is exactly like GEORADIUS with the sole difference that instead of taking, as the center of the area
   * to query, a longitude and latitude value, it takes the name of a member already existing inside the geospatial
   * index represented by the sorted set.
   * @param key Key string
   * @param member member
   * @param radius radius
   * @param unit geo unit
   * @param options geo radius options
   * @return 
   */
  public Single<String> rxGeoradiusbymemberWithOptions(String key, String member, double radius, GeoUnit unit, GeoRadiusOptions options) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      georadiusbymemberWithOptions(key, member, radius, unit, options, handler);
    });
  }

  /**
   * Delete a key asynchronously in another thread. Otherwise it is just as DEL, but non blocking.
   * @param key Key string
   * @param handler 
   * @return 
   */
  public RedisTransaction unlink(String key, Handler<AsyncResult<String>> handler) { 
    delegate.unlink(key, handler);
    return this;
  }

  /**
   * Delete a key asynchronously in another thread. Otherwise it is just as DEL, but non blocking.
   * @param key Key string
   * @return 
   */
  public Single<String> rxUnlink(String key) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      unlink(key, handler);
    });
  }

  /**
   * Delete multiple keys asynchronously in another thread. Otherwise it is just as DEL, but non blocking.
   * @param keys List of keys to delete
   * @param handler Handler for the result of this call.
   * @return 
   */
  public RedisTransaction unlinkMany(List<String> keys, Handler<AsyncResult<String>> handler) { 
    delegate.unlinkMany(keys, handler);
    return this;
  }

  /**
   * Delete multiple keys asynchronously in another thread. Otherwise it is just as DEL, but non blocking.
   * @param keys List of keys to delete
   * @return 
   */
  public Single<String> rxUnlinkMany(List<String> keys) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      unlinkMany(keys, handler);
    });
  }

  /**
   * Swaps two Redis databases
   * @param index1 index of first database to swap
   * @param index2 index of second database to swap
   * @param handler Handler for the result of this call.
   * @return 
   */
  public RedisTransaction swapdb(int index1, int index2, Handler<AsyncResult<String>> handler) { 
    delegate.swapdb(index1, index2, handler);
    return this;
  }

  /**
   * Swaps two Redis databases
   * @param index1 index of first database to swap
   * @param index2 index of second database to swap
   * @return 
   */
  public Single<String> rxSwapdb(int index1, int index2) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      swapdb(index1, index2, handler);
    });
  }


  public static  RedisTransaction newInstance(io.vertx.redis.RedisTransaction arg) {
    return arg != null ? new RedisTransaction(arg) : null;
  }
}
