/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.test.redis;

import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.redis.RedisClient;
import io.vertx.redis.RedisOptions;
import io.vertx.redis.RedisTransaction;
import io.vertx.redis.op.AggregateOptions;
import io.vertx.redis.op.BitOperation;
import io.vertx.redis.op.InsertOptions;
import io.vertx.redis.op.KillFilter;
import io.vertx.redis.op.MigrateOptions;
import io.vertx.redis.op.ObjectCmd;
import io.vertx.redis.op.RangeLimitOptions;
import io.vertx.redis.op.RangeOptions;
import io.vertx.redis.op.ScanOptions;
import io.vertx.redis.op.SetOptions;
import io.vertx.redis.op.SortOptions;
import io.vertx.test.core.VertxTestBase;
import io.vertx.test.redis.RedisPost28Tests;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import redis.embedded.RedisServer;

public abstract class RedisClientTestBase
extends VertxTestBase {
    private static final Integer DEFAULT_PORT = 6379;
    private static final Map<Integer, RedisServer> instances = new ConcurrentHashMap<Integer, RedisServer>();
    protected RedisClient redis;

    private static String getHost() {
        return RedisClientTestBase.getProperty("host");
    }

    private static String getPort() {
        return RedisClientTestBase.getProperty("port");
    }

    private static String getProperty(String name) {
        String s = System.getProperty(name);
        return s != null && s.trim().length() > 0 ? s : null;
    }

    @BeforeClass
    public static void startRedis() throws Exception {
        if (RedisClientTestBase.getHost() == null && RedisClientTestBase.getPort() == null) {
            RedisClientTestBase.createRedisInstance(DEFAULT_PORT);
            instances.get(DEFAULT_PORT).start();
            System.out.println("** Using embedded redis");
        } else {
            System.out.println("** Using standalone redis");
        }
    }

    @AfterClass
    public static void stopRedis() throws Exception {
        for (Map.Entry<Integer, RedisServer> entry : instances.entrySet()) {
            if (entry == null) continue;
            entry.getValue().stop();
        }
    }

    public static void createRedisCount(int count) throws Exception {
        Integer[] ports = new Integer[count];
        Integer basePort = DEFAULT_PORT;
        for (int i = 0; i < count; ++i) {
            Integer n = basePort;
            Integer n2 = basePort = Integer.valueOf(basePort + 1);
            ports[i] = n;
        }
        RedisClientTestBase.createRedisInstance(ports);
    }

    public static void createRedisInstance(Integer ... ports) throws Exception {
        for (Integer port : ports) {
            System.out.println("Creating redis server on port: " + port);
            instances.put(port, new RedisServer(port));
            System.out.println("Created embedded redis server on port " + port);
        }
    }

    private static JsonArray toJsonArray(Object ... params) {
        return params != null ? new JsonArray(Arrays.asList(params)) : null;
    }

    private static Object[] toArray(Object ... params) {
        return params;
    }

    private static String errorMessage(Throwable t) {
        return t != null ? t.getMessage() : "";
    }

    private static String makeKey() {
        return UUID.randomUUID().toString();
    }

    private static Map<String, Object> toMap(String ... params) {
        if (params.length % 2 != 0) {
            throw new IllegalArgumentException("Last key has no value");
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        String key = null;
        for (String param : params) {
            if (key == null) {
                key = param;
                continue;
            }
            result.put(key, param);
            key = null;
        }
        return result;
    }

    @SafeVarargs
    private static <T> List<T> toList(T ... params) {
        return Arrays.asList(params);
    }

    protected RedisOptions getConfig() {
        String host = RedisClientTestBase.getHost();
        String port = RedisClientTestBase.getPort();
        RedisOptions config = new RedisOptions();
        if (host != null) {
            config.setHost(host);
        }
        if (port != null) {
            config.setPort(Integer.parseInt(port));
        }
        return config;
    }

    @Test
    public void testAppend() {
        String key = RedisClientTestBase.makeKey();
        this.redis.delMany(RedisClientTestBase.toList(key), reply0 -> {
            this.assertTrue(reply0.succeeded());
            this.redis.append(key, "Hello", reply1 -> {
                this.assertTrue(reply1.succeeded());
                this.assertEquals(5L, (Long)reply1.result());
                this.redis.append(key, " World", reply2 -> {
                    this.assertTrue(reply2.succeeded());
                    this.assertEquals(11L, (Long)reply2.result());
                    this.redis.get(key, reply3 -> {
                        this.assertTrue(reply3.succeeded());
                        this.assertTrue(reply3.succeeded());
                        this.assertEquals("Hello World", reply3.result());
                        this.testComplete();
                    });
                });
            });
        });
        this.await();
    }

    @Test
    public void testAuth() throws Exception {
        RedisServer server = RedisServer.builder().port(Integer.valueOf(6381)).setting("requirepass foobar").build();
        server.start();
        RedisOptions job = new RedisOptions().setHost("localhost").setPort(6381);
        RedisClient rdx = RedisClient.create((Vertx)this.vertx, (RedisOptions)job);
        rdx.auth("barfoo", reply -> {
            this.assertFalse(reply.succeeded());
            rdx.auth("foobar", reply2 -> {
                this.assertTrue(reply2.succeeded());
                try {
                    server.stop();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.testComplete();
            });
        });
        this.await();
    }

    @Test
    public void testBgrewriteaof() {
        this.redis.bgrewriteaof(reply -> {
            this.assertTrue(reply.succeeded());
            this.testComplete();
        });
        this.await();
    }

    @Test
    public void testBgsave() {
        this.redis.bgsave(reply -> {
            this.assertTrue(reply.succeeded());
            this.assertEquals("Background saving started", reply.result());
            this.testComplete();
        });
        this.await();
    }

    @Test
    public void testBitcount() {
        String key = RedisClientTestBase.makeKey();
        this.redis.set(key, "foobar", reply0 -> {
            this.assertTrue(reply0.succeeded());
            this.redis.bitcount(key, reply1 -> {
                this.assertTrue(reply1.succeeded());
                this.assertEquals(26L, (Long)reply1.result());
                this.redis.bitcountRange(key, 0L, 0L, reply2 -> {
                    this.assertTrue(reply2.succeeded());
                    this.assertEquals(4L, (Long)reply2.result());
                    this.redis.bitcountRange(key, 1L, 1L, reply3 -> {
                        this.assertTrue(reply3.succeeded());
                        this.assertEquals(6L, (Long)reply3.result());
                        this.testComplete();
                    });
                });
            });
        });
        this.await();
    }

    @Test
    public void testBitop() {
        String key1 = RedisClientTestBase.makeKey();
        String key2 = RedisClientTestBase.makeKey();
        String destkey = RedisClientTestBase.makeKey();
        this.redis.set(key1, "foobar", reply0 -> {
            this.assertTrue(reply0.succeeded());
            this.redis.set(key2, "abcdef", reply1 -> {
                this.assertTrue(reply1.succeeded());
                this.redis.bitop(BitOperation.AND, destkey, RedisClientTestBase.toList(key1, key2), reply2 -> {
                    this.assertTrue(reply2.succeeded());
                    this.redis.get(destkey, reply3 -> {
                        this.assertTrue(reply3.succeeded());
                        this.testComplete();
                    });
                });
            });
        });
        this.await();
    }

    @Test
    public void testBlpop() {
        String list1 = RedisClientTestBase.makeKey();
        String list2 = RedisClientTestBase.makeKey();
        this.redis.delMany(RedisClientTestBase.toList(list1, list2), reply0 -> {
            this.assertTrue(reply0.succeeded());
            this.redis.rpushMany(list1, RedisClientTestBase.toList("a", "b", "c"), reply1 -> {
                this.assertTrue(reply1.succeeded());
                this.assertEquals(3L, (Long)reply1.result());
                this.redis.blpopMany(RedisClientTestBase.toList(list1, list2), 0, reply2 -> {
                    this.assertTrue(reply2.succeeded());
                    this.assertArrayEquals(RedisClientTestBase.toArray(list1, "a"), ((JsonArray)reply2.result()).getList().toArray());
                    this.testComplete();
                });
            });
        });
        this.await();
    }

    @Test
    public void testBrpop() {
        String list1 = RedisClientTestBase.makeKey();
        String list2 = RedisClientTestBase.makeKey();
        this.redis.delMany(RedisClientTestBase.toList(list1, list2), reply0 -> {
            this.assertTrue(reply0.succeeded());
            this.redis.rpushMany(list1, RedisClientTestBase.toList("a", "b", "c"), reply1 -> {
                this.assertTrue(reply1.succeeded());
                this.assertEquals(3L, (Long)reply1.result());
                this.redis.brpopMany(RedisClientTestBase.toList(list1, list2), 0, reply2 -> {
                    this.assertTrue(RedisClientTestBase.errorMessage(reply2.cause()), reply2.succeeded());
                    this.assertArrayEquals(RedisClientTestBase.toArray(list1, "c"), ((JsonArray)reply2.result()).getList().toArray());
                    this.testComplete();
                });
            });
        });
        this.await();
    }

    @Test
    public void testBrpoplpush() throws Exception {
        this.redis.brpoplpush("list1", "list2", 100, result -> {
            if (result.succeeded()) {
                this.redis.lpop("list2", result2 -> {
                    if (result2.succeeded()) {
                        System.out.println((String)result2.result());
                        this.assertTrue("hello".equals(result2.result()));
                    }
                    this.testComplete();
                });
            } else {
                result.cause().printStackTrace();
                this.fail();
            }
        });
        RedisClient redis2 = RedisClient.create((Vertx)this.vertx, (RedisOptions)this.getConfig());
        redis2.lpush("list1", "hello", result -> {});
        this.await();
    }

    @Test
    @Category(value={RedisPost28Tests.class})
    public void testClientKill() {
        this.redis.clientList(reply -> {
            this.assertTrue(reply.succeeded());
            String clients = (String)reply.result();
            String[] keyvals = clients.split("\\s");
            String addr = null;
            for (String keyval : keyvals) {
                String[] pair = keyval.split("=");
                if (!"addr".equals(pair[0])) continue;
                addr = pair[1];
                break;
            }
            this.assertNotNull("No addr in CLIENT LIST", addr);
            this.redis.clientKill(new KillFilter().setAddr(addr).setType(KillFilter.Type.NORMAL), reply2 -> {
                this.assertTrue(String.valueOf(reply2.cause()), reply2.succeeded());
                this.testComplete();
            });
        });
        this.await();
    }

    @Test
    public void testClientList() {
        this.redis.clientList(result -> {
            this.assertTrue(result.succeeded());
            this.assertNotNull(result.result());
            this.testComplete();
        });
        this.await();
    }

    @Test
    public void testClientSetAndGetName() throws Exception {
        this.redis.clientGetname(result -> {
            this.assertTrue(String.valueOf(result.cause()), result.succeeded());
            this.assertNull(result.result());
            this.redis.clientSetname("test-connection", result1 -> {
                this.assertTrue(result1.succeeded());
                this.redis.clientGetname(result2 -> {
                    this.assertTrue(result2.succeeded());
                    this.assertEquals("test-connection", result2.result());
                    this.testComplete();
                });
            });
        });
        this.await();
    }

    @Test
    public void testConfigGet() {
        this.redis.configGet("*", reply -> {
            this.assertTrue(reply.succeeded());
            this.assertTrue(reply.result() != null && ((JsonArray)reply.result()).size() > 0);
            this.testComplete();
        });
        this.await();
    }

    @Test
    public void testConfigSetAndGet() {
        this.redis.configSet("dbfilename", "redis.dump", reply -> {
            if (reply.succeeded()) {
                this.redis.configGet("dbfilename", reply2 -> {
                    if (reply2.succeeded()) {
                        this.assertNotNull(((JsonArray)reply2.result()).getString(0));
                        this.assertTrue(((JsonArray)reply2.result()).getString(1).equals("redis.dump"));
                        this.testComplete();
                    }
                });
            }
        });
        this.await();
    }

    @Test
    public void testConfigResetstat() {
        this.redis.info(reply -> {
            this.assertTrue(reply.succeeded());
            JsonObject result = ((JsonObject)reply.result()).getJsonObject("stats");
            Integer conn = Integer.valueOf(result.getString("total_connections_received"));
            this.assertTrue(conn > 0);
            this.redis.configResetstat(reply2 -> {
                this.assertTrue(reply2.succeeded());
                this.redis.info(reply3 -> {
                    this.assertTrue(reply3.succeeded());
                    this.testComplete();
                });
            });
        });
        this.await();
    }

    @Test
    public void testDbsize() {
        this.redis.dbsize(reply -> {
            this.assertTrue(reply.succeeded());
            Long size = (Long)reply.result();
            this.redis.set("new", "value", reply2 -> {
                this.assertTrue(reply2.succeeded());
                this.redis.dbsize(reply3 -> {
                    this.assertTrue(reply3.succeeded());
                    this.assertEquals(size + 1L, reply3.result());
                    this.testComplete();
                });
            });
        });
        this.await();
    }

    @Test
    public void testDebugObject() {
    }

    @Test
    public void testDebugSegfault() throws Exception {
        RedisServer server = RedisServer.builder().port(Integer.valueOf(6381)).build();
        server.start();
        RedisOptions job = new RedisOptions().setHost("localhost").setPort(6381);
        RedisClient rdx = RedisClient.create((Vertx)this.vertx, (RedisOptions)job);
        rdx.debugSegfault(reply -> {
            this.assertTrue(reply.failed());
            rdx.info(reply2 -> {
                this.assertFalse(reply2.succeeded());
                server.stop();
                this.testComplete();
            });
        });
        this.await();
    }

    @Test
    public void testDecr() {
        String mykey = RedisClientTestBase.makeKey();
        this.redis.set(mykey, "10", reply0 -> {
            this.assertTrue(reply0.succeeded());
            this.redis.decr(mykey, reply1 -> {
                this.assertTrue(reply1.succeeded());
                this.assertEquals(9L, (Long)reply1.result());
                this.testComplete();
            });
        });
        this.await();
    }

    @Test
    public void testDecrby() {
        String mykey = RedisClientTestBase.makeKey();
        this.redis.set(mykey, "10", reply0 -> {
            this.assertTrue(reply0.succeeded());
            this.redis.decrby(mykey, 5L, reply1 -> {
                this.assertTrue(reply1.succeeded());
                this.assertEquals(5L, (Long)reply1.result());
                this.testComplete();
            });
        });
        this.await();
    }

    @Test
    public void testDel() {
        String key1 = RedisClientTestBase.makeKey();
        String key2 = RedisClientTestBase.makeKey();
        String key3 = RedisClientTestBase.makeKey();
        this.redis.set(key1, "Hello", reply0 -> {
            this.assertTrue(reply0.succeeded());
            this.redis.set(key2, "World", reply1 -> {
                this.assertTrue(reply1.succeeded());
                this.redis.delMany(RedisClientTestBase.toList(key1, key2, key3), reply2 -> {
                    this.assertTrue(reply2.succeeded());
                    this.assertEquals(2L, (Long)reply2.result());
                    this.testComplete();
                });
            });
        });
        this.await();
    }

    @Test
    public void testDiscard() {
        String key = RedisClientTestBase.makeKey();
        this.redis.set(key, "0", reply -> {
            this.assertTrue(reply.succeeded());
            RedisTransaction transaction = this.redis.transaction();
            transaction.multi(reply2 -> {
                this.assertTrue(reply2.succeeded());
                transaction.incr(key, reply3 -> {
                    this.assertTrue(reply3.succeeded());
                    transaction.discard(reply4 -> {
                        this.assertTrue(reply4.succeeded());
                        transaction.get(key, reply5 -> {
                            this.assertTrue(reply5.succeeded());
                            this.assertTrue(Integer.valueOf((String)reply5.result()) == 0);
                            this.testComplete();
                        });
                    });
                });
            });
        });
        this.await();
    }

    @Test
    public void testEcho() {
        this.redis.echo("Hello World!", reply0 -> {
            this.assertTrue(reply0.succeeded());
            this.assertEquals("Hello World!", reply0.result());
            this.testComplete();
        });
        this.await();
    }

    @Test
    public void testEval() {
        String key1 = RedisClientTestBase.makeKey();
        String key2 = RedisClientTestBase.makeKey();
        this.redis.eval("return {KEYS[1],KEYS[2],ARGV[1],ARGV[2]}", RedisClientTestBase.toList(key1, key2), RedisClientTestBase.toList("first", "second"), reply -> {
            this.assertTrue(reply.succeeded());
            Object r = reply.result();
            this.assertNotNull(r);
            this.testComplete();
        });
        this.await();
    }

    @Test
    public void testEvalshaNumKeysAndValuesDifferent() {
        String inline = "return 1";
        this.redis.scriptLoad(inline, reply -> {
            this.assertTrue(reply.succeeded());
            this.assertNotNull(reply.result());
            ArrayList<String> keys = new ArrayList<String>(2);
            ArrayList<String> values = new ArrayList<String>(1);
            keys.add("key1");
            keys.add("key2");
            values.add("value1");
            this.redis.evalsha((String)reply.result(), keys, values, reply2 -> {
                this.assertTrue(reply2.succeeded());
                this.testComplete();
            });
        });
        this.await();
    }

    @Test
    public void testEvalsha() {
        String inline = "return 1";
        this.redis.scriptLoad(inline, reply -> {
            this.assertTrue(reply.succeeded());
            this.assertNotNull(reply.result());
            this.redis.evalsha((String)reply.result(), Collections.emptyList(), Collections.emptyList(), reply2 -> {
                this.assertTrue(reply2.succeeded());
                this.testComplete();
            });
        });
        this.await();
    }

    @Test
    public void testExec() {
        RedisTransaction transaction = this.redis.transaction();
        transaction.multi(reply -> {
            this.assertTrue(reply.succeeded());
            transaction.set("multi-key", "first", reply2 -> {
                this.assertTrue(reply2.succeeded());
                transaction.set("multi-key2", "second", reply3 -> this.assertTrue(reply3.succeeded()));
                transaction.get("multi-key", reply4 -> {
                    this.assertTrue(reply4.succeeded());
                    this.assertTrue("QUEUED".equalsIgnoreCase((String)reply4.result()));
                });
                transaction.exec(reply5 -> {
                    this.assertTrue(reply5.succeeded());
                    this.testComplete();
                });
            });
        });
        this.await();
    }

    @Test
    public void testExists() {
        String key1 = RedisClientTestBase.makeKey();
        String key2 = RedisClientTestBase.makeKey();
        this.redis.set(key1, "Hello", reply0 -> {
            this.assertTrue(reply0.succeeded());
            this.redis.exists(key1, reply1 -> {
                this.assertTrue(reply1.succeeded());
                this.assertEquals(1L, (Long)reply1.result());
                this.redis.exists(key2, reply2 -> {
                    this.assertTrue(reply2.succeeded());
                    this.assertEquals(0L, (Long)reply2.result());
                    this.testComplete();
                });
            });
        });
        this.await();
    }

    @Ignore
    @Test
    public void testExistsMany() {
        String key1 = RedisClientTestBase.makeKey();
        String key2 = RedisClientTestBase.makeKey();
        this.redis.set(key1, "Hello", this.onSuccess(reply0 -> this.redis.existsMany(RedisClientTestBase.toList(key1, key2), this.onSuccess(reply1 -> {
            this.assertEquals(1L, (long)reply1);
            this.redis.set(key2, "Hello", this.onSuccess(reply2 -> this.redis.existsMany(RedisClientTestBase.toList(key1, key2), this.onSuccess(reply3 -> {
                this.assertEquals(2L, (long)reply3);
                this.redis.existsMany(RedisClientTestBase.toList(key1), this.onSuccess(reply4 -> {
                    this.assertEquals(1L, (long)reply4);
                    this.testComplete();
                }));
            }))));
        }))));
        this.await();
    }

    @Test
    public void testExpire() {
        String mykey = RedisClientTestBase.makeKey();
        this.redis.set(mykey, "Hello", reply0 -> {
            this.assertTrue(reply0.succeeded());
            this.redis.expire(mykey, 10L, reply1 -> {
                this.assertTrue(reply1.succeeded());
                this.assertEquals(1L, (Long)reply1.result());
                this.redis.ttl(mykey, reply2 -> {
                    this.assertTrue(reply2.succeeded());
                    this.assertEquals(10L, (Long)reply2.result());
                    this.redis.set(mykey, "Hello World", reply3 -> {
                        this.assertTrue(reply3.succeeded());
                        this.redis.ttl(mykey, reply4 -> {
                            this.assertTrue(reply4.succeeded());
                            this.assertEquals(-1L, (Long)reply4.result());
                            this.testComplete();
                        });
                    });
                });
            });
        });
        this.await();
    }

    @Test
    public void testExpireat() {
        String mykey = RedisClientTestBase.makeKey();
        this.redis.set(mykey, "Hello", reply0 -> {
            this.assertTrue(reply0.succeeded());
            this.redis.exists(mykey, reply1 -> {
                this.assertTrue(reply1.succeeded());
                this.assertEquals(1L, (Long)reply1.result());
                this.redis.expireat(mykey, 1293840000L, reply2 -> {
                    this.assertTrue(reply2.succeeded());
                    this.assertEquals(1L, (Long)reply2.result());
                    this.redis.exists(mykey, reply3 -> {
                        this.assertTrue(reply3.succeeded());
                        this.assertEquals(0L, (Long)reply3.result());
                        this.testComplete();
                    });
                });
            });
        });
        this.await();
    }

    @Test
    public void testFlushall() {
        String key = RedisClientTestBase.makeKey();
        this.redis.set(key, "blah", reply -> {
            this.assertTrue(reply.succeeded());
            this.redis.flushall(reply2 -> {
                this.assertTrue(reply.succeeded());
                this.redis.get(key, reply3 -> {
                    this.assertTrue(reply3.succeeded());
                    this.assertNull(reply3.result());
                    this.testComplete();
                });
            });
        });
        this.await();
    }

    @Test
    public void testFlushdb() {
        String key = RedisClientTestBase.makeKey();
        this.redis.set(key, "blah", reply -> {
            this.assertTrue(reply.succeeded());
            this.redis.flushall(reply2 -> {
                this.assertTrue(reply.succeeded());
                this.redis.get(key, reply3 -> {
                    this.assertTrue(reply3.succeeded());
                    this.assertNull(reply3.result());
                    this.testComplete();
                });
            });
        });
        this.await();
    }

    @Test
    public void testGet() throws Exception {
        String nonexisting = RedisClientTestBase.makeKey();
        String mykey = RedisClientTestBase.makeKey();
        this.redis.get(nonexisting, reply0 -> {
            this.assertTrue(reply0.succeeded());
            this.assertNull(reply0.result());
            this.redis.set(mykey, "Hello", reply1 -> {
                this.assertTrue(reply1.succeeded());
                this.redis.get(mykey, reply2 -> {
                    this.assertTrue(reply2.succeeded());
                    this.assertEquals("Hello", reply2.result());
                    this.testComplete();
                });
            });
        });
        this.await();
    }

    @Test
    public void testGetbit() {
        String mykey = RedisClientTestBase.makeKey();
        this.redis.setbit(mykey, 7L, 1, reply0 -> {
            this.assertTrue(reply0.succeeded());
            this.assertEquals(0L, (Long)reply0.result());
            this.redis.getbit(mykey, 0L, reply1 -> {
                this.assertTrue(reply1.succeeded());
                this.assertEquals(0L, (Long)reply1.result());
                this.redis.getbit(mykey, 7L, reply2 -> {
                    this.assertTrue(reply2.succeeded());
                    this.assertEquals(1L, (Long)reply2.result());
                    this.redis.getbit(mykey, 100L, reply3 -> {
                        this.assertTrue(reply3.succeeded());
                        this.assertEquals(0L, (Long)reply3.result());
                        this.testComplete();
                    });
                });
            });
        });
        this.await();
    }

    @Test
    public void testGetrange() {
        String mykey = RedisClientTestBase.makeKey();
        this.redis.set(mykey, "This is a string", reply0 -> {
            this.assertTrue(reply0.succeeded());
            this.redis.getrange(mykey, 0L, 3L, reply1 -> {
                this.assertTrue(reply1.succeeded());
                this.assertEquals("This", reply1.result());
                this.redis.getrange(mykey, -3L, -1L, reply2 -> {
                    this.assertTrue(reply2.succeeded());
                    this.assertEquals("ing", reply2.result());
                    this.redis.getrange(mykey, 0L, -1L, reply3 -> {
                        this.assertTrue(reply3.succeeded());
                        this.assertEquals("This is a string", reply3.result());
                        this.redis.getrange(mykey, 10L, 100L, reply4 -> {
                            this.assertTrue(reply4.succeeded());
                            this.assertEquals("string", reply4.result());
                            this.testComplete();
                        });
                    });
                });
            });
        });
        this.await();
    }

    @Test
    public void testGetset() {
        String mycounter = RedisClientTestBase.makeKey();
        this.redis.incr(mycounter, reply0 -> {
            this.assertTrue(reply0.succeeded());
            this.assertEquals(1L, (Long)reply0.result());
            this.redis.getset(mycounter, "0", reply1 -> {
                this.assertTrue(reply1.succeeded());
                this.assertEquals("1", reply1.result());
                this.redis.get(mycounter, reply2 -> {
                    this.assertTrue(reply2.succeeded());
                    this.assertEquals("0", reply2.result());
                    this.testComplete();
                });
            });
        });
        this.await();
    }

    @Test
    public void testHdel() {
        String myhash = RedisClientTestBase.makeKey();
        this.redis.hset(myhash, "field1", "foo", reply0 -> {
            this.assertTrue(reply0.succeeded());
            this.assertEquals(1L, (Long)reply0.result());
            this.redis.hdel(myhash, "field1", reply1 -> {
                this.assertTrue(reply1.succeeded());
                this.assertEquals(1L, (Long)reply1.result());
                this.redis.hdel(myhash, "field2", reply2 -> {
                    this.assertTrue(reply2.succeeded());
                    this.assertEquals(0L, (Long)reply2.result());
                    this.testComplete();
                });
            });
        });
        this.await();
    }

    @Test
    public void testHexists() {
        String myhash = RedisClientTestBase.makeKey();
        this.redis.hset(myhash, "field1", "foo", reply0 -> {
            this.assertTrue(reply0.succeeded());
            this.assertEquals(1L, (Long)reply0.result());
            this.redis.hexists(myhash, "field1", reply1 -> {
                this.assertTrue(reply1.succeeded());
                this.assertEquals(1L, (Long)reply1.result());
                this.redis.hexists(myhash, "field2", reply2 -> {
                    this.assertTrue(reply2.succeeded());
                    this.assertEquals(0L, (Long)reply2.result());
                    this.testComplete();
                });
            });
        });
        this.await();
    }

    @Test
    public void testHget() {
        String myhash = RedisClientTestBase.makeKey();
        this.redis.hset(myhash, "field1", "foo", reply0 -> {
            this.assertTrue(reply0.succeeded());
            this.assertEquals(1L, (Long)reply0.result());
            this.redis.hget(myhash, "field1", reply1 -> {
                this.assertTrue(reply1.succeeded());
                this.assertEquals("foo", reply1.result());
                this.redis.hget(myhash, "field2", reply2 -> {
                    this.assertTrue(reply2.succeeded());
                    this.assertNull(reply2.result());
                    this.testComplete();
                });
            });
        });
        this.await();
    }

    @Test
    public void testHgetall() {
        String myhash = RedisClientTestBase.makeKey();
        this.redis.hset(myhash, "field1", "Hello", reply0 -> {
            this.assertTrue(reply0.succeeded());
            this.assertEquals(1L, (Long)reply0.result());
            this.redis.hset(myhash, "field2", "World", reply1 -> {
                this.assertTrue(reply1.succeeded());
                this.assertEquals(1L, (Long)reply1.result());
                this.redis.hgetall(myhash, reply2 -> {
                    this.assertTrue(reply2.succeeded());
                    JsonObject obj = (JsonObject)reply2.result();
                    this.assertEquals("Hello", obj.getString("field1"));
                    this.assertEquals("World", obj.getString("field2"));
                    this.testComplete();
                });
            });
        });
        this.await();
    }

    @Test
    public void testHincrby() {
        String myhash = RedisClientTestBase.makeKey();
        this.redis.hset(myhash, "field", "5", reply0 -> {
            this.assertTrue(reply0.succeeded());
            this.assertEquals(1L, (Long)reply0.result());
            this.redis.hincrby(myhash, "field", 1L, reply1 -> {
                this.assertTrue(reply1.succeeded());
                this.assertEquals(6L, (Long)reply1.result());
                this.redis.hincrby(myhash, "field", -1L, reply2 -> {
                    this.assertTrue(reply2.succeeded());
                    this.assertEquals(5L, (Long)reply2.result());
                    this.redis.hincrby(myhash, "field", -10L, reply3 -> {
                        this.assertTrue(reply3.succeeded());
                        this.assertEquals(-5L, (Long)reply3.result());
                        this.testComplete();
                    });
                });
            });
        });
        this.await();
    }

    @Test
    public void testHIncrbyfloat() {
        String mykey = RedisClientTestBase.makeKey();
        this.redis.hset(mykey, "field", "10.50", reply0 -> {
            this.assertTrue(reply0.succeeded());
            this.assertEquals(1L, (Long)reply0.result());
            this.redis.hincrbyfloat(mykey, "field", 0.1, reply1 -> {
                this.assertTrue(reply1.succeeded());
                this.assertEquals("10.6", reply1.result());
                this.redis.hset(mykey, "field", "5.0e3", reply2 -> {
                    this.assertTrue(reply2.succeeded());
                    this.assertEquals(0L, (Long)reply2.result());
                    this.redis.hincrbyfloat(mykey, "field", 200.0, reply3 -> {
                        this.assertTrue(reply3.succeeded());
                        this.assertEquals("5200", reply3.result());
                        this.testComplete();
                    });
                });
            });
        });
        this.await();
    }

    @Test
    public void testHkeys() {
        String myhash = RedisClientTestBase.makeKey();
        this.redis.hset(myhash, "field1", "Hello", reply0 -> {
            this.assertTrue(reply0.succeeded());
            this.assertEquals(1L, (Long)reply0.result());
            this.redis.hset(myhash, "field2", "World", reply1 -> {
                this.assertTrue(reply1.succeeded());
                this.assertEquals(1L, (Long)reply1.result());
                this.redis.hkeys(myhash, reply2 -> {
                    this.assertTrue(reply2.succeeded());
                    this.assertArrayEquals(RedisClientTestBase.toArray("field1", "field2"), ((JsonArray)reply2.result()).getList().toArray());
                    this.testComplete();
                });
            });
        });
        this.await();
    }

    @Test
    public void testHlen() {
        String myhash = RedisClientTestBase.makeKey();
        this.redis.hset(myhash, "field1", "Hello", reply0 -> {
            this.assertTrue(reply0.succeeded());
            this.assertEquals(1L, (Long)reply0.result());
            this.redis.hset(myhash, "field2", "World", reply1 -> {
                this.assertTrue(reply1.succeeded());
                this.assertEquals(1L, (Long)reply1.result());
                this.redis.hlen(myhash, reply2 -> {
                    this.assertTrue(reply2.succeeded());
                    this.assertEquals(2L, (Long)reply2.result());
                    this.testComplete();
                });
            });
        });
        this.await();
    }

    @Test
    public void testHmget() {
        String myhash = RedisClientTestBase.makeKey();
        this.redis.hset(myhash, "field1", "Hello", reply0 -> {
            this.assertTrue(reply0.succeeded());
            this.assertEquals(1L, (Long)reply0.result());
            this.redis.hset(myhash, "field2", "World", reply1 -> {
                this.assertTrue(reply1.succeeded());
                this.assertEquals(1L, (Long)reply1.result());
                this.redis.hmget(myhash, RedisClientTestBase.toList("field1", "field2", "nofield"), reply2 -> {
                    this.assertTrue(reply2.succeeded());
                    this.assertArrayEquals(RedisClientTestBase.toArray("Hello", "World", null), ((JsonArray)reply2.result()).getList().toArray());
                    this.testComplete();
                });
            });
        });
        this.await();
    }

    @Test
    public void testHmset() {
        String myhash = RedisClientTestBase.makeKey();
        this.redis.hmset(myhash, new JsonObject(RedisClientTestBase.toMap("field1", "Hello", "field2", "World")), reply0 -> {
            this.assertTrue(reply0.succeeded());
            this.redis.hget(myhash, "field1", reply1 -> {
                this.assertTrue(reply1.succeeded());
                this.assertEquals("Hello", reply1.result());
                this.redis.hget(myhash, "field2", reply2 -> {
                    this.assertTrue(reply2.succeeded());
                    this.assertEquals("World", reply2.result());
                    this.testComplete();
                });
            });
        });
        this.await();
    }

    @Test
    public void testHset() {
        String myhash = RedisClientTestBase.makeKey();
        this.redis.hset(myhash, "field1", "Hello", reply0 -> {
            this.assertTrue(reply0.succeeded());
            this.assertEquals(1L, (Long)reply0.result());
            this.redis.hget(myhash, "field1", reply1 -> {
                this.assertTrue(reply1.succeeded());
                this.assertEquals("Hello", reply1.result());
                this.testComplete();
            });
        });
        this.await();
    }

    @Test
    public void testHsetnx() {
        String myhash = RedisClientTestBase.makeKey();
        this.redis.hsetnx(myhash, "field", "Hello", reply0 -> {
            this.assertTrue(reply0.succeeded());
            this.assertEquals(1L, (Long)reply0.result());
            this.redis.hsetnx(myhash, "field", "World", reply1 -> {
                this.assertTrue(reply1.succeeded());
                this.assertEquals(0L, (Long)reply1.result());
                this.redis.hget(myhash, "field", reply2 -> {
                    this.assertTrue(reply2.succeeded());
                    this.assertEquals("Hello", reply2.result());
                    this.testComplete();
                });
            });
        });
        this.await();
    }

    @Test
    public void testHvals() {
        String myhash = RedisClientTestBase.makeKey();
        this.redis.hset(myhash, "field1", "Hello", reply0 -> {
            this.assertTrue(reply0.succeeded());
            this.assertEquals(1L, (Long)reply0.result());
            this.redis.hset(myhash, "field2", "World", reply1 -> {
                this.assertTrue(reply1.succeeded());
                this.assertEquals(1L, (Long)reply1.result());
                this.redis.hvals(myhash, reply2 -> {
                    this.assertTrue(reply2.succeeded());
                    this.assertArrayEquals(RedisClientTestBase.toArray("Hello", "World"), ((JsonArray)reply2.result()).getList().toArray());
                    this.testComplete();
                });
            });
        });
        this.await();
    }

    @Test
    public void testIncr() {
        String mykey = RedisClientTestBase.makeKey();
        this.redis.set(mykey, "10", reply0 -> {
            this.assertTrue(reply0.succeeded());
            this.redis.incr(mykey, reply1 -> {
                this.assertTrue(reply1.succeeded());
                this.assertEquals(11L, (Long)reply1.result());
                this.redis.get(mykey, reply2 -> {
                    this.assertTrue(reply2.succeeded());
                    this.assertEquals("11", reply2.result());
                    this.testComplete();
                });
            });
        });
        this.await();
    }

    @Test
    public void testIncrby() {
        String mykey = RedisClientTestBase.makeKey();
        this.redis.set(mykey, "10", reply0 -> {
            this.assertTrue(reply0.succeeded());
            this.redis.incrby(mykey, 5L, reply1 -> {
                this.assertTrue(reply1.succeeded());
                this.assertEquals(15L, (Long)reply1.result());
                this.testComplete();
            });
        });
        this.await();
    }

    @Test
    public void testIncrbyfloat() {
        String mykey = RedisClientTestBase.makeKey();
        this.redis.set(mykey, "10.50", reply0 -> {
            this.assertTrue(reply0.succeeded());
            this.redis.incrbyfloat(mykey, 0.1, reply1 -> {
                this.assertTrue(reply1.succeeded());
                this.assertEquals("10.6", reply1.result());
                this.redis.set(mykey, "5.0e3", reply2 -> {
                    this.assertTrue(reply2.succeeded());
                    this.redis.incrbyfloat(mykey, 200.0, reply3 -> {
                        this.assertTrue(reply3.succeeded());
                        this.assertEquals("5200", reply3.result());
                        this.testComplete();
                    });
                });
            });
        });
        this.await();
    }

    @Test
    public void testInfo() {
        this.redis.info(reply0 -> {
            this.assertTrue(reply0.succeeded());
            this.assertNotNull(reply0.result());
            this.testComplete();
        });
        this.await();
    }

    @Test
    public void testKeys() {
        this.redis.mset(new JsonObject(RedisClientTestBase.toMap("one", "1", "two", "2", "three", "3", "four", "4")), reply0 -> {
            this.assertTrue(reply0.succeeded());
            this.redis.keys("*o*", reply1 -> {
                this.assertTrue(reply1.succeeded());
                JsonArray array = (JsonArray)reply1.result();
                this.assertTrue(3 <= array.size());
                this.redis.keys("t??", reply2 -> {
                    this.assertTrue(reply2.succeeded());
                    JsonArray array2 = (JsonArray)reply2.result();
                    this.assertTrue(1 == array2.size());
                    this.redis.keys("*", reply3 -> {
                        this.assertTrue(reply3.succeeded());
                        JsonArray array3 = (JsonArray)reply3.result();
                        this.assertTrue(4 <= array3.size());
                        this.testComplete();
                    });
                });
            });
        });
        this.await();
    }

    @Test
    public void testLastsave() {
        this.redis.lastsave(reply0 -> {
            this.assertTrue(reply0.succeeded());
            this.testComplete();
        });
        this.await();
    }

    @Test
    public void testLindex() {
        String mykey = RedisClientTestBase.makeKey();
        this.redis.lpush(mykey, "World", reply0 -> {
            this.assertTrue(reply0.succeeded());
            this.assertEquals(1L, (Long)reply0.result());
            this.redis.lpush(mykey, "Hello", reply1 -> {
                this.assertTrue(reply1.succeeded());
                this.assertEquals(2L, (Long)reply1.result());
                this.redis.lindex(mykey, 0, reply2 -> {
                    this.assertTrue(reply2.succeeded());
                    this.assertEquals("Hello", reply2.result());
                    this.redis.lindex(mykey, -1, reply3 -> {
                        this.assertTrue(reply3.succeeded());
                        this.assertEquals("World", reply3.result());
                        this.testComplete();
                    });
                });
            });
        });
        this.await();
    }

    @Test
    public void testLinsert() {
        String mykey = RedisClientTestBase.makeKey();
        this.redis.rpush(mykey, "Hello", reply0 -> {
            this.assertTrue(reply0.succeeded());
            this.assertEquals(1L, (Long)reply0.result());
            this.redis.rpush(mykey, "World", reply1 -> {
                this.assertTrue(reply1.succeeded());
                this.assertEquals(2L, (Long)reply1.result());
                this.redis.linsert(mykey, InsertOptions.BEFORE, "World", "There", reply2 -> {
                    this.assertTrue(reply2.succeeded());
                    this.assertEquals(3L, (Long)reply2.result());
                    this.testComplete();
                });
            });
        });
        this.await();
    }

    @Test
    public void testLlen() {
        String mykey = RedisClientTestBase.makeKey();
        this.redis.lpush(mykey, "World", reply0 -> {
            this.assertTrue(reply0.succeeded());
            this.assertEquals(1L, (Long)reply0.result());
            this.redis.lpush(mykey, "Hello", reply1 -> {
                this.assertTrue(reply1.succeeded());
                this.assertEquals(2L, (Long)reply1.result());
                this.redis.llen(mykey, reply2 -> {
                    this.assertTrue(reply2.succeeded());
                    this.assertEquals(2L, (Long)reply2.result());
                    this.testComplete();
                });
            });
        });
        this.await();
    }

    @Test
    public void testLpop() {
        String mykey = RedisClientTestBase.makeKey();
        this.redis.rpush(mykey, "one", reply0 -> {
            this.assertTrue(reply0.succeeded());
            this.assertEquals(1L, (Long)reply0.result());
            this.redis.rpush(mykey, "two", reply1 -> {
                this.assertTrue(reply1.succeeded());
                this.assertEquals(2L, (Long)reply1.result());
                this.redis.rpush(mykey, "three", reply2 -> {
                    this.assertTrue(reply2.succeeded());
                    this.assertEquals(3L, (Long)reply2.result());
                    this.redis.lpop(mykey, reply3 -> {
                        this.assertTrue(reply3.succeeded());
                        this.assertEquals("one", reply3.result());
                        this.testComplete();
                    });
                });
            });
        });
        this.await();
    }

    @Test
    public void testLpushOne() {
        String mykey = RedisClientTestBase.makeKey();
        this.redis.lpush(mykey, "world", reply0 -> {
            this.assertTrue(reply0.succeeded());
            this.assertEquals(1L, (Long)reply0.result());
            this.redis.lpush(mykey, "hello", reply1 -> {
                this.assertTrue(reply1.succeeded());
                this.assertEquals(2L, (Long)reply1.result());
                this.redis.lrange(mykey, 0L, -1L, reply2 -> {
                    this.assertTrue(reply2.succeeded());
                    this.assertArrayEquals(RedisClientTestBase.toArray("hello", "world"), ((JsonArray)reply2.result()).getList().toArray());
                    this.testComplete();
                });
            });
        });
        this.await();
    }

    @Test
    public void testLpush() {
        String mykey = RedisClientTestBase.makeKey();
        this.redis.lpushMany(mykey, RedisClientTestBase.toList("!", "world"), reply0 -> {
            this.assertTrue(reply0.succeeded());
            this.assertEquals(2L, (Long)reply0.result());
            this.redis.lpushMany(mykey, RedisClientTestBase.toList(",", "hello"), reply1 -> {
                this.assertTrue(reply1.succeeded());
                this.assertEquals(4L, (Long)reply1.result());
                this.redis.lrange(mykey, 0L, -1L, reply2 -> {
                    this.assertTrue(reply2.succeeded());
                    this.assertArrayEquals(RedisClientTestBase.toArray("hello", ",", "world", "!"), ((JsonArray)reply2.result()).getList().toArray());
                    this.testComplete();
                });
            });
        });
        this.await();
    }

    @Test
    public void testLpushx() {
        String mykey = RedisClientTestBase.makeKey();
        String myotherkey = RedisClientTestBase.makeKey();
        this.redis.lpush(mykey, "World", reply0 -> {
            this.assertTrue(reply0.succeeded());
            this.assertEquals(1L, (Long)reply0.result());
            this.redis.lpushx(mykey, "Hello", reply1 -> {
                this.assertTrue(reply1.succeeded());
                this.assertEquals(2L, (Long)reply1.result());
                this.redis.lpushx(myotherkey, "Hello", reply2 -> {
                    this.assertTrue(reply2.succeeded());
                    this.assertEquals(0L, (Long)reply2.result());
                    this.redis.lrange(mykey, 0L, -1L, reply3 -> {
                        this.assertTrue(reply3.succeeded());
                        JsonArray array3 = (JsonArray)reply3.result();
                        this.assertTrue(2 == array3.size());
                        this.assertTrue("Hello".equals(array3.getString(0)));
                        this.assertTrue("World".equals(array3.getString(1)));
                        this.redis.lrange(myotherkey, 0L, -1L, reply4 -> {
                            JsonArray array4 = (JsonArray)reply4.result();
                            this.assertTrue(0 == array4.size());
                            this.testComplete();
                        });
                    });
                });
            });
        });
        this.await();
    }

    @Test
    public void testLrange() {
        String mykey = RedisClientTestBase.makeKey();
        this.redis.rpush(mykey, "one", reply0 -> {
            this.assertTrue(reply0.succeeded());
            this.assertEquals(1L, (Long)reply0.result());
            this.redis.rpush(mykey, "two", reply1 -> {
                this.assertTrue(reply1.succeeded());
                this.assertEquals(2L, (Long)reply1.result());
                this.redis.rpush(mykey, "three", reply2 -> {
                    this.assertTrue(reply2.succeeded());
                    this.assertEquals(3L, (Long)reply2.result());
                    this.redis.lrange(mykey, 0L, 0L, reply3 -> {
                        this.assertTrue(reply3.succeeded());
                        this.assertEquals("one", ((JsonArray)reply3.result()).getString(0));
                        this.testComplete();
                    });
                });
            });
        });
        this.await();
    }

    @Test
    public void testLrem() {
        String mykey = RedisClientTestBase.makeKey();
        this.redis.rpush(mykey, "hello", reply0 -> {
            this.assertTrue(reply0.succeeded());
            this.assertEquals(1L, (Long)reply0.result());
            this.redis.rpush(mykey, "hello", reply1 -> {
                this.assertTrue(reply1.succeeded());
                this.assertEquals(2L, (Long)reply1.result());
                this.redis.rpush(mykey, "foo", reply2 -> {
                    this.assertTrue(reply2.succeeded());
                    this.assertEquals(3L, (Long)reply2.result());
                    this.redis.rpush(mykey, "hello", reply3 -> {
                        this.assertTrue(reply3.succeeded());
                        this.assertEquals(4L, (Long)reply3.result());
                        this.redis.lrem(mykey, -2L, "hello", reply4 -> {
                            this.assertTrue(reply4.succeeded());
                            this.assertEquals(2L, (Long)reply4.result());
                            this.redis.lrange(mykey, 0L, -1L, reply5 -> {
                                this.assertTrue(reply5.succeeded());
                                this.assertArrayEquals(RedisClientTestBase.toArray("hello", "foo"), ((JsonArray)reply5.result()).getList().toArray());
                                this.testComplete();
                            });
                        });
                    });
                });
            });
        });
        this.await();
    }

    @Test
    public void testLset() {
        String mykey = RedisClientTestBase.makeKey();
        this.redis.rpush(mykey, "one", reply0 -> {
            this.assertTrue(reply0.succeeded());
            this.assertEquals(1L, (Long)reply0.result());
            this.redis.rpush(mykey, "two", reply1 -> {
                this.assertTrue(reply1.succeeded());
                this.assertEquals(2L, (Long)reply1.result());
                this.redis.rpush(mykey, "three", reply2 -> {
                    this.assertTrue(reply2.succeeded());
                    this.assertEquals(3L, (Long)reply2.result());
                    this.redis.lset(mykey, 0L, "four", reply3 -> {
                        this.assertTrue(reply3.succeeded());
                        this.redis.lset(mykey, -2L, "five", reply4 -> {
                            this.assertTrue(reply4.succeeded());
                            this.redis.lrange(mykey, 0L, -1L, reply5 -> {
                                this.assertTrue(reply5.succeeded());
                                this.assertArrayEquals(RedisClientTestBase.toArray("four", "five", "three"), ((JsonArray)reply5.result()).getList().toArray());
                                this.testComplete();
                            });
                        });
                    });
                });
            });
        });
        this.await();
    }

    @Test
    public void testLtrim() {
        String mykey = RedisClientTestBase.makeKey();
        this.redis.rpush(mykey, "one", reply0 -> {
            this.assertTrue(reply0.succeeded());
            this.assertEquals(1L, (Long)reply0.result());
            this.redis.rpush(mykey, "two", reply1 -> {
                this.assertTrue(reply1.succeeded());
                this.assertEquals(2L, (Long)reply1.result());
                this.redis.rpush(mykey, "three", reply2 -> {
                    this.assertTrue(reply2.succeeded());
                    this.assertEquals(3L, (Long)reply2.result());
                    this.redis.ltrim(mykey, 1L, -1L, reply3 -> {
                        this.assertTrue(reply3.succeeded());
                        this.redis.lrange(mykey, 0L, -1L, reply5 -> {
                            this.assertTrue(reply5.succeeded());
                            this.assertArrayEquals(RedisClientTestBase.toArray("two", "three"), ((JsonArray)reply5.result()).getList().toArray());
                            this.testComplete();
                        });
                    });
                });
            });
        });
        this.await();
    }

    @Test
    public void testMget() {
        String mykey1 = RedisClientTestBase.makeKey();
        String mykey2 = RedisClientTestBase.makeKey();
        this.redis.set(mykey1, "Hello", reply0 -> {
            this.assertTrue(reply0.succeeded());
            this.redis.set(mykey2, "World", reply1 -> {
                this.assertTrue(reply1.succeeded());
                this.redis.mgetMany(RedisClientTestBase.toList(mykey1, mykey2, "nonexisting"), reply2 -> {
                    this.assertTrue(reply2.succeeded());
                    this.assertArrayEquals(RedisClientTestBase.toArray("Hello", "World", null), ((JsonArray)reply2.result()).getList().toArray());
                    this.testComplete();
                });
            });
        });
        this.await();
    }

    @Test
    public void testMigrate() throws Exception {
        RedisServer server = RedisServer.builder().port(Integer.valueOf(6382)).build();
        server.start();
        RedisOptions job = new RedisOptions().setHost("localhost").setPort(6382);
        RedisClient rdx = RedisClient.create((Vertx)this.vertx, (RedisOptions)job);
        String key = RedisClientTestBase.makeKey();
        this.redis.set(key, "migrate", reply -> {
            this.assertTrue(reply.succeeded());
            this.redis.migrate("localhost", 6382, key, 0, 20000L, MigrateOptions.NONE, reply2 -> {
                this.assertTrue(String.valueOf(reply2.cause()), reply2.succeeded());
                rdx.get(key, reply3 -> {
                    this.assertTrue(reply3.succeeded());
                    this.assertTrue("migrate".equals(reply3.result()));
                    try {
                        server.stop();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    rdx.close(reply4 -> this.assertTrue(reply4.succeeded()));
                    this.testComplete();
                });
            });
        });
        this.await();
    }

    @Test
    public void testMonitor() {
        this.redis.monitor(reply -> {
            this.assertTrue(reply.succeeded());
            this.testComplete();
        });
        this.await();
    }

    @Test
    public void testMove() {
        String key = RedisClientTestBase.makeKey();
        this.redis.set(key, "moved_key", reply -> {
            this.assertTrue(reply.succeeded());
            this.redis.move(key, 1, reply2 -> {
                this.assertTrue(reply2.succeeded());
                this.assertTrue(new Long(1L).equals(reply2.result()));
                this.testComplete();
            });
        });
        this.await();
    }

    @Test
    public void testMset() {
        String mykey1 = RedisClientTestBase.makeKey();
        String mykey2 = RedisClientTestBase.makeKey();
        this.redis.mset(new JsonObject(RedisClientTestBase.toMap(mykey1, "Hello", mykey2, "World")), reply0 -> {
            this.assertTrue(reply0.succeeded());
            this.redis.get(mykey1, reply1 -> {
                this.assertTrue(reply1.succeeded());
                this.assertEquals("Hello", reply1.result());
                this.redis.get(mykey2, reply2 -> {
                    this.assertTrue(reply2.succeeded());
                    this.assertEquals("World", reply2.result());
                    this.testComplete();
                });
            });
        });
        this.await();
    }

    @Test
    public void testMsetnx() {
        String mykey1 = RedisClientTestBase.makeKey();
        String mykey2 = RedisClientTestBase.makeKey();
        String mykey3 = RedisClientTestBase.makeKey();
        this.redis.msetnx(new JsonObject(RedisClientTestBase.toMap(mykey1, "Hello", mykey2, "there")), reply0 -> {
            this.assertTrue(reply0.succeeded());
            this.assertEquals(1L, (Long)reply0.result());
            this.redis.msetnx(new JsonObject(RedisClientTestBase.toMap(mykey2, "there", mykey3, "world")), reply1 -> {
                this.assertTrue(reply1.succeeded());
                this.assertEquals(0L, (Long)reply1.result());
                this.redis.mgetMany(RedisClientTestBase.toList(mykey1, mykey2, mykey3), reply2 -> {
                    this.assertTrue(reply2.succeeded());
                    this.assertArrayEquals(RedisClientTestBase.toArray("Hello", "there", null), ((JsonArray)reply2.result()).getList().toArray());
                    this.testComplete();
                });
            });
        });
        this.await();
    }

    @Test
    public void testMulti() throws Exception {
        String key = RedisClientTestBase.makeKey();
        RedisTransaction transaction = this.redis.transaction();
        this.redis.set(key, "0", rep -> {
            this.assertTrue(rep.succeeded());
            transaction.multi(reply -> {
                this.assertTrue(reply.succeeded());
                transaction.set(RedisClientTestBase.makeKey(), "0", reply2 -> {
                    this.assertTrue(reply2.succeeded());
                    transaction.set(RedisClientTestBase.makeKey(), "0", reply3 -> this.assertTrue(reply3.succeeded()));
                    transaction.exec(reply4 -> {
                        this.assertTrue(reply4.succeeded());
                        this.testComplete();
                    });
                });
            });
        });
        this.await();
    }

    @Test
    public void testObject() {
        String mykey = RedisClientTestBase.makeKey();
        this.redis.set(mykey, "test", reply -> {
            this.assertTrue(reply.succeeded());
            this.redis.object(mykey, ObjectCmd.REFCOUNT, reply2 -> {
                this.assertTrue(reply2.succeeded());
                this.redis.object(mykey, ObjectCmd.ENCODING, reply3 -> {
                    this.assertTrue(reply3.succeeded());
                    this.redis.object(mykey, ObjectCmd.IDLETIME, reply4 -> {
                        this.assertTrue(reply4.succeeded());
                        this.testComplete();
                    });
                });
            });
        });
        this.await();
    }

    @Test
    public void testPersist() {
        String mykey = RedisClientTestBase.makeKey();
        this.redis.set(mykey, "Hello", reply0 -> {
            this.assertTrue(reply0.succeeded());
            this.redis.expire(mykey, 10L, reply1 -> {
                this.assertTrue(reply1.succeeded());
                this.assertEquals(1L, (Long)reply1.result());
                this.redis.ttl(mykey, reply2 -> {
                    this.assertTrue(reply2.succeeded());
                    this.assertEquals(10L, (Long)reply2.result());
                    this.redis.persist(mykey, reply3 -> {
                        this.assertTrue(reply3.succeeded());
                        this.assertEquals(1L, (Long)reply3.result());
                        this.redis.ttl(mykey, reply4 -> {
                            this.assertTrue(reply4.succeeded());
                            this.assertEquals(-1L, (Long)reply4.result());
                            this.testComplete();
                        });
                    });
                });
            });
        });
        this.await();
    }

    @Test
    public void testPexpire() {
        String mykey = RedisClientTestBase.makeKey();
        this.redis.set(mykey, "Hello", reply0 -> {
            this.assertTrue(reply0.succeeded());
            this.redis.pexpire(mykey, 1000L, reply1 -> {
                this.assertTrue(reply1.succeeded());
                this.assertEquals(1L, (Long)reply1.result());
                this.redis.get(mykey, reply2 -> {
                    this.assertTrue(reply2.succeeded());
                    this.testComplete();
                });
            });
        });
        this.await();
    }

    @Test
    public void testPexpireat() {
        String mykey = RedisClientTestBase.makeKey();
        this.redis.set(mykey, "Hello", reply0 -> {
            this.assertTrue(reply0.succeeded());
            this.redis.pexpireat(mykey, 1555555555005L, reply1 -> {
                this.assertTrue(reply1.succeeded());
                this.assertEquals(1L, (Long)reply1.result());
                this.redis.ttl(mykey, reply2 -> {
                    this.assertTrue(reply2.succeeded());
                    this.assertTrue(200000000L > (Long)reply2.result() && (Long)reply2.result() > 0L);
                    this.redis.pttl(mykey, reply3 -> {
                        this.assertTrue(reply3.succeeded());
                        this.assertTrue(1555555555005L > (Long)reply3.result() && (Long)reply3.result() > 0L);
                        this.testComplete();
                    });
                });
            });
        });
        this.await();
    }

    @Test
    public void testPing() {
        this.redis.ping(reply0 -> {
            this.assertEquals("PONG", reply0.result());
            this.testComplete();
        });
        this.await();
    }

    @Test
    public void testPsetex() {
        String mykey = RedisClientTestBase.makeKey();
        this.redis.psetex(mykey, 2000L, "Hello", reply0 -> {
            this.assertTrue(reply0.succeeded());
            this.redis.pttl(mykey, reply1 -> {
                this.assertTrue(reply1.succeeded());
                this.assertTrue(3000L > (Long)reply1.result() && (Long)reply1.result() > 0L);
                this.redis.get(mykey, reply2 -> {
                    this.assertTrue(reply2.succeeded());
                    this.assertEquals("Hello", reply2.result());
                    this.testComplete();
                });
            });
        });
        this.await();
    }

    @Test
    public void testPubSubChannels() {
        this.redis.subscribe("rustic", sub -> {});
    }

    @Test
    @Ignore
    public void testPubSubNumsub() {
        this.redis.subscribe("rustic", sub -> {});
    }

    @Test
    @Ignore
    public void testPubSubNumpat() {
        this.redis.subscribe("rustic", sub -> {});
    }

    @Test
    @Ignore
    public void testPsubscribe() {
    }

    @Test
    public void testPttl() {
        String mykey = RedisClientTestBase.makeKey();
        this.redis.set(mykey, "Hello", reply0 -> {
            this.assertTrue(reply0.succeeded());
            this.redis.expire(mykey, 3L, reply1 -> {
                this.assertTrue(reply1.succeeded());
                this.assertEquals(1L, (Long)reply1.result());
                this.redis.pttl(mykey, reply2 -> {
                    this.assertTrue(reply2.succeeded());
                    this.assertTrue(3000L >= (Long)reply2.result() && (Long)reply2.result() > 0L);
                    this.testComplete();
                });
            });
        });
        this.await();
    }

    @Test
    public void testPublish() {
        String key = RedisClientTestBase.makeKey();
        this.redis.set(key, "0", reply -> {
            this.assertTrue(reply.succeeded());
            this.redis.publish(key, "1", reply2 -> {
                this.assertTrue(reply2.succeeded());
                this.assertTrue((Long)reply2.result() == 0L);
                this.testComplete();
            });
        });
        this.await();
    }

    @Test
    @Ignore
    public void testPunsubscribe() {
    }

    @Test
    public void testRandomkey() {
        this.redis.set("foo", "bar", reply -> {
            if (reply.succeeded()) {
                this.redis.randomkey(reply2 -> {
                    if (reply2.succeeded()) {
                        this.assertNotNull(reply2.result());
                        this.testComplete();
                    }
                });
            }
        });
        this.await();
    }

    @Test
    public void testRename() {
        String mykey = RedisClientTestBase.makeKey();
        String myotherkey = RedisClientTestBase.makeKey();
        this.redis.set(mykey, "Hello", reply0 -> {
            this.assertTrue(reply0.succeeded());
            this.redis.rename(mykey, myotherkey, reply1 -> {
                this.assertTrue(reply1.succeeded());
                this.redis.get(myotherkey, reply2 -> {
                    this.assertTrue(reply2.succeeded());
                    this.assertEquals("Hello", reply2.result());
                    this.testComplete();
                });
            });
        });
        this.await();
    }

    @Test
    public void testRenamenx() {
        String mykey = RedisClientTestBase.makeKey();
        String myotherkey = RedisClientTestBase.makeKey();
        this.redis.set(mykey, "Hello", reply0 -> {
            this.assertTrue(reply0.succeeded());
            this.redis.set(myotherkey, "World", reply1 -> {
                this.assertTrue(reply1.succeeded());
                this.redis.renamenx(mykey, myotherkey, reply2 -> {
                    this.assertTrue(reply2.succeeded());
                    this.assertEquals(0L, (Long)reply2.result());
                    this.redis.get(myotherkey, reply3 -> {
                        this.assertTrue(reply3.succeeded());
                        this.assertEquals("World", reply3.result());
                        this.testComplete();
                    });
                });
            });
        });
        this.await();
    }

    @Test
    public void testRestore() {
        String mykey = RedisClientTestBase.makeKey();
        String myotherkey = RedisClientTestBase.makeKey();
        Buffer value = Buffer.buffer((byte[])new byte[]{-1, -16, 0, 65, 66, 67});
        this.redis.setBinary(mykey, value, reply0 -> {
            this.assertTrue(reply0.succeeded());
            this.redis.dump(mykey, reply1 -> {
                this.assertTrue(reply1.succeeded());
                String dump = (String)reply1.result();
                this.redis.restore(myotherkey, 0L, dump, reply2 -> {
                    this.assertTrue(String.valueOf(reply2.cause()), reply2.succeeded());
                    this.redis.getBinary(myotherkey, reply3 -> {
                        this.assertTrue(reply3.succeeded());
                        this.assertEquals(value, reply3.result());
                        this.testComplete();
                    });
                });
            });
        });
        this.await();
    }

    @Test
    public void testRpop() {
        String mykey = RedisClientTestBase.makeKey();
        this.redis.rpush(mykey, "one", reply0 -> {
            this.assertTrue(reply0.succeeded());
            this.assertEquals(1L, (Long)reply0.result());
            this.redis.rpush(mykey, "two", reply1 -> {
                this.assertTrue(reply1.succeeded());
                this.assertEquals(2L, (Long)reply1.result());
                this.redis.rpush(mykey, "three", reply2 -> {
                    this.assertTrue(reply2.succeeded());
                    this.assertEquals(3L, (Long)reply2.result());
                    this.redis.rpop(mykey, reply3 -> {
                        this.assertTrue(reply3.succeeded());
                        this.assertEquals("three", reply3.result());
                        this.redis.lrange(mykey, 0L, -1L, reply5 -> {
                            this.assertTrue(reply5.succeeded());
                            this.assertArrayEquals(RedisClientTestBase.toArray("one", "two"), ((JsonArray)reply5.result()).getList().toArray());
                            this.testComplete();
                        });
                    });
                });
            });
        });
        this.await();
    }

    @Test
    public void testRpoplpush() {
        String mykey = RedisClientTestBase.makeKey();
        String myotherkey = RedisClientTestBase.makeKey();
        this.redis.rpush(mykey, "one", reply0 -> {
            this.assertTrue(reply0.succeeded());
            this.assertEquals(1L, (Long)reply0.result());
            this.redis.rpush(mykey, "two", reply1 -> {
                this.assertTrue(reply1.succeeded());
                this.assertEquals(2L, (Long)reply1.result());
                this.redis.rpush(mykey, "three", reply2 -> {
                    this.assertTrue(reply2.succeeded());
                    this.assertEquals(3L, (Long)reply2.result());
                    this.redis.rpoplpush(mykey, myotherkey, reply3 -> {
                        this.assertTrue(reply3.succeeded());
                        this.assertEquals("three", reply3.result());
                        this.redis.lrange(mykey, 0L, -1L, reply5 -> {
                            this.assertTrue(reply5.succeeded());
                            this.assertArrayEquals(RedisClientTestBase.toArray("one", "two"), ((JsonArray)reply5.result()).getList().toArray());
                            this.redis.lrange(myotherkey, 0L, -1L, reply6 -> {
                                this.assertArrayEquals(RedisClientTestBase.toArray("three"), ((JsonArray)reply6.result()).getList().toArray());
                                this.testComplete();
                            });
                        });
                    });
                });
            });
        });
        this.await();
    }

    @Test
    public void testRpush() {
        String mykey = RedisClientTestBase.makeKey();
        this.redis.rpush(mykey, "hello", reply0 -> {
            this.assertTrue(reply0.succeeded());
            this.assertEquals(1L, (Long)reply0.result());
            this.redis.rpush(mykey, "world", reply1 -> {
                this.assertTrue(reply1.succeeded());
                this.assertEquals(2L, (Long)reply1.result());
                this.redis.lrange(mykey, 0L, -1L, reply2 -> {
                    this.assertTrue(reply2.succeeded());
                    this.assertArrayEquals(RedisClientTestBase.toArray("hello", "world"), ((JsonArray)reply2.result()).getList().toArray());
                    this.testComplete();
                });
            });
        });
        this.await();
    }

    @Test
    public void testRpushx() {
        String mykey = RedisClientTestBase.makeKey();
        String myotherkey = RedisClientTestBase.makeKey();
        this.redis.rpush(mykey, "Hello", reply0 -> {
            this.assertTrue(reply0.succeeded());
            this.assertEquals(1L, (Long)reply0.result());
            this.redis.rpushx(mykey, "World", reply1 -> {
                this.assertTrue(reply1.succeeded());
                this.assertEquals(2L, (Long)reply1.result());
                this.redis.rpushx(myotherkey, "World", reply2 -> {
                    this.assertTrue(reply2.succeeded());
                    this.assertEquals(0L, (Long)reply2.result());
                    this.redis.lrange(mykey, 0L, -1L, reply3 -> {
                        this.assertTrue(reply3.succeeded());
                        this.assertArrayEquals(RedisClientTestBase.toArray("Hello", "World"), ((JsonArray)reply3.result()).getList().toArray());
                        this.redis.lrange(myotherkey, 0L, -1L, reply4 -> {
                            this.assertArrayEquals(new Object[0], ((JsonArray)reply4.result()).getList().toArray());
                            this.testComplete();
                        });
                    });
                });
            });
        });
        this.await();
    }

    @Test
    public void testSadd() {
        String mykey = RedisClientTestBase.makeKey();
        this.redis.sadd(mykey, "Hello", reply0 -> {
            this.assertTrue(reply0.succeeded());
            this.assertEquals(1L, (Long)reply0.result());
            this.redis.sadd(mykey, "World", reply1 -> {
                this.assertTrue(reply1.succeeded());
                this.assertEquals(1L, (Long)reply1.result());
                this.redis.sadd(mykey, "World", reply2 -> {
                    this.assertTrue(reply2.succeeded());
                    this.assertEquals(0L, (Long)reply2.result());
                    this.redis.smembers(mykey, reply3 -> {
                        this.assertTrue(reply3.succeeded());
                        Object[] expected = new Object[]{"Hello", "World"};
                        Object[] result = ((JsonArray)reply3.result()).getList().toArray();
                        Arrays.sort(result);
                        this.assertArrayEquals(expected, result);
                        this.testComplete();
                    });
                });
            });
        });
        this.await();
    }

    @Test
    public void testSave() {
        this.redis.save(reply -> {
            this.assertTrue(reply.succeeded());
            this.testComplete();
        });
        this.await();
    }

    @Test
    public void testScard() {
        String mykey = RedisClientTestBase.makeKey();
        this.redis.saddMany(mykey, RedisClientTestBase.toList("Hello", "World"), reply0 -> {
            this.assertTrue(reply0.succeeded());
            this.assertEquals(2L, (Long)reply0.result());
            this.redis.scard(mykey, reply2 -> {
                this.assertTrue(reply2.succeeded());
                this.assertEquals(2L, (Long)reply2.result());
                this.testComplete();
            });
        });
        this.await();
    }

    @Test
    public void testScriptexists() {
        String inline = "return 1";
        this.redis.scriptLoad(inline, reply -> {
            this.assertTrue(reply.succeeded());
            String hash = (String)reply.result();
            this.redis.scriptExists(hash, reply2 -> {
                this.assertTrue(reply2.succeeded());
                this.assertTrue(((JsonArray)reply2.result()).getInteger(0) > 0);
                this.testComplete();
            });
        });
        this.await();
    }

    @Test
    public void testScriptflush() {
        String inline = "return 1";
        this.redis.scriptLoad(inline, reply -> {
            this.assertTrue(reply.succeeded());
            String hash = (String)reply.result();
            this.redis.scriptExists(hash, reply2 -> {
                this.assertTrue(reply2.succeeded());
                this.assertTrue(((JsonArray)reply2.result()).getInteger(0) > 0);
                this.redis.scriptFlush(reply3 -> {
                    this.assertTrue(reply3.succeeded());
                    this.redis.scriptExists(hash, reply4 -> {
                        this.assertTrue(reply4.succeeded());
                        this.assertTrue(((JsonArray)reply4.result()).getInteger(0) == 0);
                        this.testComplete();
                    });
                });
            });
        });
        this.await();
    }

    @Test
    public void testScriptkill() throws Exception {
        String inline = "while true do end";
        this.redis.eval(inline, Collections.emptyList(), Collections.emptyList(), reply -> {});
        RedisOptions job = new RedisOptions().setHost("localhost").setPort(6379);
        RedisClient rdx = RedisClient.create((Vertx)this.vertx, (RedisOptions)job);
        rdx.scriptKill(reply -> {
            this.assertTrue(reply.succeeded());
            rdx.info(reply2 -> {
                this.assertTrue(reply2.succeeded());
                this.testComplete();
            });
        });
        this.await();
    }

    @Test
    public void testScriptload() {
        String inline = "return 1";
        this.redis.scriptLoad(inline, reply -> {
            this.assertTrue(reply.succeeded());
            this.assertNotNull(reply.result());
            this.testComplete();
        });
        this.await();
    }

    @Test
    public void testSdiff() {
        String mykey1 = RedisClientTestBase.makeKey();
        String mykey2 = RedisClientTestBase.makeKey();
        this.redis.saddMany(mykey1, RedisClientTestBase.toList("a", "b", "c"), reply0 -> {
            this.assertTrue(reply0.succeeded());
            this.assertEquals(3L, (Long)reply0.result());
            this.redis.saddMany(mykey2, RedisClientTestBase.toList("c", "d", "e"), reply1 -> {
                this.assertTrue(reply1.succeeded());
                this.assertEquals(3L, (Long)reply1.result());
                this.redis.sdiff(mykey1, RedisClientTestBase.toList(mykey2), reply2 -> {
                    this.assertTrue(reply2.succeeded());
                    Object[] expected = new Object[]{"a", "b"};
                    Object[] result = ((JsonArray)reply2.result()).getList().toArray();
                    Arrays.sort(result);
                    this.assertArrayEquals(expected, result);
                    this.testComplete();
                });
            });
        });
        this.await();
    }

    @Test
    public void testSdiffstore() {
        String mykey = RedisClientTestBase.makeKey();
        String mykey1 = RedisClientTestBase.makeKey();
        String mykey2 = RedisClientTestBase.makeKey();
        this.redis.saddMany(mykey1, RedisClientTestBase.toList("a", "b", "c"), reply0 -> {
            this.assertTrue(reply0.succeeded());
            this.assertEquals(3L, (Long)reply0.result());
            this.redis.saddMany(mykey2, RedisClientTestBase.toList("c", "d", "e"), reply1 -> {
                this.assertTrue(reply1.succeeded());
                this.assertEquals(3L, (Long)reply1.result());
                this.redis.sdiffstore(mykey, mykey1, RedisClientTestBase.toList(mykey2), reply2 -> {
                    this.assertTrue(reply2.succeeded());
                    Long diff = (Long)reply2.result();
                    this.assertTrue(diff == 2L);
                    this.redis.smembers(mykey, reply3 -> {
                        HashSet<String> expected = new HashSet<String>(RedisClientTestBase.toList("a", "b"));
                        JsonArray members = (JsonArray)reply3.result();
                        HashSet result = new HashSet(members.getList());
                        this.assertEquals(expected, result);
                        this.testComplete();
                    });
                });
            });
        });
        this.await();
    }

    @Test
    public void testSelect() {
        this.redis.select(1, reply -> {
            if (reply.succeeded()) {
                this.redis.set("first", "value", reply2 -> {
                    if (reply2.succeeded()) {
                        this.redis.select(0, reply3 -> {
                            if (reply3.succeeded()) {
                                this.redis.select(1, reply4 -> {
                                    if (reply4.succeeded()) {
                                        this.redis.get("first", reply5 -> {
                                            if (reply5.succeeded()) {
                                                this.assertTrue("value".equals(reply5.result()));
                                                this.testComplete();
                                            }
                                        });
                                    }
                                });
                            }
                        });
                    }
                });
            }
        });
        this.await();
    }

    @Test
    public void testSet() {
        String mykey = RedisClientTestBase.makeKey();
        this.redis.set(mykey, "Hello", reply0 -> {
            this.assertTrue(reply0.succeeded());
            this.redis.get(mykey, reply1 -> {
                this.assertTrue(reply1.succeeded());
                this.assertEquals("Hello", reply1.result());
                this.testComplete();
            });
        });
        this.await();
    }

    @Test
    public void testSetWithOptions() {
        String mykey = RedisClientTestBase.makeKey();
        this.redis.setWithOptions(mykey, "Hello!", new SetOptions().setNX(true).setEX(10L), reply0 -> {
            this.assertTrue(reply0.succeeded());
            this.redis.get(mykey, reply1 -> {
                this.assertTrue(reply1.succeeded());
                this.assertEquals("Hello!", reply1.result());
                this.redis.setWithOptions(mykey, "Hello again!", new SetOptions().setNX(true).setEX(10L), reply2 -> {
                    this.assertTrue(reply2.succeeded());
                    this.redis.get(mykey, reply3 -> {
                        this.assertTrue(reply3.succeeded());
                        this.assertEquals("Hello!", reply1.result());
                        this.testComplete();
                    });
                });
            });
        });
        this.await();
    }

    @Test
    public void testSetWithOptions2() {
        String mykey = RedisClientTestBase.makeKey();
        this.redis.setWithOptions(mykey, "Hello!", new SetOptions().setNX(true), reply0 -> {
            this.assertTrue(reply0.succeeded());
            this.redis.setWithOptions(mykey, "Hello again!", new SetOptions().setNX(true), reply2 -> {
                this.assertTrue(reply2.succeeded());
                this.assertNull(reply2.result());
                this.testComplete();
            });
        });
        this.await();
    }

    @Test
    public void testSetbit() {
        String mykey = RedisClientTestBase.makeKey();
        this.redis.setbit(mykey, 7L, 1, reply0 -> {
            this.assertTrue(reply0.succeeded());
            this.assertEquals(0L, (Long)reply0.result());
            this.redis.setbit(mykey, 7L, 0, reply1 -> {
                this.assertTrue(reply1.succeeded());
                this.assertEquals(1L, (Long)reply1.result());
                this.redis.get(mykey, reply2 -> {
                    this.assertTrue(reply2.succeeded());
                    this.assertEquals("\u0000", reply2.result());
                    this.testComplete();
                });
            });
        });
        this.await();
    }

    @Test
    public void testSetex() {
        String mykey = RedisClientTestBase.makeKey();
        this.redis.setex(mykey, 10L, "Hello", reply0 -> {
            this.assertTrue(reply0.succeeded());
            this.redis.ttl(mykey, reply1 -> {
                this.assertTrue(reply1.succeeded());
                this.assertEquals(10L, (Long)reply1.result());
                this.redis.get(mykey, reply2 -> {
                    this.assertTrue(reply2.succeeded());
                    this.assertEquals("Hello", reply2.result());
                    this.testComplete();
                });
            });
        });
        this.await();
    }

    @Test
    public void testSetnx() {
        String mykey = RedisClientTestBase.makeKey();
        this.redis.setnx(mykey, "Hello", reply0 -> {
            this.assertTrue(reply0.succeeded());
            this.assertEquals(1L, (Long)reply0.result());
            this.redis.setnx(mykey, "World", reply1 -> {
                this.assertTrue(reply1.succeeded());
                this.assertEquals(0L, (Long)reply1.result());
                this.redis.get(mykey, reply2 -> {
                    this.assertTrue(reply2.succeeded());
                    this.assertEquals("Hello", reply2.result());
                    this.testComplete();
                });
            });
        });
        this.await();
    }

    @Test
    public void testSetrange() {
        String mykey = RedisClientTestBase.makeKey();
        this.redis.set(mykey, "Hello World", reply0 -> {
            this.assertTrue(reply0.succeeded());
            this.redis.setrange(mykey, 6, "Redis", reply1 -> {
                this.assertTrue(reply1.succeeded());
                this.assertEquals(11L, (Long)reply1.result());
                this.redis.get(mykey, reply2 -> {
                    this.assertTrue(reply2.succeeded());
                    this.assertEquals("Hello Redis", reply2.result());
                    this.testComplete();
                });
            });
        });
        this.await();
    }

    @Test
    public void testSinter() {
        String mykey1 = RedisClientTestBase.makeKey();
        String mykey2 = RedisClientTestBase.makeKey();
        this.redis.saddMany(mykey1, RedisClientTestBase.toList("a", "b", "c"), reply0 -> {
            this.assertTrue(reply0.succeeded());
            this.assertEquals(3L, (Long)reply0.result());
            this.redis.saddMany(mykey2, RedisClientTestBase.toList("c", "d", "e"), reply1 -> {
                this.assertTrue(reply1.succeeded());
                this.assertEquals(3L, (Long)reply1.result());
                this.redis.sinter(RedisClientTestBase.toList(mykey1, mykey2), reply2 -> {
                    this.assertTrue(reply2.succeeded());
                    this.assertArrayEquals(new Object[]{"c"}, ((JsonArray)reply2.result()).getList().toArray());
                    this.testComplete();
                });
            });
        });
        this.await();
    }

    @Test
    public void testSinterstore() {
        String mykey = RedisClientTestBase.makeKey();
        String mykey1 = RedisClientTestBase.makeKey();
        String mykey2 = RedisClientTestBase.makeKey();
        this.redis.saddMany(mykey1, RedisClientTestBase.toList("a", "b", "c"), reply0 -> {
            this.assertTrue(reply0.succeeded());
            this.assertEquals(3L, (Long)reply0.result());
            this.redis.saddMany(mykey2, RedisClientTestBase.toList("c", "d", "e"), reply1 -> {
                this.assertTrue(reply1.succeeded());
                this.assertEquals(3L, (Long)reply1.result());
                this.redis.sinterstore(mykey, RedisClientTestBase.toList(mykey1, mykey2), reply2 -> {
                    this.assertTrue(reply2.succeeded());
                    this.assertTrue((Long)reply2.result() == 1L);
                    this.testComplete();
                });
            });
        });
        this.await();
    }

    @Test
    public void testSismember() {
        String mykey = RedisClientTestBase.makeKey();
        this.redis.sadd(mykey, "one", reply0 -> {
            this.assertTrue(reply0.succeeded());
            this.redis.sismember(mykey, "one", reply1 -> {
                this.assertTrue(reply1.succeeded());
                this.assertEquals(1L, (Long)reply1.result());
                this.redis.sismember(mykey, "two", reply2 -> {
                    this.assertTrue(reply2.succeeded());
                    this.assertEquals(0L, (Long)reply2.result());
                    this.testComplete();
                });
            });
        });
        this.await();
    }

    @Test
    @Ignore
    public void testSlaveof() {
    }

    @Test
    @Ignore
    public void testSlowlog() {
    }

    @Test
    public void testSmembers() {
        String mykey = RedisClientTestBase.makeKey();
        this.redis.saddMany(mykey, RedisClientTestBase.toList("Hello", "World"), reply0 -> {
            this.assertTrue(reply0.succeeded());
            this.assertEquals(2L, (Long)reply0.result());
            this.redis.smembers(mykey, reply1 -> {
                this.assertTrue(reply1.succeeded());
                Object[] expected = new Object[]{"Hello", "World"};
                Object[] result = ((JsonArray)reply1.result()).getList().toArray();
                Arrays.sort(result);
                this.assertArrayEquals(expected, result);
                this.testComplete();
            });
        });
        this.await();
    }

    @Test
    public void testSmove() {
        String mykey = RedisClientTestBase.makeKey();
        String myotherkey = RedisClientTestBase.makeKey();
        this.redis.saddMany(mykey, RedisClientTestBase.toList("one", "two"), reply0 -> {
            this.assertTrue(reply0.succeeded());
            this.assertEquals(2L, (Long)reply0.result());
            this.redis.sadd(myotherkey, "three", reply1 -> {
                this.assertTrue(reply1.succeeded());
                this.assertEquals(1L, (Long)reply1.result());
                this.redis.smove(mykey, myotherkey, "two", reply2 -> {
                    this.assertTrue(reply2.succeeded());
                    this.assertEquals(1L, (Long)reply2.result());
                    this.redis.smembers(mykey, reply3 -> {
                        this.assertTrue(reply3.succeeded());
                        Object[] expected = new Object[]{"one"};
                        Object[] result = ((JsonArray)reply3.result()).getList().toArray();
                        Arrays.sort(result);
                        this.assertArrayEquals(expected, result);
                        this.redis.smembers(myotherkey, reply4 -> {
                            this.assertTrue(reply4.succeeded());
                            Object[] expected1 = new Object[]{"three", "two"};
                            Object[] result1 = ((JsonArray)reply4.result()).getList().toArray();
                            Arrays.sort(result1);
                            this.assertArrayEquals(expected1, result1);
                            this.testComplete();
                        });
                    });
                });
            });
        });
        this.await();
    }

    @Test
    public void testSort() {
        String mykey = RedisClientTestBase.makeKey();
        String k1 = mykey + ":1";
        String k2 = mykey + ":2";
        String k3 = mykey + ":3";
        String kx = mykey + ":*";
        this.redis.saddMany(mykey, RedisClientTestBase.toList("1", "2", "3"), reply0 -> {
            this.assertTrue(reply0.succeeded());
            this.assertEquals(3L, (Long)reply0.result());
            this.redis.set(k1, "one", reply1 -> {
                this.assertTrue(reply1.succeeded());
                this.redis.set(k2, "two", reply2 -> {
                    this.assertTrue(reply2.succeeded());
                    this.redis.set(k3, "three", reply3 -> {
                        this.assertTrue(reply3.succeeded());
                        this.redis.sort(mykey, new SortOptions().useDescending().addGet(kx), reply4 -> {
                            this.assertTrue(reply4.succeeded());
                            this.assertArrayEquals(RedisClientTestBase.toArray("three", "two", "one"), ((JsonArray)reply4.result()).getList().toArray());
                            this.testComplete();
                        });
                    });
                });
            });
        });
        this.await();
    }

    @Test
    public void testSpop() {
        String mykey = RedisClientTestBase.makeKey();
        this.redis.saddMany(mykey, RedisClientTestBase.toList("one", "two", "three"), reply0 -> {
            this.assertTrue(reply0.succeeded());
            this.assertEquals(3L, (Long)reply0.result());
            this.redis.spop(mykey, reply1 -> {
                this.assertTrue(String.valueOf(reply1.cause()), reply1.succeeded());
                String ret = (String)reply1.result();
                this.assertTrue(ret.equals("one") || ret.equals("two") || ret.equals("three"));
                JsonArray expected = new JsonArray();
                if (!ret.equals("one")) {
                    expected.add("one");
                }
                if (!ret.equals("two")) {
                    expected.add("two");
                }
                if (!ret.equals("three")) {
                    expected.add("three");
                }
                this.redis.smembers(mykey, reply2 -> {
                    this.assertTrue(reply2.succeeded());
                    Object[] expectedA = expected.getList().toArray();
                    Arrays.sort(expectedA);
                    Object[] res = ((JsonArray)reply2.result()).getList().toArray();
                    Arrays.sort(res);
                    this.assertArrayEquals(expectedA, res);
                    this.testComplete();
                });
            });
        });
        this.await();
    }

    @Test
    @Ignore
    public void testSpopMany() {
        String mykey = RedisClientTestBase.makeKey();
        this.redis.saddMany(mykey, RedisClientTestBase.toList("one", "two", "three"), reply0 -> {
            this.assertTrue(reply0.succeeded());
            this.assertEquals(3L, (Long)reply0.result());
            this.redis.spopMany(mykey, 3, reply1 -> {
                this.assertTrue(String.valueOf(reply1.cause()), reply1.succeeded());
                JsonArray ret = (JsonArray)reply1.result();
                this.testComplete();
            });
        });
        this.await();
    }

    @Test
    public void testSrandmember() {
        String mykey = RedisClientTestBase.makeKey();
        this.redis.saddMany(mykey, RedisClientTestBase.toList("one", "two", "three"), reply0 -> {
            this.assertTrue(reply0.succeeded());
            this.assertEquals(3L, (Long)reply0.result());
            this.redis.srandmember(mykey, reply1 -> {
                this.assertTrue(reply1.succeeded());
                String randmember = (String)reply1.result();
                this.assertTrue(randmember.equals("one") || randmember.equals("two") || randmember.equals("three"));
                this.testComplete();
            });
        });
        this.await();
    }

    @Test
    public void testSrem() {
        String mykey = RedisClientTestBase.makeKey();
        this.redis.saddMany(mykey, RedisClientTestBase.toList("one", "two", "three"), reply0 -> {
            this.assertTrue(reply0.succeeded());
            this.assertEquals(3L, (Long)reply0.result());
            this.redis.srem(mykey, "one", reply1 -> {
                this.assertTrue(reply1.succeeded());
                this.assertEquals(1L, (Long)reply1.result());
                this.redis.srem(mykey, "four", reply2 -> {
                    this.assertTrue(reply2.succeeded());
                    this.assertEquals(0L, (Long)reply2.result());
                    this.testComplete();
                });
            });
        });
        this.await();
    }

    @Test
    public void testStrlen() {
        String mykey = RedisClientTestBase.makeKey();
        this.redis.set(mykey, "Hello world", reply0 -> {
            this.assertTrue(reply0.succeeded());
            this.redis.strlen(mykey, reply1 -> {
                this.assertTrue(reply1.succeeded());
                this.assertEquals(11L, (Long)reply1.result());
                this.redis.strlen("nonexisting", reply2 -> {
                    this.assertTrue(reply2.succeeded());
                    this.assertEquals(0L, (Long)reply2.result());
                    this.testComplete();
                });
            });
        });
        this.await();
    }

    @Test
    public void testSubscribe() {
        String key = RedisClientTestBase.makeKey();
        this.redis.subscribe(key, reply -> {
            this.assertTrue(reply.succeeded());
            this.redis.unsubscribe(RedisClientTestBase.toList(key), reply2 -> {
                this.assertTrue(reply2.succeeded());
                this.testComplete();
            });
        });
        this.await();
    }

    @Test
    public void testSunion() throws Exception {
        String mykey1 = RedisClientTestBase.makeKey();
        String mykey2 = RedisClientTestBase.makeKey();
        CountDownLatch latch = new CountDownLatch(6);
        this.redis.sadd(mykey1, "a", reply0 -> {
            this.assertTrue(reply0.succeeded());
            this.assertEquals(1L, (Long)reply0.result());
            latch.countDown();
            this.redis.sadd(mykey1, "b", reply1 -> {
                this.assertTrue(reply1.succeeded());
                this.assertEquals(1L, (Long)reply1.result());
                latch.countDown();
            });
            this.redis.sadd(mykey1, "c", reply2 -> {
                this.assertTrue(reply2.succeeded());
                this.assertEquals(1L, (Long)reply2.result());
                latch.countDown();
            });
            this.redis.sadd(mykey2, "c", reply3 -> {
                this.assertTrue(reply3.succeeded());
                this.assertEquals(1L, (Long)reply3.result());
                latch.countDown();
            });
            this.redis.sadd(mykey2, "d", reply4 -> {
                this.assertTrue(reply4.succeeded());
                this.assertEquals(1L, (Long)reply4.result());
                latch.countDown();
            });
            this.redis.sadd(mykey2, "e", reply5 -> {
                this.assertTrue(reply5.succeeded());
                this.assertEquals(1L, (Long)reply5.result());
                latch.countDown();
                try {
                    latch.await(10L, TimeUnit.SECONDS);
                }
                catch (InterruptedException e) {
                    this.testComplete();
                    this.fail("Time out while waiting for all SADD calls to finish");
                }
                this.redis.sunion(RedisClientTestBase.toList(mykey1, mykey2), reply6 -> {
                    this.assertTrue(reply6.succeeded());
                    JsonArray arr = (JsonArray)reply6.result();
                    Object[] array = arr.getList().toArray();
                    Arrays.sort(array);
                    this.assertTrue(array.length == 5);
                    this.assertArrayEquals(new Object[]{"a", "b", "c", "d", "e"}, array);
                    this.testComplete();
                });
            });
        });
        this.await();
    }

    @Test
    public void testSunionstore() {
        String mykey = RedisClientTestBase.makeKey();
        String mykey1 = RedisClientTestBase.makeKey();
        String mykey2 = RedisClientTestBase.makeKey();
        this.redis.saddMany(mykey1, RedisClientTestBase.toList("a", "b", "c"), reply0 -> {
            this.assertTrue(reply0.succeeded());
            this.assertEquals(3L, (Long)reply0.result());
            this.redis.saddMany(mykey2, RedisClientTestBase.toList("c", "d", "e"), reply1 -> {
                this.assertTrue(reply1.succeeded());
                this.assertEquals(3L, (Long)reply1.result());
                this.redis.sunionstore(mykey, RedisClientTestBase.toList(mykey1, mykey2), reply2 -> {
                    this.assertTrue(reply2.succeeded());
                    this.assertTrue((Long)reply2.result() == 5L);
                    this.testComplete();
                });
            });
        });
        this.await();
    }

    @Test
    public void testSync() {
        this.redis.sync(v -> {
            this.assertTrue(v.succeeded());
            this.testComplete();
        });
        this.await();
    }

    @Test
    public void testTime() {
        this.redis.time(reply0 -> {
            this.assertTrue(reply0.succeeded());
            this.assertTrue(((JsonArray)reply0.result()).size() == 2);
            this.testComplete();
        });
        this.await();
    }

    @Test
    public void testTtl() {
        String mykey = RedisClientTestBase.makeKey();
        this.redis.set(mykey, "Hello", reply0 -> {
            this.assertTrue(reply0.succeeded());
            this.redis.expire(mykey, 10L, reply1 -> {
                this.assertTrue(reply1.succeeded());
                this.assertEquals(1L, (Long)reply1.result());
                this.redis.ttl(mykey, reply2 -> {
                    this.assertTrue(reply2.succeeded());
                    this.assertEquals(10L, (Long)reply2.result());
                    this.testComplete();
                });
            });
        });
        this.await();
    }

    @Test
    public void testType() {
        String key1 = RedisClientTestBase.makeKey();
        String key2 = RedisClientTestBase.makeKey();
        String key3 = RedisClientTestBase.makeKey();
        this.redis.set(key1, "value", reply0 -> {
            this.assertTrue(reply0.succeeded());
            this.redis.lpush(key2, "value", reply1 -> {
                this.assertTrue(reply1.succeeded());
                this.assertEquals(1L, (Long)reply1.result());
                this.redis.sadd(key3, "value", reply2 -> {
                    this.assertTrue(reply2.succeeded());
                    this.assertEquals(1L, (Long)reply2.result());
                    this.redis.type(key1, reply3 -> {
                        this.assertTrue(reply3.succeeded());
                        this.assertEquals("string", reply3.result());
                        this.redis.type(key2, reply4 -> {
                            this.assertTrue(reply4.succeeded());
                            this.assertEquals("list", reply4.result());
                            this.redis.type(key3, reply5 -> {
                                this.assertTrue(reply5.succeeded());
                                this.assertEquals("set", reply5.result());
                                this.testComplete();
                            });
                        });
                    });
                });
            });
        });
        this.await();
    }

    @Test
    public void testUnsubscribe() {
        String key = RedisClientTestBase.makeKey();
        this.redis.subscribe(key, reply -> {
            this.assertTrue(reply.succeeded());
            this.redis.unsubscribe(RedisClientTestBase.toList(key), reply2 -> {
                this.assertTrue(reply2.succeeded());
                this.testComplete();
            });
        });
        this.await();
    }

    @Test
    @Ignore
    public void testUnwatch() {
    }

    @Test
    public void testWatch() throws Exception {
        String key = RedisClientTestBase.makeKey();
        RedisClient rdx = RedisClient.create((Vertx)this.vertx, (RedisOptions)this.getConfig());
        RedisTransaction transaction = this.redis.transaction();
        this.redis.set(key, "0", reply -> {
            this.assertTrue(reply.succeeded());
            transaction.watch(key, reply2 -> {
                this.assertTrue(reply2.succeeded());
                transaction.multi(reply3 -> {
                    this.assertTrue(reply3.succeeded());
                    transaction.incr(key, reply4 -> {
                        this.assertTrue(reply4.succeeded());
                        rdx.incr(key, reply1 -> {
                            this.assertTrue(reply1.succeeded());
                            this.assertEquals(1L, reply1.result());
                            transaction.incr(key, reply5 -> {
                                this.assertTrue(reply5.succeeded());
                                transaction.incrby(key, 10L, reply6 -> {
                                    this.assertTrue(reply6.succeeded());
                                    transaction.exec(reply7 -> {
                                        this.assertTrue(reply7.succeeded());
                                        this.assertNull(reply7.result());
                                        this.redis.get(key, reply8 -> {
                                            this.assertTrue(reply8.succeeded());
                                            this.assertEquals("1", reply8.result());
                                            this.testComplete();
                                        });
                                    });
                                });
                            });
                        });
                    });
                });
            });
        });
        this.await();
    }

    @Test
    public void testZadd() {
        String key = RedisClientTestBase.makeKey();
        this.redis.zadd(key, 1.0, "one", reply0 -> {
            this.assertTrue(reply0.succeeded());
            this.assertEquals(1L, (Long)reply0.result());
            this.redis.zadd(key, 1.0, "uno", reply1 -> {
                this.assertTrue(reply1.succeeded());
                this.assertEquals(1L, (Long)reply1.result());
                HashMap<String, Double> values = new HashMap<String, Double>();
                values.put("one", 1.0);
                values.put("two", 2.0);
                values.put("two", 3.0);
                this.redis.zaddMany(key, values, reply2 -> {
                    this.assertTrue(reply2.succeeded());
                    this.assertEquals(1L, (Long)reply2.result());
                    this.redis.zadd(key, 3.0, "two", reply3 -> {
                        this.assertTrue(reply3.succeeded());
                        this.assertEquals(0L, (Long)reply3.result());
                        this.redis.zrangeWithOptions(key, 0L, -1L, RangeOptions.WITHSCORES, reply4 -> {
                            this.assertTrue(reply4.succeeded());
                            this.assertArrayEquals(RedisClientTestBase.toArray("one", "1", "uno", "1", "two", "3"), ((JsonArray)reply4.result()).getList().toArray());
                            this.testComplete();
                        });
                    });
                });
            });
        });
        this.await();
    }

    @Test
    public void testZcard() {
        String key = RedisClientTestBase.makeKey();
        this.redis.zadd(key, 1.0, "one", reply0 -> {
            this.assertTrue(reply0.succeeded());
            this.assertEquals(1L, (Long)reply0.result());
            this.redis.zadd(key, 2.0, "two", reply1 -> {
                this.assertTrue(reply1.succeeded());
                this.assertEquals(1L, (Long)reply1.result());
                this.redis.zcard(key, reply2 -> {
                    this.assertTrue(reply2.succeeded());
                    this.assertEquals(2L, (Long)reply2.result());
                    this.testComplete();
                });
            });
        });
        this.await();
    }

    @Test
    public void testZcount() {
        String key = RedisClientTestBase.makeKey();
        this.redis.zadd(key, 1.0, "one", reply0 -> {
            this.assertTrue(reply0.succeeded());
            this.assertEquals(1L, (Long)reply0.result());
            this.redis.zadd(key, 2.0, "two", reply1 -> {
                this.assertTrue(reply1.succeeded());
                this.assertEquals(1L, (Long)reply1.result());
                this.redis.zadd(key, 3.0, "three", reply2 -> {
                    this.assertTrue(reply2.succeeded());
                    this.assertEquals(1L, (Long)reply2.result());
                    this.redis.zcount(key, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, reply3 -> {
                        this.assertTrue(reply3.succeeded());
                        this.assertEquals(3L, (Long)reply3.result());
                        this.testComplete();
                    });
                });
            });
        });
        this.await();
    }

    @Test
    public void testZincrby() {
        String key = RedisClientTestBase.makeKey();
        this.redis.zadd(key, 1.0, "one", reply0 -> {
            this.assertTrue(reply0.succeeded());
            this.assertEquals(1L, (Long)reply0.result());
            this.redis.zadd(key, 2.0, "two", reply1 -> {
                this.assertTrue(reply1.succeeded());
                this.assertEquals(1L, (Long)reply1.result());
                this.redis.zincrby(key, 2.0, "one", reply2 -> {
                    this.assertTrue(reply2.succeeded());
                    this.assertEquals("3", reply2.result());
                    this.testComplete();
                });
            });
        });
        this.await();
    }

    @Test
    public void testZinterstore() {
        String key1 = RedisClientTestBase.makeKey();
        String key2 = RedisClientTestBase.makeKey();
        String key3 = RedisClientTestBase.makeKey();
        this.redis.zadd(key1, 1.0, "one", reply0 -> {
            this.assertTrue(reply0.succeeded());
            this.assertEquals(1L, (Long)reply0.result());
            this.redis.zadd(key1, 2.0, "two", reply1 -> {
                this.assertTrue(reply1.succeeded());
                this.assertEquals(1L, (Long)reply1.result());
                this.redis.zadd(key2, 1.0, "one", reply2 -> {
                    this.assertTrue(reply2.succeeded());
                    this.assertEquals(1L, (Long)reply2.result());
                    this.redis.zadd(key2, 2.0, "two", reply3 -> {
                        this.assertTrue(reply3.succeeded());
                        this.assertEquals(1L, (Long)reply3.result());
                        this.redis.zadd(key2, 3.0, "three", reply4 -> {
                            this.assertTrue(reply4.succeeded());
                            this.assertEquals(1L, (Long)reply4.result());
                            HashMap<String, Double> sets = new HashMap<String, Double>();
                            sets.put(key1, 2.0);
                            sets.put(key2, 3.0);
                            this.redis.zinterstoreWeighed(key3, sets, AggregateOptions.NONE, reply5 -> {
                                this.assertTrue(reply5.succeeded());
                                this.assertEquals(2L, (Long)reply5.result());
                                this.testComplete();
                            });
                        });
                    });
                });
            });
        });
        this.await();
    }

    @Test
    public void testZrange() {
        String key = RedisClientTestBase.makeKey();
        this.redis.zadd(key, 1.0, "one", reply0 -> {
            this.assertTrue(reply0.succeeded());
            this.assertEquals(1L, (Long)reply0.result());
            this.redis.zadd(key, 2.0, "two", reply1 -> {
                this.assertTrue(reply1.succeeded());
                this.assertEquals(1L, (Long)reply1.result());
                this.redis.zadd(key, 3.0, "three", reply2 -> {
                    this.assertTrue(reply2.succeeded());
                    this.assertEquals(1L, (Long)reply2.result());
                    this.redis.zrange(key, 0L, -1L, reply3 -> {
                        this.assertTrue(reply3.succeeded());
                        this.assertArrayEquals(RedisClientTestBase.toArray("one", "two", "three"), ((JsonArray)reply3.result()).getList().toArray());
                        this.testComplete();
                    });
                });
            });
        });
        this.await();
    }

    @Test
    public void testZrangebyscore() {
        String key = RedisClientTestBase.makeKey();
        this.redis.zadd(key, 1.0, "one", reply0 -> {
            this.assertTrue(reply0.succeeded());
            this.assertEquals(1L, (Long)reply0.result());
            this.redis.zadd(key, 2.0, "two", reply1 -> {
                this.assertTrue(reply1.succeeded());
                this.assertEquals(1L, (Long)reply1.result());
                this.redis.zadd(key, 3.0, "three", reply2 -> {
                    this.assertTrue(reply2.succeeded());
                    this.assertEquals(1L, (Long)reply2.result());
                    this.redis.zrangebyscore(key, "-inf", "+inf", RangeLimitOptions.NONE, reply3 -> {
                        this.assertTrue(reply3.succeeded());
                        this.assertArrayEquals(RedisClientTestBase.toArray("one", "two", "three"), ((JsonArray)reply3.result()).getList().toArray());
                        this.testComplete();
                    });
                });
            });
        });
        this.await();
    }

    @Test
    public void testZrangebyscoreWithLimits() {
        RangeLimitOptions options = new RangeLimitOptions();
        options.setLimit(0L, 1L);
        this.redis.zrangebyscore("yourkey", "-inf", "+inf", options, result -> {
            this.assertTrue(result.succeeded());
            this.testComplete();
        });
        this.await();
    }

    @Test
    public void testZrank() {
        String key = RedisClientTestBase.makeKey();
        HashMap<String, Double> values = new HashMap<String, Double>();
        values.put("one", 1.0);
        values.put("two", 2.0);
        values.put("three", 3.0);
        this.redis.zaddMany(key, values, reply0 -> {
            this.assertTrue(reply0.succeeded());
            this.assertEquals(3L, (Long)reply0.result());
            this.redis.zrank(key, "three", reply3 -> {
                this.assertTrue(reply3.succeeded());
                this.assertEquals(2L, (Long)reply3.result());
                this.testComplete();
            });
        });
        this.await();
    }

    @Test
    public void testZrem() {
        String key = RedisClientTestBase.makeKey();
        HashMap<String, Double> values = new HashMap<String, Double>();
        values.put("one", 1.0);
        values.put("two", 2.0);
        values.put("three", 3.0);
        this.redis.zaddMany(key, values, reply0 -> {
            this.assertTrue(reply0.succeeded());
            this.assertEquals(3L, (Long)reply0.result());
            this.redis.zrem(key, "two", reply3 -> {
                this.assertTrue(reply3.succeeded());
                this.assertEquals(1L, (Long)reply3.result());
                this.testComplete();
            });
        });
        this.await();
    }

    @Test
    public void testZremrangebyrank() {
        String key = RedisClientTestBase.makeKey();
        HashMap<String, Double> values = new HashMap<String, Double>();
        values.put("one", 1.0);
        values.put("two", 2.0);
        values.put("three", 3.0);
        this.redis.zaddMany(key, values, reply0 -> {
            this.assertTrue(reply0.succeeded());
            this.assertEquals(3L, (Long)reply0.result());
            this.redis.zremrangebyrank(key, 0L, 1L, reply3 -> {
                this.assertTrue(reply3.succeeded());
                this.assertEquals(2L, (Long)reply3.result());
                this.testComplete();
            });
        });
        this.await();
    }

    @Test
    public void testZremrangebyscore() {
        String key = RedisClientTestBase.makeKey();
        HashMap<String, Double> values = new HashMap<String, Double>();
        values.put("one", 1.0);
        values.put("two", 2.0);
        values.put("three", 3.0);
        this.redis.zaddMany(key, values, reply0 -> {
            this.assertTrue(reply0.succeeded());
            this.assertEquals(3L, (Long)reply0.result());
            this.redis.zremrangebyscore(key, "-inf", "(2", reply3 -> {
                this.assertTrue(reply3.succeeded());
                this.assertEquals(1L, (Long)reply3.result());
                this.testComplete();
            });
        });
        this.await();
    }

    @Test
    public void testZrevrange() {
        String key = RedisClientTestBase.makeKey();
        HashMap<String, Double> values = new HashMap<String, Double>();
        values.put("one", 1.0);
        values.put("two", 2.0);
        values.put("three", 3.0);
        this.redis.zaddMany(key, values, reply0 -> {
            this.assertTrue(reply0.succeeded());
            this.assertEquals(3L, (Long)reply0.result());
            this.redis.zrevrange(key, 0L, -1L, RangeOptions.NONE, reply3 -> {
                this.assertTrue(reply3.succeeded());
                this.assertArrayEquals(RedisClientTestBase.toArray("three", "two", "one"), ((JsonArray)reply3.result()).getList().toArray());
                this.testComplete();
            });
        });
        this.await();
    }

    @Test
    public void testZrevrangebyscore() {
        String key = RedisClientTestBase.makeKey();
        HashMap<String, Double> values = new HashMap<String, Double>();
        values.put("one", 1.0);
        values.put("two", 2.0);
        values.put("three", 3.0);
        this.redis.zaddMany(key, values, reply0 -> {
            this.assertTrue(reply0.succeeded());
            this.assertEquals(3L, (Long)reply0.result());
            this.redis.zrevrangebyscore(key, "+inf", "-inf", RangeLimitOptions.NONE, reply3 -> {
                this.assertTrue(reply3.succeeded());
                this.assertArrayEquals(RedisClientTestBase.toArray("three", "two", "one"), ((JsonArray)reply3.result()).getList().toArray());
                this.testComplete();
            });
        });
        this.await();
    }

    @Test
    public void testZrevrank() {
        String key = RedisClientTestBase.makeKey();
        HashMap<String, Double> values = new HashMap<String, Double>();
        values.put("one", 1.0);
        values.put("two", 2.0);
        values.put("three", 3.0);
        this.redis.zaddMany(key, values, reply0 -> {
            this.assertTrue(reply0.succeeded());
            this.assertEquals(3L, (Long)reply0.result());
            this.redis.zrevrank(key, "one", reply3 -> {
                this.assertTrue(reply3.succeeded());
                this.assertEquals(2L, (Long)reply3.result());
                this.testComplete();
            });
        });
        this.await();
    }

    @Test
    public void testZscore() {
        String key = RedisClientTestBase.makeKey();
        this.redis.zadd(key, 1.0, "one", reply0 -> {
            this.assertTrue(reply0.succeeded());
            this.assertEquals(1L, (Long)reply0.result());
            this.redis.zscore(key, "one", reply1 -> {
                this.assertTrue(reply1.succeeded());
                this.assertEquals("1", reply1.result());
                this.testComplete();
            });
        });
        this.await();
    }

    @Test
    public void testZunionstore() {
        String key1 = RedisClientTestBase.makeKey();
        String key2 = RedisClientTestBase.makeKey();
        String key3 = RedisClientTestBase.makeKey();
        HashMap<String, Double> values = new HashMap<String, Double>();
        values.put("one", 1.0);
        values.put("two", 2.0);
        this.redis.zaddMany(key1, values, reply0 -> {
            this.assertTrue(reply0.succeeded());
            this.assertEquals(2L, (Long)reply0.result());
            values.put("three", 3.0);
            this.redis.zaddMany(key2, values, reply2 -> {
                this.assertTrue(reply2.succeeded());
                this.assertEquals(3L, (Long)reply2.result());
                HashMap<String, Double> weighedSets = new HashMap<String, Double>();
                weighedSets.put(key1, 2.0);
                weighedSets.put(key2, 3.0);
                this.redis.zunionstoreWeighed(key3, weighedSets, AggregateOptions.NONE, reply5 -> {
                    this.assertTrue(String.valueOf(reply5.cause()), reply5.succeeded());
                    this.assertEquals(3L, (Long)reply5.result());
                    this.testComplete();
                });
            });
        });
        this.await();
    }

    @Test
    @Category(value={RedisPost28Tests.class})
    public void testHscan() {
        String key = RedisClientTestBase.makeKey();
        HashMap<String, String> obj = new HashMap<String, String>();
        for (int i = 0; i < 100; ++i) {
            obj.put("field" + i, "val" + i);
        }
        this.redis.hmset(key, new JsonObject(obj), reply0 -> {
            this.assertTrue(reply0.succeeded());
            this.assertEquals("OK", reply0.result());
            this.redis.hscan(key, "0", new ScanOptions().setMatch("field1*"), reply1 -> {
                this.assertTrue(String.valueOf(reply1.cause()), reply1.succeeded());
                JsonArray result = (JsonArray)reply1.result();
                this.assertEquals(2L, result.size());
                JsonArray page = result.getJsonArray(1);
                this.assertEquals(22L, page.size());
                this.testComplete();
            });
        });
        this.await();
    }

    @Test
    @Category(value={RedisPost28Tests.class})
    public void testBitpos() {
        String key = RedisClientTestBase.makeKey();
        byte[] value = new byte[]{-1, -16, 0};
        this.redis.setBinary(key, Buffer.buffer((byte[])value), reply0 -> {
            this.assertTrue(reply0.succeeded());
            this.redis.bitpos(key, 0, reply1 -> {
                this.assertTrue(String.valueOf(reply1.cause()), reply1.succeeded());
                this.assertEquals(12L, (Long)reply1.result());
                byte[] value2 = new byte[]{0, 0, 0};
                this.redis.setBinary(key, Buffer.buffer((byte[])value2), reply2 -> {
                    this.assertTrue(reply2.succeeded());
                    this.redis.bitpos(key, 1, reply3 -> {
                        this.assertTrue(String.valueOf(reply3.cause()), reply3.succeeded());
                        this.assertEquals(-1L, (Long)reply3.result());
                        this.testComplete();
                    });
                });
            });
        });
        this.await();
    }

    @Test
    @Category(value={RedisPost28Tests.class})
    public void testBitposFrom() {
        String key = RedisClientTestBase.makeKey();
        byte[] value = new byte[]{0, -1, -16};
        this.redis.setBinary(key, Buffer.buffer((byte[])value), reply0 -> {
            this.assertTrue(reply0.succeeded());
            this.redis.bitposFrom(key, 1, 0, reply1 -> {
                this.assertTrue(String.valueOf(reply1.cause()), reply1.succeeded());
                this.assertEquals(8L, (Long)reply1.result());
                this.redis.bitposFrom(key, 1, 2, reply2 -> {
                    this.assertTrue(String.valueOf(reply2.cause()), reply2.succeeded());
                    this.assertEquals(16L, (Long)reply2.result());
                    this.testComplete();
                });
            });
        });
        this.await();
    }

    @Test
    public void testBinarySetAndGet() {
        String key = RedisClientTestBase.makeKey();
        byte[] value = new byte[256];
        for (int i = 0; i < value.length; ++i) {
            value[i] = (byte)i;
        }
        this.redis.setBinary(key, Buffer.buffer((byte[])value), reply0 -> {
            this.assertTrue(reply0.succeeded());
            this.redis.getBinary(key, reply1 -> {
                this.assertTrue(String.valueOf(reply1.cause()), reply1.succeeded());
                this.assertArrayEquals(value, ((Buffer)reply1.result()).getBytes());
                this.testComplete();
            });
        });
        this.await();
    }

    @Test
    public void testIssue5BlockingCall_shouldWork() {
        String list1 = RedisClientTestBase.makeKey();
        String list2 = RedisClientTestBase.makeKey();
        this.redis.rpushMany(list1, RedisClientTestBase.toList("a", "b", "c"), reply0 -> {
            this.assertTrue(reply0.succeeded());
            this.assertEquals(3L, (Long)reply0.result());
            this.redis.brpopMany(RedisClientTestBase.toList(list1, list2), 0, reply1 -> {
                this.assertTrue(reply1.succeeded());
                this.assertEquals(list1, ((JsonArray)reply1.result()).getString(0));
                this.assertEquals("c", ((JsonArray)reply1.result()).getString(1));
                this.testComplete();
            });
        });
        this.await();
    }

    @Test
    public void testIssue5BlockingCall_report() {
        String list = RedisClientTestBase.makeKey();
        this.redis.brpop(list, 2, reply1 -> {
            this.assertTrue(reply1.succeeded());
            this.assertNull(reply1.result());
            this.testComplete();
        });
        this.await();
    }

    @Test
    public void testSscan() {
        String key = RedisClientTestBase.makeKey();
        this.redis.saddMany(key, RedisClientTestBase.toList("1", "2", "3", "foo", "bar", "feelsgood"), reply1 -> {
            this.assertTrue(reply1.succeeded());
            this.assertEquals(6L, (Long)reply1.result());
            this.redis.sscan(key, "0", new ScanOptions().setMatch("f*"), reply2 -> {
                this.assertTrue(reply2.succeeded());
                this.assertEquals("0", ((JsonArray)reply2.result()).getString(0));
                this.assertTrue(((JsonArray)reply2.result()).getJsonArray(1).contains((Object)"foo"));
                this.assertTrue(((JsonArray)reply2.result()).getJsonArray(1).contains((Object)"feelsgood"));
                this.testComplete();
            });
        });
        this.await();
    }
}

