/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.test.redis;

import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.net.NetServer;
import io.vertx.redis.RedisClient;
import io.vertx.redis.RedisOptions;
import io.vertx.test.core.VertxTestBase;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.Test;

public class TestReconnect
extends VertxTestBase {
    static final int PORT = 2000;
    private static final Buffer PING = Buffer.buffer((String)"*1\r\n$4\r\nPING\r\n");
    private static final Buffer PONG = Buffer.buffer((String)"*1\r\n$4\r\nPONG\r\n");

    @Test
    public void test() throws Exception {
        long numCommands = 100000L;
        NetServer server = this.vertx.createNetServer();
        server.connectHandler(so -> {
            AtomicInteger received = new AtomicInteger();
            AtomicInteger index = new AtomicInteger();
            so.handler(buff -> {
                int val = index.addAndGet(buff.length());
                int pongs = val / PING.length();
                index.set(val % PING.length());
                for (int i = 0; i < pongs; ++i) {
                    if (received.incrementAndGet() == 10000) {
                        so.close();
                        return;
                    }
                    so.write(PONG);
                }
            });
        });
        CountDownLatch latch = new CountDownLatch(1);
        server.listen(2000, "localhost", this.onSuccess(v -> latch.countDown()));
        this.awaitLatch(latch);
        RedisClient client = RedisClient.create((Vertx)this.vertx, (RedisOptions)new RedisOptions().setAddress("localhost").setPort(2000));
        AtomicInteger inflight = new AtomicInteger();
        AtomicInteger done = new AtomicInteger();
        AtomicInteger sent = new AtomicInteger();
        while ((long)sent.get() < numCommands) {
            if (inflight.get() < 5000) {
                inflight.incrementAndGet();
                sent.incrementAndGet();
                client.ping(ar -> {
                    inflight.decrementAndGet();
                    if ((long)done.incrementAndGet() == numCommands) {
                        this.testComplete();
                    }
                });
                continue;
            }
            Thread.yield();
        }
        this.await();
    }
}

