/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.shell;

import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.core.net.JksOptions;
import io.vertx.ext.auth.AuthOptions;
import io.vertx.ext.auth.shiro.ShiroAuthOptions;
import io.vertx.ext.auth.shiro.ShiroAuthRealmType;
import io.vertx.ext.shell.ShellService;
import io.vertx.ext.shell.ShellServiceOptions;
import io.vertx.ext.shell.command.CommandBuilder;
import io.vertx.ext.shell.command.CommandRegistry;
import io.vertx.ext.shell.term.HttpTermOptions;
import io.vertx.ext.shell.term.SSHTermOptions;
import io.vertx.ext.shell.term.TelnetTermOptions;

public class Main {
    public static void main(String[] args) throws Exception {
        Vertx vertx = Vertx.vertx();
        CommandRegistry mgr = CommandRegistry.getShared((Vertx)vertx);
        CommandBuilder echoKeyboardCmd = CommandBuilder.command((String)"echo-keyboard");
        echoKeyboardCmd.processHandler(process -> {
            process.stdinHandler(line -> process.write("-> " + line + "\n"));
            process.interruptHandler(v -> process.end());
        });
        mgr.registerCommand(echoKeyboardCmd.build(vertx));
        CommandBuilder windowCmd = CommandBuilder.command((String)"window");
        windowCmd.processHandler(process -> {
            process.write("[" + process.width() + "," + process.height() + "]\n");
            process.resizehandler(v -> process.write("[" + process.width() + "," + process.height() + "]\n"));
            process.interruptHandler(v -> process.end());
        });
        mgr.registerCommand(windowCmd.build(vertx));
        CommandBuilder charsetTestCmd = CommandBuilder.command((String)"charset-test");
        charsetTestCmd.processHandler(process -> process.write("\u20ac").end());
        mgr.registerCommand(charsetTestCmd.build(vertx));
        ShiroAuthOptions authOptions = new ShiroAuthOptions().setType(ShiroAuthRealmType.PROPERTIES).setConfig(new JsonObject().put("properties_path", "file:src/test/resources/test-auth.properties"));
        SSHTermOptions options = new SSHTermOptions().setPort(5001);
        options.setKeyPairOptions(new JksOptions().setPath("src/test/resources/server-keystore.jks").setPassword("wibble")).setAuthOptions((AuthOptions)authOptions);
        ShellService service = ShellService.create((Vertx)vertx, (ShellServiceOptions)new ShellServiceOptions().setTelnetOptions(new TelnetTermOptions().setPort(5000)).setSSHOptions(options).setHttpOptions(new HttpTermOptions().setPort(8080).setAuthOptions((AuthOptions)authOptions)));
        service.start();
    }
}

