/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.shell;

import io.vertx.core.Context;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.ext.shell.Shell;
import io.vertx.ext.shell.ShellServer;
import io.vertx.ext.shell.cli.CliToken;
import io.vertx.ext.shell.command.CommandBuilder;
import io.vertx.ext.shell.command.CommandProcessTest;
import io.vertx.ext.shell.command.CommandResolver;
import io.vertx.ext.shell.session.Session;
import io.vertx.ext.shell.session.impl.SessionImpl;
import io.vertx.ext.shell.support.TestCommands;
import io.vertx.ext.shell.system.Job;
import io.vertx.ext.shell.term.Pty;
import io.vertx.ext.unit.Async;
import io.vertx.ext.unit.TestContext;
import io.vertx.ext.unit.junit.VertxUnitRunner;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=VertxUnitRunner.class)
public class ShellServerTest {
    Vertx vertx;
    ShellServer server;
    TestCommands commands;

    @Before
    public void before(TestContext context) {
        this.vertx = Vertx.vertx();
        this.server = ShellServer.create((Vertx)this.vertx);
        this.commands = new TestCommands(this.vertx);
        this.server.registerCommandResolver(CommandResolver.baseCommands((Vertx)this.vertx)).registerCommandResolver((CommandResolver)this.commands).listen(context.asyncAssertSuccess());
    }

    @After
    public void after(TestContext context) {
        this.vertx.close(context.asyncAssertSuccess());
    }

    @Test
    public void testRun(TestContext context) {
        this.commands.add(CommandBuilder.command((String)"foo").processHandler(process -> process.end(3)));
        Shell shell = this.server.createShell();
        Job job = shell.createJob(CliToken.tokenize((String)"foo"));
        Async async = context.async();
        job.setTty(Pty.create().slave()).statusUpdateHandler(CommandProcessTest.terminateHandler((Handler<Void>)((Handler)code -> {
            context.assertEquals((Object)3, (Object)job.process().exitCode());
            async.complete();
        }))).run();
    }

    @Test
    public void testThrowExceptionInProcess(TestContext context) {
        this.commands.add(CommandBuilder.command((String)"foo").processHandler(process -> {
            throw new RuntimeException();
        }));
        Shell shell = this.server.createShell();
        Job job = shell.createJob("foo");
        Async async = context.async();
        Pty pty = Pty.create();
        job.setTty(pty.slave()).statusUpdateHandler(CommandProcessTest.terminateHandler((Handler<Void>)((Handler)code -> {
            context.assertEquals((Object)1, (Object)job.process().exitCode());
            async.complete();
        }))).run();
    }

    @Test
    public void testStdin(TestContext context) {
        CountDownLatch latch = new CountDownLatch(1);
        this.commands.add(CommandBuilder.command((String)"foo").processHandler(process -> {
            process.stdinHandler(data -> {
                context.assertEquals((Object)"hello_world", data);
                process.end(0);
            });
            latch.countDown();
        }));
        Shell shell = this.server.createShell();
        Job job = shell.createJob(CliToken.tokenize((String)"foo"));
        Async async = context.async();
        Pty pty = Pty.create();
        job.setTty(pty.slave());
        job.statusUpdateHandler(CommandProcessTest.terminateHandler((Handler<Void>)((Handler)code -> {
            context.assertEquals((Object)0, (Object)job.process().exitCode());
            async.complete();
        }))).run();
        try {
            latch.await(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            context.fail((Throwable)e);
        }
        pty.write("hello_world");
    }

    @Test
    public void testStdout(TestContext context) {
        this.commands.add(CommandBuilder.command((String)"foo").processHandler(process -> {
            process.write("bye_world");
            process.end(0);
        }));
        Shell shell = this.server.createShell();
        Job job = shell.createJob("foo");
        Async async = context.async();
        LinkedList out = new LinkedList();
        Pty pty = Pty.create();
        pty.stdoutHandler(out::add);
        job.setTty(pty.slave());
        job.statusUpdateHandler(CommandProcessTest.terminateHandler((Handler<Void>)((Handler)code -> {
            context.assertEquals((Object)0, (Object)job.process().exitCode());
            context.assertEquals(Arrays.asList("bye_world"), (Object)out);
            async.complete();
        }))).run();
    }

    @Test
    public void testVertxContext(TestContext testContext) throws Exception {
        Context commandCtx = this.vertx.getOrCreateContext();
        Context shellCtx = this.vertx.getOrCreateContext();
        Async async = testContext.async();
        Async latch = testContext.async();
        commandCtx.runOnContext(v1 -> {
            CommandBuilder cmd = CommandBuilder.command((String)"foo");
            cmd.processHandler(process -> {
                Context currentCtx = Vertx.currentContext();
                testContext.assertTrue(commandCtx == currentCtx);
                process.stdinHandler(text -> {
                    testContext.assertTrue(commandCtx == Vertx.currentContext());
                    testContext.assertEquals((Object)"ping", text);
                    process.write("pong");
                });
                process.suspendHandler(event -> {
                    testContext.assertTrue(commandCtx == Vertx.currentContext());
                    process.end(0);
                });
                latch.countDown();
            });
            this.commands.add(cmd);
            shellCtx.runOnContext(v3 -> {
                testContext.assertTrue(shellCtx == Vertx.currentContext());
                Shell shell = this.server.createShell();
                Job job = shell.createJob("foo");
                Pty pty = Pty.create();
                pty.stdoutHandler(text -> {
                    testContext.assertTrue(shellCtx == Vertx.currentContext());
                    testContext.assertEquals((Object)"pong", text);
                    job.suspend();
                });
                job.setTty(pty.slave()).statusUpdateHandler(CommandProcessTest.terminateHandler((Handler<Void>)((Handler)code -> {
                    testContext.assertTrue(shellCtx == Vertx.currentContext());
                    async.complete();
                }))).run();
                latch.awaitSuccess(10000L);
                pty.write("ping");
            });
        });
    }

    @Test
    public void testSendEvent(TestContext context) {
        CountDownLatch latch = new CountDownLatch(1);
        this.commands.add(CommandBuilder.command((String)"foo").processHandler(process -> {
            process.suspendHandler(v -> process.end(0));
            latch.countDown();
        }));
        Shell shell = this.server.createShell();
        Job job = shell.createJob("foo");
        Async async = context.async();
        Pty pty = Pty.create();
        job.setTty(pty.slave()).statusUpdateHandler(CommandProcessTest.terminateHandler((Handler<Void>)((Handler)status -> async.complete()))).run();
        try {
            latch.await(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            context.fail((Throwable)e);
        }
        job.suspend();
    }

    @Test
    public void testResize(TestContext context) {
        this.commands.add(CommandBuilder.command((String)"foo").processHandler(process -> {
            context.assertEquals((Object)20, (Object)process.width());
            context.assertEquals((Object)10, (Object)process.height());
            process.resizehandler(v -> {
                context.assertEquals((Object)25, (Object)process.width());
                context.assertEquals((Object)15, (Object)process.height());
                process.end(0);
            });
            process.write("ping");
        }));
        Shell shell = this.server.createShell();
        Job job = shell.createJob("foo");
        Pty pty = Pty.create();
        Async async = context.async();
        pty.setSize(20, 10);
        pty.stdoutHandler(text -> pty.setSize(25, 15));
        job.setTty(pty.slave()).statusUpdateHandler(CommandProcessTest.terminateHandler((Handler<Void>)((Handler)status -> async.complete()))).run();
    }

    @Test
    public void testSessionGet(TestContext context) throws Exception {
        Async async = context.async();
        this.commands.add(CommandBuilder.command((String)"foo").processHandler(process -> {
            Session session = process.session();
            context.assertNotNull((Object)session);
            context.assertEquals((Object)"the_value", session.get("the_key"));
            process.end();
        }));
        Shell shell = this.server.createShell();
        Job job = shell.createJob("foo");
        SessionImpl session = new SessionImpl();
        session.put("the_key", (Object)"the_value");
        Pty pty = Pty.create();
        job.setSession((Session)session).setTty(pty.slave()).statusUpdateHandler(CommandProcessTest.terminateHandler((Handler<Void>)((Handler)status -> {
            context.assertEquals((Object)0, (Object)job.process().exitCode());
            async.complete();
        }))).run();
    }

    @Test
    public void testSessionPut(TestContext context) throws Exception {
        Async async = context.async();
        this.commands.add(CommandBuilder.command((String)"foo").processHandler(process -> {
            Session session = process.session();
            context.assertNotNull((Object)session);
            context.assertNull(session.get("the_key"));
            session.put("the_key", (Object)"the_value");
            process.end();
        }));
        Shell shell = this.server.createShell();
        Job job = shell.createJob("foo");
        Pty pty = Pty.create();
        SessionImpl session = new SessionImpl();
        job.setSession((Session)session).setTty(pty.slave()).statusUpdateHandler(CommandProcessTest.terminateHandler((Handler<Void>)((Handler)arg_0 -> ShellServerTest.lambda$testSessionPut$26(context, job, (Session)session, async, arg_0)))).run();
    }

    @Test
    public void testSessionRemove(TestContext context) throws Exception {
        Async async = context.async();
        this.commands.add(CommandBuilder.command((String)"foo").processHandler(process -> {
            Session session = process.session();
            context.assertNotNull((Object)session);
            context.assertEquals((Object)"the_value", session.remove("the_key"));
            process.end();
        }));
        Shell shell = this.server.createShell();
        Job job = shell.createJob("foo");
        Pty pty = Pty.create();
        SessionImpl session = new SessionImpl();
        session.put("the_key", (Object)"the_value");
        job.setSession((Session)session).setTty(pty.slave()).statusUpdateHandler(CommandProcessTest.terminateHandler((Handler<Void>)((Handler)arg_0 -> ShellServerTest.lambda$testSessionRemove$28(context, job, (Session)session, async, arg_0)))).run();
    }

    @Test
    public void testClose(TestContext context) {
        Async endLatch = context.async(2);
        Async runningLatch = context.async();
        this.commands.add(CommandBuilder.command((String)"foo").processHandler(process -> {
            process.endHandler(v -> endLatch.countDown());
            runningLatch.countDown();
        }));
        Shell shell = this.server.createShell();
        Job job = shell.createJob("foo");
        Pty pty = Pty.create();
        job.setTty(pty.slave()).statusUpdateHandler(CommandProcessTest.terminateHandler((Handler<Void>)((Handler)status -> endLatch.countDown()))).run();
        runningLatch.awaitSuccess(10000L);
        shell.close();
        endLatch.awaitSuccess(10000L);
        context.assertEquals((Object)0, (Object)shell.jobController().jobs().size());
    }

    private static /* synthetic */ void lambda$testSessionRemove$28(TestContext context, Job job, Session session, Async async, Void status) {
        context.assertEquals((Object)0, (Object)job.process().exitCode());
        context.assertNull(session.get("the_key"));
        async.complete();
    }

    private static /* synthetic */ void lambda$testSessionPut$26(TestContext context, Job job, Session session, Async async, Void status) {
        context.assertEquals((Object)0, (Object)job.process().exitCode());
        context.assertEquals((Object)"the_value", session.get("the_key"));
        async.complete();
    }
}

