/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.shell.cli;

import io.vertx.ext.shell.cli.CliToken;
import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class CliTokenTest {
    @Test
    public void testEmpty() {
        this.assertTokens("", new CliToken[0]);
    }

    @Test
    public void testDashes() {
        this.assertTokens("-", CliToken.createText((String)"-"));
        this.assertTokens("- ", CliToken.createText((String)"-"), CliToken.createBlank((String)" "));
        this.assertTokens("-\t", CliToken.createText((String)"-"), CliToken.createBlank((String)"\t"));
        this.assertTokens("--", CliToken.createText((String)"--"));
        this.assertTokens("-- ", CliToken.createText((String)"--"), CliToken.createBlank((String)" "));
        this.assertTokens("--\t", CliToken.createText((String)"--"), CliToken.createBlank((String)"\t"));
        this.assertTokens("---", CliToken.createText((String)"---"));
        this.assertTokens("--- ", CliToken.createText((String)"---"), CliToken.createBlank((String)" "));
        this.assertTokens("---\t", CliToken.createText((String)"---"), CliToken.createBlank((String)"\t"));
    }

    @Test
    public void testBlank() {
        this.assertTokens(" ", CliToken.createBlank((String)" "));
        this.assertTokens("\t", CliToken.createBlank((String)"\t"));
        this.assertTokens(" \t", CliToken.createBlank((String)" \t"));
        this.assertTokens("\t ", CliToken.createBlank((String)"\t "));
    }

    @Test
    public void testText() {
        this.assertTokens("a", CliToken.createText((String)"a"));
    }

    @Test
    public void testEscape() {
        this.assertTokens("\\ ", CliToken.createText((String)" "));
        this.assertTokens("\\\"", CliToken.createText((String)"\""));
        this.assertTokens("\\'", CliToken.createText((String)"'"));
        this.assertTokens("\"a\"", CliToken.createText((String)"a"));
        this.assertTokens("\" \"", CliToken.createText((String)" "));
        this.assertTokens("\"\\a\"", CliToken.createText((String)"\\a"));
        this.assertTokens("\"\\\"\"", CliToken.createText((String)"\""));
        this.assertTokens("'a'", CliToken.createText((String)"a"));
        this.assertTokens("' '", CliToken.createText((String)" "));
        this.assertTokens("'\\'", CliToken.createText((String)"\\"));
    }

    private void assertTokens(String s, CliToken ... expected) {
        List tokens = CliToken.tokenize((String)s);
        Assert.assertEquals(Arrays.asList(expected), (Object)tokens);
    }
}

