/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.shell.command;

import io.vertx.core.Vertx;
import io.vertx.ext.shell.cli.CliToken;
import io.vertx.ext.shell.cli.Completion;
import io.vertx.ext.shell.command.CommandBuilder;
import io.vertx.ext.shell.command.CommandRegistry;
import io.vertx.ext.shell.command.CommandResolver;
import io.vertx.ext.shell.session.Session;
import io.vertx.ext.shell.system.impl.InternalCommandManager;
import io.vertx.ext.unit.Async;
import io.vertx.ext.unit.TestContext;
import io.vertx.ext.unit.junit.RunTestOnContext;
import io.vertx.ext.unit.junit.VertxUnitRunner;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=VertxUnitRunner.class)
public class CompletionTest {
    @Rule
    public final RunTestOnContext rule = new RunTestOnContext();
    private CommandRegistry registry;
    private InternalCommandManager mgr;

    @Before
    public void before(TestContext context) {
        this.registry = CommandRegistry.getShared((Vertx)this.rule.vertx());
        this.registry.registerCommand(CommandBuilder.command((String)"foo").processHandler(proc -> {}).completionHandler(completion -> completion.complete("completed_by_foo", false)).build(this.rule.vertx()), context.asyncAssertSuccess(v1 -> this.registry.registerCommand(CommandBuilder.command((String)"bar").processHandler(proc -> {}).build(this.rule.vertx()), context.asyncAssertSuccess(v2 -> this.registry.registerCommand(CommandBuilder.command((String)"baz").processHandler(proc -> {}).build(this.rule.vertx()), context.asyncAssertSuccess(v3 -> this.registry.registerCommand(CommandBuilder.command((String)"err").processHandler(proc -> {}).completionHandler(completion -> {
            throw new RuntimeException("expected");
        }).build(this.rule.vertx()), context.asyncAssertSuccess())))))));
        this.mgr = new InternalCommandManager(new CommandResolver[]{this.registry});
    }

    @Test
    public void testEnumerateCommands(TestContext context) {
        final Async async = context.async();
        this.mgr.complete((Completion)new TestCompletion(context, ""){

            @Override
            public void complete(List<String> candidates) {
                this.context.assertEquals(Arrays.asList("bar", "baz", "err", "foo"), candidates.stream().sorted().collect(Collectors.toList()));
                async.complete();
            }
        });
    }

    @Test
    public void testSingleCommand(TestContext context) {
        final Async async = context.async();
        this.mgr.complete((Completion)new TestCompletion(context, "f"){

            @Override
            public void complete(String value, boolean terminal) {
                this.context.assertTrue(terminal);
                this.context.assertEquals((Object)"oo", (Object)value);
                async.complete();
            }
        });
    }

    @Test
    public void testExactCommand(TestContext context) {
        final Async async = context.async();
        this.mgr.complete((Completion)new TestCompletion(context, "foo"){

            @Override
            public void complete(String value, boolean terminal) {
                this.context.assertTrue(terminal);
                this.context.assertEquals((Object)"", (Object)value);
                async.complete();
            }
        });
    }

    @Test
    public void testAfterExactCommand(TestContext context) {
        final Async async = context.async();
        this.mgr.complete((Completion)new TestCompletion(context, "foo "){

            @Override
            public void complete(String value, boolean terminal) {
                this.context.assertFalse(terminal);
                this.context.assertEquals((Object)"completed_by_foo", (Object)value);
                async.complete();
            }
        });
    }

    @Test
    public void testNotFoundCommand(TestContext context) {
        final Async async = context.async();
        this.mgr.complete((Completion)new TestCompletion(context, "not_found"){

            @Override
            public void complete(List<String> candidates) {
                this.context.assertEquals(Collections.emptyList(), candidates);
                async.complete();
            }
        });
    }

    @Test
    public void testAfterNotFoundCommand(TestContext context) {
        final Async async = context.async();
        this.mgr.complete((Completion)new TestCompletion(context, "not_found "){

            @Override
            public void complete(List<String> candidates) {
                this.context.assertEquals(Collections.emptyList(), candidates);
                async.complete();
            }
        });
    }

    @Test
    public void testCommandWithCommonPrefix(TestContext context) {
        final Async async = context.async();
        this.mgr.complete((Completion)new TestCompletion(context, "b"){

            @Override
            public void complete(String value, boolean terminal) {
                this.context.assertFalse(terminal);
                this.context.assertEquals((Object)"a", (Object)value);
                async.complete();
            }
        });
    }

    @Test
    public void testCommands(TestContext context) {
        final Async async = context.async();
        this.mgr.complete((Completion)new TestCompletion(context, "ba"){

            @Override
            public void complete(List<String> candidates) {
                this.context.assertEquals(Arrays.asList("bar", "baz"), candidates.stream().sorted().collect(Collectors.toList()));
                async.complete();
            }
        });
    }

    @Test
    public void testFailure(TestContext context) {
        final Async async = context.async();
        this.mgr.complete((Completion)new TestCompletion(context, "err "){

            @Override
            public void complete(List<String> candidates) {
                this.context.assertEquals(Collections.emptyList(), candidates);
                async.complete();
            }
        });
    }

    class TestCompletion
    implements Completion {
        final TestContext context;
        final String line;

        public TestCompletion(TestContext context, String line) {
            this.line = line;
            this.context = context;
        }

        public Vertx vertx() {
            return CompletionTest.this.rule.vertx();
        }

        public Session session() {
            return null;
        }

        public String rawLine() {
            return this.line;
        }

        public List<CliToken> lineTokens() {
            return CliToken.tokenize((String)this.line);
        }

        public void complete(List<String> candidates) {
            this.context.fail();
        }

        public void complete(String value, boolean terminal) {
            this.context.fail();
        }
    }
}

