/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.shell.command.base;

import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.eventbus.DeliveryOptions;
import io.vertx.core.eventbus.Message;
import io.vertx.core.eventbus.ReplyException;
import io.vertx.core.eventbus.ReplyFailure;
import io.vertx.core.http.CaseInsensitiveHeaders;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.shell.Shell;
import io.vertx.ext.shell.ShellServer;
import io.vertx.ext.shell.command.CommandResolver;
import io.vertx.ext.shell.command.base.BaseCommandPack;
import io.vertx.ext.shell.system.ExecStatus;
import io.vertx.ext.shell.system.Job;
import io.vertx.ext.shell.term.Pty;
import io.vertx.ext.unit.Async;
import io.vertx.ext.unit.TestContext;
import io.vertx.ext.unit.junit.VertxUnitRunner;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=VertxUnitRunner.class)
public class BusTest {
    Vertx vertx;
    ShellServer server;

    @Before
    public void before(TestContext context) throws Exception {
        this.vertx = Vertx.vertx();
        this.server = ShellServer.create((Vertx)this.vertx).registerCommandResolver((CommandResolver)new BaseCommandPack(this.vertx)).listen(context.asyncAssertSuccess());
    }

    @After
    public void after(TestContext context) {
        this.vertx.close(context.asyncAssertSuccess());
    }

    @Test
    public void testBusSend(TestContext context) {
        Async consumerAsync = context.async();
        this.assertBusSend(context, "bus-send the_address the_message", msg -> {
            context.assertEquals((Object)"the_message", msg.body());
            consumerAsync.complete();
        });
    }

    @Test
    public void testBusSendHeader(TestContext context) {
        Async consumerAsync = context.async();
        this.assertBusSend(context, "bus-send --header=foo:bar the_address the_message", msg -> {
            context.assertEquals((Object)"the_message", msg.body());
            context.assertEquals(Collections.singleton("foo"), (Object)msg.headers().names());
            context.assertEquals(Collections.singletonList("bar"), (Object)msg.headers().getAll("foo"));
            consumerAsync.complete();
        });
    }

    @Test
    public void testBusSendHeaders(TestContext context) {
        Async consumerAsync = context.async();
        this.assertBusSend(context, "bus-send --header=foo:bar1 --header=foo:bar2 the_address the_message", msg -> {
            context.assertEquals((Object)"the_message", msg.body());
            context.assertEquals(Collections.singleton("foo"), (Object)msg.headers().names());
            context.assertEquals(Arrays.asList("bar1", "bar2"), (Object)msg.headers().getAll("foo"));
            consumerAsync.complete();
        });
    }

    @Test
    public void testBusSendReply(TestContext context) {
        Async consumerAsync = context.async();
        String result = this.assertBusSend(context, "bus-send --reply the_address the_message", msg -> {
            msg.reply((Object)"the_reply");
            context.assertEquals((Object)"the_message", msg.body());
            consumerAsync.complete();
        });
        context.assertEquals((Object)"Reply: <the_reply>\n", (Object)result);
    }

    @Test
    public void testBusSendReplyTimeout(TestContext context) {
        Async consumerAsync = context.async();
        String result = this.assertBusSend(context, "bus-send --reply --timeout 50 the_address the_message", msg -> {
            context.assertEquals((Object)"the_message", msg.body());
            consumerAsync.complete();
        });
        context.assertEquals((Object)"Error: Timed out after waiting 50(ms) for a reply. address: 1, repliedAddress: the_address\n", (Object)result);
    }

    @Test
    public void testBusSendReplyVerbose(TestContext context) {
        Async consumerAsync = context.async();
        String result = this.assertBusSend(context, "bus-send --reply --verbose the_address the_message", msg -> {
            msg.reply((Object)"the_reply", new DeliveryOptions().addHeader("header_name", "header_value_1").addHeader("header_name", "header_value_2"));
            context.assertEquals((Object)"the_message", msg.body());
            consumerAsync.complete();
        });
        context.assertEquals((Object)"Reply address: null\nReply header header_name:[header_value_1, header_value_2]\nReply: <the_reply>\n", (Object)result);
    }

    @Test
    public void testBusSendNull(TestContext context) {
        Async consumerAsync = context.async();
        this.assertBusSend(context, "bus-send the_address", msg -> {
            context.assertEquals(null, msg.body());
            consumerAsync.complete();
        });
    }

    @Test
    public void testBusSendString(TestContext context) {
        Async consumerAsync = context.async();
        this.assertBusSend(context, "bus-send --type STRING the_address hello_string", msg -> {
            context.assertEquals((Object)"hello_string", msg.body());
            consumerAsync.complete();
        });
    }

    @Test
    public void testBusSendBoolean(TestContext context) {
        Async consumerAsync = context.async();
        this.assertBusSend(context, "bus-send --type BOOLEAN the_address true", msg -> {
            context.assertEquals((Object)true, msg.body());
            consumerAsync.complete();
        });
    }

    @Test
    public void testBusSendByte(TestContext context) {
        Async consumerAsync = context.async();
        this.assertBusSend(context, "bus-send --type BYTE the_address 123", msg -> {
            context.assertEquals((Object)123, msg.body());
            consumerAsync.complete();
        });
    }

    @Test
    public void testBusSendShort(TestContext context) {
        Async consumerAsync = context.async();
        this.assertBusSend(context, "bus-send --type SHORT the_address 1234", msg -> {
            context.assertEquals((Object)1234, msg.body());
            consumerAsync.complete();
        });
    }

    @Test
    public void testBusSendInteger(TestContext context) {
        Async consumerAsync = context.async();
        this.assertBusSend(context, "bus-send --type INTEGER the_address 12345678", msg -> {
            context.assertEquals((Object)12345678, msg.body());
            consumerAsync.complete();
        });
    }

    @Test
    public void testBusSendLong(TestContext context) {
        Async consumerAsync = context.async();
        this.assertBusSend(context, "bus-send --type LONG the_address 12345678", msg -> {
            context.assertEquals((Object)12345678L, msg.body());
            consumerAsync.complete();
        });
    }

    @Test
    public void testBusSendFloat(TestContext context) {
        Async consumerAsync = context.async();
        this.assertBusSend(context, "bus-send --type FLOAT the_address 0.12", msg -> {
            context.assertEquals((Object)Float.valueOf(0.12f), msg.body());
            consumerAsync.complete();
        });
    }

    @Test
    public void testBusSendDouble(TestContext context) {
        Async consumerAsync = context.async();
        this.assertBusSend(context, "bus-send --type DOUBLE the_address 0.1234", msg -> {
            context.assertEquals((Object)0.1234, msg.body());
            consumerAsync.complete();
        });
    }

    @Test
    public void testBusSendCharacter(TestContext context) {
        Async consumerAsync = context.async();
        this.assertBusSend(context, "bus-send --type CHARACTER the_address A", msg -> {
            context.assertEquals((Object)Character.valueOf('A'), msg.body());
            consumerAsync.complete();
        });
    }

    @Test
    public void testBusSendJsonObject(TestContext context) {
        Async consumerAsync = context.async();
        this.assertBusSend(context, "bus-send --type JSON_OBJECT the_address '{\"foo\":\"foo_value\",\"bar\":3}'", msg -> {
            context.assertEquals((Object)new JsonObject().put("foo", "foo_value").put("bar", Integer.valueOf(3)), msg.body());
            consumerAsync.complete();
        });
    }

    @Test
    public void testBusSendArrayObject(TestContext context) {
        Async consumerAsync = context.async();
        this.assertBusSend(context, "bus-send --type JSON_ARRAY the_address '[\"foo\",3]'", msg -> {
            context.assertEquals((Object)new JsonArray().add("foo").add(Integer.valueOf(3)), msg.body());
            consumerAsync.complete();
        });
    }

    @Test
    public void testBusSendBuffer(TestContext context) {
        Async consumerAsync = context.async();
        this.assertBusSend(context, "bus-send --type BUFFER the_address hello_world", msg -> {
            context.assertEquals((Object)Buffer.buffer((String)"hello_world"), msg.body());
            consumerAsync.complete();
        });
    }

    @Test
    public void testBusSendHex(TestContext context) {
        Async consumerAsync = context.async();
        this.assertBusSend(context, "bus-send --type HEX the_address 001FFF", msg -> {
            context.assertEquals((Object)Buffer.buffer((byte[])new byte[]{0, 31, -1}), msg.body());
            consumerAsync.complete();
        });
    }

    @Test
    public void testBusSendBase64(TestContext context) {
        Async consumerAsync = context.async();
        this.assertBusSend(context, "bus-send --type BASE64 the_address " + new String(Base64.getEncoder().encode(new byte[]{0, 31, -1})), msg -> {
            context.assertEquals((Object)Buffer.buffer((byte[])new byte[]{0, 31, -1}), msg.body());
            consumerAsync.complete();
        });
    }

    @Test
    public void testBusSendNegativeLong(TestContext context) {
        Async consumerAsync = context.async();
        this.assertBusSend(context, "bus-send --type LONG the_address -12345678", msg -> {
            context.assertEquals((Object)-12345678L, msg.body());
            consumerAsync.complete();
        });
    }

    private <T> String assertBusSend(TestContext context, String cmd, Handler<Message<T>> handler) {
        Async terminatedLatch = context.async();
        this.vertx.eventBus().consumer("the_address", handler);
        Shell shell = this.server.createShell();
        Pty pty = Pty.create();
        StringBuffer result = new StringBuffer();
        pty.stdoutHandler(result::append);
        Job job = shell.createJob(cmd).setTty(pty.slave());
        job.statusUpdateHandler(status -> {
            if (status == ExecStatus.TERMINATED) {
                terminatedLatch.complete();
            }
        });
        job.run();
        terminatedLatch.awaitSuccess(5000L);
        return result.toString();
    }

    @Test
    public void testBusTail(TestContext context) {
        String expected = "the_address1:the_message1\nthe_address2:the_message2\nthe_address1:the_message3\n";
        this.assertBusTail(context, "bus-tail the_address1 the_address2", () -> {
            this.assertSend(context, "the_address1", "the_message1", 50);
            this.assertSend(context, "the_address2", "the_message2", 50);
            this.assertSend(context, "the_address1", "the_message3", 50);
        }, expected::equals);
    }

    @Test
    public void testBusTailVerbose(TestContext context) {
        String expected = "the_address:\nReply address: .*\nHeader header_name:\\[header_value\\]\nthe_message\n";
        Pattern p = Pattern.compile(expected);
        this.assertBusTail(context, "bus-tail --verbose the_address", () -> this.assertSend(context, "the_address", "the_message", new DeliveryOptions().setHeaders((MultiMap)new CaseInsensitiveHeaders()).addHeader("header_name", "header_value"), 50), s -> p.matcher((CharSequence)s).matches());
    }

    private void assertBusTail(TestContext context, String cmd, Runnable send, Predicate<String> check) {
        Async runningLatch = context.async();
        Shell shell = this.server.createShell();
        Pty pty = Pty.create();
        StringBuffer result = new StringBuffer();
        pty.stdoutHandler(result::append);
        Job job = shell.createJob(cmd).setTty(pty.slave());
        job.statusUpdateHandler(status -> {
            if (status == ExecStatus.RUNNING) {
                runningLatch.complete();
            }
        });
        job.run();
        runningLatch.awaitSuccess(5000L);
        send.run();
        long now = System.currentTimeMillis();
        while (!check.test(result.toString())) {
            context.assertTrue(System.currentTimeMillis() - now < 2000L);
        }
    }

    private void assertSend(TestContext context, String address, Object body, int times) {
        this.assertSend(context, address, body, new DeliveryOptions(), times);
    }

    private void assertSend(TestContext context, String address, Object body, DeliveryOptions options, int times) {
        context.assertTrue(times > 0);
        this.vertx.eventBus().send(address, body, options, ar -> {
            ReplyException ex;
            if (ar.failed() && (ex = (ReplyException)ar.cause()).failureType() == ReplyFailure.NO_HANDLERS) {
                this.assertSend(context, address, body, options, times - 1);
            }
        });
    }
}

