/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.shell.term;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.http.CaseInsensitiveHeaders;
import io.vertx.core.http.HttpClient;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.AbstractUser;
import io.vertx.ext.auth.AuthOptions;
import io.vertx.ext.auth.AuthProvider;
import io.vertx.ext.auth.shiro.ShiroAuthOptions;
import io.vertx.ext.auth.shiro.ShiroAuthRealmType;
import io.vertx.ext.shell.term.HttpTermOptions;
import io.vertx.ext.shell.term.TermServer;
import io.vertx.ext.unit.Async;
import io.vertx.ext.unit.TestContext;
import io.vertx.ext.unit.junit.VertxUnitRunner;
import java.io.File;
import java.net.URL;
import java.util.Arrays;
import java.util.Base64;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=VertxUnitRunner.class)
public abstract class HttpTermServerBase {
    protected Vertx vertx;
    private TermServer server;
    private final String basePath;

    public HttpTermServerBase(String basePath) {
        this.basePath = basePath;
    }

    @Before
    public void before() throws Exception {
        this.vertx = Vertx.vertx();
    }

    @After
    public void after(TestContext context) {
        this.vertx.close(context.asyncAssertSuccess());
    }

    protected abstract TermServer createServer(TestContext var1, HttpTermOptions var2);

    @Test
    public void testServerWrite(TestContext context) {
        Async async = context.async();
        this.server = this.createServer(context, new HttpTermOptions().setPort(8080));
        this.server.termHandler(term -> term.write("hello_from_server"));
        this.server.listen(context.asyncAssertSuccess(server -> {
            HttpClient client = this.vertx.createHttpClient();
            client.websocket(8080, "localhost", this.basePath + "/shell/websocket", ws -> ws.handler(buf -> {
                context.assertEquals((Object)"hello_from_server", (Object)buf.toString());
                async.complete();
            }), arg_0 -> ((TestContext)context).fail(arg_0));
        }));
    }

    @Test
    public void testServerRead(TestContext context) {
        Async async = context.async();
        this.server = this.createServer(context, new HttpTermOptions().setPort(8080));
        this.server.termHandler(term -> term.stdinHandler(buf -> {
            context.assertEquals((Object)"hello_from_client", buf);
            async.complete();
        }));
        this.server.listen(context.asyncAssertSuccess(server -> {
            HttpClient client = this.vertx.createHttpClient();
            client.websocket(8080, "localhost", this.basePath + "/shell/websocket", ws -> ws.writeFinalTextFrame(new JsonObject().put("action", "read").put("data", "hello_from_client").encode()), arg_0 -> ((TestContext)context).fail(arg_0));
        }));
    }

    @Test
    public void testInitialSize(TestContext context) {
        this.testSize(context, this.basePath + "/shell/websocket?cols=100&rows=50", 100, 50);
    }

    @Test
    public void testInitialSizeCols(TestContext context) {
        this.testSize(context, this.basePath + "/shell/websocket?cols=100", 100, 24);
    }

    @Test
    public void testInitialSizeRows(TestContext context) {
        this.testSize(context, this.basePath + "/shell/websocket?rows=50", 80, 50);
    }

    @Test
    public void testInitialSizeNegative1(TestContext context) {
        this.testSize(context, this.basePath + "/shell/websocket?cols=100&rows=-50", 80, 24);
    }

    @Test
    public void testInitialSizeNegative2(TestContext context) {
        this.testSize(context, this.basePath + "/shell/websocket?cols=-100&rows=50", 80, 24);
    }

    @Test
    public void testInitialSizeNegative3(TestContext context) {
        this.testSize(context, this.basePath + "/shell/websocket?rows=-50", 80, 24);
    }

    @Test
    public void testInitialSizeNegative4(TestContext context) {
        this.testSize(context, this.basePath + "/shell/websocket?cols=-100", 80, 24);
    }

    @Test
    public void testInitialSizeInvalid1(TestContext context) {
        this.testSize(context, this.basePath + "/shell/websocket?cols=100&rows=abc", 80, 24);
    }

    @Test
    public void testInitialSizeInvalid2(TestContext context) {
        this.testSize(context, this.basePath + "/shell/websocket?cols=abc&rows=50", 80, 24);
    }

    @Test
    public void testInitialSizeInvalid3(TestContext context) {
        this.testSize(context, this.basePath + "/shell/websocket?rows=abc", 80, 24);
    }

    @Test
    public void testInitialSizeInvalid4(TestContext context) {
        this.testSize(context, this.basePath + "/shell/websocket?cols=abc", 80, 24);
    }

    private void testSize(TestContext context, String uri, int expectedCols, int expectedRows) {
        Async async = context.async();
        this.server = this.createServer(context, new HttpTermOptions().setPort(8080));
        this.server.termHandler(term -> {
            context.assertEquals((Object)expectedCols, (Object)term.width());
            context.assertEquals((Object)expectedRows, (Object)term.height());
            async.complete();
        });
        this.server.listen(context.asyncAssertSuccess(server -> {
            HttpClient client = this.vertx.createHttpClient();
            client.websocket(8080, "localhost", uri, ws -> {}, arg_0 -> ((TestContext)context).fail(arg_0));
        }));
    }

    @Test
    public void testResize(TestContext context) {
        this.testResize(context, new JsonObject().put("action", "resize").put("cols", Integer.valueOf(100)).put("rows", Integer.valueOf(50)), 100, 50);
    }

    @Test
    public void testResizeCols(TestContext context) {
        this.testResize(context, new JsonObject().put("action", "resize").put("cols", Integer.valueOf(100)), 100, 24);
    }

    @Test
    public void testResizeRows(TestContext context) {
        this.testResize(context, new JsonObject().put("action", "resize").put("rows", Integer.valueOf(50)), 80, 50);
    }

    private void testResize(TestContext context, JsonObject event, int expectedCols, int expectedRows) {
        Async async = context.async();
        this.server = this.createServer(context, new HttpTermOptions().setPort(8080));
        this.server.termHandler(term -> term.resizehandler(v -> {
            context.assertEquals((Object)expectedCols, (Object)term.width());
            context.assertEquals((Object)expectedRows, (Object)term.height());
            async.complete();
        }));
        this.server.listen(context.asyncAssertSuccess(server -> {
            HttpClient client = this.vertx.createHttpClient();
            client.websocket(8080, "localhost", this.basePath + "/shell/websocket", ws -> ws.writeFinalTextFrame(event.encode()), arg_0 -> ((TestContext)context).fail(arg_0));
        }));
    }

    @Test
    public void testResizeInvalid(TestContext context) {
        Async async = context.async();
        this.server = this.createServer(context, new HttpTermOptions().setPort(8080));
        this.server.termHandler(term -> term.resizehandler(v -> context.fail()));
        this.server.listen(context.asyncAssertSuccess(server -> {
            HttpClient client = this.vertx.createHttpClient();
            client.websocket(8080, "localhost", this.basePath + "/shell/websocket", ws -> {
                ws.writeFinalTextFrame(new JsonObject().put("action", "resize").put("cols", Integer.valueOf(-50)).encode());
                this.vertx.setTimer(1000L, id -> async.complete());
            }, arg_0 -> ((TestContext)context).fail(arg_0));
        }));
    }

    @Test
    public void testSecure(TestContext context) {
        Async async = context.async();
        this.server = this.createServer(context, new HttpTermOptions().setAuthOptions((AuthOptions)new ShiroAuthOptions().setType(ShiroAuthRealmType.PROPERTIES).setConfig(new JsonObject().put("properties_path", "classpath:test-auth.properties"))).setPort(8080));
        this.server.termHandler(term -> term.write("hello"));
        this.server.listen(context.asyncAssertSuccess(server -> {
            HttpClient client = this.vertx.createHttpClient();
            client.websocket(8080, "localhost", this.basePath + "/shell/websocket", ws -> context.fail(), err -> client.websocket(8080, "localhost", this.basePath + "/shell/websocket", new CaseInsensitiveHeaders().add("Authorization", "Basic " + Base64.getEncoder().encodeToString("tim:sausages".getBytes())), ws -> ws.handler(buf -> {
                context.assertEquals((Object)"hello", (Object)buf.toString());
                async.complete();
            }), arg_0 -> ((TestContext)context).fail(arg_0)));
        }));
    }

    @Test
    public void testExternalAuthProvider(TestContext context) throws Exception {
        AtomicInteger count = new AtomicInteger();
        AuthProvider authProvider = (authInfo, resultHandler) -> {
            count.incrementAndGet();
            final String username = authInfo.getString("username");
            String password = authInfo.getString("password");
            if (username.equals("paulo") && password.equals("anothersecret")) {
                resultHandler.handle((Object)Future.succeededFuture((Object)new AbstractUser(){

                    protected void doIsPermitted(String permission, Handler<AsyncResult<Boolean>> resultHandler) {
                        resultHandler.handle((Object)Future.succeededFuture((Object)true));
                    }

                    public JsonObject principal() {
                        return new JsonObject().put("username", username);
                    }

                    public void setAuthProvider(AuthProvider authProvider) {
                    }
                }));
            } else {
                resultHandler.handle((Object)Future.failedFuture((String)"not authenticated"));
            }
        };
        Async async = context.async(2);
        this.server = this.createServer(context, new HttpTermOptions().setPort(8080));
        this.server.authProvider(authProvider);
        this.server.termHandler(term -> {
            context.assertEquals((Object)1, (Object)count.get());
            async.countDown();
        });
        this.server.listen(context.asyncAssertSuccess(server -> {
            HttpClient client = this.vertx.createHttpClient();
            client.websocket(8080, "localhost", this.basePath + "/shell/websocket", new CaseInsensitiveHeaders().add("Authorization", "Basic " + Base64.getEncoder().encodeToString("paulo:anothersecret".getBytes())), ws -> async.countDown(), arg_0 -> ((TestContext)context).fail(arg_0));
        }));
    }

    @Test
    public void testExternalAuthProviderFails(TestContext context) throws Exception {
        AtomicInteger count = new AtomicInteger();
        AuthProvider authProvider = (authInfo, resultHandler) -> {
            count.incrementAndGet();
            resultHandler.handle((Object)Future.failedFuture((String)"not authenticated"));
        };
        Async async = context.async();
        this.server = this.createServer(context, new HttpTermOptions().setPort(8080));
        this.server.authProvider(authProvider);
        this.server.termHandler(term -> context.fail());
        this.server.listen(context.asyncAssertSuccess(server -> {
            HttpClient client = this.vertx.createHttpClient();
            client.websocket(8080, "localhost", this.basePath + "/shell/websocket", new CaseInsensitiveHeaders().add("Authorization", "Basic " + Base64.getEncoder().encodeToString("paulo:anothersecret".getBytes())), ws -> context.fail(), err -> {
                Assert.assertEquals((long)1L, (long)count.get());
                async.complete();
            });
        }));
    }

    @Test
    public void testDifferentCharset(TestContext context) throws Exception {
        Async async = context.async();
        this.server = this.createServer(context, new HttpTermOptions().setPort(8080).setCharset("ISO_8859_1"));
        this.server.termHandler(term -> {
            term.write("\u20ac");
            term.close();
        });
        this.server.listen(context.asyncAssertSuccess(server -> {
            HttpClient client = this.vertx.createHttpClient();
            client.websocket(8080, "localhost", this.basePath + "/shell/websocket", new CaseInsensitiveHeaders().add("Authorization", "Basic " + Base64.getEncoder().encodeToString("paulo:anothersecret".getBytes())), ws -> ws.handler(buf -> {
                context.assertTrue(Arrays.equals(new byte[]{63}, buf.getBytes()));
                async.complete();
            }), arg_0 -> ((TestContext)context).fail(arg_0));
        }));
    }

    @Test
    public void testKeymapFromFilesystem(TestContext context) throws Exception {
        URL url = TermServer.class.getResource("/io/vertx/ext/shell/inputrc");
        File f = new File(url.toURI());
        Async async = context.async();
        this.server = this.createServer(context, new HttpTermOptions().setPort(8080).setIntputrc(f.getAbsolutePath()));
        this.server.termHandler(term -> {
            term.close();
            async.complete();
        });
        this.server.listen(context.asyncAssertSuccess(server -> {
            HttpClient client = this.vertx.createHttpClient();
            client.websocket(8080, "localhost", this.basePath + "/shell/websocket", new CaseInsensitiveHeaders().add("Authorization", "Basic " + Base64.getEncoder().encodeToString("paulo:anothersecret".getBytes())), ws -> ws.handler(buf -> {}), arg_0 -> ((TestContext)context).fail(arg_0));
        }));
    }
}

