/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.shell.term;

import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.ext.shell.term.TelnetTermOptions;
import io.vertx.ext.shell.term.Term;
import io.vertx.ext.shell.term.TermServer;
import io.vertx.ext.unit.Async;
import io.vertx.ext.unit.TestContext;
import io.vertx.ext.unit.junit.VertxUnitRunner;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.function.Consumer;
import org.apache.commons.net.telnet.EchoOptionHandler;
import org.apache.commons.net.telnet.SimpleOptionHandler;
import org.apache.commons.net.telnet.TelnetClient;
import org.apache.commons.net.telnet.TelnetOptionHandler;
import org.apache.commons.net.telnet.TerminalTypeOptionHandler;
import org.apache.commons.net.telnet.WindowSizeOptionHandler;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=VertxUnitRunner.class)
public class TelnetTermServerTest {
    private TelnetClient client;
    private Vertx vertx;
    private TermServer server;

    @Before
    public void before() throws Exception {
        this.vertx = Vertx.vertx();
        this.client = new TelnetClient();
        this.client.addOptionHandler((TelnetOptionHandler)new EchoOptionHandler(false, false, true, true));
        this.client.addOptionHandler((TelnetOptionHandler)new SimpleOptionHandler(0, false, false, true, true));
        this.client.addOptionHandler((TelnetOptionHandler)new TerminalTypeOptionHandler("xterm-color", false, false, true, false));
    }

    @After
    public void after(TestContext context) {
        if (this.client != null && this.client.isConnected()) {
            try {
                this.client.disconnect();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.vertx.close(context.asyncAssertSuccess());
    }

    private void startTelnet(TestContext context, Handler<Term> termHandler) {
        this.startTelnet(context, new TelnetTermOptions(), termHandler);
    }

    private void startTelnet(TestContext context, TelnetTermOptions options, Handler<Term> termHandler) {
        this.server = TermServer.createTelnetTermServer((Vertx)this.vertx, (TelnetTermOptions)options.setPort(4000));
        this.server.termHandler(termHandler);
        Async async = context.async();
        this.server.listen(context.asyncAssertSuccess(v -> async.complete()));
        async.awaitSuccess(5000L);
    }

    @Test
    public void testRead(TestContext context) throws IOException {
        Async async = context.async();
        this.startTelnet(context, (Handler<Term>)((Handler)term -> term.stdinHandler(s -> {
            context.assertEquals((Object)"hello_from_client", s);
            async.complete();
        })));
        this.client.connect("localhost", this.server.actualPort());
        OutputStreamWriter writer = new OutputStreamWriter(this.client.getOutputStream());
        writer.write("hello_from_client");
        ((Writer)writer).flush();
    }

    @Test
    public void testWrite(TestContext context) throws IOException {
        this.startTelnet(context, (Handler<Term>)((Handler)term -> term.write("hello_from_server")));
        this.client.connect("localhost", this.server.actualPort());
        InputStreamReader reader = new InputStreamReader(this.client.getInputStream());
        StringBuilder sb = new StringBuilder("hello_from_server");
        while (sb.length() > 0) {
            int c = ((Reader)reader).read();
            context.assertNotEquals((Object)-1, (Object)c);
            context.assertEquals((Object)c, (Object)sb.charAt(0));
            sb.deleteCharAt(0);
        }
    }

    @Test
    public void testCloseHandler(TestContext context) throws IOException {
        Async async1 = context.async();
        Async async2 = context.async();
        this.startTelnet(context, (Handler<Term>)((Handler)term -> {
            term.closeHandler(v -> async2.complete());
            async1.complete();
        }));
        this.client.connect("localhost", this.server.actualPort());
        async1.awaitSuccess(4000L);
        this.client.disconnect();
    }

    @Test
    public void testClose(TestContext context) throws Exception {
        this.testClose(context, term -> this.vertx.setTimer(10L, id -> term.close()));
    }

    @Test
    public void testCloseImmediatly(TestContext context) throws Exception {
        this.testClose(context, Term::close);
    }

    private void testClose(TestContext context, Consumer<Term> closer) throws Exception {
        Async async1 = context.async();
        Async async2 = context.async();
        this.startTelnet(context, (Handler<Term>)((Handler)term -> {
            term.closeHandler(v -> async2.complete());
            closer.accept((Term)term);
            async1.complete();
        }));
        this.client.connect("localhost", this.server.actualPort());
        async1.await(4000L);
        OutputStream out = this.client.getOutputStream();
        long now = System.currentTimeMillis();
        while (true) {
            context.assertTrue(System.currentTimeMillis() - now < 10000L);
            try {
                out.write(4);
                out.flush();
            }
            catch (IOException ignore) {
                break;
            }
            Thread.sleep(10L);
        }
    }

    @Test
    public void testType(TestContext context) throws Exception {
        Async async = context.async();
        this.startTelnet(context, (Handler<Term>)((Handler)term -> {
            long now = System.currentTimeMillis();
            this.vertx.setPeriodic(10L, id -> {
                context.assertTrue(System.currentTimeMillis() - now < 10000L);
                if (term.type() != null) {
                    this.vertx.cancelTimer(id.longValue());
                    context.assertEquals((Object)"xterm-color", (Object)term.type());
                    async.complete();
                }
            });
        }));
        this.client.connect("localhost", this.server.actualPort());
    }

    @Test
    public void testWindowSize(TestContext context) throws Exception {
        Async async = context.async();
        this.startTelnet(context, (Handler<Term>)((Handler)term -> {
            context.assertEquals((Object)-1, (Object)term.width());
            context.assertEquals((Object)-1, (Object)term.height());
            term.resizehandler(v -> {
                context.assertEquals((Object)10, (Object)term.width());
                context.assertEquals((Object)20, (Object)term.height());
                async.complete();
            });
        }));
        this.client.addOptionHandler((TelnetOptionHandler)new WindowSizeOptionHandler(10, 20, false, false, true, false));
        this.client.connect("localhost", this.server.actualPort());
    }

    @Test
    public void testOutBinaryTrue(TestContext context) throws Exception {
        this.startTelnet(context, new TelnetTermOptions().setOutBinary(true), (Handler<Term>)((Handler)term -> term.write("\u20ac")));
        this.client.addOptionHandler((TelnetOptionHandler)new WindowSizeOptionHandler(10, 20, false, false, true, false));
        this.client.connect("localhost", this.server.actualPort());
        InputStream in = this.client.getInputStream();
        context.assertEquals((Object)226, (Object)in.read());
        context.assertEquals((Object)130, (Object)in.read());
        context.assertEquals((Object)172, (Object)in.read());
    }

    @Test
    public void testOutBinaryFalse(TestContext context) throws Exception {
        byte[] expected = StandardCharsets.US_ASCII.encode("\u20ac").array();
        this.startTelnet(context, new TelnetTermOptions().setOutBinary(false), (Handler<Term>)((Handler)term -> term.write("\u20ac")));
        this.client.addOptionHandler((TelnetOptionHandler)new WindowSizeOptionHandler(10, 20, false, false, true, false));
        this.client.connect("localhost", this.server.actualPort());
        InputStream in = this.client.getInputStream();
        for (int i = 0; i < expected.length; ++i) {
            context.assertEquals((Object)expected[i], (Object)in.read());
        }
    }

    @Test
    public void testDifferentCharset(TestContext context) throws Exception {
        this.startTelnet(context, new TelnetTermOptions().setCharset("ISO_8859_1"), (Handler<Term>)((Handler)term -> {
            term.write("\u20ac");
            term.close();
        }));
        this.client.connect("localhost", this.server.actualPort());
        InputStream in = this.client.getInputStream();
        int b = in.read();
        context.assertEquals((Object)63, (Object)b);
    }

    @Test
    public void testKeymapFromFilesystem(TestContext context) throws Exception {
        URL url = TermServer.class.getResource("/io/vertx/ext/shell/inputrc");
        File f = new File(url.toURI());
        this.startTelnet(context, new TelnetTermOptions().setIntputrc(f.getAbsolutePath()), (Handler<Term>)((Handler)Term::close));
        this.client.connect("localhost", this.server.actualPort());
    }
}

