/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.shell.system.impl;

import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.ext.shell.session.Session;
import io.vertx.ext.shell.system.ExecStatus;
import io.vertx.ext.shell.system.Job;
import io.vertx.ext.shell.system.Process;
import io.vertx.ext.shell.system.impl.JobControllerImpl;
import io.vertx.ext.shell.term.Tty;

public class JobImpl
implements Job {
    final int id;
    final JobControllerImpl controller;
    final Process process;
    final String line;
    private volatile ExecStatus actualStatus;
    volatile long lastStopped;
    volatile Tty tty;
    volatile Session session;
    volatile Handler<ExecStatus> statusUpdateHandler;
    final Future<Void> terminateFuture;

    JobImpl(int id, JobControllerImpl controller, Process process, String line) {
        this.id = id;
        this.controller = controller;
        this.process = process;
        this.line = line;
        this.terminateFuture = Future.future();
        process.terminatedHandler((Handler<Integer>)((Handler)exitCode -> {
            if (controller.foregroundJob == this) {
                controller.foregroundJob = null;
                if (controller.foregroundUpdatedHandler != null) {
                    controller.foregroundUpdatedHandler.handle(null);
                }
            }
            controller.removeJob(this.id);
            if (this.statusUpdateHandler != null) {
                this.statusUpdateHandler.handle((Object)ExecStatus.TERMINATED);
            }
            this.terminateFuture.complete();
        }));
    }

    @Override
    public Job setSession(Session session) {
        this.session = session;
        return this;
    }

    public ExecStatus actualStatus() {
        return this.actualStatus;
    }

    @Override
    public Job statusUpdateHandler(Handler<ExecStatus> handler) {
        this.statusUpdateHandler = handler;
        return this;
    }

    @Override
    public boolean interrupt() {
        return this.process.interrupt();
    }

    @Override
    public Job resume(boolean foreground) {
        if (this.controller.foregroundJob != null) {
            throw new IllegalStateException();
        }
        try {
            this.process.resume(foreground, (Handler<Void>)((Handler)v -> {
                this.actualStatus = ExecStatus.RUNNING;
            }));
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        if (foreground) {
            this.controller.foregroundJob = this;
            if (this.controller.foregroundUpdatedHandler != null) {
                this.controller.foregroundUpdatedHandler.handle((Object)this);
            }
        }
        if (this.statusUpdateHandler != null) {
            this.statusUpdateHandler.handle((Object)this.process.status());
        }
        return this;
    }

    @Override
    public Job suspend() {
        try {
            this.process.suspend((Handler<Void>)((Handler)v -> {
                this.actualStatus = ExecStatus.STOPPED;
            }));
        }
        catch (IllegalStateException ignore) {
            return this;
        }
        if (this.controller.foregroundJob == this) {
            this.controller.foregroundJob = null;
            if (this.controller.foregroundUpdatedHandler != null) {
                this.controller.foregroundUpdatedHandler.handle(null);
            }
        }
        if (this.statusUpdateHandler != null) {
            this.statusUpdateHandler.handle((Object)this.process.status());
        }
        return this;
    }

    @Override
    public void terminate() {
        try {
            this.process.terminate();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Override
    public Process process() {
        return this.process;
    }

    @Override
    public long lastStopped() {
        return this.lastStopped;
    }

    @Override
    public ExecStatus status() {
        return this.process.status();
    }

    @Override
    public String line() {
        return this.line;
    }

    @Override
    public Job toBackground() {
        if (this.controller.foregroundJob == this) {
            this.controller.foregroundJob = null;
            this.process.toBackground();
            if (this.statusUpdateHandler != null) {
                this.statusUpdateHandler.handle((Object)this.process.status());
            }
        }
        return this;
    }

    @Override
    public Job toForeground() {
        if (this.controller.foregroundJob != null) {
            throw new IllegalStateException();
        }
        this.controller.foregroundJob = this;
        if (this.controller.foregroundUpdatedHandler != null) {
            this.controller.foregroundUpdatedHandler.handle((Object)this);
        }
        this.process.toForeground();
        if (this.statusUpdateHandler != null) {
            this.statusUpdateHandler.handle((Object)this.process.status());
        }
        return this;
    }

    @Override
    public int id() {
        return this.id;
    }

    @Override
    public Job setTty(Tty tty) {
        this.tty = tty;
        return this;
    }

    @Override
    public Job run() {
        this.controller.foregroundJob = this;
        if (this.controller.foregroundUpdatedHandler != null) {
            this.controller.foregroundUpdatedHandler.handle((Object)this);
        }
        this.actualStatus = ExecStatus.RUNNING;
        if (this.statusUpdateHandler != null) {
            this.statusUpdateHandler.handle((Object)ExecStatus.RUNNING);
        }
        this.process.setTty(this.tty);
        this.process.setSession(this.session);
        this.process.run();
        return this;
    }
}

