/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.shell.term.impl;

import io.netty.handler.codec.http.QueryStringDecoder;
import io.termd.core.http.HttpTtyConnection;
import io.termd.core.util.Vector;
import io.vertx.core.Context;
import io.vertx.core.buffer.Buffer;
import io.vertx.ext.web.handler.sockjs.SockJSSocket;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class SockJSTtyConnection
extends HttpTtyConnection {
    private final Context context;
    private final SockJSSocket socket;

    public SockJSTtyConnection(Charset charset, Context context, SockJSSocket socket) {
        super(charset, SockJSTtyConnection.getInitialSize(socket));
        this.context = context;
        this.socket = socket;
    }

    protected void write(byte[] bytes) {
        this.socket.write(Buffer.buffer((byte[])bytes));
    }

    public void close() {
        this.socket.close();
    }

    public void execute(Runnable runnable) {
        this.context.runOnContext(v -> runnable.run());
    }

    public void schedule(Runnable runnable, long l, TimeUnit timeUnit) {
        this.context.owner().setTimer(timeUnit.toMillis(l), id -> runnable.run());
    }

    private static Vector getInitialSize(SockJSSocket socket) {
        QueryStringDecoder decoder = new QueryStringDecoder(socket.uri());
        Map params = decoder.parameters();
        try {
            int cols = SockJSTtyConnection.getParamValue(params, "cols", 80);
            int rows = SockJSTtyConnection.getParamValue(params, "rows", 24);
            return new Vector(cols, rows);
        }
        catch (Exception e) {
            return new Vector(80, 24);
        }
    }

    private static int getParamValue(Map<String, List<String>> params, String paramName, int def) throws Exception {
        List<String> param = params.get(paramName);
        if (param != null && param.size() > 0) {
            int val = Integer.parseInt(param.get(0));
            if (val > 0) {
                return val;
            }
            throw new Exception("Negative size");
        }
        return def;
    }
}

