/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.runtime.adapter;

import com.sun.javafx.runtime.adapter.Resources;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.Rectangle2D;
import java.util.ResourceBundle;
import javax.swing.JPanel;

public class ErrorPanel
extends JPanel
implements MouseListener,
ActionListener {
    private Image errorImage = null;
    private static final String ERROR_IMAGE_FILE = "com/sun/javafx/runtime/adapter/icon-info16.png";
    private static final Color ERROR_BORDER = new Color(204, 204, 204);
    private Color bg_color = Color.WHITE;
    private Color fg_color = Color.BLACK;
    private PopupMenu popup;
    private MenuItem start_application;
    private ResourceBundle locale = new Resources();
    private ActionListener restartListener;

    public void addActionListener(ActionListener actionListener) {
        this.restartListener = actionListener;
    }

    public ErrorPanel() {
        this.setToolTipText(this.locale.getString("applet.error.message"));
        this.addMouseListener(this);
    }

    private synchronized Image getErrorImage() {
        if (this.errorImage == null) {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            this.errorImage = toolkit.createImage(Thread.currentThread().getContextClassLoader().getResource(ERROR_IMAGE_FILE));
            MediaTracker mediaTracker = new MediaTracker(this);
            mediaTracker.addImage(this.errorImage, 0);
            try {
                mediaTracker.waitForID(0);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return this.errorImage;
    }

    protected void paintComponent(Graphics graphics) {
        graphics.setColor(this.bg_color);
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        this.drawBorder(graphics2D, this.getSize());
        if (this.getWidth() > 24 && this.getHeight() > 24) {
            int n = 4;
            int n2 = 5;
            graphics2D.drawImage(this.getErrorImage(), n, n2, this.bg_color, null);
            this.drawMessage(graphics2D, this.locale.getString("applet.error.message"), this.getErrorImage().getWidth(null) + n + 7, this.getErrorImage().getHeight(null) + n2 - 4);
        }
        graphics2D.dispose();
    }

    private void drawBorder(Graphics graphics, Dimension dimension) {
        Color color = ERROR_BORDER;
        Color color2 = graphics.getColor();
        graphics.setColor(color);
        graphics.drawRect(0, 0, dimension.width - 1, dimension.height - 1);
        graphics.setColor(color2);
    }

    private void drawMessage(Graphics2D graphics2D, String string, int n, int n2) {
        Dimension dimension = this.getSize();
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        Rectangle2D rectangle2D = fontMetrics.getStringBounds(string, graphics2D);
        boolean bl = true;
        if (rectangle2D.getWidth() + (double)n > dimension.getWidth()) {
            int n3;
            bl = false;
            while (!bl && (n3 = string.lastIndexOf(" ")) != -1) {
                string = string.substring(0, n3);
                rectangle2D = fontMetrics.getStringBounds(string = string + "...", graphics2D);
                if (!(rectangle2D.getWidth() + (double)n < dimension.getWidth())) continue;
                bl = true;
            }
            if (!bl && (rectangle2D = fontMetrics.getStringBounds(string = "...", graphics2D)).getWidth() + (double)n < dimension.getWidth()) {
                bl = true;
            }
        }
        if (bl) {
            Color color = graphics2D.getColor();
            graphics2D.setColor(this.fg_color);
            graphics2D.drawString(string, n, n2);
            graphics2D.setColor(color);
        }
    }

    private PopupMenu getPopupMenu() {
        if (this.popup == null) {
            this.popup = new PopupMenu();
            this.start_application = new MenuItem(this.locale.getString("menu.start_application"));
            this.popup.add(this.start_application);
            this.start_application.addActionListener(this);
            this.add(this.popup);
        }
        return this.popup;
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            this.getPopupMenu().show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        } else if (mouseEvent.getButton() == 1) {
            this.onLeftMouseClick();
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            this.getPopupMenu().show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    private void restartApplet() {
        this.setVisible(false);
        if (this.restartListener != null) {
            this.restartListener.actionPerformed(null);
        }
    }

    private void onLeftMouseClick() {
        this.restartApplet();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.start_application) {
            this.restartApplet();
        }
    }
}

