/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.runtime.adapter;

import com.sun.java.browser.plugin2.liveconnect.v1.Bridge;
import com.sun.java.browser.plugin2.liveconnect.v1.BridgeFactory;
import com.sun.java.browser.plugin2.liveconnect.v1.ConversionDelegate;
import com.sun.java.browser.plugin2.liveconnect.v1.InvocationDelegate;
import com.sun.java.browser.plugin2.liveconnect.v1.Result;
import com.sun.javafx.runtime.liveconnect.FXConversionDelegate;
import com.sun.javafx.runtime.liveconnect.FXDelegate;
import java.applet.Applet;
import java.awt.EventQueue;
import java.lang.reflect.InvocationTargetException;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;

class LiveConnectBridgeImpl {
    static AWTFXDelegate awtfxdelegate = null;
    static FXConversionDelegate fxconversiondelegate = null;

    LiveConnectBridgeImpl() {
    }

    public static void install(Applet applet, String string) {
        Bridge bridge = BridgeFactory.getBridge((Applet)applet);
        awtfxdelegate = new AWTFXDelegate(bridge, string);
        fxconversiondelegate = new FXConversionDelegate(bridge);
        bridge.register((InvocationDelegate)awtfxdelegate);
        bridge.register((ConversionDelegate)fxconversiondelegate);
    }

    public static void uninstall(Applet applet) {
        Bridge bridge = BridgeFactory.getBridge((Applet)applet);
        bridge.unregister((InvocationDelegate)awtfxdelegate);
        bridge.unregister((ConversionDelegate)fxconversiondelegate);
    }

    static class AWTFXDelegate
    implements InvocationDelegate {
        private InvocationDelegate delegate;

        public AWTFXDelegate(Bridge bridge, String string) {
            this.delegate = new FXDelegate(bridge, string);
        }

        public boolean invoke(final String string, final Object object, final Object[] objectArray, final boolean bl, final boolean bl2, final Result[] resultArray) throws Exception {
            final boolean[] blArray = new boolean[1];
            final AccessControlContext accessControlContext = AccessController.getContext();
            this.runOnEDT(new Runnable(){

                public void run() {
                    try {
                        AccessController.doPrivileged(new PrivilegedExceptionAction(){

                            public Object run() throws Exception {
                                blArray[0] = AWTFXDelegate.this.delegate.invoke(string, object, objectArray, bl, bl2, resultArray);
                                return null;
                            }
                        }, accessControlContext);
                    }
                    catch (Exception exception) {
                        throw new RuntimeException(exception);
                    }
                }
            });
            return blArray[0];
        }

        public boolean getField(final String string, final Object object, final boolean bl, final boolean bl2, final Result[] resultArray) throws Exception {
            final boolean[] blArray = new boolean[1];
            final AccessControlContext accessControlContext = AccessController.getContext();
            this.runOnEDT(new Runnable(){

                public void run() {
                    try {
                        AccessController.doPrivileged(new PrivilegedExceptionAction(){

                            public Object run() throws Exception {
                                blArray[0] = AWTFXDelegate.this.delegate.getField(string, object, bl, bl2, resultArray);
                                return null;
                            }
                        }, accessControlContext);
                    }
                    catch (Exception exception) {
                        throw new RuntimeException(exception);
                    }
                }
            });
            return blArray[0];
        }

        public boolean setField(final String string, final Object object, final Object object2, final boolean bl, final boolean bl2) throws Exception {
            final boolean[] blArray = new boolean[1];
            final AccessControlContext accessControlContext = AccessController.getContext();
            this.runOnEDT(new Runnable(){

                public void run() {
                    try {
                        AccessController.doPrivileged(new PrivilegedExceptionAction(){

                            public Object run() throws Exception {
                                blArray[0] = AWTFXDelegate.this.delegate.setField(string, object, object2, bl, bl2);
                                return null;
                            }
                        }, accessControlContext);
                    }
                    catch (Exception exception) {
                        throw new RuntimeException(exception);
                    }
                }
            });
            return blArray[0];
        }

        public boolean hasField(final String string, final Object object, final boolean bl, final boolean bl2, final boolean[] blArray) {
            final boolean[] blArray2 = new boolean[1];
            final AccessControlContext accessControlContext = AccessController.getContext();
            try {
                this.runOnEDT(new Runnable(){

                    public void run() {
                        try {
                            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                                public Object run() throws Exception {
                                    blArray2[0] = AWTFXDelegate.this.delegate.hasField(string, object, bl, bl2, blArray);
                                    return null;
                                }
                            }, accessControlContext);
                        }
                        catch (Exception exception) {
                            throw new RuntimeException(exception);
                        }
                    }
                });
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
            return blArray2[0];
        }

        public boolean hasMethod(final String string, final Object object, final boolean bl, final boolean bl2, final boolean[] blArray) {
            final boolean[] blArray2 = new boolean[1];
            final AccessControlContext accessControlContext = AccessController.getContext();
            try {
                this.runOnEDT(new Runnable(){

                    public void run() {
                        try {
                            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                                public Object run() throws Exception {
                                    blArray2[0] = AWTFXDelegate.this.delegate.hasMethod(string, object, bl, bl2, blArray);
                                    return null;
                                }
                            }, accessControlContext);
                        }
                        catch (Exception exception) {
                            throw new RuntimeException(exception);
                        }
                    }
                });
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
            return blArray2[0];
        }

        public boolean hasFieldOrMethod(final String string, final Object object, final boolean bl, final boolean bl2, final boolean[] blArray) {
            final boolean[] blArray2 = new boolean[1];
            final AccessControlContext accessControlContext = AccessController.getContext();
            try {
                this.runOnEDT(new Runnable(){

                    public void run() {
                        try {
                            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                                public Object run() throws Exception {
                                    blArray2[0] = AWTFXDelegate.this.delegate.hasFieldOrMethod(string, object, bl, bl2, blArray);
                                    return null;
                                }
                            }, accessControlContext);
                        }
                        catch (Exception exception) {
                            throw new RuntimeException(exception);
                        }
                    }
                });
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
            return blArray2[0];
        }

        public Object findClass(final String string) {
            final Object[] objectArray = new Object[1];
            final AccessControlContext accessControlContext = AccessController.getContext();
            try {
                this.runOnEDT(new Runnable(){

                    public void run() {
                        try {
                            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                                public Object run() throws Exception {
                                    objectArray[0] = AWTFXDelegate.this.delegate.findClass(string);
                                    return null;
                                }
                            }, accessControlContext);
                        }
                        catch (Exception exception) {
                            throw new RuntimeException(exception);
                        }
                    }
                });
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
            return objectArray[0];
        }

        public Object newInstance(final Object object, final Object[] objectArray) throws Exception {
            final Object[] objectArray2 = new Object[1];
            final AccessControlContext accessControlContext = AccessController.getContext();
            this.runOnEDT(new Runnable(){

                public void run() {
                    try {
                        AccessController.doPrivileged(new PrivilegedExceptionAction(){

                            public Object run() throws Exception {
                                objectArray2[0] = AWTFXDelegate.this.delegate.newInstance(object, objectArray);
                                return null;
                            }
                        }, accessControlContext);
                    }
                    catch (Exception exception) {
                        throw new RuntimeException(exception);
                    }
                }
            });
            return objectArray2[0];
        }

        private void runOnEDT(Runnable runnable) throws Exception {
            if (EventQueue.isDispatchThread()) {
                runnable.run();
            } else {
                try {
                    EventQueue.invokeAndWait(runnable);
                }
                catch (InvocationTargetException invocationTargetException) {
                    Throwable throwable = invocationTargetException.getTargetException();
                    if (throwable instanceof Exception) {
                        throw (Exception)throwable;
                    }
                    if (throwable instanceof Error) {
                        throw (Error)throwable;
                    }
                    throw new RuntimeException(throwable);
                }
            }
        }
    }
}

