/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.tk.swing;

import com.sun.javafx.tk.TKScene;
import com.sun.javafx.tk.TKStage;
import com.sun.javafx.tk.TKStageListener;
import com.sun.javafx.tk.swing.FullScreenFrame;
import com.sun.javafx.tk.swing.FullScreenManager;
import com.sun.javafx.tk.swing.SwingScene;
import com.sun.javafx.tk.swing.WindowImpl;
import java.applet.Applet;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.List;
import javafx.stage.StageStyle;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;

public class WindowStage
implements TKStage,
KeyEventDispatcher {
    protected TKStageListener listener;
    protected TKScene scene;
    public Window window;
    private FullScreenFrame fswin;
    private int x;
    private int y;
    private int width;
    private int height;
    private float opacity = 1.0f;
    private boolean visible;
    private String title;
    private boolean stageFullScreen;
    private StageStyle stageStyle;
    private KeyboardFocusManager manager;
    protected boolean popupStage = false;
    protected static ArrayList<WindowStage> popupStack = new ArrayList();
    protected static boolean popupVisible = false;
    protected static boolean showPopup = false;
    protected static int focusedPopupIndex = -1;
    static Applet applet;

    public WindowStage(final Window window, StageStyle stageStyle, boolean bl) {
        this.window = window;
        this.popupStage = bl;
        this.initializeStyle(window, stageStyle);
        window.addComponentListener(new ComponentAdapter(){

            public void componentMoved(ComponentEvent componentEvent) {
                if (WindowStage.this.listener != null && WindowStage.this.fswin == null) {
                    Point point = window.getLocation();
                    if (point.x != WindowStage.this.x || point.y != WindowStage.this.y) {
                        WindowStage.this.listener.changedLocation((float)point.x, (float)point.y);
                    }
                    if (WindowStage.this.scene instanceof SwingScene) {
                        ((SwingScene)WindowStage.this.scene).updateSceneLocation();
                    }
                }
            }

            public void componentResized(ComponentEvent componentEvent) {
                if (WindowStage.this.listener != null && WindowStage.this.fswin == null) {
                    Dimension dimension = window.getSize();
                    if (dimension.width != WindowStage.this.width || dimension.height != WindowStage.this.height) {
                        WindowStage.this.listener.changedSize((float)dimension.width, (float)dimension.height);
                    }
                    if (WindowStage.this.scene instanceof SwingScene) {
                        ((SwingScene)WindowStage.this.scene).updateSceneLocation();
                    }
                }
            }
        });
        WindowAdapter windowAdapter = new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                if (WindowStage.this.listener != null && WindowStage.this.fswin == null) {
                    WindowStage.this.listener.closing();
                }
            }

            public void windowGainedFocus(WindowEvent windowEvent) {
                if (WindowStage.this.listener != null && WindowStage.this.fswin == null) {
                    WindowStage.this.listener.changedContainsFocus(true);
                }
            }

            public void windowLostFocus(WindowEvent windowEvent) {
                if (WindowStage.this.listener != null && WindowStage.this.fswin == null) {
                    WindowStage.this.listener.changedContainsFocus(false);
                }
                if (!popupStack.isEmpty() && focusedPopupIndex != -1 && focusedPopupIndex < popupStack.size()) {
                    WindowStage windowStage = popupStack.get(focusedPopupIndex);
                    WindowStage.this.updateContainsFocus(windowStage, false);
                    focusedPopupIndex = -1;
                }
            }
        };
        window.addWindowListener(windowAdapter);
        window.addWindowFocusListener(windowAdapter);
        window.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                WindowStage.this.requestFocusOnScene(true);
            }
        });
        if (bl) {
            window.setFocusableWindowState(false);
            this.manager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        }
    }

    protected void initializeStyle(Window window, StageStyle stageStyle) {
        this.stageStyle = stageStyle;
        if (stageStyle == StageStyle.TRANSPARENT) {
            Dimension dimension = window.getSize();
            if (dimension.getWidth() < 1.0 || dimension.getHeight() < 1.0) {
                window.setSize(new Dimension(1, 1));
            }
            WindowImpl.setWindowTransparency(window, true);
        }
    }

    public void setTKStageListener(TKStageListener tKStageListener) {
        this.listener = tKStageListener;
        if (this.fswin != null) {
            this.fswin.setTKStageListener(tKStageListener);
        }
    }

    protected void updateScene(TKScene tKScene) {
        this.scene = tKScene;
    }

    protected static void checkPopupStack() {
        popupVisible = !popupStack.isEmpty();
    }

    void setBackground(Color color) {
        if (this.stageStyle != StageStyle.TRANSPARENT) {
            this.window.setBackground(color);
        }
    }

    public void setScene(TKScene tKScene) {
        Object object;
        this.scene = tKScene;
        if (tKScene instanceof SwingScene) {
            object = (SwingScene)tKScene;
            ((SwingScene)object).windowStage = this;
            this.setBackground(((SwingScene)object).bgColor);
        }
        object = (RootPaneContainer)((Object)this.window);
        if (this.fswin != null) {
            object = this.fswin;
        }
        if (tKScene != null && ((SwingScene)tKScene).scenePanel != null) {
            SwingScene swingScene = (SwingScene)tKScene;
            object.setContentPane((Container)((Object)swingScene.scenePanel));
            swingScene.scenePanel.revalidate();
            swingScene.updateSceneLocation();
            this.requestFocusOnScene(true);
            MouseAdapter mouseAdapter = new MouseAdapter(){

                public void mousePressed(MouseEvent mouseEvent) {
                }

                public void mouseReleased(MouseEvent mouseEvent) {
                }

                public void mouseClicked(MouseEvent mouseEvent) {
                    WindowStage.this.simulateLogicalFocusChangeEvents(mouseEvent);
                }
            };
            swingScene.scenePanel.addMouseListener(mouseAdapter);
        } else {
            object.setContentPane(new JPanel());
        }
        object.getRootPane().revalidate();
    }

    void simulateLogicalFocusChangeEvents(MouseEvent mouseEvent) {
        if (this.popupStage) {
            int n;
            if (!showPopup && (n = popupStack.indexOf(this)) != -1 && n != focusedPopupIndex) {
                WindowStage windowStage = popupStack.get(n);
                this.updateContainsFocus(windowStage, true);
                if (focusedPopupIndex != -1 && focusedPopupIndex < popupStack.size()) {
                    windowStage = popupStack.get(focusedPopupIndex);
                    this.updateContainsFocus(windowStage, false);
                }
                focusedPopupIndex = n;
            }
        } else if (popupVisible && !showPopup && focusedPopupIndex != -1 && focusedPopupIndex < popupStack.size()) {
            WindowStage windowStage = popupStack.get(focusedPopupIndex);
            this.updateContainsFocus(windowStage, false);
            focusedPopupIndex = -1;
        }
    }

    public void setSizeAndLocation(float f, float f2, float f3, float f4) {
        if (applet != null && this.popupStage) {
            Point point = new Point(0, 0);
            SwingUtilities.convertPointToScreen(point, applet);
            if (Float.isNaN(f) && Float.isNaN(f2)) {
                this.setSize(f3, f4);
            } else if (Float.isNaN(f3) && Float.isNaN(f4)) {
                this.setLocation((float)point.x + f, (float)point.y + f2);
            } else {
                Rectangle rectangle = this.window.getBounds();
                if (!Float.isNaN(f)) {
                    rectangle.x = point.x + (int)f;
                }
                if (!Float.isNaN(f2)) {
                    rectangle.y = point.y + (int)f2;
                }
                if (!Float.isNaN(f3)) {
                    rectangle.width = (int)f3;
                }
                if (!Float.isNaN(f4)) {
                    rectangle.height = (int)f4;
                }
                this.window.setBounds(rectangle);
            }
        } else if (Float.isNaN(f) && Float.isNaN(f2)) {
            this.setSize(f3, f4);
        } else if (Float.isNaN(f3) && Float.isNaN(f4)) {
            this.setLocation(f, f2);
        } else {
            Rectangle rectangle = this.window.getBounds();
            if (!Float.isNaN(f)) {
                rectangle.x = (int)f;
            }
            if (!Float.isNaN(f2)) {
                rectangle.y = (int)f2;
            }
            if (!Float.isNaN(f3)) {
                rectangle.width = (int)f3;
            }
            if (!Float.isNaN(f4)) {
                rectangle.height = (int)f4;
            }
            this.window.setBounds(rectangle);
        }
    }

    private void setLocation(float f, float f2) {
        if (!Float.isNaN(f) && !Float.isNaN(f2)) {
            this.x = (int)f;
            this.y = (int)f2;
            this.window.setLocation(this.x, this.y);
        } else if (!Float.isNaN(f)) {
            this.x = (int)f;
            Point point = this.window.getLocation();
            point.x = this.x;
            this.window.setLocation(point);
        } else if (!Float.isNaN(f2)) {
            this.y = (int)f2;
            Point point = this.window.getLocation();
            point.y = this.y;
            this.window.setLocation(point);
        }
    }

    private void setSize(float f, float f2) {
        if (!Float.isNaN(f) && !Float.isNaN(f2)) {
            this.width = (int)f;
            this.height = (int)f2;
            this.window.setSize(this.width, this.height);
        } else if (!Float.isNaN(f)) {
            this.width = (int)f;
            Dimension dimension = this.window.getSize();
            dimension.width = this.width;
            this.window.setSize(dimension);
        } else if (!Float.isNaN(f2)) {
            this.height = (int)f2;
            Dimension dimension = this.window.getSize();
            dimension.height = this.height;
            this.window.setSize(dimension);
        }
    }

    public boolean dispatchKeyEvent(KeyEvent keyEvent) {
        if (!popupStack.isEmpty()) {
            SwingScene swingScene = (SwingScene)WindowStage.popupStack.get((int)(WindowStage.popupStack.size() - 1)).scene;
            this.manager.redispatchEvent((Component)((Object)swingScene.scenePanel), keyEvent);
            return true;
        }
        return false;
    }

    private void updateContainsFocus(WindowStage windowStage, boolean bl) {
        if (windowStage.listener != null && windowStage.fswin == null) {
            windowStage.listener.changedContainsFocus(bl);
        }
    }

    private void managePopupStackAndFocus(boolean bl) {
        if (bl) {
            if (popupStack.isEmpty()) {
                this.manager.addKeyEventDispatcher(this);
            }
            popupStack.add(this);
        } else if (this.visible && !bl) {
            WindowStage windowStage = null;
            if (focusedPopupIndex != -1) {
                windowStage = popupStack.get(focusedPopupIndex);
            }
            popupStack.remove(this);
            if (windowStage != null) {
                focusedPopupIndex = popupStack.indexOf(windowStage);
            }
            if (popupStack.isEmpty()) {
                this.manager.removeKeyEventDispatcher(this);
                popupVisible = false;
            }
        }
        if (bl && this.listener != null && this.fswin == null) {
            this.listener.changedContainsFocus(true);
            focusedPopupIndex = popupStack.indexOf(this);
            int n = popupStack.size() - 2;
            if (n >= 0) {
                WindowStage windowStage = popupStack.get(n);
                this.updateContainsFocus(windowStage, false);
            }
        }
    }

    public void setVisible(boolean bl) {
        Dimension dimension = this.window.getSize();
        if (dimension.getWidth() < 1.0 || dimension.getHeight() < 1.0) {
            this.window.setSize(new Dimension(1, 1));
        }
        if (this.popupStage) {
            this.managePopupStackAndFocus(bl);
        }
        this.visible = bl;
        if (this.fswin != null) {
            this.fswin.setVisible(bl);
        } else if (bl && this.stageFullScreen) {
            this.setFullScreen(true);
        } else {
            this.window.setVisible(bl);
        }
    }

    public void setFullScreen(boolean bl) {
        this.stageFullScreen = bl;
        if (bl ? !this.visible || this.fswin != null : this.fswin == null) {
            return;
        }
        if (bl) {
            this.fswin = FullScreenManager.createFSFrame(WindowImpl.getGraphicsDevice(this.window).getDefaultConfiguration());
            this.fswin.setTKStageListener(this.listener);
            this.fswin.setTitle(this.title);
            this.window.setVisible(false);
            if (this.stageStyle == StageStyle.TRANSPARENT) {
                WindowImpl.setWindowTransparency(this.window, false);
            }
            RootPaneContainer rootPaneContainer = (RootPaneContainer)((Object)this.window);
            Container container = rootPaneContainer.getContentPane();
            rootPaneContainer.setContentPane(new JPanel());
            rootPaneContainer = this.fswin;
            rootPaneContainer.setContentPane(container);
            this.window.dispose();
            this.fswin.enterFS();
        } else {
            this.fswin.exitFS();
            RootPaneContainer rootPaneContainer = this.fswin;
            Container container = rootPaneContainer.getContentPane();
            rootPaneContainer.setContentPane(new JPanel());
            rootPaneContainer = (RootPaneContainer)((Object)this.window);
            rootPaneContainer.setContentPane(container);
            this.fswin = null;
            if (this.stageStyle == StageStyle.TRANSPARENT) {
                WindowImpl.setWindowTransparency(this.window, true);
            }
            this.window.setVisible(this.visible);
            this.requestFocusOnScene(false);
            if (this.listener != null) {
                this.listener.changedSize((float)this.width, (float)this.height);
            }
        }
        if (this.listener != null) {
            this.listener.changedFullscreen(bl);
        }
    }

    public void setIcons(List list) {
        if (list != null && list.size() > 0) {
            try {
                Method method = AccessController.doPrivileged(new PrivilegedExceptionAction<Method>(){

                    @Override
                    public Method run() throws NoSuchMethodException {
                        return Window.class.getDeclaredMethod("setIconImages", List.class);
                    }
                });
                method.invoke((Object)this.window, list);
                return;
            }
            catch (PrivilegedActionException privilegedActionException) {
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
            catch (InvocationTargetException invocationTargetException) {
                invocationTargetException.printStackTrace();
            }
            if (this.window instanceof JFrame) {
                ((JFrame)this.window).setIconImage((Image)list.get(0));
            }
        }
    }

    public void setOpacity(float f) {
        if (f != this.opacity) {
            this.opacity = f;
            WindowImpl.setWindowOpacity(this.window, f);
        }
    }

    public void setIconified(boolean bl) {
    }

    public void setResizable(boolean bl) {
    }

    public void setTitle(String string) {
        this.title = string;
        if (this.fswin != null) {
            this.fswin.setTitle(string);
        }
    }

    public void sizeToScene() {
        this.window.pack();
        Dimension dimension = this.window.getSize();
        this.listener.changedSize((float)dimension.width, (float)dimension.height);
    }

    public void centerOnScreen() {
        this.window.setLocationRelativeTo(null);
        Point point = this.window.getLocation();
        this.listener.changedLocation((float)point.x, (float)point.y);
    }

    void requestFocusOnScene(boolean bl) {
        if (this.scene != null && ((SwingScene)this.scene).scenePanel != null) {
            SwingScene.SwingScenePanel swingScenePanel = ((SwingScene)this.scene).scenePanel;
            if (bl) {
                ((Component)((Object)swingScenePanel)).requestFocusInWindow();
            } else {
                ((Component)((Object)swingScenePanel)).requestFocus();
            }
        }
    }

    public void requestFocus() {
        this.requestFocusOnScene(false);
    }

    public void toBack() {
        this.window.toBack();
    }

    public void toFront() {
        this.window.toFront();
        if (this.popupStage) {
            showPopup = true;
        }
    }

    public void close() {
        if (this.fswin != null) {
            this.setFullScreen(false);
        }
        WindowImpl.dispose(this.window);
        this.window.dispose();
    }

    public void initSecurityContext() {
        FullScreenManager.init();
    }
}

