/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.context;

import com.sun.faces.component.visit.PartialVisitContext;
import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.OnOffResponseWrapper;
import com.sun.faces.util.Util;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.component.visit.VisitCallback;
import javax.faces.component.visit.VisitContext;
import javax.faces.component.visit.VisitHint;
import javax.faces.component.visit.VisitResult;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.PartialResponseWriter;
import javax.faces.context.PartialViewContext;
import javax.faces.context.ResponseWriter;
import javax.faces.event.PhaseId;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PartialViewContextImpl
extends PartialViewContext {
    private static Logger LOGGER = FacesLogger.CONTEXT.getLogger();
    private boolean released;
    private PartialResponseWriter partialResponseWriter;
    private Collection<String> executeIds;
    private Collection<String> renderIds;
    private Boolean ajaxRequest;
    private Boolean partialRequest;
    private Boolean renderAll;
    private FacesContext ctx;
    private static final String ORIGINAL_WRITER = "com.sun.faces.ORIGINAL_WRITER";

    public PartialViewContextImpl(FacesContext ctx) {
        this.ctx = ctx;
    }

    public boolean isAjaxRequest() {
        this.assertNotReleased();
        if (this.ajaxRequest == null) {
            this.ajaxRequest = "partial/ajax".equals(this.ctx.getExternalContext().getRequestHeaderMap().get("Faces-Request"));
        }
        return this.ajaxRequest;
    }

    public boolean isPartialRequest() {
        this.assertNotReleased();
        if (this.partialRequest == null) {
            this.partialRequest = this.isAjaxRequest() || "partial/process".equals(this.ctx.getExternalContext().getRequestHeaderMap().get("Faces-Request"));
        }
        return this.partialRequest;
    }

    public boolean isExecuteAll() {
        this.assertNotReleased();
        String execute = (String)this.ctx.getExternalContext().getRequestParameterMap().get("javax.faces.partial.execute");
        return "@all".equals(execute);
    }

    public boolean isRenderAll() {
        this.assertNotReleased();
        if (this.renderAll == null) {
            String render = (String)this.ctx.getExternalContext().getRequestParameterMap().get("javax.faces.partial.render");
            this.renderAll = "@all".equals(render);
        }
        return this.renderAll;
    }

    public void setRenderAll(boolean renderAll) {
        this.renderAll = renderAll;
    }

    public void setPartialRequest(boolean isPartialRequest) {
        this.partialRequest = isPartialRequest;
    }

    public Collection<String> getExecuteIds() {
        this.assertNotReleased();
        if (this.executeIds != null) {
            return this.executeIds;
        }
        this.executeIds = this.populatePhaseClientIds("javax.faces.partial.execute");
        return this.executeIds;
    }

    public Collection<String> getRenderIds() {
        this.assertNotReleased();
        if (this.renderIds != null) {
            return this.renderIds;
        }
        this.renderIds = this.populatePhaseClientIds("javax.faces.partial.render");
        return this.renderIds;
    }

    public void processPartial(PhaseId phaseId) {
        Collection<String> executeIds = this.getExecuteIds();
        Collection<String> renderIds = this.getRenderIds();
        UIViewRoot viewRoot = this.ctx.getViewRoot();
        if (phaseId == PhaseId.APPLY_REQUEST_VALUES || phaseId == PhaseId.PROCESS_VALIDATIONS || phaseId == PhaseId.UPDATE_MODEL_VALUES) {
            if (executeIds == null || executeIds.isEmpty()) {
                return;
            }
            try {
                this.processComponents((UIComponent)viewRoot, phaseId, executeIds, this.ctx);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (phaseId == PhaseId.APPLY_REQUEST_VALUES) {
                PartialResponseWriter writer = this.getPartialResponseWriter();
                this.ctx.setResponseWriter((ResponseWriter)writer);
            }
        } else if (phaseId == PhaseId.RENDER_RESPONSE) {
            try {
                OnOffResponseWrapper onOffResponse = new OnOffResponseWrapper(this.ctx);
                onOffResponse.setEnabled(true);
                PartialResponseWriter writer = this.getPartialResponseWriter();
                ResponseWriter orig = this.ctx.getResponseWriter();
                this.ctx.getAttributes().put(ORIGINAL_WRITER, orig);
                this.ctx.setResponseWriter((ResponseWriter)writer);
                ExternalContext exContext = this.ctx.getExternalContext();
                exContext.setResponseContentType("text/xml");
                exContext.addResponseHeader("Cache-Control", "no-cache");
                writer.startDocument();
                if (this.isRenderAll()) {
                    this.renderAll(this.ctx, viewRoot);
                    this.renderState(this.ctx);
                    writer.endDocument();
                    return;
                }
                if (renderIds != null && !renderIds.isEmpty()) {
                    this.processComponents((UIComponent)viewRoot, phaseId, renderIds, this.ctx);
                }
                this.renderState(this.ctx);
                writer.endDocument();
            }
            catch (IOException ex) {
                this.cleanupAfterView();
            }
            catch (RuntimeException ex) {
                this.cleanupAfterView();
                throw ex;
            }
        }
    }

    public PartialResponseWriter getPartialResponseWriter() {
        this.assertNotReleased();
        if (this.partialResponseWriter == null) {
            this.partialResponseWriter = this.createPartialResponseWriter();
        }
        return this.partialResponseWriter;
    }

    public void release() {
        this.released = true;
        this.ajaxRequest = null;
        this.renderAll = null;
        this.partialResponseWriter = null;
        this.executeIds = null;
        this.renderIds = null;
        this.ctx = null;
        this.partialRequest = null;
    }

    private Collection<String> populatePhaseClientIds(String parameterName) {
        Map requestParamMap = FacesContext.getCurrentInstance().getExternalContext().getRequestParameterMap();
        String param = (String)requestParamMap.get(parameterName);
        if (param == null) {
            return new ArrayList<String>();
        }
        String[] pcs = Util.split(param, "[ \t]+");
        return pcs != null && pcs.length != 0 ? new ArrayList<String>(Arrays.asList(pcs)) : new ArrayList<String>();
    }

    private void processComponents(UIComponent component, PhaseId phaseId, Collection<String> phaseClientIds, FacesContext context) throws IOException {
        EnumSet<VisitHint> hints = EnumSet.of(VisitHint.SKIP_UNRENDERED);
        PartialVisitContext visitContext = new PartialVisitContext(context, phaseClientIds, hints);
        PhaseAwareVisitCallback visitCallback = new PhaseAwareVisitCallback(this.ctx, phaseId);
        component.visitTree((VisitContext)visitContext, (VisitCallback)visitCallback);
    }

    private void renderAll(FacesContext context, UIViewRoot viewRoot) throws IOException {
        PartialResponseWriter writer = this.getPartialResponseWriter();
        writer.startUpdate("javax.faces.ViewRoot");
        Iterator itr = viewRoot.getFacetsAndChildren();
        while (itr.hasNext()) {
            UIComponent kid = (UIComponent)itr.next();
            kid.encodeAll(context);
        }
        writer.endUpdate();
    }

    private void renderState(FacesContext context) throws IOException {
        PartialResponseWriter writer = this.getPartialResponseWriter();
        writer.startUpdate("javax.faces.ViewState");
        String state = context.getApplication().getStateManager().getViewState(context);
        writer.write(state);
        writer.endUpdate();
    }

    private PartialResponseWriter createPartialResponseWriter() {
        Writer out;
        ResponseWriter responseWriter;
        String encoding;
        block4: {
            ExternalContext extContext = this.ctx.getExternalContext();
            encoding = extContext.getRequestCharacterEncoding();
            extContext.setResponseCharacterEncoding(encoding);
            responseWriter = null;
            out = null;
            try {
                out = extContext.getResponseOutputWriter();
            }
            catch (IOException ioe) {
                if (!LOGGER.isLoggable(Level.SEVERE)) break block4;
                LOGGER.log(Level.SEVERE, ioe.toString(), ioe);
            }
        }
        if (out != null) {
            responseWriter = this.ctx.getRenderKit().createResponseWriter(out, "text/xml", encoding);
        }
        if (responseWriter instanceof PartialResponseWriter) {
            return (PartialResponseWriter)responseWriter;
        }
        return new PartialResponseWriter(responseWriter);
    }

    private void cleanupAfterView() {
        ResponseWriter orig = (ResponseWriter)this.ctx.getAttributes().get(ORIGINAL_WRITER);
        assert (null != orig);
        this.ctx.setResponseWriter(orig);
    }

    private final void assertNotReleased() {
        if (this.released) {
            throw new IllegalStateException();
        }
    }

    private static class PhaseAwareVisitCallback
    implements VisitCallback {
        private PhaseId curPhase;
        private FacesContext ctx;

        private PhaseAwareVisitCallback(FacesContext ctx, PhaseId curPhase) {
            this.ctx = ctx;
            this.curPhase = curPhase;
        }

        public VisitResult visit(VisitContext context, UIComponent comp) {
            block9: {
                try {
                    if (this.curPhase == PhaseId.APPLY_REQUEST_VALUES) {
                        comp.processDecodes(this.ctx);
                        break block9;
                    }
                    if (this.curPhase == PhaseId.PROCESS_VALIDATIONS) {
                        comp.processValidators(this.ctx);
                        break block9;
                    }
                    if (this.curPhase == PhaseId.UPDATE_MODEL_VALUES) {
                        comp.processUpdates(this.ctx);
                        break block9;
                    }
                    if (this.curPhase == PhaseId.RENDER_RESPONSE) {
                        PartialResponseWriter writer;
                        block10: {
                            writer = this.ctx.getPartialViewContext().getPartialResponseWriter();
                            writer.startUpdate(comp.getClientId(this.ctx));
                            try {
                                comp.encodeAll(this.ctx);
                            }
                            catch (Exception ce) {
                                if (LOGGER.isLoggable(Level.SEVERE)) {
                                    LOGGER.severe(ce.toString());
                                }
                                if (!LOGGER.isLoggable(Level.FINE)) break block10;
                                LOGGER.log(Level.FINE, ce.toString(), ce);
                            }
                        }
                        writer.endUpdate();
                        break block9;
                    }
                    throw new IllegalStateException("I18N: Unexpected PhaseId passed to  PhaseAwareContextCallback: " + this.curPhase.toString());
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
            return VisitResult.REJECT;
        }
    }
}

