/*
 * Decompiled with CFR 0.152.
 */
package javax.slee;

import java.io.Serializable;
import java.io.StreamCorruptedException;

public final class AddressScreening
implements Serializable {
    public static final int ADDRESS_SCREENING_UNDEFINED = 0;
    public static final int ADDRESS_SCREENING_USER_NOT_VERIFIED = 1;
    public static final int ADDRESS_SCREENING_USER_VERIFIED_PASSED = 2;
    public static final int ADDRESS_SCREENING_USER_VERIFIED_FAILED = 3;
    public static final int ADDRESS_SCREENING_NETWORK = 4;
    public static final String UNDEFINED_STRING = "Undefined";
    public static final String USER_NOT_VERIFIED_STRING = "Not Verified";
    public static final String USER_VERIFIED_PASSED_STRING = "User Verified Passed";
    public static final String USER_VERIFIED_FAILED_STRING = "User Verified Failed";
    public static final String NETWORK_STRING = "Network";
    public static final AddressScreening UNDEFINED = new AddressScreening(0);
    public static final AddressScreening USER_NOT_VERIFIED = new AddressScreening(1);
    public static final AddressScreening USER_VERIFIED_PASSED = new AddressScreening(2);
    public static final AddressScreening USER_VERIFIED_FAILED = new AddressScreening(3);
    public static final AddressScreening NETWORK = new AddressScreening(4);
    private final int value;

    public static AddressScreening fromInt(int value) throws IllegalArgumentException {
        switch (value) {
            case 0: {
                return UNDEFINED;
            }
            case 1: {
                return USER_NOT_VERIFIED;
            }
            case 2: {
                return USER_VERIFIED_PASSED;
            }
            case 3: {
                return USER_VERIFIED_FAILED;
            }
            case 4: {
                return NETWORK;
            }
        }
        throw new IllegalArgumentException("Invalid value: " + value);
    }

    public AddressScreening fromString(String value) throws NullPointerException, IllegalArgumentException {
        if (value == null) {
            throw new NullPointerException("value is null");
        }
        if (value.equalsIgnoreCase(UNDEFINED_STRING)) {
            return UNDEFINED;
        }
        if (value.equalsIgnoreCase(USER_NOT_VERIFIED_STRING)) {
            return USER_NOT_VERIFIED;
        }
        if (value.equalsIgnoreCase(USER_VERIFIED_PASSED_STRING)) {
            return USER_VERIFIED_PASSED;
        }
        if (value.equalsIgnoreCase(USER_VERIFIED_FAILED_STRING)) {
            return USER_VERIFIED_FAILED;
        }
        if (value.equalsIgnoreCase(NETWORK_STRING)) {
            return NETWORK;
        }
        throw new IllegalArgumentException("Invalid value: " + value);
    }

    public int toInt() {
        return this.value;
    }

    public boolean isUndefined() {
        return this.value == 0;
    }

    public boolean isUserNotVerified() {
        return this.value == 1;
    }

    public boolean isUserVerifiedPassed() {
        return this.value == 2;
    }

    public boolean isUserVerifiedFailed() {
        return this.value == 3;
    }

    public boolean isNetwork() {
        return this.value == 4;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        return obj instanceof AddressScreening && ((AddressScreening)obj).value == this.value;
    }

    public int hashCode() {
        return this.value;
    }

    public String toString() {
        switch (this.value) {
            case 0: {
                return UNDEFINED_STRING;
            }
            case 1: {
                return USER_NOT_VERIFIED_STRING;
            }
            case 2: {
                return USER_VERIFIED_PASSED_STRING;
            }
            case 3: {
                return USER_VERIFIED_FAILED_STRING;
            }
            case 4: {
                return NETWORK_STRING;
            }
        }
        return "Address Screening in Unknown and Invalid State";
    }

    private AddressScreening(int value) {
        this.value = value;
    }

    private Object readResolve() throws StreamCorruptedException {
        try {
            return AddressScreening.fromInt(this.value);
        }
        catch (IllegalArgumentException iae) {
            throw new StreamCorruptedException("Invalid internal state found");
        }
    }
}

