/*
 * Decompiled with CFR 0.152.
 */
package javax.slee.management;

import javax.management.ObjectName;
import javax.slee.management.AbstractNotificationSource;
import javax.slee.management.NotificationSource;

public final class SubsystemNotification
extends AbstractNotificationSource
implements NotificationSource {
    public static final String ALARM_NOTIFICATION_TYPE = "javax.slee.management.alarm.subsystem";
    public static final String TRACE_NOTIFICATION_TYPE = "javax.slee.management.trace.subsystem";
    public static final String USAGE_NOTIFICATION_TYPE = "javax.slee.management.usage.subsystem";
    public static final String SUBSYSTEM_NAME_KEY = "subsystemName";
    private final String subsystemName;
    private static final String TYPE = SubsystemNotification.class.getName();

    public SubsystemNotification(String subsystemName) {
        if (subsystemName == null) {
            throw new NullPointerException("entityName is null");
        }
        this.subsystemName = subsystemName;
    }

    public String getSubsystemName() {
        return this.subsystemName;
    }

    public String getAlarmNotificationType() {
        return ALARM_NOTIFICATION_TYPE;
    }

    public String getTraceNotificationType() {
        return TRACE_NOTIFICATION_TYPE;
    }

    public String getUsageNotificationType() {
        return USAGE_NOTIFICATION_TYPE;
    }

    public static String getUsageMBeanProperties(String subsystemName) {
        if (subsystemName == null) {
            throw new NullPointerException("subsystemName is null");
        }
        return "subsystemName=" + ObjectName.quote(subsystemName);
    }

    public String getUsageMBeanProperties() {
        return SubsystemNotification.getUsageMBeanProperties(this.subsystemName);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof SubsystemNotification)) {
            return false;
        }
        return this.subsystemName.equals(((SubsystemNotification)obj).subsystemName);
    }

    public int hashCode() {
        return this.subsystemName.hashCode();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("SubsystemNotification[subsystem=").append(this.subsystemName).append(']');
        return buf.toString();
    }

    public int compareTo(Object obj) {
        if (obj == null) {
            throw new NullPointerException("obj is null");
        }
        if (obj == this) {
            return 0;
        }
        if (obj instanceof SubsystemNotification) {
            SubsystemNotification that = (SubsystemNotification)obj;
            return this.subsystemName.compareTo(that.subsystemName);
        }
        return super.compareTo(TYPE, obj);
    }

    protected String getClassName() {
        return TYPE;
    }
}

