/*
 * Decompiled with CFR 0.152.
 */
package javax.slee.profile.query;

import java.io.Serializable;
import java.text.Collator;
import java.util.Locale;

public final class QueryCollator
implements Serializable {
    private final Locale locale;
    private final boolean hasStrength;
    private final int strength;
    private final boolean hasDecomposition;
    private final int decomposition;
    private transient Collator collator;

    public QueryCollator(Locale locale) {
        this(locale, false, 0, false, 0);
    }

    public QueryCollator(Locale locale, int strength) {
        this(locale, true, strength, false, 0);
    }

    public QueryCollator(Locale locale, int strength, int decomposition) {
        this(locale, true, strength, true, decomposition);
    }

    public Locale getLocale() {
        return this.locale;
    }

    public boolean hasStrength() {
        return this.hasStrength;
    }

    public int getStrength() {
        return this.strength;
    }

    public boolean hasDecomposition() {
        return this.hasDecomposition;
    }

    public int getDecomposition() {
        return this.decomposition;
    }

    public Collator getCollator() {
        if (this.collator == null) {
            this.collator = Collator.getInstance(this.locale);
            if (this.hasStrength) {
                this.collator.setStrength(this.strength);
            }
            if (this.hasDecomposition) {
                this.collator.setDecomposition(this.decomposition);
            }
        }
        return this.collator;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof QueryCollator)) {
            return false;
        }
        QueryCollator that = (QueryCollator)obj;
        return this.locale.equals(that.locale) && this.hasStrength == that.hasStrength && this.strength == that.strength && this.hasDecomposition == that.hasDecomposition && this.decomposition == that.decomposition;
    }

    public int hashCode() {
        return this.locale.hashCode();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.locale);
        if (this.hasStrength) {
            buf.append(":strength=").append(this.getStrengthString());
        }
        if (this.hasDecomposition) {
            buf.append(":decomposition=").append(this.getDecompositionString());
        }
        return buf.toString();
    }

    private QueryCollator(Locale locale, boolean hasStrength, int strength, boolean hasDecomposition, int decomposition) {
        if (locale == null) {
            throw new NullPointerException("locale is null");
        }
        this.locale = locale;
        this.hasStrength = hasStrength;
        this.strength = strength;
        this.hasDecomposition = hasDecomposition;
        this.decomposition = decomposition;
    }

    private String getStrengthString() {
        switch (this.strength) {
            case 0: {
                return "primary";
            }
            case 1: {
                return "secondary";
            }
            case 2: {
                return "tertiary";
            }
            case 3: {
                return "identical";
            }
        }
        return "unknown";
    }

    private String getDecompositionString() {
        switch (this.decomposition) {
            case 0: {
                return "none";
            }
            case 1: {
                return "canonical";
            }
            case 2: {
                return "full";
            }
        }
        return "unknown";
    }
}

