/*
 * Decompiled with CFR 0.152.
 */
package javax.slee.resource;

public final class ActivityFlags {
    public static final int NO_FLAGS = 0;
    public static final int SLEE_MAY_MARSHAL = 1;
    public static final int REQUEST_ENDED_CALLBACK = 2;
    public static final int REQUEST_ACTIVITY_UNREFERENCED_CALLBACK = 4;
    public static final int STANDARD_FLAGS_MASK = 0xFFFFFF;
    public static final int VENDOR_FLAGS_MASK = -16777216;

    public static boolean hasNoFlags(int flags) {
        return flags == 0;
    }

    public static boolean hasStandardFlags(int flags) {
        return (flags & 0xFFFFFF) != 0;
    }

    public static boolean hasVendorFlags(int flags) {
        return (flags & 0xFF000000) != 0;
    }

    public static boolean hasFlags(int flags, int flagsToTestFor) {
        return (flags & flagsToTestFor) != 0;
    }

    public static boolean hasSleeMayMarshal(int flags) {
        return ActivityFlags.hasFlags(flags, 1);
    }

    public static boolean hasRequestEndedCallback(int flags) {
        return ActivityFlags.hasFlags(flags, 2);
    }

    public static boolean hasRequestSleeActivityGCCallback(int flags) {
        return ActivityFlags.hasFlags(flags, 4);
    }

    public static int setSleeMayMarshal(int currentFlags) {
        return currentFlags | 1;
    }

    public static int setRequestEndedCallback(int currentFlags) {
        return currentFlags | 2;
    }

    public static int setRequestSleeActivityGCCallback(int currentFlags) {
        return currentFlags | 4;
    }

    public static String toString(int flags) {
        if (ActivityFlags.hasNoFlags(flags)) {
            return "NO_FLAGS";
        }
        StringBuffer buf = new StringBuffer(64);
        if (ActivityFlags.hasFlags(flags, 1)) {
            buf.append("SLEE_MAY_MARSHAL");
        }
        if (ActivityFlags.hasFlags(flags, 2)) {
            if (buf.length() > 0) {
                buf.append('|');
            }
            buf.append("REQUEST_ENDED_CALLBACK");
        }
        if (ActivityFlags.hasFlags(flags, 4)) {
            if (buf.length() > 0) {
                buf.append('|');
            }
            buf.append("REQUEST_ACTIVITY_UNREFERENCED_CALLBACK");
        }
        if (ActivityFlags.hasFlags(flags, -16777216)) {
            if (buf.length() > 0) {
                buf.append('|');
            }
            buf.append("VENDOR_FLAGS == 0x").append(Integer.toHexString(flags & 0xFF000000));
        }
        return buf.toString();
    }

    private ActivityFlags() {
    }
}

