/*
 * Decompiled with CFR 0.152.
 */
package javax.slee.resource;

public final class EventFlags {
    public static final int NO_FLAGS = 0;
    public static final int SLEE_MAY_MARSHAL = 16;
    public static final int REQUEST_PROCESSING_SUCCESSFUL_CALLBACK = 32;
    public static final int REQUEST_PROCESSING_FAILED_CALLBACK = 64;
    public static final int REQUEST_EVENT_UNREFERENCED_CALLBACK = 128;
    public static final int SBB_PROCESSED_EVENT = 256;
    public static final int STANDARD_FLAGS_MASK = 0xFFFFFF;
    public static final int VENDOR_FLAGS_MASK = -16777216;

    public static boolean hasNoFlags(int flags) {
        return flags == 0;
    }

    public static boolean hasStandardFlags(int flags) {
        return (flags & 0xFFFFFF) != 0;
    }

    public static boolean hasVendorFlags(int flags) {
        return (flags & 0xFF000000) != 0;
    }

    public static boolean hasFlags(int flags, int flagsToTestFor) {
        return (flags & flagsToTestFor) != 0;
    }

    public static boolean hasSleeMayMarshal(int flags) {
        return EventFlags.hasFlags(flags, 16);
    }

    public static boolean hasRequestProcessingSuccessfulCallback(int flags) {
        return EventFlags.hasFlags(flags, 32);
    }

    public static boolean hasRequestProcessingFailedCallback(int flags) {
        return EventFlags.hasFlags(flags, 64);
    }

    public static boolean hasRequestEventReferenceReleasedCallback(int flags) {
        return EventFlags.hasFlags(flags, 128);
    }

    public static boolean hasSbbProcessedEvent(int flags) {
        return EventFlags.hasFlags(flags, 256);
    }

    public static int setSleeMayMarshal(int currentFlags) {
        return currentFlags | 0x10;
    }

    public static int setRequestProcessingSuccessfulCallback(int currentFlags) {
        return currentFlags | 0x20;
    }

    public static int setRequestProcessingFailedCallback(int currentFlags) {
        return currentFlags | 0x40;
    }

    public static int setRequestEventReferenceReleasedCallback(int currentFlags) {
        return currentFlags | 0x80;
    }

    public static int setSbbProcessedEvent(int currentFlags) {
        return currentFlags | 0x100;
    }

    public static String toString(int flags) {
        if (EventFlags.hasNoFlags(flags)) {
            return "NO_FLAGS";
        }
        StringBuffer buf = new StringBuffer(64);
        if (EventFlags.hasFlags(flags, 16)) {
            buf.append("SLEE_MAY_MARSHAL");
        }
        if (EventFlags.hasFlags(flags, 32)) {
            if (buf.length() > 0) {
                buf.append('|');
            }
            buf.append("REQUEST_PROCESSING_SUCCESSFUL_CALLBACK");
        }
        if (EventFlags.hasFlags(flags, 64)) {
            if (buf.length() > 0) {
                buf.append('|');
            }
            buf.append("REQUEST_PROCESSING_FAILED_CALLBACK");
        }
        if (EventFlags.hasFlags(flags, 128)) {
            if (buf.length() > 0) {
                buf.append('|');
            }
            buf.append("REQUEST_EVENT_UNREFERENCED_CALLBACK");
        }
        if (EventFlags.hasFlags(flags, 256)) {
            if (buf.length() > 0) {
                buf.append('|');
            }
            buf.append("SBB_PROCESSED_EVENT");
        }
        if (EventFlags.hasFlags(flags, -16777216)) {
            if (buf.length() > 0) {
                buf.append('|');
            }
            buf.append("VENDOR_FLAGS == 0x").append(Integer.toHexString(flags & 0xFF000000));
        }
        return buf.toString();
    }

    private EventFlags() {
    }
}

