/*
 * Decompiled with CFR 0.152.
 */
package javax.slee.usage;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import javax.management.Notification;
import javax.slee.SbbID;
import javax.slee.ServiceID;
import javax.slee.management.NotificationSource;
import javax.slee.management.SbbNotification;
import javax.slee.management.VendorExtensionUtils;
import javax.slee.management.VendorExtensions;
import javax.slee.usage.SbbUsageMBean;
import javax.slee.usage.UsageMBean;

public final class UsageNotification
extends Notification
implements VendorExtensions {
    private static final int VERSION_SLEE1_0 = 1;
    private static final int VERSION_SLEE1_1 = 2;
    private final NotificationSource notificationSource;
    private final ServiceID serviceID;
    private final SbbID sbbID;
    private final String paramSet;
    private final String paramName;
    private final boolean counter;
    private final long value;
    private final int version;
    private static volatile boolean vendorDataSerializationEnabled = false;
    private static volatile boolean vendorDataDeserializationEnabled = false;
    private transient Object vendorData;

    public UsageNotification(SbbUsageMBean sbbUsageMBean, ServiceID serviceID, SbbID sbbID, String paramSet, String paramName, boolean counter, long value, long sequenceNumber, long timestamp) throws NullPointerException {
        super("javax.slee.management.usage", sbbUsageMBean, sequenceNumber, timestamp, "Usage parameter \"" + paramName + "\" updated" + (paramSet != null ? " in usage parameter set " + paramSet : ""));
        if (sbbUsageMBean == null) {
            throw new NullPointerException("sbbUsageMBean is null");
        }
        if (serviceID == null) {
            throw new NullPointerException("serviceID is null");
        }
        if (sbbID == null) {
            throw new NullPointerException("sbbID is null");
        }
        if (paramName == null) {
            throw new NullPointerException("paramName is null");
        }
        this.serviceID = serviceID;
        this.sbbID = sbbID;
        this.paramSet = paramSet;
        this.paramName = paramName;
        this.counter = counter;
        this.value = value;
        this.notificationSource = new SbbNotification(serviceID, sbbID);
        this.version = 1;
    }

    public UsageNotification(String type, UsageMBean usageMBean, NotificationSource notificationSource, String paramSet, String paramName, boolean counter, long value, long sequenceNumber, long timestamp) throws NullPointerException {
        super(type, usageMBean, sequenceNumber, timestamp, "Usage parameter \"" + paramName + "\" updated" + (paramSet != null ? " in usage parameter set " + paramSet : "") + " for " + notificationSource);
        if (type == null) {
            throw new NullPointerException("type is null");
        }
        if (usageMBean == null) {
            throw new NullPointerException("usageMBean is null");
        }
        if (notificationSource == null) {
            throw new NullPointerException("notificationSource is null");
        }
        if (paramName == null) {
            throw new NullPointerException("paramName is null");
        }
        this.notificationSource = notificationSource;
        this.paramSet = paramSet;
        this.paramName = paramName;
        this.counter = counter;
        this.value = value;
        if (notificationSource instanceof SbbNotification) {
            SbbNotification sbbNotification = (SbbNotification)notificationSource;
            this.serviceID = sbbNotification.getService();
            this.sbbID = sbbNotification.getSbb();
        } else {
            this.serviceID = null;
            this.sbbID = null;
        }
        this.version = 2;
    }

    public NotificationSource getNotificationSource() {
        return this.notificationSource;
    }

    public ServiceID getService() {
        return this.serviceID;
    }

    public SbbID getSbb() {
        return this.sbbID;
    }

    public String getUsageParameterSetName() {
        return this.paramSet;
    }

    public String getUsageParameterName() {
        return this.paramName;
    }

    public boolean isCounter() {
        return this.counter;
    }

    public long getValue() {
        return this.value;
    }

    public static void enableVendorDataSerialization() {
        vendorDataSerializationEnabled = true;
    }

    public static void disableVendorDataSerialization() {
        vendorDataSerializationEnabled = false;
    }

    public static void enableVendorDataDeserialization() {
        vendorDataDeserializationEnabled = true;
    }

    public static void disableVendorDataDeserialization() {
        vendorDataDeserializationEnabled = false;
    }

    public void setVendorData(Object vendorData) {
        this.vendorData = vendorData;
    }

    public Object getVendorData() {
        return this.vendorData;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof UsageNotification)) {
            return false;
        }
        UsageNotification that = (UsageNotification)obj;
        if (this.version == 1) {
            if (that.version != 1) {
                return false;
            }
            return this.serviceID.equals(that.serviceID) && this.sbbID.equals(that.sbbID) && (this.paramSet == null ? that.paramSet == null : this.paramSet.equals(that.paramSet)) && this.paramName.equals(that.paramName) && this.counter == that.counter;
        }
        if (that.version != 2) {
            return false;
        }
        return ((Object)this.notificationSource).equals(that.notificationSource) && (this.paramSet == null ? that.paramSet == null : this.paramSet.equals(that.paramSet)) && this.paramName.equals(that.paramName) && this.counter == that.counter;
    }

    public int hashCode() {
        return this.paramSet != null ? this.paramSet.hashCode() ^ this.paramName.hashCode() : this.paramName.hashCode();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("UsageNotification[");
        if (this.version == 1) {
            buf.append("type=").append(this.getType()).append(",timestamp=").append(this.getTimeStamp()).append(",service=").append(this.serviceID).append(",sbb=").append(this.sbbID).append(",paramSet=").append(this.paramSet).append(",param=").append(this.paramName).append(",counter=").append(this.counter).append(",value=").append(this.value);
        } else {
            buf.append("type=").append(this.getType()).append(",source=").append(this.notificationSource).append(",paramSet=").append(this.paramSet).append(",param=").append(this.paramName).append(",counter=").append(this.counter).append(",value=").append(this.value).append(",timestamp=").append(this.getTimeStamp());
        }
        if (this.vendorData != null) {
            buf.append(",vendor data=").append(this.vendorData);
        }
        buf.append("]");
        return buf.toString();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        VendorExtensionUtils.writeObject(out, vendorDataSerializationEnabled ? this.vendorData : null);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.vendorData = VendorExtensionUtils.readObject(in, vendorDataDeserializationEnabled);
    }
}

