/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.xml.factory.objects;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import org.jfree.util.Configuration;
import org.jfree.util.Log;
import org.jfree.util.ReadOnlyIterator;
import org.jfree.xml.factory.objects.ObjectDescription;

public abstract class AbstractObjectDescription
implements ObjectDescription,
Cloneable {
    private Class className;
    private HashMap parameters;
    private HashMap parameterDefs;
    private Configuration config;

    public AbstractObjectDescription(Class className) {
        this.className = className;
        this.parameters = new HashMap();
        this.parameterDefs = new HashMap();
    }

    public Class getParameterDefinition(String name) {
        return (Class)this.parameterDefs.get(name);
    }

    public void setParameterDefinition(String name, Class obj) {
        if (obj == null) {
            this.parameterDefs.remove(name);
        } else {
            this.parameterDefs.put(name, obj);
        }
    }

    public static Class convertPrimitiveClass(Class obj) {
        if (!obj.isPrimitive()) {
            return obj;
        }
        if (obj == Boolean.TYPE) {
            return Boolean.class;
        }
        if (obj == Byte.TYPE) {
            return Byte.class;
        }
        if (obj == Character.TYPE) {
            return Character.class;
        }
        if (obj == Short.TYPE) {
            return Short.class;
        }
        if (obj == Integer.TYPE) {
            return Integer.class;
        }
        if (obj == Long.TYPE) {
            return Long.class;
        }
        if (obj == Float.TYPE) {
            return Float.class;
        }
        if (obj == Double.TYPE) {
            return Double.class;
        }
        throw new IllegalArgumentException("Class 'void' is not allowed here");
    }

    public void setParameter(String name, Object value) {
        if (this.getParameterDefinition(name) == null) {
            throw new IllegalArgumentException("No such Parameter defined: " + name + " in class " + this.getObjectClass());
        }
        Class parameterClass = AbstractObjectDescription.convertPrimitiveClass(this.getParameterDefinition(name));
        if (!parameterClass.isAssignableFrom(value.getClass())) {
            throw new ClassCastException("In Object " + this.getObjectClass() + ": Value is not assignable: " + value.getClass() + " is not assignable from " + parameterClass);
        }
        this.parameters.put(name, value);
    }

    public synchronized Iterator getParameterNames() {
        ArrayList parameterNames = new ArrayList(this.parameterDefs.keySet());
        Collections.sort(parameterNames);
        return new ReadOnlyIterator(parameterNames.iterator());
    }

    protected Iterator getDefinedParameterNames() {
        return new ReadOnlyIterator(this.parameters.keySet().iterator());
    }

    public Object getParameter(String name) {
        return this.parameters.get(name);
    }

    public Class getObjectClass() {
        return this.className;
    }

    public ObjectDescription getInstance() {
        try {
            AbstractObjectDescription c = (AbstractObjectDescription)super.clone();
            c.parameters = (HashMap)this.parameters.clone();
            return c;
        }
        catch (Exception e) {
            Log.error("Should not happen: Clone Error: ", e);
            return null;
        }
    }

    public ObjectDescription getUnconfiguredInstance() {
        try {
            AbstractObjectDescription c = (AbstractObjectDescription)super.clone();
            c.parameters = (HashMap)this.parameters.clone();
            c.config = null;
            return c;
        }
        catch (Exception e) {
            Log.error("Should not happen: Clone Error: ", e);
            return null;
        }
    }

    public void configure(Configuration config) {
        if (config == null) {
            throw new NullPointerException("The given configuration is null");
        }
        this.config = config;
    }

    public Configuration getConfig() {
        return this.config;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AbstractObjectDescription)) {
            return false;
        }
        AbstractObjectDescription abstractObjectDescription = (AbstractObjectDescription)o;
        return this.className.equals(abstractObjectDescription.className);
    }

    public int hashCode() {
        return this.className.hashCode();
    }
}

