/*
 * Decompiled with CFR 0.152.
 */
package me.dm7.barcodescanner.core;

import android.content.Context;
import android.graphics.Point;
import android.hardware.Camera;
import android.os.Handler;
import android.util.AttributeSet;
import android.util.Log;
import android.view.Display;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import java.util.List;
import me.dm7.barcodescanner.core.CameraWrapper;
import me.dm7.barcodescanner.core.DisplayUtils;

public class CameraPreview
extends SurfaceView
implements SurfaceHolder.Callback {
    private static final String TAG = "CameraPreview";
    private CameraWrapper mCameraWrapper;
    private Handler mAutoFocusHandler;
    private boolean mPreviewing = true;
    private boolean mAutoFocus = true;
    private boolean mSurfaceCreated = false;
    private boolean mShouldScaleToFill = true;
    private Camera.PreviewCallback mPreviewCallback;
    private Runnable doAutoFocus = new Runnable(){

        @Override
        public void run() {
            if (CameraPreview.this.mCameraWrapper != null && CameraPreview.this.mPreviewing && CameraPreview.this.mAutoFocus && CameraPreview.this.mSurfaceCreated) {
                CameraPreview.this.safeAutoFocus();
            }
        }
    };
    Camera.AutoFocusCallback autoFocusCB = new Camera.AutoFocusCallback(){

        public void onAutoFocus(boolean success, Camera camera) {
            CameraPreview.this.scheduleAutoFocus();
        }
    };

    public CameraPreview(Context context, CameraWrapper cameraWrapper, Camera.PreviewCallback previewCallback) {
        super(context);
        this.init(cameraWrapper, previewCallback);
    }

    public CameraPreview(Context context, AttributeSet attrs, CameraWrapper cameraWrapper, Camera.PreviewCallback previewCallback) {
        super(context, attrs);
        this.init(cameraWrapper, previewCallback);
    }

    public void init(CameraWrapper cameraWrapper, Camera.PreviewCallback previewCallback) {
        this.setCamera(cameraWrapper, previewCallback);
        this.mAutoFocusHandler = new Handler();
        this.getHolder().addCallback((SurfaceHolder.Callback)this);
        this.getHolder().setType(3);
    }

    public void setCamera(CameraWrapper cameraWrapper, Camera.PreviewCallback previewCallback) {
        this.mCameraWrapper = cameraWrapper;
        this.mPreviewCallback = previewCallback;
    }

    public void setShouldScaleToFill(boolean scaleToFill) {
        this.mShouldScaleToFill = scaleToFill;
    }

    public void surfaceCreated(SurfaceHolder surfaceHolder) {
        this.mSurfaceCreated = true;
    }

    public void surfaceChanged(SurfaceHolder surfaceHolder, int i, int i2, int i3) {
        if (surfaceHolder.getSurface() == null) {
            return;
        }
        this.stopCameraPreview();
        this.showCameraPreview();
    }

    public void surfaceDestroyed(SurfaceHolder surfaceHolder) {
        this.mSurfaceCreated = false;
        this.stopCameraPreview();
    }

    public void showCameraPreview() {
        if (this.mCameraWrapper != null) {
            try {
                this.getHolder().addCallback((SurfaceHolder.Callback)this);
                this.mPreviewing = true;
                this.setupCameraParameters();
                this.mCameraWrapper.mCamera.setPreviewDisplay(this.getHolder());
                this.mCameraWrapper.mCamera.setDisplayOrientation(this.getDisplayOrientation());
                this.mCameraWrapper.mCamera.setOneShotPreviewCallback(this.mPreviewCallback);
                this.mCameraWrapper.mCamera.startPreview();
                if (this.mAutoFocus) {
                    if (this.mSurfaceCreated) {
                        this.safeAutoFocus();
                    } else {
                        this.scheduleAutoFocus();
                    }
                }
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)e.toString(), (Throwable)e);
            }
        }
    }

    public void safeAutoFocus() {
        try {
            this.mCameraWrapper.mCamera.autoFocus(this.autoFocusCB);
        }
        catch (RuntimeException re) {
            this.scheduleAutoFocus();
        }
    }

    public void stopCameraPreview() {
        if (this.mCameraWrapper != null) {
            try {
                this.mPreviewing = false;
                this.getHolder().removeCallback((SurfaceHolder.Callback)this);
                this.mCameraWrapper.mCamera.cancelAutoFocus();
                this.mCameraWrapper.mCamera.setOneShotPreviewCallback(null);
                this.mCameraWrapper.mCamera.stopPreview();
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)e.toString(), (Throwable)e);
            }
        }
    }

    public void setupCameraParameters() {
        Camera.Size optimalSize = this.getOptimalPreviewSize();
        Camera.Parameters parameters = this.mCameraWrapper.mCamera.getParameters();
        parameters.setPreviewSize(optimalSize.width, optimalSize.height);
        this.mCameraWrapper.mCamera.setParameters(parameters);
        this.adjustViewSize(optimalSize);
    }

    private void adjustViewSize(Camera.Size cameraSize) {
        Point previewSize = this.convertSizeToLandscapeOrientation(new Point(this.getWidth(), this.getHeight()));
        float screenRatio = (float)previewSize.x / (float)previewSize.y;
        float cameraRatio = (float)cameraSize.width / (float)cameraSize.height;
        if (screenRatio > cameraRatio) {
            this.setViewSize((int)((float)previewSize.y * cameraRatio), previewSize.y);
        } else {
            this.setViewSize(previewSize.x, (int)((float)previewSize.x / cameraRatio));
        }
    }

    private Point convertSizeToLandscapeOrientation(Point size) {
        if (this.getDisplayOrientation() % 180 == 0) {
            return size;
        }
        return new Point(size.y, size.x);
    }

    private void setViewSize(int width, int height) {
        int tmpHeight;
        int tmpWidth;
        ViewGroup.LayoutParams layoutParams = this.getLayoutParams();
        if (this.getDisplayOrientation() % 180 == 0) {
            tmpWidth = width;
            tmpHeight = height;
        } else {
            tmpWidth = height;
            tmpHeight = width;
        }
        if (this.mShouldScaleToFill) {
            int parentHeight;
            float ratioHeight;
            int parentWidth = ((View)this.getParent()).getWidth();
            float ratioWidth = (float)parentWidth / (float)tmpWidth;
            float compensation = ratioWidth > (ratioHeight = (float)(parentHeight = ((View)this.getParent()).getHeight()) / (float)tmpHeight) ? ratioWidth : ratioHeight;
            tmpWidth = Math.round((float)tmpWidth * compensation);
            tmpHeight = Math.round((float)tmpHeight * compensation);
        }
        layoutParams.width = tmpWidth;
        layoutParams.height = tmpHeight;
        this.setLayoutParams(layoutParams);
    }

    public int getDisplayOrientation() {
        int result;
        if (this.mCameraWrapper == null) {
            return 0;
        }
        Camera.CameraInfo info = new Camera.CameraInfo();
        if (this.mCameraWrapper.mCameraId == -1) {
            Camera.getCameraInfo((int)0, (Camera.CameraInfo)info);
        } else {
            Camera.getCameraInfo((int)this.mCameraWrapper.mCameraId, (Camera.CameraInfo)info);
        }
        WindowManager wm = (WindowManager)this.getContext().getSystemService("window");
        Display display = wm.getDefaultDisplay();
        int rotation = display.getRotation();
        int degrees = 0;
        switch (rotation) {
            case 0: {
                degrees = 0;
                break;
            }
            case 1: {
                degrees = 90;
                break;
            }
            case 2: {
                degrees = 180;
                break;
            }
            case 3: {
                degrees = 270;
            }
        }
        if (info.facing == 1) {
            result = (info.orientation + degrees) % 360;
            result = (360 - result) % 360;
        } else {
            result = (info.orientation - degrees + 360) % 360;
        }
        return result;
    }

    private Camera.Size getOptimalPreviewSize() {
        if (this.mCameraWrapper == null) {
            return null;
        }
        List sizes = this.mCameraWrapper.mCamera.getParameters().getSupportedPreviewSizes();
        int w = this.getWidth();
        int h = this.getHeight();
        if (DisplayUtils.getScreenOrientation(this.getContext()) == 1) {
            int portraitWidth = h;
            h = w;
            w = portraitWidth;
        }
        double ASPECT_TOLERANCE = 0.1;
        double targetRatio = (double)w / (double)h;
        if (sizes == null) {
            return null;
        }
        Camera.Size optimalSize = null;
        double minDiff = Double.MAX_VALUE;
        int targetHeight = h;
        for (Camera.Size size : sizes) {
            double ratio = (double)size.width / (double)size.height;
            if (Math.abs(ratio - targetRatio) > 0.1 || !((double)Math.abs(size.height - targetHeight) < minDiff)) continue;
            optimalSize = size;
            minDiff = Math.abs(size.height - targetHeight);
        }
        if (optimalSize == null) {
            minDiff = Double.MAX_VALUE;
            for (Camera.Size size : sizes) {
                if (!((double)Math.abs(size.height - targetHeight) < minDiff)) continue;
                optimalSize = size;
                minDiff = Math.abs(size.height - targetHeight);
            }
        }
        return optimalSize;
    }

    public void setAutoFocus(boolean state) {
        if (this.mCameraWrapper != null && this.mPreviewing) {
            if (state == this.mAutoFocus) {
                return;
            }
            this.mAutoFocus = state;
            if (this.mAutoFocus) {
                if (this.mSurfaceCreated) {
                    Log.v((String)TAG, (String)"Starting autofocus");
                    this.safeAutoFocus();
                } else {
                    this.scheduleAutoFocus();
                }
            } else {
                Log.v((String)TAG, (String)"Cancelling autofocus");
                this.mCameraWrapper.mCamera.cancelAutoFocus();
            }
        }
    }

    private void scheduleAutoFocus() {
        this.mAutoFocusHandler.postDelayed(this.doAutoFocus, 1000L);
    }
}

