/*
 * Decompiled with CFR 0.152.
 */
package me.dm7.barcodescanner.core;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Point;
import android.graphics.Rect;
import android.util.AttributeSet;
import android.view.View;
import me.dm7.barcodescanner.core.DisplayUtils;
import me.dm7.barcodescanner.core.IViewFinder;
import me.dm7.barcodescanner.core.R;

public class ViewFinderView
extends View
implements IViewFinder {
    private static final String TAG = "ViewFinderView";
    private Rect mFramingRect;
    private static final float PORTRAIT_WIDTH_RATIO = 0.75f;
    private static final float PORTRAIT_WIDTH_HEIGHT_RATIO = 0.75f;
    private static final float LANDSCAPE_HEIGHT_RATIO = 0.625f;
    private static final float LANDSCAPE_WIDTH_HEIGHT_RATIO = 1.4f;
    private static final int MIN_DIMENSION_DIFF = 50;
    private static final float SQUARE_DIMENSION_RATIO = 0.625f;
    private static final int[] SCANNER_ALPHA = new int[]{0, 64, 128, 192, 255, 192, 128, 64};
    private int scannerAlpha;
    private static final int POINT_SIZE = 10;
    private static final long ANIMATION_DELAY = 80L;
    private final int mDefaultLaserColor = this.getResources().getColor(R.color.viewfinder_laser);
    private final int mDefaultMaskColor = this.getResources().getColor(R.color.viewfinder_mask);
    private final int mDefaultBorderColor = this.getResources().getColor(R.color.viewfinder_border);
    private final int mDefaultBorderStrokeWidth = this.getResources().getInteger(R.integer.viewfinder_border_width);
    private final int mDefaultBorderLineLength = this.getResources().getInteger(R.integer.viewfinder_border_length);
    protected Paint mLaserPaint;
    protected Paint mFinderMaskPaint;
    protected Paint mBorderPaint;
    protected int mBorderLineLength;
    protected boolean mSquareViewFinder;

    public ViewFinderView(Context context) {
        super(context);
        this.init();
    }

    public ViewFinderView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    private void init() {
        this.mLaserPaint = new Paint();
        this.mLaserPaint.setColor(this.mDefaultLaserColor);
        this.mLaserPaint.setStyle(Paint.Style.FILL);
        this.mFinderMaskPaint = new Paint();
        this.mFinderMaskPaint.setColor(this.mDefaultMaskColor);
        this.mBorderPaint = new Paint();
        this.mBorderPaint.setColor(this.mDefaultBorderColor);
        this.mBorderPaint.setStyle(Paint.Style.STROKE);
        this.mBorderPaint.setStrokeWidth((float)this.mDefaultBorderStrokeWidth);
        this.mBorderLineLength = this.mDefaultBorderLineLength;
    }

    public void setLaserColor(int laserColor) {
        this.mLaserPaint.setColor(laserColor);
    }

    public void setMaskColor(int maskColor) {
        this.mFinderMaskPaint.setColor(maskColor);
    }

    public void setBorderColor(int borderColor) {
        this.mBorderPaint.setColor(borderColor);
    }

    public void setBorderStrokeWidth(int borderStrokeWidth) {
        this.mBorderPaint.setStrokeWidth((float)borderStrokeWidth);
    }

    public void setBorderLineLength(int borderLineLength) {
        this.mBorderLineLength = borderLineLength;
    }

    public void setSquareViewFinder(boolean set) {
        this.mSquareViewFinder = set;
    }

    @Override
    public void setupViewFinder() {
        this.updateFramingRect();
        this.invalidate();
    }

    @Override
    public Rect getFramingRect() {
        return this.mFramingRect;
    }

    public void onDraw(Canvas canvas) {
        if (this.getFramingRect() == null) {
            return;
        }
        this.drawViewFinderMask(canvas);
        this.drawViewFinderBorder(canvas);
        this.drawLaser(canvas);
    }

    public void drawViewFinderMask(Canvas canvas) {
        int width = canvas.getWidth();
        int height = canvas.getHeight();
        Rect framingRect = this.getFramingRect();
        canvas.drawRect(0.0f, 0.0f, (float)width, (float)framingRect.top, this.mFinderMaskPaint);
        canvas.drawRect(0.0f, (float)framingRect.top, (float)framingRect.left, (float)(framingRect.bottom + 1), this.mFinderMaskPaint);
        canvas.drawRect((float)(framingRect.right + 1), (float)framingRect.top, (float)width, (float)(framingRect.bottom + 1), this.mFinderMaskPaint);
        canvas.drawRect(0.0f, (float)(framingRect.bottom + 1), (float)width, (float)height, this.mFinderMaskPaint);
    }

    public void drawViewFinderBorder(Canvas canvas) {
        Rect framingRect = this.getFramingRect();
        canvas.drawLine((float)(framingRect.left - 1), (float)(framingRect.top - 1), (float)(framingRect.left - 1), (float)(framingRect.top - 1 + this.mBorderLineLength), this.mBorderPaint);
        canvas.drawLine((float)(framingRect.left - 1), (float)(framingRect.top - 1), (float)(framingRect.left - 1 + this.mBorderLineLength), (float)(framingRect.top - 1), this.mBorderPaint);
        canvas.drawLine((float)(framingRect.left - 1), (float)(framingRect.bottom + 1), (float)(framingRect.left - 1), (float)(framingRect.bottom + 1 - this.mBorderLineLength), this.mBorderPaint);
        canvas.drawLine((float)(framingRect.left - 1), (float)(framingRect.bottom + 1), (float)(framingRect.left - 1 + this.mBorderLineLength), (float)(framingRect.bottom + 1), this.mBorderPaint);
        canvas.drawLine((float)(framingRect.right + 1), (float)(framingRect.top - 1), (float)(framingRect.right + 1), (float)(framingRect.top - 1 + this.mBorderLineLength), this.mBorderPaint);
        canvas.drawLine((float)(framingRect.right + 1), (float)(framingRect.top - 1), (float)(framingRect.right + 1 - this.mBorderLineLength), (float)(framingRect.top - 1), this.mBorderPaint);
        canvas.drawLine((float)(framingRect.right + 1), (float)(framingRect.bottom + 1), (float)(framingRect.right + 1), (float)(framingRect.bottom + 1 - this.mBorderLineLength), this.mBorderPaint);
        canvas.drawLine((float)(framingRect.right + 1), (float)(framingRect.bottom + 1), (float)(framingRect.right + 1 - this.mBorderLineLength), (float)(framingRect.bottom + 1), this.mBorderPaint);
    }

    public void drawLaser(Canvas canvas) {
        Rect framingRect = this.getFramingRect();
        this.mLaserPaint.setAlpha(SCANNER_ALPHA[this.scannerAlpha]);
        this.scannerAlpha = (this.scannerAlpha + 1) % SCANNER_ALPHA.length;
        int middle = framingRect.height() / 2 + framingRect.top;
        canvas.drawRect((float)(framingRect.left + 2), (float)(middle - 1), (float)(framingRect.right - 1), (float)(middle + 2), this.mLaserPaint);
        this.postInvalidateDelayed(80L, framingRect.left - 10, framingRect.top - 10, framingRect.right + 10, framingRect.bottom + 10);
    }

    protected void onSizeChanged(int xNew, int yNew, int xOld, int yOld) {
        this.updateFramingRect();
    }

    public synchronized void updateFramingRect() {
        int width;
        int height;
        Point viewResolution = new Point(this.getWidth(), this.getHeight());
        int orientation = DisplayUtils.getScreenOrientation(this.getContext());
        if (this.mSquareViewFinder) {
            if (orientation != 1) {
                width = height = (int)((float)this.getHeight() * 0.625f);
            } else {
                height = width = (int)((float)this.getWidth() * 0.625f);
            }
        } else if (orientation != 1) {
            height = (int)((float)this.getHeight() * 0.625f);
            width = (int)(1.4f * (float)height);
        } else {
            width = (int)((float)this.getWidth() * 0.75f);
            height = (int)(0.75f * (float)width);
        }
        if (width > this.getWidth()) {
            width = this.getWidth() - 50;
        }
        if (height > this.getHeight()) {
            height = this.getHeight() - 50;
        }
        int leftOffset = (viewResolution.x - width) / 2;
        int topOffset = (viewResolution.y - height) / 2;
        this.mFramingRect = new Rect(leftOffset, topOffset, leftOffset + width, topOffset + height);
    }
}

