/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.cj.xdevapi;

import com.mysql.cj.Messages;
import com.mysql.cj.util.StringUtils;
import com.mysql.cj.xdevapi.AbstractColumnDef;
import com.mysql.cj.xdevapi.ColumnDefinition;
import com.mysql.cj.xdevapi.Type;
import com.mysql.cj.xdevapi.XDevAPIError;
import java.util.HashMap;
import java.util.Map;

public final class ColumnDef
extends AbstractColumnDef<ColumnDefinition.StaticColumnDefinition>
implements ColumnDefinition.StaticColumnDefinition {
    protected String defaultExpr = null;
    protected boolean defaultExprWasSet = false;
    protected boolean autoIncrement = false;
    protected Map<String, String[]> foreignKey = new HashMap<String, String[]>();

    public ColumnDef(String columnName, Type columnType) {
        if (columnName == null) {
            throw new XDevAPIError(Messages.getString("CreateTableStatement.0", new String[]{"columnName"}));
        }
        if (columnType == null) {
            throw new XDevAPIError(Messages.getString("CreateTableStatement.0", new String[]{"columnType"}));
        }
        this.name = columnName;
        this.type = columnType;
    }

    public ColumnDef(String columnName, Type columnType, int length) {
        if (columnName == null) {
            throw new XDevAPIError(Messages.getString("CreateTableStatement.0", new String[]{"columnName"}));
        }
        if (columnType == null) {
            throw new XDevAPIError(Messages.getString("CreateTableStatement.0", new String[]{"columnType"}));
        }
        this.name = columnName;
        this.type = columnType;
        this.length = length;
    }

    @Override
    ColumnDefinition.StaticColumnDefinition self() {
        return this;
    }

    @Override
    public ColumnDefinition.StaticColumnDefinition setDefault(String expr) {
        this.defaultExpr = expr;
        this.defaultExprWasSet = true;
        return this.self();
    }

    @Override
    public ColumnDefinition.StaticColumnDefinition autoIncrement() {
        this.autoIncrement = true;
        return this.self();
    }

    @Override
    public ColumnDefinition.StaticColumnDefinition foreignKey(String tableName, String ... foreignColumnName) {
        if (tableName == null) {
            throw new XDevAPIError(Messages.getString("CreateTableStatement.0", new String[]{"tableName"}));
        }
        if (foreignColumnName == null) {
            throw new XDevAPIError(Messages.getString("CreateTableStatement.0", new String[]{"foreignColumnName"}));
        }
        for (String c : foreignColumnName) {
            if (c != null) continue;
            throw new XDevAPIError(Messages.getString("CreateTableStatement.1", new String[]{"foreignColumnName"}));
        }
        this.foreignKey.put(tableName, foreignColumnName);
        return this.self();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.name);
        sb.append(" ").append(this.getMysqlType());
        if (this.notNull != null) {
            sb.append(this.notNull != false ? " NOT NULL" : " NULL");
        }
        if (this.defaultExprWasSet) {
            sb.append(" DEFAULT ").append(this.defaultExpr);
        }
        if (this.autoIncrement) {
            sb.append(" AUTO_INCREMENT");
        }
        if (this.primaryKey) {
            sb.append(" PRIMARY KEY");
        } else if (this.uniqueIndex) {
            sb.append(" UNIQUE KEY");
        }
        if (this.comment != null && !this.comment.isEmpty()) {
            sb.append(" COMMENT ").append(StringUtils.quoteIdentifier(this.comment, "'", true));
        }
        return sb.toString();
    }
}

