/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.implementation.bind.annotation;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import net.bytebuddy.description.annotation.AnnotationDescription;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.method.MethodList;
import net.bytebuddy.description.method.ParameterDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.auxiliary.TypeProxy;
import net.bytebuddy.implementation.bind.MethodDelegationBinder;
import net.bytebuddy.implementation.bind.annotation.TargetMethodAnnotationDrivenBinder;
import net.bytebuddy.implementation.bytecode.assign.Assigner;
import net.bytebuddy.matcher.ElementMatchers;

@Documented
@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.PARAMETER})
public @interface Default {
    public boolean serializableProxy() default false;

    public Class<?> proxyType() default void.class;

    public static enum Binder implements TargetMethodAnnotationDrivenBinder.ParameterBinder<Default>
    {
        INSTANCE;

        private static final MethodDescription.InDefinedShape SERIALIZABLE_PROXY;
        private static final MethodDescription.InDefinedShape PROXY_TYPE;

        @Override
        public Class<Default> getHandledType() {
            return Default.class;
        }

        @Override
        public MethodDelegationBinder.ParameterBinding<?> bind(AnnotationDescription.Loadable<Default> annotation, MethodDescription source, ParameterDescription target, Implementation.Target implementationTarget, Assigner assigner) {
            TypeDescription proxyType = TypeLocator.ForType.of(annotation.getValue(PROXY_TYPE).resolve(TypeDescription.class)).resolve(target.getType());
            if (!proxyType.isInterface()) {
                throw new IllegalStateException(target + " uses the @Default annotation on an invalid type");
            }
            if (source.isStatic() || !implementationTarget.getInstrumentedType().getInterfaces().asErasures().contains(proxyType)) {
                return MethodDelegationBinder.ParameterBinding.Illegal.INSTANCE;
            }
            return new MethodDelegationBinder.ParameterBinding.Anonymous(new TypeProxy.ForDefaultMethod(proxyType, implementationTarget, annotation.getValue(SERIALIZABLE_PROXY).resolve(Boolean.class)));
        }

        public String toString() {
            return "Default.Binder." + this.name();
        }

        static {
            MethodList<MethodDescription.InDefinedShape> annotationProperties = new TypeDescription.ForLoadedType(Default.class).getDeclaredMethods();
            SERIALIZABLE_PROXY = (MethodDescription.InDefinedShape)((MethodList)annotationProperties.filter(ElementMatchers.named("serializableProxy"))).getOnly();
            PROXY_TYPE = (MethodDescription.InDefinedShape)((MethodList)annotationProperties.filter(ElementMatchers.named("proxyType"))).getOnly();
        }

        protected static interface TypeLocator {
            public TypeDescription resolve(TypeDescription.Generic var1);

            public static class ForType
            implements TypeLocator {
                private final TypeDescription typeDescription;

                protected ForType(TypeDescription typeDescription) {
                    this.typeDescription = typeDescription;
                }

                protected static TypeLocator of(TypeDescription typeDescription) {
                    if (typeDescription.represents(Void.TYPE)) {
                        return ForParameterType.INSTANCE;
                    }
                    if (!typeDescription.isInterface()) {
                        throw new IllegalStateException("Cannot assign proxy to " + typeDescription);
                    }
                    return new ForType(typeDescription);
                }

                @Override
                public TypeDescription resolve(TypeDescription.Generic parameterType) {
                    if (!this.typeDescription.isAssignableTo(parameterType.asErasure())) {
                        throw new IllegalStateException("Impossible to assign " + this.typeDescription + " to parameter of type " + parameterType);
                    }
                    return this.typeDescription;
                }

                public boolean equals(Object other) {
                    if (this == other) {
                        return true;
                    }
                    if (other == null || this.getClass() != other.getClass()) {
                        return false;
                    }
                    ForType forType = (ForType)other;
                    return this.typeDescription.equals(forType.typeDescription);
                }

                public int hashCode() {
                    return this.typeDescription.hashCode();
                }

                public String toString() {
                    return "Default.Binder.TypeLocator.ForType{typeDescription=" + this.typeDescription + '}';
                }
            }

            public static enum ForParameterType implements TypeLocator
            {
                INSTANCE;


                @Override
                public TypeDescription resolve(TypeDescription.Generic parameterType) {
                    return parameterType.asErasure();
                }

                public String toString() {
                    return "Default.Binder.TypeLocator.ForParameterType." + this.name();
                }
            }
        }
    }
}

