/*
 * Decompiled with CFR 0.152.
 */
package net.codesup.utilities.basen;

import java.math.BigInteger;
import java.util.Arrays;
import java.util.UUID;

public class AnyBaseEncoder {
    public static final String WHITESPACE_ALPHABET = " \t\n\r\u000b\u0085\u00a0\u2000\u2001\u2002\u2004\u2005\u2006\u2007\u2008\u2009\u200a";
    public static final String BASE_32_HEX_ALPHABET = "0123456789ABCDEFGHIJKLMNOPQRSTUV";
    public static final String BASE_32_ALPHABET = "ABCDEFGHIJKLMNOPQRSTUVWXYZ234567";
    public static final String BASE_36_ALPHABET = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    public static final String BASE_52_ALPHABET = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";
    public static final String BASE_62_ALPHABET = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";
    public static final String BASE_64_ALPHABET = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
    public static final String BASE_85_ALPHABET = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz!#$%&()*+-;<=>?@^_`{|}~";
    public static final String Z_85_ALPHABET = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ.-:+=^!/*?&<>()[]{}@%$#";
    public static final String BASE_91_ALPHABET = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789!#$%&()*+,./:;<=>?@[]^_`{|}~\"";
    public static final String BASE_94_ALPHABET = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789!#$%&()*+,./:;<=>?@[]^_`{|}~\"-\\'";
    public static final String BASE_98_ALPHABET = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789!#$%&()*+,./:;<=>?@[]^_`{|}~\"-\\' \t\n\r";
    public static final AnyBaseEncoder BASE_32_HEX = new AnyBaseEncoder("0123456789ABCDEFGHIJKLMNOPQRSTUV");
    public static final AnyBaseEncoder BASE_32 = new AnyBaseEncoder("ABCDEFGHIJKLMNOPQRSTUVWXYZ234567");
    public static final AnyBaseEncoder BASE_36 = new AnyBaseEncoder("0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ");
    public static final AnyBaseEncoder BASE_52 = new AnyBaseEncoder("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz");
    public static final AnyBaseEncoder BASE_62 = new AnyBaseEncoder("0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz");
    public static final AnyBaseEncoder BASE_64 = new AnyBaseEncoder("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/");
    public static final AnyBaseEncoder BASE_85 = new AnyBaseEncoder("0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz!#$%&()*+-;<=>?@^_`{|}~");
    public static final AnyBaseEncoder BASE_91 = new AnyBaseEncoder("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789!#$%&()*+,./:;<=>?@[]^_`{|}~\"");
    public static final AnyBaseEncoder BASE_94 = new AnyBaseEncoder("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789!#$%&()*+,./:;<=>?@[]^_`{|}~\"-\\'");
    public static final AnyBaseEncoder BASE_98 = new AnyBaseEncoder("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789!#$%&()*+,./:;<=>?@[]^_`{|}~\"-\\' \t\n\r");
    private static final String[] ALPHABETS = new String[]{"0123456789ABCDEFGHIJKLMNOPQRSTUV", "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ", "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz", "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz", "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/", "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz!#$%&()*+-;<=>?@^_`{|}~", "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789!#$%&()*+,./:;<=>?@[]^_`{|}~\"", "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789!#$%&()*+,./:;<=>?@[]^_`{|}~\"-\\'"};
    private static final BigInteger MIN_128_INV = BigInteger.ONE.shiftLeft(127);
    private final char[] alphabet;
    private final BigInteger targetBase;

    public AnyBaseEncoder(String alphabet) {
        this(alphabet.toCharArray());
    }

    public AnyBaseEncoder(char[] alphabet) {
        this.alphabet = alphabet;
        this.targetBase = BigInteger.valueOf(alphabet.length);
    }

    public AnyBaseEncoder(int radix) {
        this(AnyBaseEncoder.findAlphabet(radix));
    }

    private static String findAlphabet(int radix) {
        for (int i = 0; i < ALPHABETS.length; ++i) {
            if (ALPHABETS[i].length() < radix) continue;
            return ALPHABETS[i].substring(0, radix);
        }
        return BASE_94_ALPHABET;
    }

    public String encode(UUID guid) {
        byte[] guidBytes = AnyBaseEncoder.uuidToBytes(guid);
        return this.encode(guidBytes);
    }

    public String encode(byte[] bytes) {
        BigInteger guidInt = new BigInteger(bytes);
        return this.encode(guidInt);
    }

    public String encode(BigInteger bigInt) {
        BigInteger[] fracAndRemainder;
        BigInteger value = bigInt.add(MIN_128_INV);
        StringBuilder stringBuilder = new StringBuilder();
        do {
            fracAndRemainder = value.divideAndRemainder(this.targetBase);
            stringBuilder.append(this.alphabet[fracAndRemainder[1].intValue()]);
        } while ((value = fracAndRemainder[0]).compareTo(BigInteger.ZERO) > 0);
        return stringBuilder.toString();
    }

    public BigInteger decode(char[] encoded) {
        BigInteger sum = BigInteger.ZERO;
        int charLen = encoded.length;
        for (int i = 0; i < charLen; ++i) {
            sum = sum.add(this.targetBase.pow(i).multiply(BigInteger.valueOf(Arrays.binarySearch(this.alphabet, encoded[i]))));
        }
        return sum.subtract(MIN_128_INV);
    }

    public BigInteger decode(String encoded) {
        return this.decode(encoded.toCharArray());
    }

    public UUID decodeUuid(String encoded) {
        BigInteger bigInt = this.decode(encoded);
        return AnyBaseEncoder.uuidFromBytes(bigInt.toByteArray());
    }

    public static UUID uuidFromBytes(byte[] data) {
        int i;
        long lsb = 0L;
        long msb = 0L;
        long highInt = 0L;
        long midShort = 0L;
        long lowShort = 0L;
        for (i = 3; i >= 0; --i) {
            highInt = highInt << 8 | (long)(data[i] & 0xFF);
        }
        for (i = 5; i >= 4; --i) {
            midShort = midShort << 8 | (long)(data[i] & 0xFF);
        }
        for (i = 7; i >= 6; --i) {
            lowShort = lowShort << 8 | (long)(data[i] & 0xFF);
        }
        msb = highInt << 32 | midShort << 16 | lowShort;
        for (i = 8; i < 16; ++i) {
            lsb = lsb << 8 | (long)(data[i] & 0xFF);
        }
        return new UUID(msb, lsb);
    }

    public static byte[] uuidToBytes(UUID uuid) {
        long lsb = uuid.getLeastSignificantBits();
        long msb = uuid.getMostSignificantBits();
        byte[] bytes = new byte[16];
        bytes[7] = (byte)(msb >> 8 & 0xFFL);
        bytes[6] = (byte)(msb >> 0 & 0xFFL);
        bytes[5] = (byte)(msb >> 24 & 0xFFL);
        bytes[4] = (byte)(msb >> 16 & 0xFFL);
        bytes[3] = (byte)(msb >> 56 & 0xFFL);
        bytes[2] = (byte)(msb >> 48 & 0xFFL);
        bytes[1] = (byte)(msb >> 40 & 0xFFL);
        bytes[0] = (byte)(msb >> 32 & 0xFFL);
        for (int i = 0; i < 8; ++i) {
            bytes[15 - i] = (byte)(lsb & 0xFFL);
            lsb >>= 8;
        }
        return bytes;
    }
}

