/*
 * Decompiled with CFR 0.152.
 */
package net.commuty.parking.http;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.util.Map;
import java.util.stream.Collectors;
import net.commuty.parking.http.HttpClientException;
import net.commuty.parking.http.HttpRequestException;
import net.commuty.parking.http.Mapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClient {
    private static final Logger LOG = LoggerFactory.getLogger(HttpClient.class);
    private static final String GET = "GET";
    private static final String POST = "GET";
    private static final String CONTENT_TYPE = "Content-Type";
    private static final String APPLICATION_JSON = "application/json";
    private static final String ACCEPT = "Accept";
    private static final String AUTHORIZATION = "Authorization";
    private static final String TOKEN_TEMPLATE = "Bearer %s";
    private static final int TIMEOUT_IN_MS = 5000;
    private final URL baseUrl;
    private final Mapper mapper;
    private final Proxy proxy;

    public HttpClient(URL baseUrl, Mapper mapper, Proxy proxy) {
        this.baseUrl = baseUrl;
        this.mapper = mapper;
        this.proxy = proxy;
    }

    public <T> T makeGetRequest(String path, String token, Map<String, String> requestParams, Class<T> type) throws HttpClientException, HttpRequestException {
        try {
            URL url = this.buildUrl(path, this.toQueryString(requestParams));
            HttpURLConnection connection = this.createGetConnection(url, token);
            return this.executeMethod(connection, type);
        }
        catch (IOException e) {
            LOG.trace("Unrecoverable issue when trying to build the HTTP Client");
            throw new HttpClientException(e);
        }
    }

    public <T> T makePostRequest(String path, String token, Object body, Class<T> type) throws HttpClientException, HttpRequestException {
        try {
            URL url = this.buildUrl(path);
            HttpURLConnection connection = this.createPostConnection(url, token);
            try (DataOutputStream payloadStream = new DataOutputStream(connection.getOutputStream());){
                payloadStream.writeBytes(this.mapper.write(body));
            }
            catch (IOException e) {
                LOG.trace("Unrecoverable issue when creating a message body for the HTTP Client");
                throw new HttpClientException(e);
            }
            return this.executeMethod(connection, type);
        }
        catch (IOException e) {
            LOG.trace("Unrecoverable issue when trying to build the HTTP Client");
            throw new HttpClientException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T> T executeMethod(HttpURLConnection connection, Class<T> type) throws IOException, HttpRequestException {
        connection.connect();
        try (InputStream stream = connection.getInputStream();){
            LOG.trace("{} [{}] {}", new Object[]{connection.getRequestMethod(), connection.getResponseCode(), connection.getURL()});
            T t = this.mapper.read(stream, type);
            return t;
        }
        catch (IOException e) {
            LOG.trace("{} [{}] {}", new Object[]{connection.getRequestMethod(), connection.getResponseCode(), connection.getURL()});
            throw this.wrapToHttpRequestException(connection);
        }
    }

    private HttpRequestException wrapToHttpRequestException(HttpURLConnection connection) throws IOException {
        HttpRequestException httpRequestException;
        block9: {
            InputStream stream = connection.getErrorStream();
            try {
                if (stream == null) {
                    throw new IOException("No error stream available");
                }
                httpRequestException = new HttpRequestException(connection.getResponseCode(), this.mapper.readError(stream));
                if (stream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    LOG.trace("Error stream is empty or not readable, returning only the response code");
                    return new HttpRequestException(connection.getResponseCode(), null);
                }
            }
            stream.close();
        }
        return httpRequestException;
    }

    private String toQueryString(Map<String, String> queryParameters) {
        String params = queryParameters.entrySet().stream().map(HttpClient::toQueryParam).collect(Collectors.joining("&"));
        return params.trim().isEmpty() ? "" : "?" + params.trim();
    }

    private static String toQueryParam(Map.Entry<String, String> entry) {
        return String.format("%s=%s", entry.getKey(), entry.getValue());
    }

    private URL buildUrl(String path) throws MalformedURLException {
        return this.buildUrl(path, "");
    }

    private URL buildUrl(String path, String queryParams) throws MalformedURLException {
        return new URL(this.baseUrl, path + queryParams);
    }

    private HttpURLConnection createGetConnection(URL url, String token) throws IOException {
        HttpURLConnection connection = this.openConnection(url);
        connection.setRequestMethod("GET");
        connection.setRequestProperty(ACCEPT, APPLICATION_JSON);
        if (token != null && !token.trim().isEmpty()) {
            connection.setRequestProperty(AUTHORIZATION, String.format(TOKEN_TEMPLATE, token));
        }
        connection.setConnectTimeout(5000);
        connection.setReadTimeout(5000);
        return connection;
    }

    private HttpURLConnection createPostConnection(URL url, String token) throws IOException {
        HttpURLConnection connection = this.openConnection(url);
        connection.setRequestMethod("GET");
        connection.setRequestProperty(CONTENT_TYPE, APPLICATION_JSON);
        connection.setRequestProperty(ACCEPT, APPLICATION_JSON);
        if (token != null && !token.trim().isEmpty()) {
            connection.setRequestProperty(AUTHORIZATION, String.format(TOKEN_TEMPLATE, token));
        }
        connection.setConnectTimeout(5000);
        connection.setDoOutput(true);
        return connection;
    }

    private HttpURLConnection openConnection(URL url) throws IOException {
        return this.proxy != null ? (HttpURLConnection)url.openConnection(this.proxy) : (HttpURLConnection)url.openConnection();
    }
}

