/*
 * Decompiled with CFR 0.152.
 */
package net.commuty.parking.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import net.commuty.parking.model.UserIdType;

public class UserId {
    private final String id;
    private final UserIdType type;

    @JsonCreator
    UserId(@JsonProperty(value="type") UserIdType type, @JsonProperty(value="id") String id) {
        if (id == null || id.trim().isEmpty()) {
            throw new IllegalArgumentException("Identifier of the user cannot be null or blank");
        }
        this.type = type;
        this.id = id;
    }

    public static UserId fromEmail(String email) {
        return new UserId(UserIdType.EMAIL, email);
    }

    public static UserId fromLicensePlate(String licensePlate) {
        return new UserId(UserIdType.LICENSE_PLATE, licensePlate);
    }

    public static UserId fromIdentificationNumber(String identificationNumber) {
        return new UserId(UserIdType.IDENTIFICATION_NUMBER, identificationNumber);
    }

    public static UserId fromQrCode(String qrCode) {
        return new UserId(UserIdType.QR_CODE, qrCode);
    }

    public static UserId fromBadgeNumber(String badgeNumber) {
        return new UserId(UserIdType.BADGE_NUMBER, badgeNumber);
    }

    public static UserId fromCardholderId(String cardholderId) {
        return new UserId(UserIdType.CARDHOLDER_ID, cardholderId);
    }

    public static UserId fromPinCode(String pinCode) {
        return new UserId(UserIdType.PIN_CODE, pinCode);
    }

    public static UserId fromWim26EncodedLicensePlate(String win26EncodedLicensePlate) {
        return new UserId(UserIdType.LICENSE_PLATE_WIM26, win26EncodedLicensePlate);
    }

    public static UserId fromWim64EncodedLicensePlate(String win64EncodedLicensePlate) {
        return new UserId(UserIdType.LICENSE_PLATE_WIM64, win64EncodedLicensePlate);
    }

    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="type")
    public UserIdType getType() {
        return this.type;
    }

    public boolean hasType(UserIdType type) {
        return this.type == type;
    }

    public String toString() {
        return "UserId{id='" + this.id + '\'' + ", type='" + (Object)((Object)this.type) + '\'' + '}';
    }
}

