/*
 * Decompiled with CFR 0.152.
 */
package net.commuty.parking.rest;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.io.IOException;
import java.io.InputStream;
import net.commuty.parking.http.Error;
import net.commuty.parking.http.Mapper;
import net.commuty.parking.rest.JsonError;

class JsonMapper
implements Mapper {
    private final ObjectMapper mapper = this.initMapper();

    protected JsonMapper() {
    }

    private ObjectMapper initMapper() {
        return new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).registerModules(new Module[]{new JavaTimeModule()}).setSerializationInclusion(JsonInclude.Include.NON_NULL).disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS).disable(DeserializationFeature.ADJUST_DATES_TO_CONTEXT_TIME_ZONE).enable(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_USING_DEFAULT_VALUE);
    }

    static JsonMapper create() {
        return new JsonMapper();
    }

    @Override
    public String write(Object body) throws JsonProcessingException {
        return this.mapper.writeValueAsString(body);
    }

    @Override
    public <R> R read(InputStream stream, Class<R> type) throws IOException {
        return (R)this.mapper.readValue(stream, type);
    }

    @Override
    public Error readError(InputStream stream) throws IOException {
        return this.read(stream, JsonError.class);
    }
}

