/*
 * Decompiled with CFR 0.152.
 */
package net.conquiris.jersey.client;

import com.google.common.base.Preconditions;
import com.sun.jersey.api.client.WebResource;
import net.conquiris.api.index.Delays;
import net.conquiris.api.index.IndexReport;
import net.conquiris.api.index.IndexReportLevel;
import net.conquiris.api.index.IndexerService;

final class IndexerServiceClient
implements IndexerService {
    private final WebResource resource;

    IndexerServiceClient(WebResource resource) {
        this.resource = (WebResource)Preconditions.checkNotNull((Object)resource, (Object)"The root resource must be provided");
    }

    public IndexReport getIndexReport(IndexReportLevel level) {
        Preconditions.checkNotNull((Object)level, (Object)"The index report level must be provided");
        return (IndexReport)this.resource.queryParam("l", level.name()).get(IndexReport.class);
    }

    public void setDelays(Delays delays) {
        Preconditions.checkNotNull((Object)delays, (Object)"The delays configuration must be provided");
        this.resource.path("delays").put((Object)delays);
    }

    public void start() {
        this.resource.path("delays").post();
    }

    public void stop() {
        this.resource.path("stop").post();
    }

    public void setCheckpoint(String checkpoint) {
        this.resource.path("checkpoint").put((Object)checkpoint);
    }

    public void reindex() {
        this.resource.path("reindex").post();
    }
}

