/*
 * WebappLicenseParam 23/10/2007 kynan.fraser@customware.net
 * --------------------------------------------------------------------------------------
 * Copyright (c) CustomWare Asia Pacific Pty Ltd. All rights reserved.  http://www.customware.net
 *				
 */

package net.customware.license.webapp;

import net.customware.license.support.simple.SimpleLicenseParam;
import net.customware.license.webapp.prefs.WebappSystemPreferences;

public abstract class WebappLicenseParam extends SimpleLicenseParam {

    /**
     * Constructs a new Webapp license provider, with the license being stored in the
     * system-wide preferences node.
     */
    protected WebappLicenseParam() {
        requireLicensePerServer();
    }
    
    protected void requireLicensePerServer() {
        setPreferences( new WebappSystemPreferences() );
    }
}


