/*
 * AbstractPropertySetPreferences 23/10/2007 kynan.fraser@customware.net
 * --------------------------------------------------------------------------------------
 * Copyright (c) CustomWare Asia Pacific Pty Ltd. All rights reserved.  http://www.customware.net
 *				
 */

package net.customware.license.webapp.prefs;

import net.customware.license.support.util.AbstractLicensePreferences;

import com.opensymphony.module.propertyset.PropertySet;

public abstract class AbstractPropertySetPreferences extends AbstractLicensePreferences {

    private static final String PREFIX = "java.util.prefs:";

    public AbstractPropertySetPreferences() {
        this( null, "" );
    }

    public AbstractPropertySetPreferences( AbstractPropertySetPreferences parent, String path ) {
        super( parent, path );
    }

    @Override protected String getSpi( String key ) {
        return getPropertySet().getText( getFullPath( key ) );
    }

    private String getFullPath( String key ) {
        return PREFIX + absolutePath() + "//" + key;
    }

    @Override protected void putSpi( String key, String value ) {
        getPropertySet().setText( getFullPath( key ), value );
    }

    @Override protected void removeSpi( String key ) {
        getPropertySet().setText( getFullPath( key ), null );
    }

    protected abstract PropertySet getPropertySet();

}


