/*
 * Decompiled with CFR 0.152.
 */
package com.redis;

import com.redis.IO;
import com.redis.RedisConnectionException;
import com.redis.serialization.Parse$;
import java.io.BufferedInputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuilder;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public abstract class IO$class {
    public static boolean connected(IO $this) {
        return $this.socket() != null && $this.socket().isBound() && !$this.socket().isClosed() && $this.socket().isConnected() && !$this.socket().isInputShutdown() && !$this.socket().isOutputShutdown();
    }

    public static boolean connect(IO $this) {
        try {
            $this.socket_$eq(new Socket());
            $this.socket().connect(new InetSocketAddress($this.host(), $this.port()), $this.timeout());
            $this.socket().setSoTimeout($this.timeout());
            $this.socket().setKeepAlive(true);
            $this.socket().setTcpNoDelay(true);
            $this.out_$eq($this.socket().getOutputStream());
            $this.in_$eq(new BufferedInputStream($this.socket().getInputStream()));
            return true;
        }
        catch (Throwable throwable) {
            $this.clearFd();
            throw new RuntimeException(throwable);
        }
    }

    public static boolean disconnect(IO $this) {
        boolean bl;
        try {
            $this.socket().close();
            $this.out().close();
            $this.in().close();
            $this.clearFd();
            bl = true;
        }
        catch (Throwable throwable) {
            bl = false;
        }
        return bl;
    }

    public static void clearFd(IO $this) {
        $this.socket_$eq(null);
        $this.out_$eq(null);
        $this.in_$eq(null);
    }

    public static void write_to_socket(IO $this, byte[] data, Function1 op) {
        op.apply((Object)$this.out());
    }

    public static void write(IO $this, byte[] data) {
        $this.ifDebug((Function0<String>)new Serializable($this, data){
            public static final long serialVersionUID = 0L;
            private final byte[] data$1;

            public final String apply() {
                return new StringBuilder().append((Object)"C: ").append((Object)Parse$.MODULE$.parseStringSafe().apply(this.data$1)).toString();
            }
            {
                this.data$1 = data$1;
            }
        });
        Object object = $this.connected() ? BoxedUnit.UNIT : BoxesRunTime.boxToBoolean((boolean)$this.connect());
        $this.write_to_socket(data, (Function1<OutputStream, BoxedUnit>)new Serializable($this, data){
            public static final long serialVersionUID = 0L;
            private final byte[] data$1;

            public final void apply(OutputStream os) {
                try {
                    os.write(this.data$1);
                    os.flush();
                    return;
                }
                catch (Throwable throwable) {
                    throw new RedisConnectionException("connection is closed. write error");
                }
            }
            {
                this.data$1 = data$1;
            }
        });
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] readLine(IO $this) {
        Object object = $this.connected() ? BoxedUnit.UNIT : BoxesRunTime.boxToBoolean((boolean)$this.connect());
        List<Object> delimiter = $this.com$redis$IO$$crlf();
        Nil$ found = Nil$.MODULE$;
        ArrayBuilder.ofByte build = new ArrayBuilder.ofByte();
        while (true) {
            try {
                List<Object> list = delimiter;
                Nil$ nil$ = Nil$.MODULE$;
                if (list == null) {
                    if (nil$ == null) return build.result();
                } else if (list.equals((Object)nil$)) {
                    return build.result();
                }
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (!(throwable2 instanceof SocketTimeoutException)) throw throwable;
                SocketTimeoutException socketTimeoutException = (SocketTimeoutException)throwable2;
                if ($this.timeout() <= 0) throw throwable;
                $this.disconnect();
                throw socketTimeoutException;
            }
            {
                void var3_3;
                BoxedUnit boxedUnit;
                List list;
                List<Object> list2;
                int next = $this.in().read();
                if (next < 0) {
                    return null;
                }
                if (next == BoxesRunTime.unboxToInt((Object)list2.head())) {
                    list = list.$colon$colon(list2.head());
                    list2 = (List<Object>)list2.tail();
                    boxedUnit = BoxedUnit.UNIT;
                    continue;
                }
                void v3 = list;
                Nil$ nil$ = Nil$.MODULE$;
                if (v3 == null ? nil$ != null : !v3.equals(nil$)) {
                    list2 = $this.com$redis$IO$$crlf();
                    var3_3.$plus$plus$eq((TraversableOnce)list.reverseMap((Function1)new Serializable($this){
                        public static final long serialVersionUID = 0L;

                        public final byte apply(int x$1) {
                            return (byte)x$1;
                        }
                    }, List$.MODULE$.canBuildFrom()));
                    list = Nil$.MODULE$;
                }
                boxedUnit = var3_3.$plus$eq((byte)next);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static byte[] readCounted(IO $this, int count) {
        Object object = $this.connected() ? BoxedUnit.UNIT : BoxesRunTime.boxToBoolean((boolean)$this.connect());
        byte[] arr = new byte[count];
        try {
            void var2_2;
            for (int cur = 0; cur < count; cur += $this.in().read(arr, cur, count - cur)) {
            }
            return var2_2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable2 instanceof SocketTimeoutException) {
                SocketTimeoutException socketTimeoutException = (SocketTimeoutException)throwable2;
                if ($this.timeout() > 0) {
                    $this.disconnect();
                    throw socketTimeoutException;
                }
            }
            throw throwable;
        }
    }

    public static void $init$(IO $this) {
        $this.com$redis$IO$_setter_$com$redis$IO$$crlf_$eq(List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{13, 10})));
    }
}

