/*
 * Decompiled with CFR 0.152.
 */
package net.ericaro.neoitertools.generators.combinatorics;

import java.util.ArrayList;
import java.util.List;
import net.ericaro.neoitertools.Generator;
import net.ericaro.neoitertools.generators.combinatorics.CombinationNumber;
import net.ericaro.neoitertools.generators.combinatorics.PermutationNumber;
import net.ericaro.neoitertools.generators.combinatorics.SubListNumber;
import net.ericaro.neoitertools.generators.combinatorics.VarBaseNumber;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Combinatorics {
    public static Generator<int[]> permutations(int n) {
        return new PermutationNumber(n);
    }

    public static Generator<int[]> product(int[] lengths) {
        return new VarBaseNumber(lengths);
    }

    public static Generator<int[]> combinations(int m, int n) {
        return new CombinationNumber(m, n);
    }

    public static Generator<int[]> sublists(int m, int n) {
        return new SubListNumber(m, n);
    }

    public static <T> List<T> apply(List<T> origin, int[] indices) {
        ArrayList<T> items = new ArrayList<T>(indices.length);
        for (int i : indices) {
            items.add(origin.get(i));
        }
        return items;
    }

    public static <T> List<T> select(List<List<T>> lists, int[] indices) {
        int size = lists.size();
        ArrayList<T> items = new ArrayList<T>(indices.length);
        for (int i = 0; i < indices.length; ++i) {
            items.add(lists.get(i % size).get(indices[i]));
        }
        return items;
    }

    public static <T> Generator<List<T>> selected(final List<List<T>> lists, final Generator<int[]> indicesGenerator) {
        return new Generator<List<T>>(){

            @Override
            public List<T> next() {
                return Combinatorics.select(lists, (int[])indicesGenerator.next());
            }
        };
    }

    public static <T> Generator<List<T>> applied(final List<T> elements, final Generator<int[]> indicesGenerator) {
        return new Generator<List<T>>(){

            @Override
            public List<T> next() {
                return Combinatorics.apply(elements, (int[])indicesGenerator.next());
            }
        };
    }
}

