/*
 * Decompiled with CFR 0.152.
 */
package net.greghaines.jesque.worker;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Set;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.Callable;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import net.greghaines.jesque.Config;
import net.greghaines.jesque.Job;
import net.greghaines.jesque.JobFailure;
import net.greghaines.jesque.WorkerStatus;
import net.greghaines.jesque.json.ObjectMapperFactory;
import net.greghaines.jesque.utils.JesqueUtils;
import net.greghaines.jesque.utils.PoolUtils;
import net.greghaines.jesque.utils.ScriptUtils;
import net.greghaines.jesque.utils.VersionUtils;
import net.greghaines.jesque.worker.DefaultFailQueueStrategy;
import net.greghaines.jesque.worker.DefaultPoolExceptionHandler;
import net.greghaines.jesque.worker.ExceptionHandler;
import net.greghaines.jesque.worker.FailQueueStrategy;
import net.greghaines.jesque.worker.JobExecutor;
import net.greghaines.jesque.worker.JobFactory;
import net.greghaines.jesque.worker.NextQueueStrategy;
import net.greghaines.jesque.worker.RecoveryStrategy;
import net.greghaines.jesque.worker.Worker;
import net.greghaines.jesque.worker.WorkerAware;
import net.greghaines.jesque.worker.WorkerEvent;
import net.greghaines.jesque.worker.WorkerEventEmitter;
import net.greghaines.jesque.worker.WorkerListenerDelegate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.Transaction;
import redis.clients.jedis.exceptions.JedisException;
import redis.clients.jedis.exceptions.JedisNoScriptException;
import redis.clients.util.Pool;

public class WorkerPoolImpl
implements Worker {
    private static final Logger LOG = LoggerFactory.getLogger(WorkerPoolImpl.class);
    private static final AtomicLong WORKER_COUNTER = new AtomicLong(0L);
    protected static final long EMPTY_QUEUE_SLEEP_TIME = 500L;
    protected static final long RECONNECT_SLEEP_TIME = 5000L;
    private static final String LPOPLPUSH_LUA = "/workerScripts/jesque_lpoplpush.lua";
    private static final String POP_LUA = "/workerScripts/jesque_pop.lua";
    private static final String POP_FROM_MULTIPLE_PRIO_QUEUES = "/workerScripts/fromMultiplePriorityQueues.lua";
    private static volatile boolean threadNameChangingEnabled = false;
    private final NextQueueStrategy nextQueueStrategy;
    protected final Config config;
    protected final Pool<Jedis> jedisPool;
    protected final String namespace;
    protected final BlockingDeque<String> queueNames = new LinkedBlockingDeque<String>();
    private final String name;
    protected final WorkerListenerDelegate listenerDelegate = new WorkerListenerDelegate();
    protected final AtomicReference<JobExecutor.State> state = new AtomicReference<JobExecutor.State>(JobExecutor.State.NEW);
    private final AtomicBoolean paused = new AtomicBoolean(false);
    private final AtomicBoolean processingJob = new AtomicBoolean(false);
    private final AtomicReference<String> popScriptHash = new AtomicReference<Object>(null);
    private final AtomicReference<String> lpoplpushScriptHash = new AtomicReference<Object>(null);
    private final AtomicReference<String> multiPriorityQueuesScriptHash = new AtomicReference<Object>(null);
    private final long workerId = WORKER_COUNTER.getAndIncrement();
    private final String threadNameBase = "Worker-" + this.workerId + " Jesque-" + VersionUtils.getVersion() + ": ";
    private final AtomicReference<Thread> threadRef = new AtomicReference<Object>(null);
    private final AtomicReference<ExceptionHandler> exceptionHandlerRef = new AtomicReference<DefaultPoolExceptionHandler>(new DefaultPoolExceptionHandler());
    private final AtomicReference<FailQueueStrategy> failQueueStrategyRef;
    private final JobFactory jobFactory;

    public static boolean isThreadNameChangingEnabled() {
        return threadNameChangingEnabled;
    }

    public static void setThreadNameChangingEnabled(boolean enabled) {
        threadNameChangingEnabled = enabled;
    }

    protected static void checkQueues(Iterable<String> queues) {
        if (queues == null) {
            throw new IllegalArgumentException("queues must not be null");
        }
        for (String queue : queues) {
            if (queue != null && !"".equals(queue)) continue;
            throw new IllegalArgumentException("queues' members must not be null: " + queues);
        }
    }

    public WorkerPoolImpl(Config config, Collection<String> queues, JobFactory jobFactory, Pool<Jedis> jedisPool) {
        this(config, queues, jobFactory, jedisPool, NextQueueStrategy.DRAIN_WHILE_MESSAGES_EXISTS);
    }

    public WorkerPoolImpl(Config config, Collection<String> queues, JobFactory jobFactory, Pool<Jedis> jedisPool, NextQueueStrategy nextQueueStrategy) {
        if (config == null) {
            throw new IllegalArgumentException("config must not be null");
        }
        if (jobFactory == null) {
            throw new IllegalArgumentException("jobFactory must not be null");
        }
        if (jedisPool == null) {
            throw new IllegalArgumentException("jedisPool must not be null");
        }
        if (nextQueueStrategy == null) {
            throw new IllegalArgumentException("nextQueueStrategy must not be null");
        }
        WorkerPoolImpl.checkQueues(queues);
        this.nextQueueStrategy = nextQueueStrategy;
        this.config = config;
        this.jobFactory = jobFactory;
        this.namespace = config.getNamespace();
        this.jedisPool = jedisPool;
        this.failQueueStrategyRef = new AtomicReference<DefaultFailQueueStrategy>(new DefaultFailQueueStrategy(this.namespace));
        this.setQueues(queues);
        this.name = this.createName();
    }

    public long getWorkerId() {
        return this.workerId;
    }

    @Override
    public void run() {
        block5: {
            block6: {
                if (!this.state.compareAndSet(JobExecutor.State.NEW, JobExecutor.State.RUNNING)) break block6;
                try {
                    this.renameThread("RUNNING");
                    this.threadRef.set(Thread.currentThread());
                    PoolUtils.doWorkInPool(this.jedisPool, new PoolUtils.PoolWork<Jedis, Void>(){

                        @Override
                        public Void doWork(Jedis jedis) throws IOException {
                            jedis.sadd(WorkerPoolImpl.this.key("workers"), new String[]{WorkerPoolImpl.this.name});
                            jedis.set(WorkerPoolImpl.this.key("worker", WorkerPoolImpl.this.name, "started"), new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ").format(new Date()));
                            WorkerPoolImpl.this.listenerDelegate.fireEvent(WorkerEvent.WORKER_START, WorkerPoolImpl.this, null, null, null, null, null);
                            WorkerPoolImpl.this.loadRedisScripts(jedis);
                            return null;
                        }
                    });
                    this.poll();
                    this.renameThread("STOPPING");
                    this.listenerDelegate.fireEvent(WorkerEvent.WORKER_STOP, this, null, null, null, null, null);
                }
                catch (Exception ex) {
                    try {
                        LOG.error("Uncaught exception in worker run-loop!", (Throwable)ex);
                        this.listenerDelegate.fireEvent(WorkerEvent.WORKER_ERROR, this, null, null, null, null, ex);
                        this.renameThread("STOPPING");
                        this.listenerDelegate.fireEvent(WorkerEvent.WORKER_STOP, this, null, null, null, null, null);
                    }
                    catch (Throwable throwable) {
                        this.renameThread("STOPPING");
                        this.listenerDelegate.fireEvent(WorkerEvent.WORKER_STOP, this, null, null, null, null, null);
                        PoolUtils.doWorkInPoolNicely(this.jedisPool, new PoolUtils.PoolWork<Jedis, Void>(){

                            @Override
                            public Void doWork(Jedis jedis) {
                                jedis.srem(WorkerPoolImpl.this.key("workers"), new String[]{WorkerPoolImpl.this.name});
                                jedis.del(new String[]{WorkerPoolImpl.this.key("worker", WorkerPoolImpl.this.name), WorkerPoolImpl.this.key("worker", WorkerPoolImpl.this.name, "started"), WorkerPoolImpl.this.key("stat", "failed", WorkerPoolImpl.this.name), WorkerPoolImpl.this.key("stat", "processed", WorkerPoolImpl.this.name)});
                                return null;
                            }
                        });
                        this.threadRef.set(null);
                        throw throwable;
                    }
                    PoolUtils.doWorkInPoolNicely(this.jedisPool, new /* invalid duplicate definition of identical inner class */);
                    this.threadRef.set(null);
                    break block5;
                }
                PoolUtils.doWorkInPoolNicely(this.jedisPool, new /* invalid duplicate definition of identical inner class */);
                this.threadRef.set(null);
                break block5;
            }
            if (JobExecutor.State.RUNNING.equals((Object)this.state.get())) {
                throw new IllegalStateException("This WorkerImpl is already running");
            }
            throw new IllegalStateException("This WorkerImpl is shutdown");
        }
    }

    @Override
    public void end(boolean now) {
        if (now) {
            this.state.set(JobExecutor.State.SHUTDOWN_IMMEDIATE);
            Thread workerThread = this.threadRef.get();
            if (workerThread != null) {
                workerThread.interrupt();
            }
        } else {
            this.state.set(JobExecutor.State.SHUTDOWN);
        }
        this.togglePause(false);
    }

    @Override
    public boolean isShutdown() {
        return JobExecutor.State.SHUTDOWN.equals((Object)this.state.get()) || JobExecutor.State.SHUTDOWN_IMMEDIATE.equals((Object)this.state.get());
    }

    @Override
    public boolean isPaused() {
        return this.paused.get();
    }

    @Override
    public boolean isProcessingJob() {
        return this.processingJob.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void togglePause(boolean paused) {
        this.paused.set(paused);
        AtomicBoolean atomicBoolean = this.paused;
        synchronized (atomicBoolean) {
            this.paused.notifyAll();
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public WorkerEventEmitter getWorkerEventEmitter() {
        return this.listenerDelegate;
    }

    @Override
    public Collection<String> getQueues() {
        return Collections.unmodifiableCollection(this.queueNames);
    }

    @Override
    public void addQueue(String queueName) {
        if (queueName == null || "".equals(queueName)) {
            throw new IllegalArgumentException("queueName must not be null or empty: " + queueName);
        }
        this.queueNames.add(queueName);
    }

    @Override
    public void removeQueue(String queueName, boolean all) {
        if (queueName == null || "".equals(queueName)) {
            throw new IllegalArgumentException("queueName must not be null or empty: " + queueName);
        }
        if (all) {
            boolean tryAgain = true;
            while (tryAgain) {
                tryAgain = this.queueNames.remove(queueName);
            }
        } else {
            this.queueNames.remove(queueName);
        }
    }

    @Override
    public void removeAllQueues() {
        this.queueNames.clear();
    }

    @Override
    public void setQueues(Collection<String> queues) {
        WorkerPoolImpl.checkQueues(queues);
        this.queueNames.clear();
        if (queues == ALL_QUEUES) {
            this.queueNames.addAll((Collection<String>)PoolUtils.doWorkInPoolNicely(this.jedisPool, new PoolUtils.PoolWork<Jedis, Set<String>>(){

                @Override
                public Set<String> doWork(Jedis jedis) {
                    return jedis.smembers(WorkerPoolImpl.this.key("queues"));
                }
            }));
        } else {
            this.queueNames.addAll(queues);
        }
    }

    @Override
    public JobFactory getJobFactory() {
        return this.jobFactory;
    }

    @Override
    public ExceptionHandler getExceptionHandler() {
        return this.exceptionHandlerRef.get();
    }

    @Override
    public void setExceptionHandler(ExceptionHandler exceptionHandler) {
        if (exceptionHandler == null) {
            throw new IllegalArgumentException("exceptionHandler must not be null");
        }
        this.exceptionHandlerRef.set(exceptionHandler);
    }

    public FailQueueStrategy getFailQueueStrategy() {
        return this.failQueueStrategyRef.get();
    }

    public void setFailQueueStrategy(FailQueueStrategy failQueueStrategy) {
        if (failQueueStrategy == null) {
            throw new IllegalArgumentException("failQueueStrategy must not be null");
        }
        this.failQueueStrategyRef.set(failQueueStrategy);
    }

    @Override
    public void join(long millis) throws InterruptedException {
        Thread workerThread = this.threadRef.get();
        if (workerThread != null && workerThread.isAlive()) {
            workerThread.join(millis);
        }
    }

    protected void poll() {
        int missCount = 0;
        String curQueue = null;
        while (JobExecutor.State.RUNNING.equals((Object)this.state.get())) {
            try {
                if (threadNameChangingEnabled) {
                    this.renameThread("Waiting for " + JesqueUtils.join(",", this.queueNames));
                }
                if ((curQueue = this.getNextQueue()) == null) continue;
                this.checkPaused();
                if (!JobExecutor.State.RUNNING.equals((Object)this.state.get())) continue;
                this.listenerDelegate.fireEvent(WorkerEvent.WORKER_POLL, this, curQueue, null, null, null, null);
                String payload = this.pop(curQueue);
                if (payload != null) {
                    this.process((Job)ObjectMapperFactory.get().readValue(payload, Job.class), curQueue);
                    missCount = 0;
                    continue;
                }
                if (!this.shouldSleep(++missCount) || !JobExecutor.State.RUNNING.equals((Object)this.state.get())) continue;
                missCount = 0;
                Thread.sleep(500L);
            }
            catch (InterruptedException ie) {
                if (this.isShutdown()) continue;
                this.recoverFromException(curQueue, ie);
            }
            catch (JsonParseException | JsonMappingException e) {
                final String fCurQueue = curQueue;
                PoolUtils.doWorkInPoolNicely(this.jedisPool, new PoolUtils.PoolWork<Jedis, Void>(){

                    @Override
                    public Void doWork(Jedis jedis) {
                        WorkerPoolImpl.this.removeInFlight(jedis, fCurQueue, true);
                        return null;
                    }
                });
                this.recoverFromException(curQueue, (Exception)e);
            }
            catch (Exception e) {
                this.recoverFromException(curQueue, e);
            }
        }
    }

    private boolean shouldSleep(int missCount) {
        return NextQueueStrategy.RESET_TO_HIGHEST_PRIORITY.equals((Object)this.nextQueueStrategy) || missCount >= this.queueNames.size();
    }

    protected String getNextQueue() throws InterruptedException {
        String nextQueue;
        switch (this.nextQueueStrategy) {
            case DRAIN_WHILE_MESSAGES_EXISTS: {
                String nextPollQueue = this.queueNames.poll(500L, TimeUnit.MILLISECONDS);
                if (nextPollQueue != null) {
                    this.queueNames.add(nextPollQueue);
                }
                nextQueue = nextPollQueue;
                break;
            }
            case RESET_TO_HIGHEST_PRIORITY: {
                nextQueue = JesqueUtils.join(",", this.queueNames);
                break;
            }
            default: {
                throw new RuntimeException("Unimplemented 'nextQueueStrategy'");
            }
        }
        return nextQueue;
    }

    protected String pop(final String curQueue) {
        final String key = this.key("queue", curQueue);
        final String now = Long.toString(System.currentTimeMillis());
        final String inflightKey = this.key("inflight", this.name, curQueue);
        return PoolUtils.doWorkInPoolNicely(this.jedisPool, new PoolUtils.PoolWork<Jedis, String>(){

            @Override
            public String doWork(Jedis jedis) {
                switch (WorkerPoolImpl.this.nextQueueStrategy) {
                    case DRAIN_WHILE_MESSAGES_EXISTS: {
                        return (String)jedis.evalsha((String)WorkerPoolImpl.this.popScriptHash.get(), 3, new String[]{key, inflightKey, JesqueUtils.createRecurringHashKey(key), now});
                    }
                    case RESET_TO_HIGHEST_PRIORITY: {
                        return (String)jedis.evalsha((String)WorkerPoolImpl.this.multiPriorityQueuesScriptHash.get(), 3, new String[]{curQueue, inflightKey, WorkerPoolImpl.this.namespace, now});
                    }
                }
                throw new RuntimeException("Unimplemented 'nextQueueStrategy'");
            }
        });
    }

    protected void recoverFromException(String curQueue, Exception ex) {
        RecoveryStrategy recoveryStrategy = this.exceptionHandlerRef.get().onException(this, ex, curQueue);
        switch (recoveryStrategy) {
            case RECONNECT: {
                if (ex instanceof JedisNoScriptException) {
                    LOG.info("Got JedisNoScriptException while reconnecting, reloading Redis scripts");
                    this.loadRedisScripts();
                    break;
                }
                LOG.info("Waiting 5000ms for pool to reconnect to redis", (Throwable)ex);
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException interruptedException) {}
                break;
            }
            case TERMINATE: {
                LOG.warn("Terminating in response to exception", (Throwable)ex);
                this.end(false);
                break;
            }
            case PROCEED: {
                this.listenerDelegate.fireEvent(WorkerEvent.WORKER_ERROR, this, curQueue, null, null, null, ex);
                break;
            }
            default: {
                LOG.error("Unknown RecoveryStrategy: " + (Object)((Object)recoveryStrategy) + " while attempting to recover from the following exception; worker proceeding...", (Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkPaused() throws IOException {
        if (this.paused.get()) {
            AtomicBoolean atomicBoolean = this.paused;
            synchronized (atomicBoolean) {
                if (this.paused.get()) {
                    PoolUtils.doWorkInPoolNicely(this.jedisPool, new PoolUtils.PoolWork<Jedis, Void>(){

                        @Override
                        public Void doWork(Jedis jedis) throws IOException {
                            jedis.set(WorkerPoolImpl.this.key("worker", WorkerPoolImpl.this.name), WorkerPoolImpl.this.pauseMsg());
                            return null;
                        }
                    });
                }
                while (this.paused.get()) {
                    try {
                        this.paused.wait();
                    }
                    catch (InterruptedException ie) {
                        LOG.warn("Worker interrupted", (Throwable)ie);
                    }
                }
                PoolUtils.doWorkInPoolNicely(this.jedisPool, new PoolUtils.PoolWork<Jedis, Void>(){

                    @Override
                    public Void doWork(Jedis jedis) {
                        jedis.del(WorkerPoolImpl.this.key("worker", WorkerPoolImpl.this.name));
                        return null;
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void process(final Job job, final String curQueue) {
        boolean skipReque;
        boolean success = false;
        try {
            this.processingJob.set(true);
            if (threadNameChangingEnabled) {
                this.renameThread("Processing " + curQueue + " since " + System.currentTimeMillis());
            }
            this.listenerDelegate.fireEvent(WorkerEvent.JOB_PROCESS, this, curQueue, job, null, null, null);
            PoolUtils.doWorkInPool(this.jedisPool, new PoolUtils.PoolWork<Jedis, Void>(){

                @Override
                public Void doWork(Jedis jedis) throws IOException {
                    jedis.set(WorkerPoolImpl.this.key("worker", WorkerPoolImpl.this.name), WorkerPoolImpl.this.statusMsg(curQueue, job));
                    return null;
                }
            });
            Object instance = this.jobFactory.materializeJob(job);
            Object result = this.execute(job, curQueue, instance);
            this.success(job, instance, result, curQueue);
            skipReque = success = true;
        }
        catch (Throwable thrwbl) {
            boolean skipReque2;
            try {
                this.failure(thrwbl, job, curQueue);
                skipReque2 = success;
            }
            catch (Throwable throwable) {
                boolean skipReque3 = success;
                PoolUtils.doWorkInPoolNicely(this.jedisPool, new PoolUtils.PoolWork<Jedis, Void>(curQueue, skipReque3){
                    final /* synthetic */ String val$curQueue;
                    final /* synthetic */ boolean val$skipReque;
                    {
                        this.val$curQueue = string;
                        this.val$skipReque = bl;
                    }

                    @Override
                    public Void doWork(Jedis jedis) {
                        WorkerPoolImpl.this.removeInFlight(jedis, this.val$curQueue, this.val$skipReque);
                        jedis.del(WorkerPoolImpl.this.key("worker", WorkerPoolImpl.this.name));
                        return null;
                    }
                });
                this.processingJob.set(false);
                throw throwable;
            }
            PoolUtils.doWorkInPoolNicely(this.jedisPool, new /* invalid duplicate definition of identical inner class */);
            this.processingJob.set(false);
        }
        PoolUtils.doWorkInPoolNicely(this.jedisPool, new /* invalid duplicate definition of identical inner class */);
        this.processingJob.set(false);
    }

    private void removeInFlight(Jedis jedis, String curQueue, boolean skipRequeue) {
        if (JobExecutor.State.SHUTDOWN_IMMEDIATE.equals((Object)this.state.get()) && !skipRequeue) {
            this.lpoplpush(jedis, this.key("inflight", this.name, curQueue), this.key("queue", curQueue));
        } else {
            jedis.lpop(this.key("inflight", this.name, curQueue));
        }
    }

    protected Object execute(Job job, String curQueue, Object instance) throws Exception {
        Object result;
        if (instance instanceof WorkerAware) {
            ((WorkerAware)instance).setWorker(this);
        }
        this.listenerDelegate.fireEvent(WorkerEvent.JOB_EXECUTE, this, curQueue, job, instance, null, null);
        if (instance instanceof Callable) {
            result = ((Callable)instance).call();
        } else if (instance instanceof Runnable) {
            ((Runnable)instance).run();
            result = null;
        } else {
            throw new ClassCastException("Instance must be a Runnable or a Callable: " + instance.getClass().getName() + " - " + instance);
        }
        return result;
    }

    protected void success(Job job, Object runner, Object result, String curQueue) {
        try {
            PoolUtils.doWorkInPool(this.jedisPool, new PoolUtils.PoolWork<Jedis, Void>(){

                @Override
                public Void doWork(Jedis jedis) {
                    jedis.incr(WorkerPoolImpl.this.key("stat", "processed"));
                    jedis.incr(WorkerPoolImpl.this.key("stat", "processed", WorkerPoolImpl.this.name));
                    return null;
                }
            });
        }
        catch (JedisException je) {
            LOG.warn("Error updating success stats for job=" + job, (Throwable)je);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.listenerDelegate.fireEvent(WorkerEvent.JOB_SUCCESS, this, curQueue, job, runner, result, null);
    }

    protected void failure(final Throwable thrwbl, final Job job, final String curQueue) {
        try {
            PoolUtils.doWorkInPool(this.jedisPool, new PoolUtils.PoolWork<Jedis, Void>(){

                @Override
                public Void doWork(Jedis jedis) throws IOException {
                    jedis.incr(WorkerPoolImpl.this.key("stat", "failed"));
                    jedis.incr(WorkerPoolImpl.this.key("stat", "failed", WorkerPoolImpl.this.name));
                    FailQueueStrategy strategy = (FailQueueStrategy)WorkerPoolImpl.this.failQueueStrategyRef.get();
                    String failQueueKey = strategy.getFailQueueKey(thrwbl, job, curQueue);
                    if (failQueueKey != null) {
                        int failQueueMaxItems = strategy.getFailQueueMaxItems(curQueue);
                        if (failQueueMaxItems > 0) {
                            Long currentItems = jedis.llen(failQueueKey);
                            if (currentItems >= (long)failQueueMaxItems) {
                                Transaction tx = jedis.multi();
                                tx.ltrim(failQueueKey, 1L, -1L);
                                tx.rpush(failQueueKey, new String[]{WorkerPoolImpl.this.failMsg(thrwbl, curQueue, job)});
                                tx.exec();
                            } else {
                                jedis.rpush(failQueueKey, new String[]{WorkerPoolImpl.this.failMsg(thrwbl, curQueue, job)});
                            }
                        } else {
                            jedis.rpush(failQueueKey, new String[]{WorkerPoolImpl.this.failMsg(thrwbl, curQueue, job)});
                        }
                    }
                    return null;
                }
            });
        }
        catch (JedisException je) {
            LOG.warn("Error updating failure stats for throwable=" + thrwbl + " job=" + job, (Throwable)je);
        }
        catch (IOException ioe) {
            LOG.warn("Error serializing failure payload for throwable=" + thrwbl + " job=" + job, (Throwable)ioe);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.listenerDelegate.fireEvent(WorkerEvent.JOB_FAILURE, this, curQueue, job, null, null, thrwbl);
    }

    protected String failMsg(Throwable thrwbl, String queue, Job job) throws IOException {
        JobFailure failure = new JobFailure();
        failure.setFailedAt(new Date());
        failure.setWorker(this.name);
        failure.setQueue(queue);
        failure.setPayload(job);
        failure.setThrowable(thrwbl);
        return ObjectMapperFactory.get().writeValueAsString((Object)failure);
    }

    protected String statusMsg(String queue, Job job) throws IOException {
        WorkerStatus status = new WorkerStatus();
        status.setRunAt(new Date());
        status.setQueue(queue);
        status.setPayload(job);
        return ObjectMapperFactory.get().writeValueAsString((Object)status);
    }

    protected String pauseMsg() throws IOException {
        WorkerStatus status = new WorkerStatus();
        status.setRunAt(new Date());
        status.setPaused(this.isPaused());
        return ObjectMapperFactory.get().writeValueAsString((Object)status);
    }

    protected String createName() {
        StringBuilder buf = new StringBuilder(128);
        try {
            buf.append(InetAddress.getLocalHost().getHostName()).append(":").append(ManagementFactory.getRuntimeMXBean().getName().split("@")[0]).append('-').append(this.workerId).append(":").append("JAVA_DYNAMIC_QUEUES");
            for (String queueName : this.queueNames) {
                buf.append(',').append(queueName);
            }
        }
        catch (UnknownHostException uhe) {
            throw new RuntimeException(uhe);
        }
        return buf.toString();
    }

    protected String key(String ... parts) {
        return JesqueUtils.createKey(this.namespace, parts);
    }

    protected void renameThread(String msg) {
        Thread.currentThread().setName(this.threadNameBase + msg);
    }

    protected String lpoplpush(Jedis jedis, String from, String to) {
        return (String)jedis.evalsha(this.lpoplpushScriptHash.get(), 2, new String[]{from, to});
    }

    protected void loadRedisScripts(Jedis jedis) throws IOException {
        this.popScriptHash.set(jedis.scriptLoad(ScriptUtils.readScript(POP_LUA)));
        this.lpoplpushScriptHash.set(jedis.scriptLoad(ScriptUtils.readScript(LPOPLPUSH_LUA)));
        this.multiPriorityQueuesScriptHash.set(jedis.scriptLoad(ScriptUtils.readScript(POP_FROM_MULTIPLE_PRIO_QUEUES)));
    }

    protected void loadRedisScripts() {
        PoolUtils.doWorkInPoolNicely(this.jedisPool, new PoolUtils.PoolWork<Jedis, Void>(){

            @Override
            public Void doWork(Jedis jedis) throws IOException {
                WorkerPoolImpl.this.loadRedisScripts(jedis);
                return null;
            }
        });
    }

    public String toString() {
        return this.namespace + ":" + "worker" + ":" + this.name;
    }
}

